#include "stringops.h"

/* lookup table to replace special characters with similar common ones */
/* important for sorting so characters like '' are sorted like 'A' */

static char nospecial[0x0100];

/* the same with removed cases */

static char nospecialnocase[0x0100];

/* table of what character replaces what special characters (for sorting etc) */

static char *convert[]=
{
	"A", "",
	"a", "@",
	"C", "ǩ",
	"c", "",
	"D", "",
	"d", "",
	"E", "ˀ",
	"e", "",
	"f", "",
	"I", "",
	"i", "",
	"N", "",
	"n", "",
	"O", "،",
	"o", "",
	"R", "",
	"S", "$",
	"s", "",
	"T", "",
	"U", "",
	"u", "",
	"Y", "ݟ",
	"y", "",
	"Z", "",
	"z", "",
	"?", "",
	"!", "",
	/* ޶ױ */
	0
};

void initstringops()
{
	unsigned int i, k;
	char *cnv;
	char c;

	for (i=0;i<0x0100;i++) nospecial[i] = (char)i;

	i = 0;
	while (convert[i])
	{
		c = *convert[i];
		i++;
		cnv = convert[i];
		i++;
		k = 0;
		while (cnv[k])
		{
			nospecial[(unsigned int)cnv[k]] = c;
			k++;
		}
	}

	for (i=0;i<0x0100;i++)
	{
		c = nospecial[i];
		if ((c >= 'a') && (c <= 'z')) c += ('A' - 'a');
		nospecialnocase[i] = c;
	}
}

bool stringorder(const char *str1, const char *str2)
{
	unsigned int i;
	char c1,c2;

	i = 0;
	while (i < 1024)
	{
		c1 = nospecialnocase[(unsigned char)str1[i]];
		c2 = nospecialnocase[(unsigned char)str2[i]];
/*
		if ((c1 >= 'a') && ( c1 <= 'z')) c1 += ('A' - 'a');
		if ((c2 >= 'a') && ( c2 <= 'z')) c2 += ('A' - 'a');
*/
		if (c1 != c2) return (c1 < c2);
		if ((c1 | c2) == 0) break;
		i++;
	}
	return false;
}

bool stringcmp(const char *token, const char *data)
{
	unsigned int i;
	char c1,c2;

	i = 0;
	while (data[i] && token[i])
	{
		c1 = data[i];
		c2 = token[i];
		if ((c1 >= 'a') && ( c1 <= 'z')) c1 += ('A' - 'a');
		if ((c2 >= 'a') && ( c2 <= 'z')) c2 += ('A' - 'a');
		if (c1 != c2) return 0;
		i++;
	}
	return (data[i] == token[i]);
}

bool tokencmp(const char *token, const char *data)
{
	unsigned int i;
	char c1,c2;

	i = 0;
	if (!data[i]) return 0;
	while (data[i])
	{
		c1 = data[i];
		c2 = token[i];
		if ((c1 >= 'a') && ( c1 <= 'z')) c1 += ('A' - 'a');
		if ((c2 >= 'a') && ( c2 <= 'z')) c2 += ('A' - 'a');
		if (c1 != c2) return 0;
		i++;
	}
	return 1;
}

unsigned int stringlen(const char *string)
{
	unsigned int i;

	if (!string) return 0;
	i = 0;
	while (string[i] != 0) i++;
	return (i);
}

char *copystring(const char *string)
{
	unsigned int len, i;
	char *newstr;

	len = stringlen(string)+1;
	newstr = 0;
	if (len > 0)
	{
		newstr = new char[len];
		for (i=0;i<len;i++) newstr[i] = string[i];
	}
	return newstr;
}

static int monthmax[12]=
{
	31,29,31,30,31,30,
	31,31,30,31,30,31
};

static int makedate(int day, int month, int year)
{
	if (day < 0)      day = 0;
	if (month < 0)  month = 0;
	if (year < 0)    return -1;
	if (month > 12)
	{
		month = 99;
		day = 99;
	}
	else
	{
		if (month <= 0) day = 0;
		else if (day > monthmax[month-1]) day = 99;
	}
	if (year > 9999) year = 9999;

	if (year < 100)
	{
		if (year < 60) year += 2000;
		else year += 1900;
	}
	return ((year << 16) | (month << 8) | day);
}

unsigned int parsedate(const char *string)
{
	unsigned int i, k;
	int val,val1,val2;
	char c;

	/* date format (32 bit): YYYYMMDD */
	val1 = 0;
	val2 = 0;
	i = 0;
	k = 0;
	while (k < 3)
	{
		val = -1;
		while (string[i])
		{
			c = string[i];
			if ((c < '0') || (c > '9')) break;
			if (val < 0) val = 0;
			val *= 10;
			val += (c - '0');
			i++;
		}
		if (c != '.') return makedate(val2,val1,val);
		i++;
		val2 = val1;
		val1 = val;
		k ++;
	}
	return 0;
}

unsigned int parsedatesafe(const char *string)
{
	unsigned int date;

	date = parsedate(string);
	if (((date >> 8) & 0x000000FF) == 99) date &= 0xFFFF0000;
	if ((date & 0x000000FF) == 99) date &= 0xFFFFFF00;
	return date;
}

unsigned int parseint(const char *string)
{
	unsigned int val, i;
	char c;

	val = 0;
	i = 0;
	while (string[i])
	{
		c = string[i];
		if ((c < '0') || (c > '9')) break;
		val *= 10;
		val += (c - '0');
		i++;
	}
	return val;
}

unsigned int printint(char *string, unsigned int val)
{
	unsigned int div, cnt, i;

	if (val == 0)
	{
		string[0] = '0';
		string[1] = 0;
		return 1;
	}
	div = 10000;
	i = 0;
	while (div > 0)
	{
		cnt = val / div;
		if (cnt > 0) break;
		val = val % div;
		div /= 10;
	}
	while (div > 0)
	{
		cnt = val / div;
		val = val % div;
		string[i++] = cnt | '0';
		div /= 10;
	}
	string[i] = 0;
	return i;
}

unsigned int printstring(char *string, char *prstr)
{
	unsigned int i;

	i = 0;
	while (prstr[i])
	{
		string[i] = prstr[i];
		i++;
	}
	string[i] = 0;
	return i;
}

unsigned int printdate(char *string, unsigned int date)
{
	unsigned int day, month, year, i;

	day = date & 0xFF;
	month = (date >> 8) & 0xFF;
	year = date >> 16;

	i = 0;
	if (year)
	{
		if (month)
		{
			if (day)
			{
				i += printint(&string[i], day);
				string[i++] = '.';
			}
			i += printint(&string[i], month);
			string[i++] = '.';
		}
		i += printint(&string[i], year);
	}
	else i += printstring(&string[i], "unknown");
	string[i] = 0;
	return i;
}

unsigned int printdatelimited(char *string, unsigned int date, unsigned int cmpdate)
{
	unsigned int day, month, year, i;
	bool y,m,d;

	y = (((date ^ cmpdate) & 0xFFFF0000) != 0);
	m = (((date ^ cmpdate) & 0x0000FF00) != 0);
	d = (((date ^ cmpdate) & 0x000000FF) != 0);

	day = date & 0xFF;
	month = (date >> 8) & 0xFF;
	year = date >> 16;

	i = 0;
	if (year)
	{
		if (month)
		{
			if (day)
			{
				i += printint(&string[i], day);
				if (m) string[i++] = '.';
			}
			if (m) i += printint(&string[i], month);
			if (y) string[i++] = '.';
		}
		if (y) i += printint(&string[i], year);
	}
	else i += printstring(&string[i], "unknown");
	string[i] = 0;
	return i;
}
