/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.pc.savestate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.javatari.atari.console.savestate.ConsoleState;
import org.javatari.atari.console.savestate.SaveStateMedia;
import org.javatari.atari.console.savestate.SaveStateSocket;

public final class FileSaveStateMedia
implements SaveStateMedia {
    private String savesDirectory;
    private static final String BASE_DIR = "javatarisaves";

    public void connect(SaveStateSocket socket) {
        socket.connectMedia(this);
    }

    @Override
    public boolean saveState(int slot, ConsoleState state) {
        return this.saveResource("save" + slot + ".sav", state);
    }

    @Override
    public ConsoleState loadState(int slot) {
        try {
            return (ConsoleState)this.loadResource("save" + slot + ".sav");
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public boolean saveResource(String name, Object data) {
        try {
            block6: {
                File dir = new File(this.savesDirectory());
                if (!dir.isDirectory()) {
                    dir.mkdir();
                }
                FileOutputStream file = null;
                try {
                    ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                    ObjectOutputStream stream = new ObjectOutputStream(byteStream);
                    stream.writeObject(data);
                    file = new FileOutputStream(String.valueOf(this.savesDirectory()) + File.separator + name);
                    file.write(byteStream.toByteArray());
                }
                finally {
                    if (file == null) break block6;
                    file.close();
                }
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public Object loadResource(String name) {
        Object object;
        block6: {
            FileInputStream file = null;
            try {
                file = new FileInputStream(String.valueOf(this.savesDirectory()) + File.separator + name);
                byte[] data = new byte[file.available()];
                file.read(data);
                ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(data));
                object = stream.readObject();
                if (file == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        file.close();
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            file.close();
        }
        return object;
    }

    private String savesDirectory() {
        if (this.savesDirectory != null) {
            return this.savesDirectory;
        }
        try {
            String userHome = System.getProperty("user.home");
            if (userHome != null && !userHome.isEmpty()) {
                this.savesDirectory = String.valueOf(userHome) + File.separator + BASE_DIR;
                return this.savesDirectory;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.savesDirectory = BASE_DIR;
        return BASE_DIR;
    }
}

