/*
 * Decompiled with CFR 0.152.
 */
package org.joy;

import org.joy.Joy;

public class Joystick {
    private final Joy.Info info;
    private final Joy.State state;
    private float deadZoneThreshold = 0.2f;
    private float digitalThreshold = 0.3f;
    public static int NORTH = 0;
    public static int NORTHEAST = 1;
    public static int EAST = 2;
    public static int SOUTHEAST = 3;
    public static int SOUTH = 4;
    public static int SOUTHWEST = 5;
    public static int WEST = 6;
    public static int NORTHWEST = 7;
    public static int CENTER = -1;
    private static int POV_CENTER_RAW = 65535;
    private static int POV_INC_RAW = 4500;
    private static int POV_MAX_RAW = 36000;

    private Joystick(Joy.Info info) {
        this.info = info;
        this.state = info.getState();
    }

    public boolean update() {
        return this.state.update();
    }

    public int getButtons() {
        return this.state.getButtons();
    }

    public boolean getButton(int button) {
        return (this.state.getButtons() & 1 << button) != 0;
    }

    public float getAxis(int axis) {
        float val = ((float)this.getAxisRaw(axis) - (float)this.info.axesMinValues[axis]) / (float)(this.info.axesMaxValues[axis] - this.info.axesMinValues[axis]) * 2.0f - 1.0f;
        return (val < 0.0f ? -val : val) < this.deadZoneThreshold ? 0.0f : val;
    }

    public float getAxisNoThreshold(int axis) {
        return ((float)this.getAxisRaw(axis) - (float)this.info.axesMinValues[axis]) / (float)(this.info.axesMaxValues[axis] - this.info.axesMinValues[axis]) * 2.0f - 1.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getAxisDigital(int axis) {
        float val = ((float)this.getAxisRaw(axis) - (float)this.info.axesMinValues[axis]) / (float)(this.info.axesMaxValues[axis] - this.info.axesMinValues[axis]) * 2.0f - 1.0f;
        if (val == 0.0f) return 0;
        float f = val < 0.0f ? -val : val;
        if (f < this.digitalThreshold) {
            return 0;
        }
        if (!(val > 0.0f)) return -1;
        return 1;
    }

    public float getAxisDirection(int xAxis, int yAxis) {
        return this.getAxisDirection(xAxis, 1, yAxis, 1);
    }

    public float getAxisDirection(int xAxis, int xSig, int yAxis, int ySig) {
        float x = this.getAxis(xAxis) * (float)xSig;
        float y = this.getAxis(yAxis) * (float)ySig;
        if (x == 0.0f && y == 0.0f) {
            return CENTER;
        }
        return (float)(1.0 - Math.atan2(x, y) / Math.PI) / 2.0f;
    }

    public int getAxisDirectionCardinal(int xAxis, int yAxis) {
        return this.getAxisDirectionCardinal(xAxis, 1, yAxis, 1);
    }

    public int getAxisDirectionCardinal(int xAxis, int xSig, int yAxis, int ySig) {
        float x = this.getAxisNoThreshold(xAxis);
        float y = this.getAxisNoThreshold(yAxis);
        x = (x < 0.0f ? -x : x) < this.digitalThreshold ? 0.0f : (x *= (float)xSig);
        y = (y < 0.0f ? -y : y) < this.digitalThreshold ? 0.0f : (y *= (float)ySig);
        if (x == 0.0f && y == 0.0f) {
            return CENTER;
        }
        float dir = (float)(1.0 - Math.atan2(x, y) / Math.PI) / 2.0f;
        if ((dir += 0.0625f) >= 1.0f) {
            dir -= 1.0f;
        }
        return (int)(dir * 8.0f);
    }

    public int getAxisRaw(int axis) {
        return this.state.getAxis(axis);
    }

    public float getPOVDirection() {
        int pov = this.getPOVRaw();
        return pov == POV_CENTER_RAW ? -1.0f : (float)pov / (float)POV_MAX_RAW;
    }

    public int getPOVDirectionCardinal() {
        int pov = this.getPOVRaw();
        return pov == POV_CENTER_RAW ? -1 : pov / POV_INC_RAW;
    }

    public int getPOVRaw() {
        return this.state.getPOV();
    }

    public void setDeadZoneThreshold(float thre) {
        this.deadZoneThreshold = thre;
    }

    public void setDigitalThreshold(float thre) {
        this.digitalThreshold = thre;
    }

    public Joy.Info getInfo() {
        return this.info;
    }

    public String toString() {
        return "Joystick (" + this.info.id + ") " + this.state;
    }

    public static Joystick create(Joy.Info info) {
        return new Joystick(info);
    }
}

