/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.CartridgeInfo;
import org.javatari.atari.cartridge.CartridgeInfoLibrary;
import org.javatari.atari.cartridge.FormatRomNameMatcher;
import org.javatari.atari.cartridge.ROM;
import org.javatari.atari.cartridge.formats.Cartridge10K_DPC;
import org.javatari.atari.cartridge.formats.Cartridge12K_FA;
import org.javatari.atari.cartridge.formats.Cartridge16K_E7;
import org.javatari.atari.cartridge.formats.Cartridge16K_F6;
import org.javatari.atari.cartridge.formats.Cartridge24K_28K_32K_FA2;
import org.javatari.atari.cartridge.formats.Cartridge2K_CV;
import org.javatari.atari.cartridge.formats.Cartridge32K_F4;
import org.javatari.atari.cartridge.formats.Cartridge32K_FA2cu;
import org.javatari.atari.cartridge.formats.Cartridge4K;
import org.javatari.atari.cartridge.formats.Cartridge64K_F0;
import org.javatari.atari.cartridge.formats.Cartridge64K_X07;
import org.javatari.atari.cartridge.formats.Cartridge8K_0840;
import org.javatari.atari.cartridge.formats.Cartridge8K_512K_3E;
import org.javatari.atari.cartridge.formats.Cartridge8K_512K_3F;
import org.javatari.atari.cartridge.formats.Cartridge8K_512K_SB;
import org.javatari.atari.cartridge.formats.Cartridge8K_64K_EF;
import org.javatari.atari.cartridge.formats.Cartridge8K_E0;
import org.javatari.atari.cartridge.formats.Cartridge8K_F8;
import org.javatari.atari.cartridge.formats.Cartridge8K_FE;
import org.javatari.atari.cartridge.formats.Cartridge8K_UA;
import org.javatari.atari.cartridge.formats.CartridgePitfall2EnhancedDPCAudio;
import org.javatari.parameters.Parameters;

public class CartridgeDatabase {
    private static List<CartridgeFormat> allFormats = Arrays.asList(Cartridge4K.FORMAT, Cartridge2K_CV.FORMAT, Cartridge8K_F8.FORMAT, Cartridge12K_FA.FORMAT, Cartridge16K_F6.FORMAT, Cartridge32K_F4.FORMAT, Cartridge24K_28K_32K_FA2.FORMAT, Cartridge64K_F0.FORMAT, Cartridge64K_X07.FORMAT, Cartridge8K_E0.FORMAT, Cartridge8K_FE.FORMAT, Cartridge16K_E7.FORMAT, Cartridge8K_512K_3E.FORMAT, Cartridge8K_512K_3F.FORMAT, Cartridge8K_512K_SB.FORMAT, Cartridge8K_64K_EF.FORMAT, Cartridge8K_UA.FORMAT, Cartridge8K_0840.FORMAT, Cartridge10K_DPC.FORMAT, CartridgePitfall2EnhancedDPCAudio.FORMAT, Cartridge32K_FA2cu.FORMAT);
    private static FormatRomNameMatcher[] formatRomNames = new FormatRomNameMatcher[]{new FormatRomNameMatcher(Cartridge8K_E0.FORMAT, new String[]{".*MONTEZUMA.*", ".*MONTZREV.*", ".*GYRUS.*", ".*TOOTH.*PROTECTORS.*", ".*TOOTHPRO.*", ".*DEATH.*STAR.*BATTLE.*", ".*DETHSTAR.*", ".*JAMES.*BOND.*", ".*JAMEBOND.*", ".*SUPER.*COBRA.*", ".*SPRCOBRA.*", ".*TUTANKHAM.*", ".*TUTANK.*", ".*POPEYE.*", ".*(SW|STAR.?WARS).*ARCADE.*GAME.*", ".*SWARCADE.*", ".*Q.*BERT.*QUBES.*", ".*QBRTQUBE.*", ".*FROGGER.?(2|II).*", ".*DO.*CASTLE.*"}), new FormatRomNameMatcher(Cartridge8K_FE.FORMAT, new String[]{".*ROBOT.*TANK.*", ".*ROBOTANK.*", ".*DECATHLON.*", ".*DECATHLN.*"}), new FormatRomNameMatcher(Cartridge16K_E7.FORMAT, new String[]{".*BUMP.*JUMP.*", ".*BNJ.*", ".*BURGER.*TIME.*", ".*BURGTIME.*", ".*POWER.*HE.?MAN.*", ".*HE_MAN.*"}), new FormatRomNameMatcher(Cartridge8K_512K_3F.FORMAT, new String[]{".*POLARIS.*", ".*RIVER.*PATROL.*", ".*RIVERP.*", ".*SPRINGER.*", ".*MINER.*2049.*", ".*MNR2049R.*", ".*MINER.*2049.*VOLUME.*", ".*MINRVOL2.*", ".*ESPIAL.*", ".*ANDREW.*DAVIE.*"}), new FormatRomNameMatcher(Cartridge8K_512K_3E.FORMAT, new String[]{".*BOULDER.*DASH.*", ".*BLDRDASH.*"}), new FormatRomNameMatcher(CartridgePitfall2EnhancedDPCAudio.FORMAT, new String[]{".*PITFALL.*(2|II).*"})};
    private static final String[] paddlesRomNames = new String[]{".*PADDLES.*", ".*BREAKOUT.*", ".*SUPER.*BREAKOUT.*", ".*SUPERB.*", ".*WARLORDS.*", ".*STEEPLE.*CHASE.*", ".*STEPLCHS.*", ".*VIDEO.*OLYMPICS.*", ".*VID(|_)OLYM(|P).*", ".*CIRCUS.*ATARI.*", ".*CIRCATRI.*", ".*KABOOM.*", ".*BUGS((?!BUNNY).)*", ".*BACHELOR.*PARTY.*", ".*BACHELOR.*", ".*BACHELORETTE.*PARTY.*", ".*BACHLRTT.*", ".*BEAT.*EM.*EAT.*EM.*", ".*BEATEM.*", ".*PHILLY.*FLASHER.*", ".*PHILLY.*", ".*JEDI.*ARENA.*", ".*JEDIAREN.*", ".*EGGOMANIA.*", ".*EGGOMANA.*", ".*PICNIC.*", ".*PIECE.*O.*CAKE.*", ".*PIECECKE.*", ".*BACKGAMMON.*", ".*BACKGAM.*", ".*BLACKJACK.*", ".*BLACK(|_)J.*", ".*CANYON.*BOMBER.*", ".*CANYONB.*", ".*CASINO.*", ".*DEMONS.*DIAMONDS.*", ".*DEMONDIM.*", ".*DUKES.*HAZZARD.*2.*", ".*STUNT.?2.*", ".*ENCOUNTER.*L.?5.*", ".*ENCONTL5.*", ".*G.*I.*JOE.*COBRA.*STRIKE.*", ".*GIJOE.*", ".*GUARDIAN.*", ".*MARBLE.*CRAZE.*", ".*MARBCRAZ.*", ".*MEDIEVAL.*MAYHEM.*", ".*MONDO.*PONG.*", ".*NIGHT.*DRIVER.*", ".*NIGHTDRV.*", ".*PARTY.*MIX.*", ".*POKER.*PLUS.*", ".*PONG.*SPORTS.*", ".*SCSICIDE.*", ".*SECRET.*AGENT.*", ".*SOLAR.*STORM.*", ".*SOLRSTRM.*", ".*SPEEDWAY.*", ".*STREET.*RACER.*", ".*STRTRACE.*", ".*STUNT.*CYCLE.*", ".*STUNT.?1.*", ".*TAC.?SCAN.*", ".*MUSIC.*MACHINE.*", ".*MUSCMACH.*", ".*VONG.*", ".*WARPLOCK.*"};
    private static final String[] crtModeRomNames = new String[]{".*STAR.*CASTLE.*", ".*SEAWEED.*"};
    private static final String HINTS_PREFIX_REGEX = "(|.*?(\\W|_|%20))";
    private static final String HINTS_SUFFIX_REGEX = "(|(\\W|_|%20).*)";
    private static final int FORMAT_PRIORITY_BOOST = 100;
    private static String CARTRIDGE_NAME = Parameters.CARTRIDGE_NAME;
    private static String CARTRIDGE_LABEL = Parameters.CARTRIDGE_LABEL;
    private static int CARTRIDGE_LABEL_COLOR = Parameters.CARTRIDGE_LABEL_COLOR;
    private static int CARTRIDGE_BACK_COLOR = Parameters.CARTRIDGE_BACK_COLOR;
    private static int CARTRIDGE_BORDER_COLOR = Parameters.CARTRIDGE_BORDER_COLOR;
    private static int CARTRIDGE_PADDLES = Parameters.CARTRIDGE_PADDLES;
    private static int CARTRIDGE_CRT_MODE = Parameters.CARTRIDGE_CRT_MODE;
    private static String CARTRIDGE_FORMAT = Parameters.CARTRIDGE_FORMAT;

    public static ArrayList<CartridgeFormatOption> getFormatOptions(ROM rom) {
        ArrayList<CartridgeFormatOption> options = new ArrayList<CartridgeFormatOption>();
        for (CartridgeFormat format : allFormats) {
            CartridgeFormatOption option = format.getOption(rom);
            if (option == null) continue;
            CartridgeDatabase.boostPriority(option, rom.info);
            options.add(option);
        }
        Collections.sort(options);
        return options;
    }

    public static CartridgeInfo produceInfo(ROM rom) {
        CartridgeInfo info = CartridgeInfoLibrary.getInfo(rom);
        if (info.name == null) {
            info.name = CartridgeDatabase.produceCartridgeName(rom.url);
        }
        CartridgeDatabase.finishInfo(info, rom);
        return info;
    }

    private static void finishInfo(CartridgeInfo info, ROM rom) {
        block15: {
            String romName;
            int n;
            int n2;
            String[] stringArray;
            if (info.label == null) {
                info.label = CartridgeDatabase.produceCartridgeLabel(info.name);
            }
            String name = info.name.toUpperCase();
            if (info.paddles == -1) {
                info.paddles = 0;
                if (!name.matches("(|.*?(\\W|_|%20))JOYSTICK(S)?(|(\\W|_|%20).*)")) {
                    if (name.matches("(|.*?(\\W|_|%20))PADDLE(S)?(|(\\W|_|%20).*)")) {
                        info.paddles = 1;
                    } else {
                        stringArray = paddlesRomNames;
                        n2 = paddlesRomNames.length;
                        n = 0;
                        while (n < n2) {
                            romName = stringArray[n];
                            if (name.matches(romName)) {
                                info.paddles = 1;
                                break;
                            }
                            ++n;
                        }
                    }
                }
            }
            if (info.crtMode == -1) {
                if (name.matches("(|.*?(\\W|_|%20))CRT(_|-)?MODE(|(\\W|_|%20).*)")) {
                    info.crtMode = 1;
                } else {
                    stringArray = crtModeRomNames;
                    n2 = crtModeRomNames.length;
                    n = 0;
                    while (n < n2) {
                        romName = stringArray[n];
                        if (name.matches(romName)) {
                            info.crtMode = 1;
                            break;
                        }
                        ++n;
                    }
                }
            }
            if (info.format == null || info.format.isEmpty()) {
                String romURL = rom.url.toUpperCase();
                for (CartridgeFormat format : allFormats) {
                    if (!CartridgeDatabase.formatMatchesByHint(format, name) && !CartridgeDatabase.formatMatchesByHint(format, romURL)) continue;
                    info.format = format.id;
                    break block15;
                }
                for (CartridgeFormat format : allFormats) {
                    if (!CartridgeDatabase.formatMatchesByName(format, name)) continue;
                    info.format = format.id;
                    break;
                }
            }
        }
    }

    public static void adjustInfoOfROMProvided(ROM rom) {
        CartridgeInfo info = rom.info;
        if (CARTRIDGE_NAME != null) {
            info.name = CARTRIDGE_NAME;
            CartridgeDatabase.finishInfo(info, rom);
        }
        if (CARTRIDGE_LABEL != null) {
            info.label = CARTRIDGE_LABEL;
        }
        if (CARTRIDGE_LABEL_COLOR != -1) {
            info.labelColor = CARTRIDGE_LABEL_COLOR;
        }
        if (CARTRIDGE_BACK_COLOR != -1) {
            info.labelBackColor = CARTRIDGE_BACK_COLOR;
        }
        if (CARTRIDGE_BORDER_COLOR != -1) {
            info.labelBorderColor = CARTRIDGE_BORDER_COLOR;
        }
        if (CARTRIDGE_PADDLES != -1) {
            info.paddles = CARTRIDGE_PADDLES;
        }
        if (CARTRIDGE_CRT_MODE != -1) {
            info.crtMode = CARTRIDGE_CRT_MODE;
        }
        if (CARTRIDGE_FORMAT != null) {
            info.format = CARTRIDGE_FORMAT;
        }
    }

    private static void boostPriority(CartridgeFormatOption formatOption, CartridgeInfo info) {
        if (info.format != null && formatOption.format.id.equals(info.format)) {
            formatOption.priority -= 100;
        }
    }

    private static boolean formatMatchesByHint(CartridgeFormat format, String hint) {
        return hint.matches(HINTS_PREFIX_REGEX + format.id + HINTS_SUFFIX_REGEX);
    }

    private static boolean formatMatchesByName(CartridgeFormat format, String name) {
        FormatRomNameMatcher[] formatRomNameMatcherArray = formatRomNames;
        int n = formatRomNames.length;
        int n2 = 0;
        while (n2 < n) {
            FormatRomNameMatcher matcher = formatRomNameMatcherArray[n2];
            if (matcher.format == format && matcher.matches(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String produceCartridgeName(String url) {
        int dot;
        int question;
        int bslash;
        int slash;
        int i;
        if (url == null || url.trim().isEmpty()) {
            return "Unknown";
        }
        String name = url;
        try {
            String enc = System.getProperty("file.encoding");
            if (enc != null) {
                name = URLDecoder.decode(url, enc);
            }
        }
        catch (Exception enc) {
            // empty catch block
        }
        if ((i = Math.max(slash = name.lastIndexOf("/"), Math.max(bslash = name.lastIndexOf("\\"), question = name.lastIndexOf("?")))) >= 0 && i < name.length() - 1) {
            name = name.substring(i + 1);
        }
        if ((dot = name.lastIndexOf(".")) >= 0) {
            name = name.substring(0, dot);
        }
        if ((name = name.trim()).isEmpty()) {
            return "Unknown";
        }
        return name;
    }

    private static String produceCartridgeLabel(String name) {
        return name.split("(\\(|\\[)")[0].trim();
    }
}

