/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.ROM;
import org.javatari.atari.cartridge.formats.CartridgeBanked;

public final class Cartridge8K_FE
extends CartridgeBanked {
    private static final int SIZE = 8192;
    private static final int BANK_SIZE = 4096;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("FE", "8K Robotank/Decathlon"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge createCartridge(ROM rom) {
            return new Cartridge8K_FE(rom, null);
        }

        @Override
        public CartridgeFormatOption getOption(ROM rom) {
            if (rom.content.length != 8192) {
                return null;
            }
            return new CartridgeFormatOption(103, this, rom);
        }
    };
    public static final long serialVersionUID = 1L;

    private Cartridge8K_FE(ROM rom) {
        super(rom, FORMAT);
        this.bankAddressOffset = 4096;
    }

    @Override
    public void maskAddress(int address) {
        if ((address & 0x2000) != 0) {
            if (this.bankAddressOffset != 0) {
                this.bankAddressOffset = 0;
            }
        } else if (this.bankAddressOffset != 4096) {
            this.bankAddressOffset = 4096;
        }
        super.maskAddress(address);
    }

    @Override
    protected void performBankSwitchOnMaskedAddress() {
    }

    /* synthetic */ Cartridge8K_FE(ROM rOM, Cartridge8K_FE cartridge8K_FE) {
        this(rOM);
    }
}

