/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.utils.slickframe;

import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import org.javatari.utils.slickframe.MousePressAndMotionListener;

public class HotspotPanel
extends JPanel {
    private MousePressAndMotionListener forwardListener;
    private MousePressAndMotionListener mouseListener;
    private boolean hotspotsEffectiveAreasValid = false;
    private List<HotspotAction> hotspots = new ArrayList<HotspotAction>();
    private List<HotspotAction> hotspotsWithTooltip = new ArrayList<HotspotAction>();
    private HotspotAction activeHotspot;
    public static final int CENTER_HOTSPOT = -10000;
    public static final long serialVersionUID = 1L;

    public HotspotPanel() throws HeadlessException {
        this.init();
    }

    public void setForwardListener(MousePressAndMotionListener forwardListener) {
        this.forwardListener = forwardListener;
    }

    public HotspotAction addHotspot(Rectangle area, Runnable activationAction) {
        return this.addHotspot(area, (String)null, activationAction);
    }

    public HotspotAction addHotspot(Rectangle area, String tooltip, Runnable activationAction) {
        HotspotAction h = new HotspotAction(area, activationAction);
        h.setTooltip(tooltip);
        return this.addHotspot(h);
    }

    public HotspotAction addHotspot(Rectangle area, Runnable activationAction, Runnable deactivationAction) {
        return this.addHotspot(area, null, activationAction, deactivationAction);
    }

    public HotspotAction addHotspot(Rectangle area, String tooltip, Runnable activationAction, Runnable deactivationAction) {
        HotspotAction h = new HotspotAction(area, activationAction, deactivationAction);
        h.setTooltip(tooltip);
        return this.addHotspot(h);
    }

    public HotspotAction addHotspot(HotspotAction h) {
        if (!this.hotspots.contains(h)) {
            this.hotspots.add(h);
            this.updateHotspotEffectiveArea(h);
            if (h.tooltip != null) {
                this.hotspotsWithTooltip.add(h);
                ToolTipManager.sharedInstance().registerComponent(this);
            }
        }
        return h;
    }

    public void removeHotspot(HotspotAction hotspot) {
        this.hotspots.remove(hotspot);
        this.hotspotsWithTooltip.remove(hotspot);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (!this.hotspotsWithTooltip.isEmpty()) {
            this.updateHotspotsEffectiveAreas();
            Point point = event.getPoint();
            for (HotspotAction hotspot : this.hotspotsWithTooltip) {
                if (!hotspot.effectiveArea.contains(point)) continue;
                return hotspot.tooltip;
            }
        }
        return null;
    }

    public MousePressAndMotionListener detachMouseListener() {
        this.removeMouseListener(this.mouseListener);
        this.removeMouseMotionListener(this.mouseListener);
        return this.mouseListener;
    }

    private void init() {
        this.mouseListener = this.buildMouseListener();
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (HotspotPanel.this.hotspotsEffectiveAreasValid && e.getComponent() == HotspotPanel.this) {
                    HotspotPanel.this.hotspotsEffectiveAreasValid = false;
                }
            }
        });
    }

    private MousePressAndMotionListener buildMouseListener() {
        return new MousePressAndMotionListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    HotspotPanel.this.updateHotspotsEffectiveAreas();
                    Point point = e.getPoint();
                    for (HotspotAction hotspot : HotspotPanel.this.hotspots) {
                        if (!hotspot.effectiveArea.contains(point)) continue;
                        HotspotPanel.this.activeHotspot = hotspot;
                        hotspot.activationAction.run();
                        return;
                    }
                    HotspotPanel.this.activeHotspot = null;
                }
                if (HotspotPanel.this.forwardListener != null) {
                    HotspotPanel.this.forwardListener.mousePressed(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1 && HotspotPanel.this.activeHotspot != null) {
                    if (((HotspotPanel)HotspotPanel.this).activeHotspot.deactivationAction != null) {
                        ((HotspotPanel)HotspotPanel.this).activeHotspot.deactivationAction.run();
                    }
                    HotspotPanel.this.activeHotspot = null;
                    return;
                }
                if (HotspotPanel.this.forwardListener != null) {
                    HotspotPanel.this.forwardListener.mouseReleased(e);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (HotspotPanel.this.activeHotspot == null && HotspotPanel.this.forwardListener != null) {
                    HotspotPanel.this.forwardListener.mouseDragged(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (HotspotPanel.this.forwardListener != null) {
                    HotspotPanel.this.forwardListener.mouseClicked(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (HotspotPanel.this.forwardListener != null) {
                    HotspotPanel.this.forwardListener.mouseEntered(e);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (HotspotPanel.this.forwardListener != null) {
                    HotspotPanel.this.forwardListener.mouseExited(e);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (HotspotPanel.this.forwardListener != null) {
                    HotspotPanel.this.forwardListener.mouseMoved(e);
                }
            }
        };
    }

    public void paintHotspots(Graphics g) {
    }

    private void updateHotspotsEffectiveAreas() {
        if (this.hotspotsEffectiveAreasValid) {
            return;
        }
        for (HotspotAction hotspot : this.hotspots) {
            this.updateHotspotEffectiveArea(hotspot);
        }
        this.hotspotsEffectiveAreasValid = true;
    }

    private void updateHotspotEffectiveArea(HotspotAction hotspot) {
        Rectangle area = hotspot.area;
        Rectangle effArea = hotspot.effectiveArea;
        int n = area.x == -10000 ? (this.getWidth() - area.width) / 2 : (effArea.x = area.x < 0 ? this.getWidth() + area.x : area.x);
        effArea.y = area.y == -10000 ? (this.getHeight() - area.height) / 2 : (area.y < 0 ? this.getHeight() + area.y : area.y);
    }

    public class HotspotAction {
        public Rectangle area;
        public Rectangle effectiveArea;
        public Runnable activationAction;
        public Runnable deactivationAction;
        public String tooltip;

        public HotspotAction(Rectangle area, Runnable activationAction) {
            this(area, activationAction, null);
        }

        public HotspotAction(Rectangle area, Runnable activationAction, Runnable deactivationAction) {
            this.area = area;
            this.effectiveArea = new Rectangle(area);
            this.activationAction = activationAction;
            this.deactivationAction = deactivationAction;
        }

        public void setTooltip(String tooltip) {
            this.tooltip = tooltip;
        }
    }
}

