/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import java.util.Arrays;
import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.ROM;
import org.javatari.atari.cartridge.formats.Cartridge24K_28K_32K_FA2;

public final class Cartridge32K_FA2cu
extends Cartridge24K_28K_32K_FA2 {
    private static final int SIZE32K_Harmony = 32768;
    private static final byte[] cuMagicWord = new byte[]{30, -85, -83, 16};
    public static final CartridgeFormat FORMAT = new CartridgeFormat("FA2cu", "32K CBS RAM Plus CU Image"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge createCartridge(ROM rom) {
            return new Cartridge32K_FA2cu(rom, null);
        }

        @Override
        public CartridgeFormatOption getOption(ROM rom) {
            if (rom.content.length != 32768) {
                return null;
            }
            byte[] hint = Arrays.copyOfRange(rom.content, 32, 36);
            boolean foundHint = Arrays.equals(hint, cuMagicWord);
            return new CartridgeFormatOption(foundHint ? 53 : 103, this, rom);
        }
    };
    public static final long serialVersionUID = 1L;

    private Cartridge32K_FA2cu(ROM rom) {
        super(rom, FORMAT);
        this.romStartAddress = 1024;
        this.bankAddressOffset = 1024;
        if (this.topBankSwitchAddress > 4091) {
            this.topBankSwitchAddress = 4091;
        }
    }

    /* synthetic */ Cartridge32K_FA2cu(ROM rOM, Cartridge32K_FA2cu cartridge32K_FA2cu) {
        this(rOM);
    }
}

