/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.pc.screen;

import java.awt.BufferCapabilities;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.ImageCapabilities;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.TransferHandler;
import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeSocket;
import org.javatari.atari.controls.ConsoleControlsSocket;
import org.javatari.general.av.video.VideoSignal;
import org.javatari.parameters.Parameters;
import org.javatari.pc.room.EmbeddedRoom;
import org.javatari.pc.room.Room;
import org.javatari.pc.screen.DesktopConsolePanel;
import org.javatari.pc.screen.DesktopScreenFullWindow;
import org.javatari.pc.screen.Monitor;
import org.javatari.pc.screen.MonitorDisplay;
import org.javatari.pc.screen.ROMTransferHandlerUtil;
import org.javatari.pc.screen.Screen;
import org.javatari.utils.SwingHelper;
import org.javatari.utils.slickframe.HotspotPanel;
import org.javatari.utils.slickframe.SlickFrame;

public final class DesktopScreenWindow
extends SlickFrame
implements MonitorDisplay,
Screen {
    private Monitor monitor;
    private Canvas canvas;
    private DesktopConsolePanel consolePanelWindow;
    private DesktopScreenFullWindow fullWindow;
    private boolean fullScreen = false;
    private BufferStrategy bufferStrategy;
    private boolean popinEnabled;
    private int totalCanvasVertPadding;
    private int totalCanvasHorizPadding;
    private BufferedImage topLeft;
    private BufferedImage bottomLeft;
    private BufferedImage topRight;
    private BufferedImage bottomRight;
    private BufferedImage top;
    private BufferedImage bottomBar;
    private BufferedImage bottomLeftBar;
    private BufferedImage bottomLeftBarNoPower;
    private BufferedImage bottomRightBar;
    private BufferedImage logoBar;
    private BufferedImage popin;
    public BufferedImage favicon;
    public BufferedImage icon64;
    public BufferedImage icon32;
    private static final Insets SLICK_INSETS = new Insets(4, 4, 30, 4);
    public static final String BASE_TITLE = "javatari";
    public static final boolean FULLSCREEN = Parameters.SCREEN_FULLSCREEN;
    public static final int USE_FSEM = Parameters.SCREEN_USE_FSEM;
    public static final int BORDER_SIZE = Parameters.SCREEN_BORDER_SIZE;
    public static final boolean CONSOLE_PANEL = Parameters.SCREEN_CONSOLE_PANEL;
    private static final boolean EMBEDDED_POPUP = Parameters.SCREEN_EMBEDDED_POPUP;
    public static final long serialVersionUID = 1L;

    public DesktopScreenWindow() {
        this.totalCanvasVertPadding = DesktopScreenWindow.SLICK_INSETS.top + DesktopScreenWindow.SLICK_INSETS.bottom;
        this.totalCanvasHorizPadding = DesktopScreenWindow.SLICK_INSETS.left + DesktopScreenWindow.SLICK_INSETS.right;
        this.setup();
    }

    @Override
    public void connect(VideoSignal videoSignal, ConsoleControlsSocket controlsSocket, CartridgeSocket cartridgeSocket) {
        this.monitor.connect(videoSignal, cartridgeSocket);
        if (this.consolePanelWindow != null) {
            this.consolePanelWindow.connect(controlsSocket, cartridgeSocket);
        }
    }

    @Override
    public void powerOn() {
        this.powerOn(FULLSCREEN);
    }

    public void powerOn(final boolean fullScreen) {
        SwingHelper.edtSmartInvokeAndWait(new Runnable(){

            @Override
            public void run() {
                DesktopScreenWindow.this.fullScreen(fullScreen);
                DesktopScreenWindow.this.monitor.powerOn();
            }
        });
    }

    @Override
    public void powerOff() {
        SwingHelper.edtSmartInvokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (DesktopScreenWindow.this.fullScreen) {
                    DesktopScreenWindow.this.fullScreen(false);
                }
                DesktopScreenWindow.this.monitor.powerOff();
                DesktopScreenWindow.this.setVisible(false);
            }
        });
    }

    @Override
    public void destroy() {
        this.close();
        this.monitor.destroy();
    }

    @Override
    public void close() {
        this.setVisible(false);
    }

    @Override
    public Monitor monitor() {
        return this.monitor;
    }

    @Override
    protected void init() {
        this.loadImages();
        this.setBackground(Color.BLACK);
        this.getContentPane().setBackground(Color.BLACK);
        this.getContentPane().setIgnoreRepaint(true);
        this.setLayout(null);
        this.setIconImages(Arrays.asList(this.icon64, this.icon32, this.favicon));
        this.setTitle(BASE_TITLE);
        this.canvas = new Canvas();
        this.canvas.setBackground(Color.BLACK);
        this.canvas.setIgnoreRepaint(true);
        this.canvas.setFocusTraversalKeysEnabled(false);
        this.add(this.canvas);
        super.init();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Insets ins = this.getInsets();
            this.totalCanvasHorizPadding = ins.left + ins.right + DesktopScreenWindow.SLICK_INSETS.left + DesktopScreenWindow.SLICK_INSETS.right + BORDER_SIZE * 2;
            this.totalCanvasVertPadding = ins.top + ins.bottom + DesktopScreenWindow.SLICK_INSETS.top + DesktopScreenWindow.SLICK_INSETS.bottom + BORDER_SIZE * 2;
            if (this.consolePanelWindow != null) {
                this.consolePanelWindow.setVisible(true);
            }
            this.canvasSetRenderingMode();
            SwingHelper.edtInvokeLater(new Runnable(){

                @Override
                public void run() {
                    DesktopScreenWindow.this.repaint();
                }
            });
        } else if (this.consolePanelWindow != null) {
            this.consolePanelWindow.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fullScreen(boolean state) {
        String string = this.monitor.refreshMonitor;
        synchronized (string) {
            if (state) {
                this.openFullWindow();
            } else {
                this.openWindow();
            }
        }
    }

    @Override
    public List<Component> keyControlsInputComponents() {
        ArrayList<Component> comps = new ArrayList<Component>(Arrays.asList(this, this.canvas, this.fullWindow));
        if (this.consolePanelWindow != null) {
            comps.add(this.consolePanelWindow);
        }
        return comps;
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.canvas.addMouseListener(l);
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        super.addMouseMotionListener(l);
        this.canvas.addMouseMotionListener(l);
    }

    @Override
    public void displaySize(Dimension size) {
        Dimension winDim = this.windowDimensionForCanvasDimension(size);
        if (this.getSize().equals(winDim)) {
            return;
        }
        int centerX = this.getX() + this.getWidth() / 2;
        int centerY = this.getY() + (this.getHeight() + 137) / 4;
        int newX = centerX - winDim.width / 2;
        int newY = centerY - (winDim.height + 137) / 4;
        this.setBounds(newX, newY, winDim.width, winDim.height);
    }

    @Override
    public void displayCenter() {
        Rectangle bounds = SwingHelper.getGraphicsConfigurationForCurrentLocation(this).getBounds();
        int x = (bounds.width - this.getWidth()) / 2 + bounds.x;
        int y = (bounds.height - this.getHeight() - 137) / 4 + bounds.y;
        this.setLocation(x, y);
    }

    @Override
    public Dimension displayEffectiveSize() {
        return this.canvas.getSize();
    }

    @Override
    public Graphics2D displayGraphics() {
        Graphics2D graphics = (Graphics2D)(this.bufferStrategy != null ? this.bufferStrategy.getDrawGraphics() : this.canvas.getGraphics());
        return graphics;
    }

    @Override
    public void displayFinishFrame(Graphics2D graphics) {
        graphics.dispose();
        if (this.bufferStrategy != null) {
            this.bufferStrategy.show();
        }
    }

    @Override
    public Container displayContainer() {
        return this;
    }

    @Override
    public void displayClear() {
        Graphics2D canvasGraphics = this.displayGraphics();
        canvasGraphics.setColor(Color.BLACK);
        canvasGraphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.displayFinishFrame(canvasGraphics);
    }

    @Override
    public float displayDefaultOpenningScaleX(int displayWidh, int displayHeight) {
        return Monitor.DEFAULT_SCALE_X;
    }

    @Override
    public void displayMinimumSize(Dimension minSize) {
        this.minimunResize(this.windowDimensionForCanvasDimension(minSize));
    }

    @Override
    public void displayRequestFocus() {
        this.requestFocus();
    }

    @Override
    public void displayLeaveFullscreen() {
        if (this.fullScreen) {
            this.fullScreen(false);
        }
    }

    private void setup() {
        this.popinEnabled = EMBEDDED_POPUP && Room.currentRoom() instanceof EmbeddedRoom;
        this.addHotspots();
        this.monitor = new Monitor();
        this.fullWindow = new DesktopScreenFullWindow(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (e.getComponent() == DesktopScreenWindow.this) {
                    DesktopScreenWindow.this.positionCanvas();
                }
            }
        });
        this.getRootPane().setTransferHandler(new ROMDropTransferHandler());
        if (CONSOLE_PANEL) {
            this.consolePanelWindow = new DesktopConsolePanel(this, this.monitor);
            this.consolePanelWindow.setTransferHandler(new ROMDropTransferHandler());
        }
        List<Component> keyControlsInputComponents = this.keyControlsInputComponents();
        this.addControlInputComponents(keyControlsInputComponents);
        this.monitor.addControlInputComponents(keyControlsInputComponents);
        this.monitor.setDisplay(this);
        this.displayCenter();
    }

    private void addControlInputComponents(List<Component> inputs) {
        DesktopScreenControlKeyListener lis = new DesktopScreenControlKeyListener();
        for (Component component : inputs) {
            component.addKeyListener(lis);
        }
    }

    private void openWindow() {
        if (this.isVisible()) {
            return;
        }
        if (this.fullWindow != null && this.fullWindow.isVisible()) {
            try {
                GraphicsConfiguration graphicsConfig = SwingHelper.getGraphicsConfigurationForCurrentLocation(this.fullWindow);
                graphicsConfig.getDevice().setFullScreenWindow(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fullWindow.setVisible(false);
        }
        this.setVisible(true);
        this.toFront();
        this.requestFocus();
        this.monitor.setDisplay(this);
        this.fullScreen = false;
    }

    private void openFullWindow() {
        if (this.fullWindow.isVisible()) {
            return;
        }
        GraphicsConfiguration graphicsConfig = SwingHelper.getGraphicsConfigurationForCurrentLocation(this);
        this.setVisible(false);
        this.fullWindow.setBounds(graphicsConfig.getBounds());
        this.fullWindow.setVisible(true);
        if (USE_FSEM != 0) {
            try {
                graphicsConfig.getDevice().setFullScreenWindow(this.fullWindow);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fullWindow.toFront();
        this.fullWindow.requestFocus();
        this.monitor.setDisplay(this.fullWindow);
        this.fullScreen = true;
    }

    public void canvasSetRenderingMode() {
        if (Monitor.MULTI_BUFFERING <= 0) {
            return;
        }
        BufferCapabilities desiredCaps = new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), Monitor.PAGE_FLIPPING ? BufferCapabilities.FlipContents.BACKGROUND : null);
        Class<?> extBufCapClass = null;
        try {
            extBufCapClass = Class.forName("sun.java2d.pipe.hw.ExtendedBufferCapabilities");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (extBufCapClass != null && Monitor.BUFFER_VSYNC != -1) {
            try {
                Class<?> vSyncTypeClass = Class.forName("sun.java2d.pipe.hw.ExtendedBufferCapabilities$VSyncType");
                Constructor<?> extBufCapConstructor = extBufCapClass.getConstructor(BufferCapabilities.class, vSyncTypeClass);
                Object vSyncType = vSyncTypeClass.getField(Monitor.BUFFER_VSYNC == 1 ? "VSYNC_ON" : "VSYNC_OFF").get(null);
                BufferCapabilities extBuffCaps = (BufferCapabilities)extBufCapConstructor.newInstance(desiredCaps, vSyncType);
                this.canvas.createBufferStrategy(Monitor.MULTI_BUFFERING, extBuffCaps);
            }
            catch (Exception vSyncTypeClass) {
                // empty catch block
            }
        }
        if (this.canvas.getBufferStrategy() == null) {
            try {
                this.canvas.createBufferStrategy(Monitor.MULTI_BUFFERING, desiredCaps);
            }
            catch (Exception vSyncTypeClass) {
                // empty catch block
            }
        }
        if (this.canvas.getBufferStrategy() == null) {
            System.out.println("Could not create desired BufferStrategy. Switching to default...");
            this.canvas.createBufferStrategy(Monitor.MULTI_BUFFERING);
        }
        this.bufferStrategy = this.canvas.getBufferStrategy();
        if (this.bufferStrategy != null) {
            System.out.println("Buffer Strategy: " + this.bufferStrategy.getClass().getSimpleName());
        }
        BufferCapabilities grantedCaps = this.bufferStrategy.getCapabilities();
        System.out.println("Backbuffer Accelerated: " + grantedCaps.getBackBufferCapabilities().isAccelerated());
        System.out.println("PageFlipping Active: " + grantedCaps.isPageFlipping() + ", " + grantedCaps.getFlipContents());
        if (extBufCapClass != null && grantedCaps.getClass().equals(extBufCapClass)) {
            try {
                System.out.println("VSynch active: " + extBufCapClass.getMethod("getVSync", null).invoke((Object)grantedCaps, new Object[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Dimension windowDimensionForCanvasDimension(Dimension size) {
        return new Dimension(size.width + this.totalCanvasHorizPadding, size.height + this.totalCanvasVertPadding);
    }

    private void positionCanvas() {
        this.canvas.setBounds(DesktopScreenWindow.SLICK_INSETS.left + BORDER_SIZE, DesktopScreenWindow.SLICK_INSETS.top + BORDER_SIZE, this.getWidth() - this.totalCanvasHorizPadding, this.getHeight() - this.totalCanvasVertPadding);
    }

    private void addHotspots() {
        HotspotPanel hotspotPanel = this.getContentHotspotPanel();
        hotspotPanel.addHotspot(new Rectangle(-10000, -27, 24, 28), "Toggle Console Controls", new Runnable(){

            @Override
            public void run() {
                if (DesktopScreenWindow.this.consolePanelWindow != null) {
                    DesktopScreenWindow.this.consolePanelWindow.toggle();
                }
            }
        });
        hotspotPanel.addHotspot(new Rectangle(-114, -20, 13, 15), "Minimize", new Runnable(){

            @Override
            public void run() {
                DesktopScreenWindow.this.setState(1);
            }
        });
        hotspotPanel.addHotspot(new Rectangle(-96, -21, 12, 16), "Decrease Size", new Runnable(){

            @Override
            public void run() {
                DesktopScreenWindow.this.monitor.controlActivated(Monitor.Control.SIZE_MINUS);
            }
        });
        hotspotPanel.addHotspot(new Rectangle(-79, -24, 14, 19), "Increase Size", new Runnable(){

            @Override
            public void run() {
                DesktopScreenWindow.this.monitor.controlActivated(Monitor.Control.SIZE_PLUS);
            }
        });
        hotspotPanel.addHotspot(new Rectangle(-60, -24, 17, 19), "Go Full Screen", new Runnable(){

            @Override
            public void run() {
                DesktopScreenWindow.this.fullScreen(!DesktopScreenWindow.this.fullScreen);
            }
        });
        hotspotPanel.addHotspot(new Rectangle(-37, -24, 16, 19), "Open Settings", new Runnable(){

            @Override
            public void run() {
                Room.currentRoom().openSettings(DesktopScreenWindow.this);
                DesktopScreenWindow.this.requestFocus();
            }
        });
        if (this.popinEnabled) {
            hotspotPanel.addHotspot(new Rectangle(7, -25, 23, 20), "Re-attach Screen", new Runnable(){

                @Override
                public void run() {
                    ((EmbeddedRoom)Room.currentRoom()).reembedScreen();
                }
            });
        } else {
            hotspotPanel.addHotspot(new Rectangle(8, -25, 19, 19), "Shutdown", new Runnable(){

                @Override
                public void run() {
                    Room.currentRoom().exit();
                }
            });
        }
    }

    private void loadImages() {
        try {
            this.topLeft = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/TopLeft.png");
            this.bottomLeft = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/BottomLeft.png");
            this.topRight = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/TopRight.png");
            this.bottomRight = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/BottomRight.png");
            this.top = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/Top.png");
            this.bottomLeftBar = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/BottomLeftBar.png");
            this.bottomLeftBarNoPower = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/BottomLeftBarNoPower.png");
            this.bottomRightBar = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/BottomRightBar.png");
            this.bottomBar = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/BottomBar.png");
            this.logoBar = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/LogoBar.png");
            this.popin = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/Popin.png");
            this.favicon = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/Favicon.png");
            this.icon64 = SwingHelper.loadAsCompatibleTranslucentImage("org/javatari/pc/screen/images/LogoIcon64.png");
            this.icon32 = SwingHelper.loadAsCompatibleTranslucentImage("org/javatari/pc/screen/images/LogoIcon32.png");
        }
        catch (IOException ex) {
            System.out.println("Screen Window: unable to load images\n" + ex);
        }
    }

    @Override
    public void paint(Graphics origGraphics) {
        Insets ins = this.getInsets();
        int w = this.getWidth() - ins.left - ins.right;
        int h = this.getHeight() - ins.top - ins.bottom;
        Graphics g = origGraphics.create(ins.left, ins.top, w, h);
        g.setColor(Color.BLACK);
        g.fillRect(DesktopScreenWindow.SLICK_INSETS.left, DesktopScreenWindow.SLICK_INSETS.top, this.getWidth() - DesktopScreenWindow.SLICK_INSETS.left - DesktopScreenWindow.SLICK_INSETS.right, this.getHeight() - DesktopScreenWindow.SLICK_INSETS.top - DesktopScreenWindow.SLICK_INSETS.bottom);
        int halfH = (h - 30) / 2;
        int halfW = w / 2;
        int maxHalfW = Math.min(halfW - 11, 512);
        int x = 0;
        while (x < w) {
            g.drawImage(this.top, x, 0, null);
            x += 512;
        }
        g.drawImage(this.topLeft, 0, 0, null);
        g.drawImage(this.topRight, w - 4, 0, null);
        x = 512;
        while (x < w - 512) {
            g.drawImage(this.bottomBar, x, h - 30, x + 256, h, 0, 0, 256, 30, null);
            x += 256;
        }
        g.drawImage(this.popinEnabled ? this.bottomLeftBarNoPower : this.bottomLeftBar, 0, h - 30, maxHalfW, h, 0, 0, maxHalfW, 30, null);
        g.drawImage(this.bottomRightBar, w - maxHalfW, h - 30, w, h, 512 - maxHalfW, 0, 512, 30, null);
        g.drawImage(this.logoBar, halfW - 12, h - 30, null);
        g.drawImage(this.bottomLeft, 0, halfH, 4, h - 30, 0, 600 - halfH, 4, 600, null);
        g.drawImage(this.bottomRight, w - 4, halfH, w, h - 30, 0, 600 - halfH, 4, 600, null);
        if (this.popinEnabled) {
            g.drawImage(this.popin, 11, h - 22, null);
        }
        this.paintHotspots(g);
        g.dispose();
    }

    private class DesktopScreenControlKeyListener
    extends KeyAdapter {
        static final int KEY_EXIT = 27;
        static final int KEY_CONSOLE_PANEL = 72;
        static final int KEY_FULL_SCR = 10;

        private DesktopScreenControlKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            switch (e.getModifiersEx()) {
                case 0: {
                    if (code == 27) {
                        if (DesktopScreenWindow.this.fullScreen) {
                            DesktopScreenWindow.this.fullScreen(false);
                        } else if (DesktopScreenWindow.this.popinEnabled) {
                            ((EmbeddedRoom)Room.currentRoom()).reembedScreen();
                        } else {
                            Room.currentRoom().exit();
                        }
                    }
                    return;
                }
                case 512: {
                    switch (code) {
                        case 10: {
                            DesktopScreenWindow.this.fullScreen(!DesktopScreenWindow.this.fullScreen);
                            return;
                        }
                        case 72: {
                            if (!DesktopScreenWindow.this.fullScreen && DesktopScreenWindow.this.consolePanelWindow != null) {
                                DesktopScreenWindow.this.consolePanelWindow.toggle();
                            }
                            return;
                        }
                    }
                }
            }
        }
    }

    private class ROMDropTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;

        private ROMDropTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!DesktopScreenWindow.this.monitor.isCartridgeChangeEnabled()) {
                return false;
            }
            Transferable transf = support.getTransferable();
            if (!ROMTransferHandlerUtil.canAccept(transf)) {
                return false;
            }
            if (support.isDrop() && support.getUserDropAction() != 0x40000000) {
                support.setDropAction(1);
            }
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            DesktopScreenWindow.this.monitor.showOSD("LOADING CARTRIDGE...", true);
            Cartridge cart = ROMTransferHandlerUtil.importCartridgeData(support.getTransferable());
            DesktopScreenWindow.this.monitor.showOSD(null, true);
            if (cart == null) {
                return false;
            }
            boolean autoPower = !support.isDrop() || support.getDropAction() != 0x40000000;
            DesktopScreenWindow.this.monitor.cartridgeInsert(cart, autoPower);
            return true;
        }
    }
}

