/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.pc.speaker;

import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;
import org.javatari.general.av.audio.AudioMonitor;
import org.javatari.general.av.audio.AudioSignal;
import org.javatari.general.board.Clock;
import org.javatari.general.board.ClockDriven;
import org.javatari.parameters.Parameters;

public final class Speaker
implements ClockDriven,
AudioMonitor {
    public Clock clock;
    private AudioSignal signal;
    private SourceDataLine dataLine;
    private ByteBuffer inputBuffer;
    private byte[] tempBuffer;
    private boolean triedToGetLine = false;
    private final AudioFormat AUDIO_FORMAT = new AudioFormat(SAMPLE_RATE, 8, 1, true, false);
    private static final double FPS = Parameters.SPEAKER_DEFAULT_FPS;
    private static final int SAMPLE_RATE = Parameters.TIA_AUDIO_SAMPLE_RATE;
    private static final int INPUT_BUFFER_SIZE = Parameters.SPEAKER_INPUT_BUFFER_SIZE;
    private static final int OUTPUT_BUFFER_SIZE = Parameters.SPEAKER_OUTPUT_BUFFER_SIZE;
    private static final int OUTPUT_BUFFER_FULL_SLEEP_TIME = Parameters.SPEAKER_OUTPUT_BUFFER_FULL_SLEEP_TIME;
    private static final int NO_DATA_SLEEP_TIME = Parameters.SPEAKER_NO_DATA_SLEEP_TIME;
    private static final int ADDED_THREAD_PRIORITY = Parameters.SPEAKER_ADDED_THREAD_PRIORITY;

    public void connect(AudioSignal signal) {
        this.signal = signal;
        signal.connectMonitor(this);
    }

    public void powerOn() {
        if (!this.triedToGetLine) {
            this.getLine();
        }
        if (this.dataLine == null) {
            return;
        }
        this.dataLine.start();
        this.clock.go();
    }

    public void powerOff() {
        if (this.dataLine == null) {
            return;
        }
        this.clock.pause();
        this.dataLine.flush();
        this.dataLine.stop();
    }

    public void destroy() {
        if (this.dataLine == null) {
            return;
        }
        this.clock.terminate();
        this.dataLine.close();
        this.dataLine = null;
    }

    @Override
    public synchronized int nextSamples(byte[] buffer, int quant) {
        if (this.dataLine == null) {
            return -1;
        }
        if (buffer == null) {
            this.dataLine.flush();
            return -1;
        }
        int ava = this.inputBuffer.remaining();
        if (ava > quant) {
            ava = quant;
        }
        this.inputBuffer.put(buffer, 0, ava);
        return this.inputBuffer.position();
    }

    @Override
    public void synchOutput() {
        this.refresh();
    }

    @Override
    public void clockPulse() {
        this.synchOutput();
    }

    private void getLine() {
        if (this.signal == null) {
            return;
        }
        try {
            this.triedToGetLine = true;
            this.dataLine = AudioSystem.getSourceDataLine(this.AUDIO_FORMAT);
            this.dataLine.open(this.AUDIO_FORMAT, OUTPUT_BUFFER_SIZE);
            this.inputBuffer = ByteBuffer.allocateDirect(INPUT_BUFFER_SIZE);
            this.tempBuffer = new byte[this.inputBuffer.capacity()];
            if (ADDED_THREAD_PRIORITY != 0) {
                this.clock.setPriority(5 + ADDED_THREAD_PRIORITY);
            }
            System.out.println("Sound Mixer Line: " + this.dataLine.getClass().getSimpleName());
            this.clock = new Clock("Speaker", this, FPS);
        }
        catch (Exception ex) {
            System.out.println("Unable to acquire audio line:\n" + ex);
            this.dataLine = null;
        }
    }

    private synchronized int getFromInputBuffer(byte[] buffer, int quant) {
        this.inputBuffer.flip();
        int ava = this.inputBuffer.remaining();
        if (ava > quant) {
            ava = quant;
        }
        this.inputBuffer.get(buffer, 0, ava);
        this.inputBuffer.compact();
        return ava;
    }

    private void refresh() {
        if (this.dataLine == null) {
            return;
        }
        int ava = this.dataLine.available();
        if (ava == 0) {
            if (OUTPUT_BUFFER_FULL_SLEEP_TIME > 0 && FPS < 0.0) {
                try {
                    Thread.sleep(OUTPUT_BUFFER_FULL_SLEEP_TIME, 0);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return;
        }
        int data = this.getFromInputBuffer(this.tempBuffer, ava);
        if (data == 0) {
            if (NO_DATA_SLEEP_TIME > 0 && FPS < 0.0) {
                try {
                    Thread.sleep(NO_DATA_SLEEP_TIME, 0);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return;
        }
        this.dataLine.write(this.tempBuffer, 0, data);
        if (FPS < 0.0) {
            try {
                Thread.sleep(OUTPUT_BUFFER_FULL_SLEEP_TIME, 0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

