/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge;

import java.io.Serializable;
import java.util.Map;
import org.javatari.atari.board.BUS;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeInfo;
import org.javatari.atari.cartridge.ROM;
import org.javatari.atari.console.savestate.SaveStateSocket;
import org.javatari.atari.controls.ConsoleControls;
import org.javatari.atari.controls.ConsoleControlsInput;
import org.javatari.general.board.BUS16Bits;
import org.javatari.general.board.ClockDriven;

public abstract class Cartridge
implements BUS16Bits,
ClockDriven,
Cloneable,
Serializable,
ConsoleControlsInput {
    protected final ROM rom;
    protected byte[] bytes;
    private final CartridgeFormat format;
    protected int maskedAddress;
    private static final int ADDRESS_MASK = 4095;
    public static final long serialVersionUID = 2L;

    protected Cartridge(ROM rom, CartridgeFormat format) {
        this.rom = rom;
        this.bytes = rom.content;
        this.format = format;
    }

    public ROM rom() {
        return this.rom;
    }

    public CartridgeFormat format() {
        return this.format;
    }

    public CartridgeInfo getInfo() {
        return this.rom.info;
    }

    public void connectBus(BUS bus) {
    }

    public void connectSaveStateSocket(SaveStateSocket socket) {
    }

    @Override
    public void clockPulse() {
    }

    @Override
    public byte readByte(int address) {
        this.maskAddress(address);
        return this.bytes[this.maskedAddress];
    }

    @Override
    public void writeByte(int address, byte b) {
        this.maskAddress(address);
    }

    public void monitorByteRead(int address, byte data) {
    }

    public void monitorByteWritten(int address, byte data) {
    }

    public boolean needsClock() {
        return false;
    }

    public boolean needsBusMonitoring() {
        return false;
    }

    protected void maskAddress(int address) {
        this.maskedAddress = address & 0xFFF;
    }

    public Cartridge clone() {
        try {
            return (Cartridge)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public void controlStateChanged(ConsoleControls.Control control, boolean state) {
    }

    @Override
    public void controlStateChanged(ConsoleControls.Control control, int position) {
    }

    @Override
    public void controlsStateReport(Map<ConsoleControls.Control, Boolean> report) {
    }
}

