/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.ROM;
import org.javatari.atari.cartridge.formats.Cartridge8K_512K_3F;

public final class Cartridge8K_512K_3E
extends Cartridge8K_512K_3F {
    private int extraRAMBankAddressOffset = -1;
    private byte[] extraRAM = new byte[0];
    private static final int EXTRA_RAM_BANK_SIZE = 1024;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("3E", "8K-512K Tigervision (+RAM)"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge createCartridge(ROM rom) {
            return new Cartridge8K_512K_3E(rom, null);
        }

        @Override
        public CartridgeFormatOption getOption(ROM rom) {
            if (rom.content.length % 2048 != 0 || rom.content.length < 8192 || rom.content.length > 524288) {
                return null;
            }
            return new CartridgeFormatOption(111, this, rom);
        }
    };
    public static final long serialVersionUID = 1L;

    private Cartridge8K_512K_3E(ROM rom) {
        super(rom, FORMAT);
    }

    @Override
    public byte readByte(int address) {
        this.maskAddress(address);
        if (this.maskedAddress >= 2048) {
            return this.bytes[this.fixedSliceAddressOffset + this.maskedAddress];
        }
        if (this.extraRAMBankAddressOffset >= 0 && this.maskedAddress < 1024) {
            return this.extraRAM[this.extraRAMBankAddressOffset + this.maskedAddress];
        }
        return this.bytes[this.bankAddressOffset + this.maskedAddress];
    }

    @Override
    public void writeByte(int address, byte b) {
        if (this.extraRAMBankAddressOffset < 0) {
            return;
        }
        this.maskAddress(address);
        if (this.maskedAddress >= 1024 && this.maskedAddress <= 2047) {
            this.extraRAM[this.extraRAMBankAddressOffset + this.maskedAddress - 1024] = b;
        }
    }

    @Override
    public void monitorByteWritten(int address, byte data) {
        if (address == 63) {
            int bank = data & 0xFF;
            if (bank <= this.selectableSliceMaxBank) {
                this.bankAddressOffset = bank * 2048;
                this.extraRAMBankAddressOffset = -1;
            }
            return;
        }
        if (address == 62) {
            int bank = data & 0xFF;
            this.adjustExtraRAMSize(bank);
            this.extraRAMBankAddressOffset = bank * 1024;
        }
    }

    private void adjustExtraRAMSize(int bank) {
        if (this.extraRAM.length >= (bank + 1) * 1024) {
            return;
        }
        byte[] newExtraRAM = new byte[(bank + 1) * 1024];
        System.arraycopy(this.extraRAM, 0, newExtraRAM, 0, this.extraRAM.length);
        this.extraRAM = newExtraRAM;
    }

    @Override
    public Cartridge8K_512K_3E clone() {
        Cartridge8K_512K_3E clone = (Cartridge8K_512K_3E)super.clone();
        clone.extraRAM = (byte[])this.extraRAM.clone();
        return clone;
    }

    /* synthetic */ Cartridge8K_512K_3E(ROM rOM, Cartridge8K_512K_3E cartridge8K_512K_3E) {
        this(rOM);
    }
}

