/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.pc.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.javatari.atari.controls.ConsoleControls;
import org.javatari.atari.controls.ConsoleControlsSocket;
import org.javatari.general.av.video.VideoMonitor;
import org.javatari.parameters.Parameters;
import org.javatari.pc.controls.AWTConsoleControls;
import org.javatari.pc.screen.Screen;
import org.joy.Joy;
import org.joy.Joystick;

public final class JoystickConsoleControls
implements ConsoleControls {
    public boolean deviceListFailed = false;
    public boolean p1ControlsMode = false;
    public boolean swappedMode = false;
    public boolean paddleMode = false;
    private final AWTConsoleControls awtControls;
    private VideoMonitor videoMonitor;
    private ConsoleControlsSocket consoleControlsSocket;
    private List<Joy.Info> devices = new Vector<Joy.Info>();
    private Vector<DeviceOption> joystick0DeviceOptions = new Vector();
    private Vector<DeviceOption> joystick1DeviceOptions = new Vector();
    private DeviceOption joystick0DeviceOption;
    private DeviceOption joystick1DeviceOption;
    private Joystick joystick0;
    private Joystick joystick1;
    private State joy0State;
    private State joy1State;
    private Preferences joy0Prefs;
    private Preferences joy1Prefs;
    private boolean started = false;
    private StateUpdater stateUpdater;
    private Joystick joyButtonDetection = null;
    private int joyButtonDetectionLastState = -1;
    private JoystickButtonDetectionListener joyButtonDetectionListener = null;
    private static int JOYSTICK_UPDATE_SLEEP = 1000 / Parameters.JOYSTICK_UPDATE_RATE;

    public JoystickConsoleControls(AWTConsoleControls awtControls) {
        this.awtControls = awtControls;
    }

    public void connect(ConsoleControlsSocket socket) {
        this.consoleControlsSocket = socket;
    }

    public void connectScreen(Screen screen) {
        this.videoMonitor = screen.monitor();
    }

    public void powerOn() {
        this.swappedMode = false;
        this.start();
    }

    public void powerOff() {
        this.stop();
    }

    public void paddleMode(boolean state) {
        this.paddleMode = state;
        this.joy1State.xPosition = -1;
        this.joy0State.xPosition = -1;
    }

    public synchronized void toggleMode() {
        if (!this.started) {
            this.swappedMode = false;
            this.start();
        } else {
            boolean bl = this.swappedMode = !this.swappedMode;
        }
        if (this.started) {
            this.videoMonitor.showOSD("Joystick input " + (this.swappedMode ? "Swapped" : "Normal"), true);
        } else if (this.devices.isEmpty()) {
            this.videoMonitor.showOSD("No Joysticks detected!", true);
        } else {
            this.videoMonitor.showOSD("Joysticks are disabled! Open Settings", true);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public Joystick getJoystick0() {
        return this.joystick0;
    }

    public Joystick getJoystick1() {
        return this.joystick1;
    }

    public Vector<DeviceOption> getJoystick0DeviceOptions() {
        return this.joystick0DeviceOptions;
    }

    public Vector<DeviceOption> getJoystick1DeviceOptions() {
        return this.joystick1DeviceOptions;
    }

    public DeviceOption getJoystick0DeviceOption() {
        return this.joystick0DeviceOption;
    }

    public DeviceOption getJoystick1DeviceOption() {
        return this.joystick1DeviceOption;
    }

    public synchronized void start() {
        this.stop();
        if (this.deviceListFailed) {
            return;
        }
        try {
            this.devices = Joy.listDevices();
        }
        catch (UnsupportedOperationException e) {
            System.out.println(e.getMessage());
            this.deviceListFailed = true;
            this.devices = new ArrayList<Joy.Info>();
            this.joystick1DeviceOptions = new Vector();
            this.joystick0DeviceOptions = this.joystick1DeviceOptions;
            this.joystick1DeviceOption = null;
            this.joystick0DeviceOption = null;
            return;
        }
        this.initPreferences();
        this.setupDeviceOptions(this.joy0Prefs.device, this.joy1Prefs.device);
        if (this.joystick0 == null && this.joystick1 == null) {
            return;
        }
        this.applyPreferences();
        this.updaterActive();
    }

    private void setupDeviceOptions(int joy0Device, int joy1Device) {
        Joy.Info auto0 = this.devices.size() > 0 ? this.devices.get(0) : null;
        Joy.Info auto1 = this.devices.size() > 1 ? this.devices.get(1) : null;
        this.joystick0DeviceOptions = new Vector();
        this.joystick0DeviceOptions.add(new DeviceOption(-99, auto0));
        this.joystick0DeviceOptions.add(new DeviceOption(-1, null));
        this.joystick1DeviceOptions = new Vector();
        this.joystick1DeviceOptions.add(new DeviceOption(-99, auto1));
        this.joystick1DeviceOptions.add(new DeviceOption(-1, null));
        for (Joy.Info info : this.devices) {
            this.joystick0DeviceOptions.add(new DeviceOption(info.id, info));
            this.joystick1DeviceOptions.add(new DeviceOption(info.id, info));
        }
        this.joystick0DeviceOption = null;
        for (DeviceOption opt : this.joystick0DeviceOptions) {
            if (joy0Device != opt.device) continue;
            this.joystick0DeviceOption = opt;
        }
        if (this.joystick0DeviceOption == null) {
            this.joystick0DeviceOption = this.joystick0DeviceOptions.get(0);
        }
        this.joystick1DeviceOption = null;
        for (DeviceOption opt : this.joystick1DeviceOptions) {
            if (joy1Device != opt.device) continue;
            this.joystick1DeviceOption = opt;
        }
        if (this.joystick1DeviceOption == null) {
            this.joystick1DeviceOption = this.joystick1DeviceOptions.get(0);
        }
        if (this.joystick0DeviceOption.info != null) {
            this.joystick0 = Joystick.create(this.joystick0DeviceOption.info);
        }
        if (this.joystick1DeviceOption.info != null) {
            this.joystick1 = Joystick.create(this.joystick1DeviceOption.info);
        }
    }

    private synchronized void stop() {
        this.updaterInactive();
        this.initControls();
    }

    public void initPreferences() {
        this.joy0Prefs = new Preferences();
        this.joy1Prefs = new Preferences();
        this.joy0Prefs.device = Parameters.JOY_P0_DEVICE;
        this.joy0Prefs.xAxis = Parameters.JOY_P0_XAXIS;
        this.joy0Prefs.xAxisSignal = Parameters.JOY_P0_XAXIS_SIGNAL;
        this.joy0Prefs.yAxis = Parameters.JOY_P0_YAXIS;
        this.joy0Prefs.yAxisSignal = Parameters.JOY_P0_YAXIS_SIGNAL;
        this.joy0Prefs.paddleAxis = Parameters.JOY_P0_PAD_AXIS;
        this.joy0Prefs.paddleAxisSignal = Parameters.JOY_P0_PAD_AXIS_SIGNAL;
        this.joy0Prefs.button = Parameters.JOY_P0_BUTTON;
        this.joy0Prefs.button2 = Parameters.JOY_P0_BUTTON2;
        this.joy0Prefs.select = Parameters.JOY_P0_SELECT;
        this.joy0Prefs.reset = Parameters.JOY_P0_RESET;
        this.joy0Prefs.pause = Parameters.JOY_P0_PAUSE;
        this.joy0Prefs.fastSpeed = Parameters.JOY_P0_FAST_SPPED;
        this.joy0Prefs.paddleCenter = (int)((float)Parameters.JOY_P0_PADDLE_CENTER / 100.0f * -190.0f) + 190 - 5;
        this.joy0Prefs.paddleSens = (int)((float)Parameters.JOY_P0_PADDLE_SENS / 100.0f * -190.0f);
        this.joy0Prefs.deadzone = Parameters.JOY_P0_DEADZONE;
        this.joy1Prefs.device = Parameters.JOY_P1_DEVICE;
        this.joy1Prefs.xAxis = Parameters.JOY_P1_XAXIS;
        this.joy1Prefs.xAxisSignal = Parameters.JOY_P1_XAXIS_SIGNAL;
        this.joy1Prefs.yAxis = Parameters.JOY_P1_YAXIS;
        this.joy1Prefs.yAxisSignal = Parameters.JOY_P1_YAXIS_SIGNAL;
        this.joy1Prefs.paddleAxis = Parameters.JOY_P1_PAD_AXIS;
        this.joy1Prefs.paddleAxisSignal = Parameters.JOY_P1_PAD_AXIS_SIGNAL;
        this.joy1Prefs.button = Parameters.JOY_P1_BUTTON;
        this.joy1Prefs.button2 = Parameters.JOY_P1_BUTTON2;
        this.joy1Prefs.select = Parameters.JOY_P1_SELECT;
        this.joy1Prefs.reset = Parameters.JOY_P1_RESET;
        this.joy1Prefs.pause = Parameters.JOY_P1_PAUSE;
        this.joy1Prefs.fastSpeed = Parameters.JOY_P1_FAST_SPPED;
        this.joy1Prefs.deadzone = Parameters.JOY_P1_DEADZONE;
        this.joy1Prefs.paddleCenter = (int)((float)Parameters.JOY_P1_PADDLE_CENTER / 100.0f * -190.0f) + 190 - 5;
        this.joy1Prefs.paddleSens = (int)((float)Parameters.JOY_P1_PADDLE_SENS / 100.0f * -190.0f);
        this.applyPreferences();
    }

    private void initControls() {
        this.joystick1 = null;
        this.joystick0 = null;
        this.joy0State = new State();
        this.joy1State = new State();
    }

    public void applyPreferences() {
        if (this.joystick0 != null) {
            this.joystick0.setDigitalThreshold((float)this.joy0Prefs.deadzone / 100.0f);
        }
        if (this.joystick1 != null) {
            this.joystick1.setDigitalThreshold((float)this.joy1Prefs.deadzone / 100.0f);
        }
    }

    public synchronized boolean startButtonDetection(int joy, JoystickButtonDetectionListener listener) {
        Joystick joystick;
        this.stopButtonDetection();
        if (joy < 0 || joy > 1 || !this.started) {
            return false;
        }
        Joystick joystick2 = joystick = joy == 0 ? this.joystick0 : this.joystick1;
        if (joystick == null) {
            return false;
        }
        this.joyButtonDetection = joystick;
        this.joyButtonDetectionListener = listener;
        return true;
    }

    public synchronized void stopButtonDetection() {
        this.joyButtonDetection = null;
        this.joyButtonDetectionLastState = -1;
        this.joyButtonDetectionListener = null;
    }

    private synchronized void update() {
        boolean ok;
        if (this.joystick0 != null) {
            ok = this.joystick0.update();
            if (ok) {
                this.update(this.joystick0, this.joy0State, this.joy0Prefs, !this.swappedMode);
            } else {
                this.joystick0 = null;
                this.videoMonitor.showOSD(String.valueOf(this.p1ControlsMode ? "P2" : "P1") + " Joystick disconnected", true);
            }
        }
        if (this.joystick1 != null) {
            ok = this.joystick1.update();
            if (ok) {
                this.update(this.joystick1, this.joy1State, this.joy1Prefs, this.swappedMode);
            } else {
                this.joystick1 = null;
                this.videoMonitor.showOSD(String.valueOf(this.p1ControlsMode ? "P1" : "P2") + " Joystick disconnected", true);
            }
        }
        if (this.joystick0 == null && this.joystick1 == null) {
            this.stop();
        }
    }

    private void update(Joystick joystick, State joyState, Preferences joyPrefs, boolean player0) {
        boolean newFastSpeed;
        boolean newPause;
        boolean newReset;
        if (this.paddleMode && joyPrefs.paddleSens != 0) {
            float pos = joystick.getAxisNoThreshold(joyPrefs.paddleAxis) * (float)joyPrefs.paddleAxisSignal;
            int newPosition = (int)(pos * (float)joyPrefs.paddleSens + (float)joyPrefs.paddleCenter);
            if (newPosition < 0) {
                newPosition = 0;
            } else if (newPosition > 380) {
                newPosition = 380;
            }
            if (newPosition != joyState.xPosition) {
                joyState.xPosition = newPosition;
                this.consoleControlsSocket.controlStateChanged(player0 ? ConsoleControls.Control.PADDLE0_POSITION : ConsoleControls.Control.PADDLE1_POSITION, newPosition);
            }
        }
        int newCardinal = Joystick.CENTER;
        if (!this.paddleMode || joyPrefs.paddleSens == 0) {
            newCardinal = joystick.getAxisDirectionCardinal(joyPrefs.xAxis, joyPrefs.xAxisSignal, joyPrefs.yAxis, joyPrefs.yAxisSignal);
        }
        if (newCardinal == Joystick.CENTER && joystick.getInfo().pov) {
            newCardinal = joystick.getPOVDirectionCardinal();
        }
        if (newCardinal != joyState.cardinal) {
            boolean newLEFT;
            boolean newUP = newCardinal == Joystick.NORTHWEST || newCardinal == Joystick.NORTH || newCardinal == Joystick.NORTHEAST;
            boolean newRIGHT = newCardinal == Joystick.NORTHEAST || newCardinal == Joystick.EAST || newCardinal == Joystick.SOUTHEAST;
            boolean newDOWN = newCardinal == Joystick.SOUTHEAST || newCardinal == Joystick.SOUTH || newCardinal == Joystick.SOUTHWEST;
            boolean bl = newLEFT = newCardinal == Joystick.SOUTHWEST || newCardinal == Joystick.WEST || newCardinal == Joystick.NORTHWEST;
            if (player0) {
                this.awtControls.processKeyEvent(Parameters.KEY_P0_UP, 0, newUP);
                this.awtControls.processKeyEvent(Parameters.KEY_P0_RIGHT, 0, newRIGHT);
                this.awtControls.processKeyEvent(Parameters.KEY_P0_DOWN, 0, newDOWN);
                this.awtControls.processKeyEvent(Parameters.KEY_P0_LEFT, 0, newLEFT);
            } else {
                this.awtControls.processKeyEvent(Parameters.KEY_P1_UP, 0, newUP);
                this.awtControls.processKeyEvent(Parameters.KEY_P1_RIGHT, 0, newRIGHT);
                this.awtControls.processKeyEvent(Parameters.KEY_P1_DOWN, 0, newDOWN);
                this.awtControls.processKeyEvent(Parameters.KEY_P1_LEFT, 0, newLEFT);
            }
            joyState.cardinal = newCardinal;
        }
        if (this.joyButtonDetection == joystick) {
            this.detectButton();
        } else {
            boolean newButton;
            boolean bl = newButton = joystick.getButton(joyPrefs.button) || joystick.getButton(joyPrefs.button2);
            if (newButton != joyState.button) {
                this.awtControls.processKeyEvent(player0 ? Parameters.KEY_P0_BUTTON : Parameters.KEY_P1_BUTTON, 0, newButton);
                joyState.button = newButton;
            }
        }
        boolean newSelect = joystick.getButton(joyPrefs.select);
        if (newSelect != joyState.select) {
            this.awtControls.processKeyEvent(122, 0, newSelect);
            joyState.select = newSelect;
        }
        if ((newReset = joystick.getButton(joyPrefs.reset)) != joyState.reset) {
            this.awtControls.processKeyEvent(123, 0, newReset);
            joyState.reset = newReset;
        }
        if ((newPause = joystick.getButton(joyPrefs.pause)) != joyState.pause) {
            this.awtControls.processKeyEvent(80, 512, newPause);
            joyState.pause = newPause;
        }
        if ((newFastSpeed = joystick.getButton(joyPrefs.fastSpeed)) != joyState.fastSpeed) {
            this.awtControls.processKeyEvent(9, 0, newFastSpeed);
            joyState.fastSpeed = newFastSpeed;
        }
    }

    private void detectButton() {
        int buttonsNewState = this.joyButtonDetection.getButtons();
        if (this.joyButtonDetectionLastState == -1) {
            this.joyButtonDetectionLastState = buttonsNewState;
            return;
        }
        if (this.joyButtonDetectionLastState == buttonsNewState) {
            return;
        }
        int b = 0;
        while (b < this.joyButtonDetection.getInfo().buttons) {
            boolean newB;
            boolean bl = newB = (buttonsNewState & 1 << b) != 0;
            if (newB && (this.joyButtonDetectionLastState & 1 << b) == 0) {
                int j = this.joyButtonDetection == this.joystick0 ? 0 : 1;
                JoystickButtonDetectionListener list = this.joyButtonDetectionListener;
                this.stopButtonDetection();
                list.joystickButtonDetected(j, b);
                return;
            }
            ++b;
        }
    }

    private synchronized void updaterActive() {
        this.started = true;
        if (this.stateUpdater != null && this.stateUpdater.isAlive()) {
            return;
        }
        this.stateUpdater = new StateUpdater();
        this.stateUpdater.start();
    }

    private synchronized void updaterInactive() {
        this.started = false;
        if (this.stateUpdater == null) {
            return;
        }
        if (this.stateUpdater.isAlive()) {
            try {
                this.stateUpdater.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.stateUpdater = null;
    }

    public static class DeviceOption {
        public int device;
        public Joy.Info info;

        public DeviceOption(int device, Joy.Info info) {
            this.device = device;
            this.info = info;
        }

        public String toString() {
            return this.device == -1 ? "None" : (this.device == -99 ? "Auto: " + (this.info != null ? this.info : "None") : this.info.toString());
        }
    }

    public static interface JoystickButtonDetectionListener {
        public void joystickButtonDetected(int var1, int var2);
    }

    private static class Preferences {
        public int device;
        public int xAxis;
        public int xAxisSignal;
        public int yAxis;
        public int yAxisSignal;
        public int paddleAxis;
        public int paddleAxisSignal;
        public int button;
        public int button2;
        public int select;
        public int reset;
        public int pause;
        public int fastSpeed;
        public int deadzone;
        public int paddleCenter;
        public int paddleSens;

        private Preferences() {
        }
    }

    private static class State {
        int cardinal = Joystick.CENTER;
        boolean button;
        boolean select;
        boolean reset;
        boolean fastSpeed;
        boolean pause = false;
        int xPosition = -1;

        private State() {
        }
    }

    private class StateUpdater
    extends Thread {
        public StateUpdater() {
            super("JoystickControls Updater");
        }

        @Override
        public void run() {
            while (JoystickConsoleControls.this.started) {
                JoystickConsoleControls.this.update();
                try {
                    StateUpdater.sleep(JOYSTICK_UPDATE_SLEEP);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

