;C64 executable code for HermIRES 'AFLI Exe' export (64tass syntax)
bmpdata=$0B00
titleaddr=bmpdata-40
bitmap=$4000
vidram=$6000
zpreg1=$fa
zpreg2=$fb
srcptr=$fc
tgtptr=$fe
titlePosY=1
titlePosX=$50
titleCol=1
titleSpr=$0c00
charROM=$d800

		*= $0801
		.word ss,2012
		.null $9e,^start;Sys 2064
ss		.word 0

		*= $0810		;INITIALIZATION AT PROGRAM START - set IRQ handlers, screen, and main VIC registers
start	sei
		lda #$35
		sta 1
		jsr Init
		jsr wrtitle

rastlp	lda #$2e
		cmp $d012
		bne *-3

		nop
		lda #0
		sta $d021
		nop
		nop
		nop
		nop
		nop
		
		ldy #25 ;will count rows
-		ldx #$38	;shift badlines up, because no badline/DMA possible after line $f8
		lda #$80
		stx $d011	;trigger badline
		sta $d018	;change video-ram (colour)
		inc $d02f	;wait for 6 cycles (can be a useful command too...)
		lda #$90	;etc...
		inx
		stx $d011
		sta $d018
		dec $d02f
		lda #$a0
		inx
		stx $d011
		sta $d018
		inc $d02f
		lda #$b0
		inx
		stx $d011
		sta $d018
		dec $d02f
		lda #$c0
		inx
		stx $d011
		sta $d018
		inc $d02f
		lda #$d0
		inx
		stx $d011
		sta $d018
		dec $d02f
		lda #$e0
		inx
		stx $d011
		sta $d018
		nop
		nop
		nop
		lda #$f0
		inx
		stx $d011
		sta $d018-$3f,x ;sta $d018 with one extra cycle
		dey
		bpl -

		lda #$fa
		cmp $d012
		bne *-3	
		lda #$17
		sta $d011	;open vertical border - part 1	
		lda #3
		sta $dd00
		lda #0
		sta $d017
		sta $d01c
		lda #$18
		sta $d018
		ldx #3
		dex
		bne *-1
		lda bordercol
		sta $d021
		ldy #15
-		lda #titleCol
		sta $d027,y
		lda titleCoord,y
		sta $d000,y
		dey
		bpl -
		
		lda #titlePosY-1
		cmp $d012
		bne *-3
		ldx #4
		dex
		bne *-1
titlebg	lda #0 ;self-modified code, to border-colour if caption is empty
		sta $d021
		lda #titlePosY+8
		cmp $d012
		bne *-3
		nop
		lda #$18	;open border - part2
		sta $d011
		ldy bordercol
		ldx #22
		dex
		bne *-1
		nop
		nop
		sty $d021
		inx
		stx $d010
		lda #$40	;place AFLI-mark on screen
		sta $d000
		lda #12
		sta $d027
		
		lda $d012
		bne *-3
		ldx #0
		stx $d015 	;hide unneeded sprites
		
		lda #$24
		cmp $d012
		bne *-3
		lda #2
		sta $dd00
		lda #$80
		sta $d018
		lda #$ff
		sta $d015	;sprites enabled to hide FLI-bug & stabilize raster-effects along with badline
		lda #$6b
		sta $d017
		sta $d01c
		ldy #$0f
-		lda FLIbugCol2
		sta $D027,y
		lda VICdata,y
		sta $d000,y
		dey
		bpl -
		lda #0
		sta $d010

		jmp rastlp

;--------------------------------------------------------
Init	;lda #2
		;sta $dd00
		ldy #$2f-1
-		lda VICdata,y
		sta $d000,y
		dey
		bpl -
		lda bmpdata+$3FE8 ;border-colour
		sta $d020
		sta $d021
		sta bordercol
		lda bmpdata+$3FE9 ;FLI-bug underlay-sprite $01 colour
		sta $d025
		lda bmpdata+$3FEA ;FLI-bug underlay-sprite $10 colour
		sta FLIbugCol2
		lda bmpdata+$3FEB ;FLI-bug underlay-sprite $11 colour
		sta $d026
		
		ldy #0			;copy bitmap & colour data to its place
		lda #<(bmpdata+$4000)
		ldx #>(bmpdata+$4000)
		sta srcptr+0
		stx srcptr+1
		lda #<(bitmap+$4000)
		ldx #>(bitmap+$4000)
		sta tgtptr+0
		stx tgtptr+1
		ldy #0
-		lda (srcptr),y
		sta (tgtptr),y
		iny
		bne -
		dec srcptr+1
		dec tgtptr+1
		lda tgtptr+1
		cmp #>(bitmap)
		bpl -
		
;		ldy #$3f
;-		lda #$ff ;0 ;tya
;		sta bitmap+$1f40,y
;		dey
;		bpl -
		ldy #7
-		lda #($1f40/$40)		;most pointers should be set by AFLI exporter of HermIRES instead
;		sta vidram+$3f8,y
;		sta vidram+$400+$3f8,y
;		sta vidram+$400*2+$3f8,y
;		sta vidram+$400*3+$3f8,y
;		sta vidram+$400*4+$3f8,y
;		sta vidram+$400*5+$3f8,y
;		sta vidram+$400*6+$3f8,y
		sta vidram+$400*7+$3f8,y
		lda #($1f80/$40)
		sta vidram+$400*7+$3f8+6 ;lowest (6th) sprite is shorter
		dey
		bpl -
		
		ldx #7
-		txa
		clc
		adc #(titlespr/64)
		sta $0400+$3F8,x 
		dex
		bpl -

		lda #0
		sta $3fff
		sta $7fff		;disable idle-graphics
		rts
		
;----------------------------		
wrtitle	ldy #0
-		lda #0
		sta titlespr,y
		sta titlespr+$100,y
		iny
		bne -

		lda titleaddr+0 ;if no caption, leave caption-graphics empty
		bne +
		lda bordercol
		sta titlebg+1
		rts

+		ldx #0
		stx zpreg1

titlelp	ldx zpreg1
		lda #0
		sta charlop+1
		sta charlop+2
		lda titleaddr,x
		beq doAmark
		asl 			;and multiply by 8 to get character's address
		rol charlop+2
		asl 
		rol charlop+2
		asl 
		rol charlop+2
		sta charlop+1
		lda charlop+2
		clc
		adc #>(charROM)
		sta charlop+2

		lda #<titlespr
		clc
		adc spChrPos,x
		sta tgtptr+0
		ldy #>titlespr
		cpx #12
		bcc +
		iny
+		sty tgtptr+1

		lda #$33		;switch to Char-RAM
		sta 1
		ldy #0
		ldx #0
charlop	lda $1111,x ;copy char byte
		sta (tgtptr),y ;paste char byte to sprite
		iny
		iny
		iny
		inx
		cpx #8
		bne charlop
		lda #$35		;switch to original RAM layout
		sta 1

		inc zpreg1
		ldx zpreg1
		cpx #24
		bne titlelp

doAmark	ldy #3*5-1
-		lda AFLImark,y
		sta titlespr+3*11,y
		dey
		bpl -

endwrti	rts
		
             ;.0  .1  .2  .3  .4  .5  .6  .7  .8  .9  .A  .B  .C  .D  .E  .F
VICdata .byte $18,$84,$18,$30,titlePosX,titlePosY,$18,$5A,titlePosX+24,titlePosY,$18,$ae,$18,$d8,titlePosX+24*2,titlePosY ;$00..$0F
		.byte $00,$08,$2d,$00,$00,$ff,$08,$6b,$80,$01,$01,$ff,$6b,$00,$00,$00 ;$1$00..$1F
		.byte $00,$00,$00,$00,$00,$0d,$0e,$01,$02,$0f,$04,$0f,$06,$07,$0f     ;$2$00..$2e

TitleCoord .byte  titlePosX, titlePosY, titlePosX+24, titlePosY, titlePosX+24*2, titlePosY, titlePosX+24*3, titlePosY 
		   .byte titlePosX+24*4, titlePosY, titlePosX+24*5, titlePosY, titlePosX+24*6, titlePosY, titlePosX+24*7, titlePosY 

spChrPos .byte 0,1,2,$40,$41,$42,$80,$81,$82,$c0,$c1,$c2, 0,1,2,$40,$41,$42,$80,$81,$82,$c0,$c1,$c2

bordercol .byte 0
FLIbugCol2 .byte 0 ;saved in file: colour for FLI-bug underlay-sprites

AFLImark .byte %01001110,%01111011,%00011010
		 .byte %10011011,%01100011,%00011001
		 .byte %10011111,%01111011,%00011001
		 .byte %10011011,%01100011,%00011001
		 .byte %01011011,%01100011,%11011010

;==============================================================================================
;Alternative displayer (without AFLI-bug handling and caption):
;This is a simple, supersmall (A)FLI Displayer - written by Crossbow
;Bitmap at $4000, Videorams at $6000-
;		sei
;		lda #$36
;		sta 1
;AFLIdis	sta $d011
;-		lda $d011
;		eor $d012
;		cmp #$6a
;		bne -
;		jsr $EEA5  ;delay 16 cycles - kernal routine 'Serial output 0': lda $dd00 , ora #$20 , sta $dd00
;		stx $d020  ;4 cycles
;-		ldy #$38
;		lda #$80
;-		sei
;		sta $d018
;		sty $d011
;		inx
;		beq AFLIdis
;		adc #$10
;		bpl --
;		iny
;		bne -

;===============================================================================
.cerror *>titleaddr,"TOO MUCH CODE BEFORE BITMAP-DATA! CHANGE BMPDATA ADDRESS!"

*=titleaddr
;title	.text "AUTHOR-NAME : PIC. TITLE",0
;
*=bmpdata
;.binary"../examples/AFLI/blabla.prg",2

;====================================================================================================
