//============================================================================================================================
//HermIRES - Hires Bitmap Editor for C64 - Hermit Software Hungary (Mihaly Horvath)     -----      Year 2014 A.D.
//============================================================================================================================
#include <allegro.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#include "AllegroPNG/alpng.h"
#include <dirent.h>
#include <stdio.h>
//#include <map>

//------------------------ Operating system specific ---------------------------
#if defined ALLEGRO_WITH_XWINDOWS && defined ALLEGRO_USE_CONSTRUCTOR
// XPM program-icon for linux
static const char *allegico_xpm[] = {
"32 32 8 1 ", // columns, rows, colors, chars-per-pixel
"  c black",
". c #494949494949",
"X c #6D6D6D6D6D6D",
"o c #B6B600000000",
"O c #B6B624242424",
"+ c #6D6D6D6DDBDB",
"@ c #6D6D6D6DFFFF",
"# c #B6B6B6B6B6B6",
/* pixels */
"                                ",
"                                ",
"   .       .       .       .    ",
"   X       X@@@@@@@X       X    ",
"   #     @@#@@@@@@@#       #    ",
"   #    @@@#@@@@@@@#       #    ",
" .###########################.  ",
"   #  @@@@@#@@@@@@@#       #    ",
"   # @@@@@@#@@@@@@@#       #    ",
"   # @+@@@@#       #@@++++@#    ",
"   #++++++ #       #+++++++#    ",
"   #@@@@@@ #       #@@@@@@ #    ",
"   #@@@@@@ #       #@@@@@  #    ",
"   #@@@@@@ #       #@@@@   #    ",
" .###########################.  ",
"   #@@@@@@ #       #oooo   #    ",
"   #@@@@@@ #       #ooooo  #    ",
"   #@@@@@@ #       #oooooo #    ",
"   #++++++ #       #OOOOOOO#    ",
"   # @@@@@@#       #ooooooo#    ",
"   # @@@@@@#@@@@@@@#       #    ",
"   #  @@@@@#@@@@@@@#       #    ",
" .###########################.  ",
"   #    @@@#@@@@@@@#       #    ",
"   #     @@#@@@@@@@#       #    ",
"   #      @#@@@@@@@#       #    ",
"   #       #       #       #    ",
"   #       #       #       #    ",
"   X       X       X       X    ",
"   .       .       .       .    ",
"                                ",
"                                "
};
extern void *allegro_icon;
CONSTRUCTOR_FUNCTION(static void _set_allegro_icon(void));
static void _set_allegro_icon(void)
{
    allegro_icon = allegico_xpm;
}
#endif


//--------------------------------------global variable declarations-----------------------------------------------------

BITMAP *DrawGrid, *ClipboardSprite, *Preview, *CRTpreview, *ToolBar;
PALETTE BMPalette; //no need for save, we use true-colour - for opening&converting 256 colour bitmaps, this may be needed
unsigned int C64Palette[16] = {0x000000,0xFFFFFF,0x68372B,0x70A4B2,0x6F3D86,0x588D43,0x352879,0xB8C76F,
                               0x6F4F25,0x433900,0x9A6759,0x444444,0x6C6C6C,0x9AD284,0x6C5EB5,0x959595};;

//std::map <unsigned int, unsigned int> BackPalette; //will be used for back-conversion from bmp....
const char HexChar[16]={'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};
const unsigned char pow2[8] = {128,64,32,16,8,4,2,1}; //powers of 2 precalculated for fast conversion
int GUIbgColor=0x102030;
int ChrSizeX=8, ChrSizeY=8, NoOfChrX=40, NoOfChrY=25;
int FieldSizeX = ChrSizeX*NoOfChrX; //SprSizeX*NoOfSprX; 
int FieldSizeY = ChrSizeY*NoOfChrY; //SprSizeY*NoOfSprY;
int Mag_min=3, Mag_max=32, MagnifyFactor = Mag_min, Grid_treshold=4, CRTemu_treshold=Mag_min+4, DefaultBlur=180, PALblur=DefaultBlur, Brightness=128;
int GridBorder=10, GridPosX = GridBorder, GridPosY = GridBorder, GridSizeX = Mag_min*FieldSizeX, GridSizeY = Mag_min*FieldSizeY, GridCol = 0x202020,ChrRangeCol = 0xC0C0C0;
int WheelBuf = MagnifyFactor, MButtBuf=0, PreviewPosX=GridBorder, PreviewPosY=GridPosY+GridSizeY+GridBorder; 
int GuiSizeX=FieldSizeX*MagnifyFactor+GridBorder*2, GuiSizeY=FieldSizeY+PreviewPosY+GridBorder; 
int PalButtPosX=FieldSizeX+GridBorder*2, PalButtPosY=GridSizeY+GridBorder*2+10, PalButtSizeX = (GuiSizeX-PalButtPosX-GridBorder)/16, PalButtSizeY=GridSizeY/16;
unsigned char BmpData [328][208]; //dimensions (FieldSizeX, FieldSizeY)
unsigned char BmpClipBoard [320][200]; //dimensions (FieldSizeX, FieldSizeY)
unsigned char C64bmp[0x2000];
int ClipBoardSizeX=0, ClipBoardSizeY=0;
unsigned char ConvChr[16][9][8]; //storing result here for 1 calculated Char on conversion (function ConvertChr)
unsigned char ClashCnt[1040][8]; //colour-count of characters to determine clash - in AFLI-mode the 'slices' are contained in 2nd dimension of the array
unsigned char ColorMap[1024][8]; //colour-map for the hires bitmap - or AFLI bitmap in case of AFLI-mode
unsigned char CopyBuffer[8][8]; //buffer for copy
unsigned char BorderColWidth=4, DefaultBorderCol=11, DefaultBGcol=12, BorderCol=DefaultBorderCol, DrawCol1=1, DrawCol2=DefaultBGcol, DitherCol=14, SelCol=0; 
int CurPosX = 10, CurPosY = 10, GridInPosX=0, GridInPosY=0, ActChar=0, ActQuad=0, ActChrBuf=0; //default position & colours
int mickeyx,mickeyy,TempPosX,TempPosY,TempPosX2,TempPosY2, TempStartX,TempStartY, PrevRightClick=0;
const int ControlTimer = 20; //frequency of timer in milliseconds
volatile int CloseButtState=FALSE; int RButt=0; 
char ConfigPath[480], ConfigFile[]="HermIRES.cfg";
char SAVEpath[480]={"untitled.hbm"}; 
char *LOADpath=SAVEpath; //[480]={"examples/"};
const char *IniPath;
char VPLpath[480]={"palettes/pepto.vpl"};
unsigned int PrgStartAdd = 0x2000;  //bitmap-data loadaddress in hexadecimal
unsigned int AFLIprgStartAdd = 0x4000; //AFLI bitmap-data loadaddress in hexa.
unsigned int BASICstartAdd = 0x0801; //EXE export's BASIC starter load-address
unsigned int EXEdataAdd = 0x0A00, AFLIEXEdataAdd = 0xB00; //EXE export's data-position
unsigned char PreviewZoom = 1; //zooming ratio of preview
int PenDiameter=4, TBSizeY=22, TButtSize=TBSizeY, NoOfButt = 8, TBSizeX=TButtSize*NoOfButt+1, 
    TBCol= 0xA0A0A0, TBFGCol = 0x20202020, TBSelCol = 0xffe080;
int TBPosX = PreviewPosX+FieldSizeX+25,TBPosY = PreviewPosY+(GuiSizeY-PreviewPosY)/2-30;
int TxtInfoPosX=TBPosX+TBSizeX+25, TxtInfoPosY=PalButtPosY+PalButtSizeY+30;
int MenuPosX=GuiSizeX-210, MenuPosY=PalButtPosY+PalButtSizeY+30;
int LinerSwitch = 1, DrawMode=0, RectFill=0, CircFill=0, DitherMode=0, Dither2Col=0; 
float pi=3.1415926, rad=pi/180, GridBrightness=1.00;
unsigned char UndoStore[256][320][200]; //256 full hbm pictures can be stored for undo/redo in this ring-buffer array
unsigned char UndoPointer = 0, UndoBase = 0, RedoMax=0; //undobase counts from 0..255 whenever UndoPointer reaches it, losing oldest step at that time
int ShapeDrawn = 0, mousestartx, mousestarty;
int ShapeRightButt=0;
int ClashTimer=0, ClashBlinkSpeed=70; 
int ClashBlinkRatio=8, BlinkOn=0;
int ClashTestMode=4, GridMode=1; 
int EnableBriGrid=true, CRTmode=1;
int mouse_x_buf, mouse_y_buf;
int SelectionStartX=0, SelectionStartY=0, SelectionEndX=FieldSizeX-1, SelectionEndY=FieldSizeY-1;
int BlinkStrength=60, FlashingColor,colbuf;
int RepeatCounter, RepeatSpeed1=15, RepeatSpeed2=3;
int CursorInSelX=0,CursorInSelY=0,PrevGUIregion=0;
bool InputProcessing=false, Displaying=false; //timer/thread safety switches
int ZoomRectColCnt=0, ZoomRectCol=0, ZoomRectSpeed=60;
bool MovingSelectiON=false;
bool AFLImode=false;
unsigned char FLIbugCol1=0,FLIbugCol2=0,FLIbugCol3=0; //FLI-bug underlay-sprite colours

//function prototypes
void InitBmp(); //InitSpr(); 
void SetTimer();
void GetControls();
void BmpDrawer();
void GridDrawer(int GridCol);
void PrevDrawer();void DrawPrv();
void DrawGridPixel(int x, int y, int col, int chkChar);
void DrawPrevPixel(int x, int y, int col);
void SetBackRange(); int CheckRange(); int GetDataX(); int GetDataY(); int GetDataScreenX(int x); int GetDataScreenY(int y);
int GUIregion;
void CloseButton(); int Quit(void); int Help(void);
int my_button_proc(int msg, DIALOG *d, int c); int my_radio_proc(int msg, DIALOG *d, int c);
int Load();int Save();int ChangeCol(); int LoadVPL();
int SelCol0(); int SelCol1(); int SelCol2(); int SelCol3(); int SelCol4(); int SelCol5(); int SelCol6(); int SelCol7(); int SelCol8(); int SelCol9();
int SelColA(); int SelColB(); int SelColC(); int SelColD(); int SelColE(); int SelColF();
int Pluser(); int Minuser(); void Zoomer(); void SettingDispl(); void CalcActChar();
int ClearBmp(); void DispSelCol(); int Spacer(); int ExportC64(); int ExportExe(); int Deleter(); int CopyChar(); int Paster(); int Cutter(); 
int Homer(); int Ender(); int PageUp(); int PageDn(); int Lefter(); int Righter(); int Upper(); int Downer(); void PrevText();
int SelChrPosX(int Chrnum); 
int SelChrPosY(int Chrnum);
int SavePNG(); void LoadFile(); void LoadBMP(); void LoadPNG(); void LoadPalette();
void DrawBmpData(int x, int y, unsigned char colour);
unsigned char GetMatchCol(unsigned int inputcol);
int F1er(); int F2er(); int F3er(); int F4er(); int F5er();int F6er();int F7er();int F8er();int F9er();int F10er();int F11er();int Zeer(); int Yeer();
void DispToolBar(); void BuffPos();
void DrawBmpPixel(int x, int y, unsigned char col);
void DrawBmpLine(int x1, int y1, int x2, int y2, unsigned char col);
void Undoer(); void Redoer(); void StoreUndo();
int ConvertChr(int Charnum);
void ConvBackBMP(BITMAP *bitmap);
void LineShape(); //draw a line from muse-click position to mouse-release position
void RectDraw(); //draw a rectangle (normal/filled) from muse-click position to mouse-release position
void CircleDraw();
void Filler();
void CopyCutSelection(); void PasteMoveSelection();
int ClashTest(), ToggleGrid(), ToggleBriGrid(); int ToggleCRTemul();
void DetectClashes();
void BorderDrawer();
void DisplayClipBoard();
void SetBlockCol(int colour);
int PickColor1();
int IncPenDiameter(); int DecPenDiameter();
int SetBrightness(); int SetBlur(); int ResetBrightness(); int ResetPALblur();
int CursorInSelection();
void dispGridBri();
int SwapColor12();
void ShapePreview(); void PenPreview(); void SelectionPreview(int DisplayContent); void GridBlitter();
void SetBlkCol(int x, int y, int ToChange, int colour);
void ShowZoomLocation(); void PrevBlitter();
void CarefulPixel(int &x, int &y, unsigned char col );
void ShowProgress(int percent);
int ToggleAFLImode(); void AFLIbuttonCol();
void SetSlcCol(int x, int y, int ToChange, int colour);
int ConvertSlice(int x, int y);

DIALOG HermIRESdialog [] =  //Array of GUI-dialog elements
{
 /* (proc)        (x)  (y)  (w) (h) (fg) (bg) (key) (flags) (d1) (d2) (dp)           (dp2) (dp3) */
//Clear Dialog screen
 { d_clear_proc,        0,   0,    0,    0,   0,  GUIbgColor,    0,      0,       0,   0,    NULL,                   NULL, NULL  },

//Palette Buttons & keys, sliders - don't insert anything here, the elements are accessed by their index
 { my_button_proc, PalButtPosX+PalButtSizeX*0, PalButtPosY,  PalButtSizeX, PalButtSizeY, 0xFFFFFF, C64Palette[0], 0, D_EXIT, 0, 0, (void*)"0&0", NULL, (void*)ChangeCol },
 { my_button_proc, PalButtPosX+PalButtSizeX*1, PalButtPosY,  PalButtSizeX, PalButtSizeY, 0x000000, C64Palette[1], 0, D_EXIT|D_DIRTY, 1, 0, (void*)"0&1", NULL, (void*)ChangeCol },
 { my_button_proc, PalButtPosX+PalButtSizeX*2, PalButtPosY,  PalButtSizeX, PalButtSizeY, 0x000000, C64Palette[2], 0, D_EXIT|D_DIRTY, 2, 0, (void*)"0&2", NULL, (void*)ChangeCol },
 { my_button_proc, PalButtPosX+PalButtSizeX*3, PalButtPosY,  PalButtSizeX, PalButtSizeY, 0x000000, C64Palette[3], 0, D_EXIT|D_DIRTY, 3, 0, (void*)"0&3", NULL, (void*)ChangeCol },
 { my_button_proc, PalButtPosX+PalButtSizeX*4, PalButtPosY,  PalButtSizeX, PalButtSizeY, 0x000000, C64Palette[4], 0, D_EXIT|D_DIRTY, 4, 0, (void*)"0&4", NULL, (void*)ChangeCol },
 { my_button_proc, PalButtPosX+PalButtSizeX*5, PalButtPosY,  PalButtSizeX, PalButtSizeY, 0x000000, C64Palette[5], 0, D_EXIT|D_DIRTY, 5, 0, (void*)"0&5", NULL, (void*)ChangeCol },
 { my_button_proc, PalButtPosX+PalButtSizeX*6, PalButtPosY,  PalButtSizeX, PalButtSizeY, 0x000000, C64Palette[6], 0, D_EXIT|D_DIRTY, 6, 0, (void*)"0&6", NULL, (void*)ChangeCol },
 { my_button_proc, PalButtPosX+PalButtSizeX*7, PalButtPosY,  PalButtSizeX, PalButtSizeY, 0x000000, C64Palette[7], 0, D_EXIT|D_DIRTY, 7, 0, (void*)"0&7", NULL, (void*)ChangeCol },
 { my_button_proc, PalButtPosX+PalButtSizeX*8, PalButtPosY,  PalButtSizeX, PalButtSizeY, 0x000000, C64Palette[8], 0, D_EXIT|D_DIRTY, 8, 0, (void*)"0&8", NULL, (void*)ChangeCol },
 { my_button_proc, PalButtPosX+PalButtSizeX*9, PalButtPosY,  PalButtSizeX, PalButtSizeY, 0x000000, C64Palette[9], 0, D_EXIT|D_DIRTY, 9, 0, (void*)"0&9", NULL, (void*)ChangeCol },
 { my_button_proc, PalButtPosX+PalButtSizeX*10, PalButtPosY, PalButtSizeX, PalButtSizeY, 0x000000, C64Palette[10], 0, D_EXIT|D_DIRTY, 10, 0, (void*)"0&A", NULL, (void*)ChangeCol },
 { my_button_proc, PalButtPosX+PalButtSizeX*11, PalButtPosY, PalButtSizeX, PalButtSizeY, 0x000000, C64Palette[11], 0, D_EXIT|D_DIRTY, 11, 0, (void*)"0&B", NULL, (void*)ChangeCol },
 { my_button_proc, PalButtPosX+PalButtSizeX*12, PalButtPosY, PalButtSizeX, PalButtSizeY, 0x000000, C64Palette[12], 0, D_EXIT|D_DIRTY, 12, 0, (void*)"0&C", NULL, (void*)ChangeCol },
 { my_button_proc, PalButtPosX+PalButtSizeX*13, PalButtPosY, PalButtSizeX, PalButtSizeY, 0x000000, C64Palette[13], 0, D_EXIT|D_DIRTY, 13, 0, (void*)"0&D", NULL, (void*)ChangeCol },
 { my_button_proc, PalButtPosX+PalButtSizeX*14, PalButtPosY, PalButtSizeX, PalButtSizeY, 0x000000, C64Palette[14], 0, D_EXIT|D_DIRTY, 14, 0, (void*)"0&E", NULL, (void*)ChangeCol },
 { my_button_proc, PalButtPosX+PalButtSizeX*15, PalButtPosY, PalButtSizeX, PalButtSizeY, 0x000000, C64Palette[15], 0, D_EXIT|D_DIRTY, 15, 0, (void*)"0&F", NULL, (void*)ChangeCol },
 { d_slider_proc,  TBPosX+90, TBPosY+TBSizeY+25,  80,   12,   0x8090a0,  GUIbgColor,    0,      D_DIRTY,     255,  Brightness,    NULL, (void *)SetBrightness, NULL  },
 { d_slider_proc,  TBPosX+90, TBPosY+TBSizeY+45,  80,   12,   0x8090a0,  GUIbgColor,    0,      D_DIRTY,     255,  PALblur,    NULL, (void *)SetBlur, NULL  },
 { my_button_proc, TBPosX+90+85, TBPosY+TBSizeY+25, 12, 12, 0x8090a0, GUIbgColor,  0, D_EXIT|D_DIRTY, 16, 0, (void*)"R", NULL, (void *)ResetBrightness},
 { my_button_proc, TBPosX+90+85, TBPosY+TBSizeY+45, 12, 12, 0x8090a0, GUIbgColor,  0, D_EXIT|D_DIRTY, 16, 0, (void*)"R", NULL, (void *)ResetPALblur},
//Main Menu Buttons from index 21
 { my_button_proc, MenuPosX-12 , MenuPosY    , 107, 20, 0xF0F0F0, 0x808080, 'l', D_EXIT|D_DIRTY, 16, 0, (void*)"&Load Picture", NULL, (void *)Load},
 { my_button_proc, MenuPosX-12 , MenuPosY+35 , 107, 20, 0xF0F0F0, 0x808080, 'p', D_EXIT|D_DIRTY, 16, 0, (void*)"Load &Palette", NULL, (void *)LoadVPL},
 { my_button_proc, MenuPosX-12 , MenuPosY+65 , 107, 20, 0xF0F0F0, 0x808080,   0, D_EXIT|D_DIRTY, 16, 0, (void*)"Clear Picture", NULL, (void *)ClearBmp},
 { my_button_proc, MenuPosX+1  , MenuPosY+100, 90, 20, 0xF0F0F0, 0x808080, 'h', D_EXIT|D_DIRTY, 16, 0, (void*)"&Help", NULL, (void *)Help},
 { my_button_proc, MenuPosX+100, MenuPosY    , 107, 20, 0xF0F0F0, 0x808080,  's', D_EXIT|D_DIRTY, 16, 0, (void*)"&Save Picture", NULL, (void *)Save},
 { my_button_proc, MenuPosX+100, MenuPosY+35 , 107, 20, 0xF0F0F0, 0x808080,    0, D_EXIT|D_DIRTY, 16, 0, (void*)"Export C64bmp", NULL, (void*)ExportC64},
 { my_button_proc, MenuPosX+100, MenuPosY+65 , 107, 20, 0xF0F0F0, 0x808080,    0, D_EXIT|D_DIRTY, 16, 0, (void*)"Export C64exe", NULL, (void*)ExportExe},
 { my_button_proc, MenuPosX+107, MenuPosY+100, 90, 20, 0xF0F0F0, 0x808080,  'q', D_EXIT|D_DIRTY, 16, 0, (void*)"&Quit", NULL, (void *)Quit},
//toggle-buttons from index 29
 { my_button_proc, MenuPosX-120, MenuPosY+100, 85, 20, 0xF0F0F0, 0x808080,   0, D_EXIT|D_DIRTY, 16, 0, (void*)"BrightGrid", NULL, (void *)ToggleBriGrid},
 { my_button_proc, MenuPosX-220, MenuPosY+100, 85, 20, 0xF0F0F0, 0x808080, 't', D_EXIT|D_DIRTY, 16, 0, (void*)"&TestClash", NULL, (void *)ClashTest},
 { my_button_proc, MenuPosX-320, MenuPosY+100, 45, 20, 0xF0F0F0, 0x808080, 'g', D_EXIT|D_DIRTY, 16, 0, (void*)"&Grid", NULL, (void *)ToggleGrid},
 { my_button_proc, MenuPosX-420, MenuPosY+100, 85, 20, 0xF0F0F0, 0x808080, 'r', D_EXIT|D_DIRTY, 16, 0, (void*)"C&RT emul.", NULL, (void *)ToggleCRTemul},
 { my_button_proc, MenuPosX-275, MenuPosY+100, 40, 20, 0xF0F0F0, 0x808080,   0, D_EXIT|D_DIRTY, 16, 0, (void*)"AFLI", NULL, (void *)ToggleAFLImode},

 //{ d_text_proc,    TBPosX+100, TBPosY,  160,   48,   0x603040,  0xa0c0d0,    0,      D_EXIT|D_DIRTY,       0,   0,    (void *)help_text,       NULL, NULL  },
//GUI-control keys
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_ESC,   0,    (void *)Quit, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_PLUS_PAD, 0, (void *)Pluser, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_MINUS_PAD, 0, (void *)Minuser, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_SPACE, 0, (void *)Spacer, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_DEL, 0, (void *)Deleter, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_BACKSPACE, 0, (void *)Deleter, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_V, 0, (void *)Paster, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_X, 0, (void *)Cutter, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_HOME, 0, (void *)Homer, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_END, 0, (void *)Ender, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_PGUP, 0, (void *)PageUp, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_PGDN, 0, (void *)PageDn, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_LEFT, 0, (void *)Lefter, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_RIGHT, 0, (void *)Righter, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_UP, 0, (void *)Upper, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_DOWN, 0, (void *)Downer, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_Z, 0, (void *)Zeer, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_Y, 0, (void *)Yeer, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_TAB, 0, (void *)PickColor1, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_TILDE, 0, (void *)SwapColor12, NULL, NULL  },

//Palette keys 0..9
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_0, 0, (void *)SelCol0, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_1, 0, (void *)SelCol1, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_2, 0, (void *)SelCol2, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_3, 0, (void *)SelCol3, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_4, 0, (void *)SelCol4, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_5, 0, (void *)SelCol5, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_6, 0, (void *)SelCol6, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_7, 0, (void *)SelCol7, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_8, 0, (void *)SelCol8, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_9, 0, (void *)SelCol9, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_A, 0, (void *)SelColA, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_B, 0, (void *)SelColB, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_C, 0, (void *)SelColC, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_D, 0, (void *)SelColD, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_E, 0, (void *)SelColE, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_F, 0, (void *)SelColF, NULL, NULL  },
//pencil-switcher keys
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_F1, 0, (void *)F1er, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_F2, 0, (void *)F2er, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_F3, 0, (void *)F3er, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_F4, 0, (void *)F4er, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_F5, 0, (void *)F5er, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_F6, 0, (void *)F6er, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_F7, 0, (void *)F7er, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_F8, 0, (void *)F8er, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_F9, 0, (void *)F9er, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_F10, 0, (void *)F10er, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_F11, 0, (void *)F11er, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_OPENBRACE, 0, (void *)DecPenDiameter, NULL, NULL  },
 { d_keyboard_proc,     0,   0,    0,    0,   0,  0,    0,      0,  KEY_CLOSEBRACE, 0, (void *)IncPenDiameter, NULL, NULL  },
//stabilizer
 { d_yield_proc,        0,   0,    0,    0,   0,  0,    0,      0,       0,   0,    NULL,                   NULL, NULL  },
 { NULL,          0,   0,   0,  0,  0,   0,   0,    0,      0,   0,   NULL,          NULL, NULL }
 };

char * shortButtName[8]={"&Load Pic.","Load &Pal.","Clear Pic.","&Help","&Save Pic","Export C64","Export Exe","&Quit"};

//------------------------------------------------------------------------------
int SizeGUI()
    {
     int i,width,height,taskbarsize=45;
     remove_timer();
     get_desktop_resolution(&width, &height); 
     for(i=4;i>=2;i--) //detect possible maximal resolution
     {
      Mag_min=MagnifyFactor=i; //every size and position is set to minimal magnification
      GridSizeX = Mag_min*FieldSizeX; GridSizeY = Mag_min*FieldSizeY;
      PreviewPosX=GridBorder; PreviewPosY=GridPosY+GridSizeY+GridBorder; 
      GuiSizeX=FieldSizeX*Mag_min+GridBorder*2; GuiSizeY=PreviewPosY+FieldSizeY+GridBorder;
      if (i==2 || (GuiSizeX<width && GuiSizeY<height-taskbarsize) ) { set_gfx_mode(GFX_AUTODETECT_WINDOWED, GuiSizeX, GuiSizeY, 0, 0); break; }
     }
     CRTemu_treshold=Mag_min+4;

     PalButtPosX=FieldSizeX+GridBorder*2-2; PalButtPosY=GridSizeY+GridBorder*2+Mag_min; PalButtSizeX = (GuiSizeX-PalButtPosX)/16; PalButtSizeY=GridSizeY/16;
     TBPosX = (Mag_min>2) ? PreviewPosX+FieldSizeX+8*Mag_min : PreviewPosX+FieldSizeX+10; 
     TBPosY = (Mag_min>2) ? PalButtPosY+PalButtSizeY+10*Mag_min : PalButtPosY+PalButtSizeY+10;
     TxtInfoPosX=(Mag_min>2) ? GuiSizeX-(GuiSizeX-(TBPosX+TBSizeX))/2-200 : TBPosX+TBSizeX+5; 
     TxtInfoPosY=(Mag_min>2) ? PalButtPosY+PalButtSizeY+30 : PalButtPosY+PalButtSizeY+5;
     MenuPosX=(Mag_min>2)?GuiSizeX-215:GuiSizeX-188; MenuPosY=(Mag_min>2)?PalButtPosY+PalButtSizeY+25:PalButtPosY+PalButtSizeY+88;
     for(i=0; i<16; i++)
     {
      HermIRESdialog[i+1].x=PalButtPosX+PalButtSizeX*i; HermIRESdialog[i+1].y=PalButtPosY; 
      HermIRESdialog[i+1].w=PalButtSizeX; HermIRESdialog[i+1].h=PalButtSizeY;
     }
     if (Mag_min<=2) { HermIRESdialog[17].x=HermIRESdialog[18].x=TBPosX+80; HermIRESdialog[19].x=HermIRESdialog[20].x=TBPosX+80+85; }
     HermIRESdialog[17].y=HermIRESdialog[19].y=(Mag_min>2) ? TBPosY+TBSizeY+20 : TBPosY+TBSizeY+10;
     HermIRESdialog[18].y=HermIRESdialog[20].y=(Mag_min>2) ? TBPosY+TBSizeY+40 : TBPosY+TBSizeY+24;
     if (Mag_min>2)
     {
      for (i=0;i<8;i++) { HermIRESdialog[21+i].x=MenuPosX+(i&4)/4*112-12+(107-HermIRESdialog[21+i].w)/2 ; HermIRESdialog[21+i].y=MenuPosY+(i&3)*33; }
      for (i=0;i<4;i++) { HermIRESdialog[29+i].x=MenuPosX-(i+1)*100-6*Mag_min; HermIRESdialog[29+i].y=MenuPosY+100; }
     }
     else
     { //'lores' mode buttons
      for (i=0;i<8;i++) 
       { 
        HermIRESdialog[21+i].w=85;
        HermIRESdialog[21+i].x=MenuPosX+(i&4)/4*95; HermIRESdialog[21+i].y=MenuPosY+(i&3)*22;
        HermIRESdialog[21+i].dp=shortButtName[i];
       } 
      for (i=0;i<4;i++) { HermIRESdialog[29+i].x=MenuPosX-95; HermIRESdialog[29+i].y=MenuPosY+22*(3-i); }
     }
     HermIRESdialog[33].x=HermIRESdialog[31].x+45; HermIRESdialog[33].y=HermIRESdialog[31].y;  //'AFLI' button
    }

//----------------------------------------------------------------------------------
/*static char * GetFileList() //(int index, int *list_size)
{
  /*if (index < 0) {
  if (list_size)
  *list_size = flist->size;
  return NULL;
 }
 return flist->name[index]; */
 
 /*DIR *pdir;
 struct dirent *pent;

 pdir=opendir("."); //"." refers to the current dir
 if (!pdir){
 printf ("opendir() failure; terminating");
 exit(1);
 }
 errno=0;
 while ((pent=readdir(pdir))){
  printf("%s", pent->d_name);
 }
 if (errno){
 printf ("readdir() failure; terminating");
 }
 closedir(pdir);*/
 
 /*return SAVEpath; 
}*/

/*static DIALOG FileDialog [] =  //Array of GUI-dialog elements
{
 // (proc)        (x)  (y)  (w) (h) (fg) (bg) (key) (flags) (d1) (d2) (dp)           (dp2) (dp3) 
//Clear Dialog screen
 { d_shadow_box_proc, 15,    80,310+FieldSizeX,      300,  0,    0,    0,    0,       0,    0,    NULL,             NULL, NULL  },
 { d_ctext_proc,      152, 100,    1,    1,    0,    0,    0,    0,       0,    0,    NULL,             NULL, },
 { d_shadow_box_proc, 320, 180,FieldSizeX+2,FieldSizeY+2,  0,    0,    0,    0,       0,    0,    NULL,             NULL, NULL  },
 { d_button_proc,     64,   160,  81,   17,   0,    0,    0,    D_EXIT,  0,    0,    (void*)"OK",      NULL, (void*)LoadFile  },
 { d_button_proc,     160,  160,  81,   17,   0,    0,    27,   D_EXIT,  0,    0,    (void*)"CANCEL",  NULL, (void*)LoadFile  },
 //{ d_edit_proc,         16,   28,   272,  8,    0,    0,    0,    0,       79,   0,    NULL,             NULL, NULL  },
 //{ d_text_list_proc,        16,   46,   273,  100,  0,    0,    0,    D_EXIT,  0,    0,   GetFileList,     NULL, NULL  },
 { d_yield_proc,        0,   0,    0,    0,   0,  0,    0,      0,       0,   0,    NULL,                   NULL, NULL  },
 { NULL,          0,   0,   0,  0,  0,   0,   0,    0,      0,   0,   NULL,          NULL, NULL }
};*/

int FileSelector(const char *message, char *path, const char *ext, int size, int width, int height)
{
 //if (RButt==1 || key_shifts&KB_SHIFT_FLAG)  
  return file_select_ex(message,path,ext,size,width,height);
 /*else
 {
  remove_timer();
  //BITMAP *FilePreview;
  char path[480];
  int FilerBorderX=10*Mag_min, FilerBorderY=30*Mag_min;
  int FilerSizeX=GuiSizeX-FilerBorderX*2, FilerSizeY=GuiSizeY-FilerBorderY*2;
  int FilerPosX=FilerBorderX, FilerPosY=FilerBorderY;
  FileDialog[0].h=FilerSizeY; FileDialog[0].w=FilerSizeX; //stretch_dialog(FileDialog, width, height);
  FileDialog[0].x=(GuiSizeX-FilerSizeX)/2; FileDialog[0].y=FilerPosY; //centre_dialog(FileDialog);     //position_dialog(FileDialog,400,500);
  set_dialog_color(FileDialog, gui_fg_color, gui_bg_color);
  FileDialog[0].bg=0x304050;
  FileDialog[1].fg=0xFFFFFF; FileDialog[1].dp = (char *)message; //text
  FileDialog[1].x=GuiSizeX/2; FileDialog[1].y=FilerPosY+20; //text
  int FilePrevPosX=FilerPosX+(FilerSizeX-320)-5*Mag_min, FilePrevPosY=FilerPosY+(FilerSizeY-200)/2;
  FileDialog[2].x=FilePrevPosX; FileDialog[2].y=FilePrevPosY; //file-preview
  FileDialog[3].x=FilerPosX+FilerSizeX/2-25*Mag_min-81; FileDialog[4].x=FilerPosX+FilerSizeX/2+25*Mag_min; //buttons
  FileDialog[3].y=FileDialog[4].y=FilerPosY+FilerSizeY-40; //buttons
  //popup_dialog(FileDialog, -1); do_dialog(FileDialog,-1);
  DIALOG_PLAYER *player2 = init_dialog(FileDialog, -1); update_dialog(player2); 
  
 //FilePreview = load_png(LOADpath,BMPalette); //create_bitmap(FieldSizeX, FieldSizeY);
  //blit(FilePreview,screen,0,0,FilePrevPosX+1,FilePrevPosY+1,FieldSizeX,FieldSizeY);
  
  while (update_dialog(player2))//main loop of GUI dialog
  {rest(200);} 
  shutdown_dialog(player2);

  //destroy_bitmap(FilePreview);
  SetTimer();
  return 0;
 }*/
}

char ExeCaption[100]={0};

static DIALOG EditCaption [] =  //Array of GUI-dialog elements
{
 // (proc)        (x)  (y)  (w) (h) (fg) (bg) (key) (flags) (d1) (d2) (dp)           (dp2) (dp3) 
//Clear Dialog screen
 { d_shadow_box_proc, GuiSizeX-230, GuiSizeY-100,230, 60,  0,    0,    0,    0,       0,    0,    NULL,             NULL, NULL  },
 { d_edit_proc,       GuiSizeX-220, GuiSizeY-70,   200,  8,    0xFFFFFF,    0x000000,    0,    D_EXIT,       24,   0,    ExeCaption,             NULL, NULL  },
 { d_ctext_proc,      GuiSizeX-220, GuiSizeY-90,    1,    1,    0,    0,    0,    0,       0,  0,    NULL,             NULL },
 //{ d_button_proc,     64,   160,  81,   17,   0,    0,    0,    D_EXIT,  0,    0,    (void*)"OK",      NULL, (void*)LoadFile  },
 { d_yield_proc,        0,   0,    0,    0,   0,  0,    0,      0,       0,   0,    NULL,                   NULL, NULL  },
 { NULL,          0,   0,   0,  0,  0,   0,   0,    0,      0,   0,   NULL,          NULL, NULL }
};

//--------------------C64 'exe.prg'-export's native displayer code--------------
unsigned char bmpExe[]=  //generated from ghex's .html output, '0x'-es and ','-s are appended with Geany
{
0x01,0x08,0x0b,0x08,0xdc,0x07,0x9e,0x32,0x30,0x36,0x34,0x00,0x00,0x00,0x00,0x00,
0x00,0x78,0xa9,0x35,0x85,0x01,0xa9,0x03,0x8d,0x00,0xdd,0x8d,0x11,0xd0,0xad,0x28,
0x2d,0x8d,0x20,0xd0,0x8d,0x21,0xd0,0x8d,0xb0,0x09,0x20,0xbd,0x08,0x20,0x25,0x09,
0xa9,0x18,0x8d,0x18,0xd0,0xa9,0x3b,0x8d,0x11,0xd0,0xa9,0x08,0x8d,0x16,0xd0,0xad,
0xd8,0x09,0xf0,0xfb,0xa9,0xf9,0xcd,0x12,0xd0,0xd0,0xfb,0xad,0x11,0xd0,0x09,0x20,
0x29,0xf7,0x8d,0x11,0xd0,0x29,0xf7,0x8d,0x11,0xd0,0xa9,0xff,0x8d,0x15,0xd0,0xa9,
0xfa,0xcd,0x12,0xd0,0xd0,0xfb,0xa2,0x09,0xca,0xd0,0xfd,0xad,0x11,0xd0,0x29,0xdf,
0x8d,0x11,0xd0,0xa9,0x00,0xcd,0x12,0xd0,0xd0,0xfb,0xa9,0x00,0x8d,0x21,0xd0,0xa9,
0x09,0xcd,0x12,0xd0,0xd0,0xfb,0xea,0xad,0x11,0xd0,0x09,0x08,0x29,0xdf,0x8d,0x11,
0xd0,0xac,0xb0,0x09,0xa2,0x15,0xca,0xd0,0xfd,0xea,0x8c,0x21,0xd0,0xa9,0x00,0x8d,
0x15,0xd0,0xad,0x12,0xd0,0xd0,0xfb,0xa9,0x32,0xcd,0x12,0xd0,0xd0,0xfb,0xa2,0x0a,
0xca,0xd0,0xfd,0xad,0x11,0xd0,0x09,0x28,0x8d,0x11,0xd0,0x4c,0x43,0x08,0xa0,0x00,
0xb9,0x40,0x29,0x99,0x00,0x04,0xb9,0x40,0x2a,0x99,0x00,0x05,0xb9,0x40,0x2b,0x99,
0x00,0x06,0xb9,0x40,0x2c,0x99,0x00,0x07,0xc8,0xd0,0xe5,0xa9,0x00,0xa2,0x29,0x85,
0xfc,0x86,0xfd,0xa9,0x00,0xa2,0x3f,0x85,0xfe,0x86,0xff,0xa0,0x00,0xb1,0xfc,0x91,
0xfe,0xc8,0xd0,0xf9,0xc6,0xfd,0xc6,0xff,0xa5,0xff,0xc9,0x20,0x10,0xef,0xa2,0x07,
0x8a,0x0a,0xa8,0xa9,0x01,0x99,0x01,0xd0,0xbd,0x90,0x09,0x99,0x00,0xd0,0xa9,0x0f,
0x9d,0x27,0xd0,0x8a,0x18,0x69,0x30,0x9d,0xf8,0x07,0xca,0x10,0xe3,0xa9,0x00,0x8d,
0x10,0xd0,0x8d,0xff,0x3f,0x60,0xa0,0x00,0xa9,0x00,0x99,0x00,0x0c,0x99,0x00,0x0d,
0xc8,0xd0,0xf5,0xa2,0x00,0x86,0xfa,0xa6,0xfa,0xa9,0x00,0x8d,0x77,0x09,0x8d,0x78,
0x09,0xbd,0xd8,0x09,0xf0,0x4a,0x0a,0x2e,0x78,0x09,0x0a,0x2e,0x78,0x09,0x0a,0x2e,
0x78,0x09,0x8d,0x77,0x09,0xad,0x78,0x09,0x18,0x69,0xd8,0x8d,0x78,0x09,0xa9,0x00,
0x18,0x7d,0x98,0x09,0x85,0xfe,0xa0,0x0c,0xe0,0x0c,0x90,0x01,0xc8,0x84,0xff,0xa9,
0x33,0x85,0x01,0xa0,0x00,0xa2,0x00,0xbd,0x11,0x11,0x91,0xfe,0xc8,0xc8,0xc8,0xe8,
0xe0,0x08,0xd0,0xf3,0xa9,0x35,0x85,0x01,0xe6,0xfa,0xa6,0xfa,0xe0,0x18,0xd0,0xa7,
0x60,0x50,0x68,0x80,0x98,0xb0,0xc8,0xe0,0xf8,0x00,0x01,0x02,0x40,0x41,0x42,0x80,
0x81,0x82,0xc0,0xc1,0xc2,0x00,0x01,0x02,0x40,0x41,0x42,0x80,0x81,0x82,0xc0,0xc1,
0xc2,0x00 
};

unsigned char AFLIexe [] =   //array generated from binary by bin2array 1.1 (made in 2013 by Hermit) 
{
 0x01,0x08,0x0B,0x08,0xDC,0x07,0x9E,0x32,0x30,0x36,0x34,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0xA9,0x35,0x85,0x01,0x20,0x43,0x09,0x20,0xB5,0x09,0xA9,0x2E,0xCD,0x12,
 0xD0,0xD0,0xFB,0xEA,0xA9,0x00,0x8D,0x21,0xD0,0xEA,0xEA,0xEA,0xEA,0xEA,0xA0,0x19,0xA2,0x38,0xA9,0x80,0x8E,0x11,0xD0,0x8D,0x18,0xD0,0xEE,0x2F,0xD0,0xA9,0x90,0xE8,
 0x8E,0x11,0xD0,0x8D,0x18,0xD0,0xCE,0x2F,0xD0,0xA9,0xA0,0xE8,0x8E,0x11,0xD0,0x8D,0x18,0xD0,0xEE,0x2F,0xD0,0xA9,0xB0,0xE8,0x8E,0x11,0xD0,0x8D,0x18,0xD0,0xCE,0x2F,
 0xD0,0xA9,0xC0,0xE8,0x8E,0x11,0xD0,0x8D,0x18,0xD0,0xEE,0x2F,0xD0,0xA9,0xD0,0xE8,0x8E,0x11,0xD0,0x8D,0x18,0xD0,0xCE,0x2F,0xD0,0xA9,0xE0,0xE8,0x8E,0x11,0xD0,0x8D,
 0x18,0xD0,0xEA,0xEA,0xEA,0xA9,0xF0,0xE8,0x8E,0x11,0xD0,0x9D,0xD9,0xCF,0x88,0x10,0x9F,0xA9,0xFA,0xCD,0x12,0xD0,0xD0,0xFB,0xA9,0x17,0x8D,0x11,0xD0,0xA9,0x03,0x8D,
 0x00,0xDD,0xA9,0x00,0x8D,0x17,0xD0,0x8D,0x1C,0xD0,0xA9,0x18,0x8D,0x18,0xD0,0xA2,0x03,0xCA,0xD0,0xFD,0xAD,0x8E,0x0A,0x8D,0x21,0xD0,0xA0,0x0F,0xA9,0x01,0x99,0x27,
 0xD0,0xB9,0x66,0x0A,0x99,0x00,0xD0,0x88,0x10,0xF2,0xA9,0x00,0xCD,0x12,0xD0,0xD0,0xFB,0xA2,0x04,0xCA,0xD0,0xFD,0xA9,0x00,0x8D,0x21,0xD0,0xA9,0x09,0xCD,0x12,0xD0,
 0xD0,0xFB,0xEA,0xA9,0x18,0x8D,0x11,0xD0,0xAC,0x8E,0x0A,0xA2,0x16,0xCA,0xD0,0xFD,0xEA,0xEA,0x8C,0x21,0xD0,0xE8,0x8E,0x10,0xD0,0xA9,0x40,0x8D,0x00,0xD0,0xA9,0x0C,
 0x8D,0x27,0xD0,0xAD,0x12,0xD0,0xD0,0xFB,0xA2,0x00,0x8E,0x15,0xD0,0xA9,0x24,0xCD,0x12,0xD0,0xD0,0xFB,0xA9,0x02,0x8D,0x00,0xDD,0xA9,0x80,0x8D,0x18,0xD0,0xA9,0xFF,
 0x8D,0x15,0xD0,0xA9,0x6B,0x8D,0x17,0xD0,0x8D,0x1C,0xD0,0xA0,0x0F,0xAD,0x8F,0x0A,0x99,0x27,0xD0,0xB9,0x37,0x0A,0x99,0x00,0xD0,0x88,0x10,0xF1,0xA9,0x00,0x8D,0x10,
 0xD0,0x4C,0x1B,0x08,0xA0,0x2E,0xB9,0x37,0x0A,0x99,0x00,0xD0,0x88,0x10,0xF7,0xAD,0xE8,0x4A,0x8D,0x20,0xD0,0x8D,0x21,0xD0,0x8D,0x8E,0x0A,0xAD,0xE9,0x4A,0x8D,0x25,
 0xD0,0xAD,0xEA,0x4A,0x8D,0x8F,0x0A,0xAD,0xEB,0x4A,0x8D,0x26,0xD0,0xA0,0x00,0xA9,0x00,0xA2,0x4B,0x85,0xFC,0x86,0xFD,0xA9,0x00,0xA2,0x80,0x85,0xFE,0x86,0xFF,0xA0,
 0x00,0xB1,0xFC,0x91,0xFE,0xC8,0xD0,0xF9,0xC6,0xFD,0xC6,0xFF,0xA5,0xFF,0xC9,0x40,0x10,0xEF,0xA0,0x07,0xA9,0x7D,0x99,0xF8,0x7F,0xA9,0x7E,0x8D,0xFE,0x7F,0x88,0x10,
 0xF3,0xA2,0x07,0x8A,0x18,0x69,0x30,0x9D,0xF8,0x07,0xCA,0x10,0xF6,0xA9,0x00,0x8D,0xFF,0x3F,0x8D,0xFF,0x7F,0x60,0xA0,0x00,0xA9,0x00,0x99,0x00,0x0C,0x99,0x00,0x0D,
 0xC8,0xD0,0xF5,0xAD,0xD8,0x0A,0xD0,0x07,0xAD,0x8E,0x0A,0x8D,0xD6,0x08,0x60,0xA2,0x00,0x86,0xFA,0xA6,0xFA,0xA9,0x00,0x8D,0x13,0x0A,0x8D,0x14,0x0A,0xBD,0xD8,0x0A,
 0xF0,0x4A,0x0A,0x2E,0x14,0x0A,0x0A,0x2E,0x14,0x0A,0x0A,0x2E,0x14,0x0A,0x8D,0x13,0x0A,0xAD,0x14,0x0A,0x18,0x69,0xD8,0x8D,0x14,0x0A,0xA9,0x00,0x18,0x7D,0x76,0x0A,
 0x85,0xFE,0xA0,0x0C,0xE0,0x0C,0x90,0x01,0xC8,0x84,0xFF,0xA9,0x33,0x85,0x01,0xA0,0x00,0xA2,0x00,0xBD,0x11,0x11,0x91,0xFE,0xC8,0xC8,0xC8,0xE8,0xE0,0x08,0xD0,0xF3,
 0xA9,0x35,0x85,0x01,0xE6,0xFA,0xA6,0xFA,0xE0,0x18,0xD0,0xA7,0xA0,0x0E,0xB9,0x90,0x0A,0x99,0x21,0x0C,0x88,0x10,0xF7,0x60,0x18,0x84,0x18,0x30,0x50,0x01,0x18,0x5A,
 0x68,0x01,0x18,0xAE,0x18,0xD8,0x80,0x01,0x00,0x08,0x2D,0x00,0x00,0xFF,0x08,0x6B,0x80,0x01,0x01,0xFF,0x6B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0D,0x0E,0x01,
 0x02,0x0F,0x04,0x0F,0x06,0x07,0x0F,0x50,0x01,0x68,0x01,0x80,0x01,0x98,0x01,0xB0,0x01,0xC8,0x01,0xE0,0x01,0xF8,0x01,0x00,0x01,0x02,0x40,0x41,0x42,0x80,0x81,0x82,
 0xC0,0xC1,0xC2,0x00,0x01,0x02,0x40,0x41,0x42,0x80,0x81,0x82,0xC0,0xC1,0xC2,0x00,0x00,0x4E,0x7B,0x1A,0x9B,0x63,0x19,0x9F,0x7B,0x19,0x9B,0x63,0x19,0x5B,0x63,0xDA,
  0 
};

//===================================================Main Function===============================================================
int main(int argc, char **argv) 
{	
    set_uformat(U_ASCII); //set character encoding to fix sized 8 bit ASCII characters
    //init window
	if (allegro_init()!= 0) return 1;
	//alpng_init(); //png-library could be loaded like bmp...didn't work, it terminated the program :(
    LOCK_FUNCTION(CloseButton);
    set_close_button_callback(CloseButton);
	install_keyboard(); 
	install_mouse(); enable_hardware_cursor();
	install_timer();
    clear_keybuf();
    
    get_executable_name(ConfigPath, sizeof(ConfigPath));
    replace_filename(ConfigPath, ConfigPath, ConfigFile, sizeof(ConfigPath));
    if (!exists(ConfigPath))
    { //try to create config file if doesn't exist
     PACKFILE *NewConfigFile = pack_fopen(ConfigPath,"w");
     pack_fputs("\n#HermIRES Configuration File (in Allegro format)\n\n",NewConfigFile);
     pack_fclose(NewConfigFile);
    }
    //push_config_state();    /* save the current ini file, then set the program specific one */
    set_config_file(ConfigPath);
    GridMode = get_config_int("settings","gridmode",GridMode);
    AFLImode = get_config_int("settings","AFLImode",AFLImode);
    ClashTestMode = get_config_int("settings","clashtestmode",ClashTestMode);
    EnableBriGrid = get_config_int("settings","enablebrigrid",EnableBriGrid);
    CRTmode = get_config_int("settings","CRTmode",EnableBriGrid);
    PALblur = get_config_int("settings","palblur",DefaultBlur); HermIRESdialog[18].d2=PALblur;
    Brightness = get_config_int("settings","brightness",Brightness);  HermIRESdialog[17].d2=Brightness;
    IniPath=get_config_string("paths","savepath",SAVEpath);
    if (IniPath!=SAVEpath) for (int i=0; i<480,IniPath[i]; i++) SAVEpath[i]=(char)IniPath[i];
    IniPath=get_config_string("paths","vplpath",VPLpath);
    if (IniPath!=VPLpath) for (int i=0; i<480,IniPath[i]; i++) VPLpath[i]=(char)IniPath[i];
	AFLIbuttonCol();

    //for (unsigned int i=0;i<16;i++) {BackPalette[C64Palette[i]]=i;} //copy C64Palette array to Backpalette associative map

    //create and adjust GUI
	set_window_title("HermIRES 1.29 - Hires Bitmap Editor for C64 - Hermit Software Hungary"); 
    //A: slower, but buttons in Windows7 don't disappear, just their text does sometimes: 
    set_color_depth(24); //set_color_depth(24);  
       //B: faster, but Windows freezes s and doesn't always refresh GUI with this (for example, after locking the PC)): 
       //int depth; if ((depth = desktop_color_depth()) != 0) set_color_depth(depth); 
    SizeGUI();
    position_mouse_z(MagnifyFactor);
    set_color_conversion(COLORCONV_TOTAL);
    //create and init bitmaps
    InitBmp();
    DrawGrid = create_bitmap(GridSizeX, GridSizeY);
    ClipboardSprite = create_bitmap(GridSizeX, GridSizeY);
    Preview = create_bitmap(FieldSizeX, FieldSizeY); CRTpreview = create_bitmap(FieldSizeX, FieldSizeY);
    ToolBar = create_bitmap(TBSizeX,TBSizeY);

    //create dialog
    gui_bg_color = C64Palette[6]; gui_mg_color=C64Palette[3]; gui_fg_color = C64Palette[14];
    DIALOG_PLAYER *player = init_dialog(HermIRESdialog, -1); 
    update_dialog(player);
    show_mouse(screen);
    textprintf_ex(screen,font, TBPosX, HermIRESdialog[17].y+2, 0x80FFFF,GUIbgColor,"Brightness");
    textprintf_ex(screen,font, TBPosX, HermIRESdialog[18].y+2, 0x80FFFF,GUIbgColor,"CRT-smooth");

    LoadPalette(); 
    if (argc == 2) //checks whether not less/more than one command line option, which should be filename
    {//MIME to path - open the file from command line parameter
     for (int i=0;i < 480;i++) {LOADpath[i] = argv[1][i];}
     LoadFile();
    }
    else
    {
     if (exists(SAVEpath)) LoadFile();
    }
    
    CopyCutSelection(); //by default all is selected automatically at startup

    BorderDrawer(); GridDrawer(GridCol); PrevDrawer(); PrevText(); DispSelCol(); DispToolBar(); //first display of bitmaps, etc.
    SettingDispl();

    LOCK_VARIABLE(DrawGrid);
    LOCK_FUNCTION(GetControls);
    InputProcessing=false; SetTimer();
//----------------------------------------------------------
    while (update_dialog(player)) //main loop of GUI dialog
    {
     if (CloseButtState) if (Quit()==D_CLOSE) goto closeapp;
     if (PrevRightClick != 0) SavePNG();
    }

closeapp:
    set_config_int("settings","gridmode",GridMode);
    set_config_int("settings","AFLImode",AFLImode);
    set_config_int("settings","clashtestmode",ClashTestMode);
    set_config_int("settings","enablebrigrid",EnableBriGrid);
    set_config_int("settings","CRTmode",CRTmode);
    set_config_int("settings","palblur",PALblur);
    set_config_int("settings","brightness",Brightness);
    set_config_string("paths","savepath",SAVEpath);
    set_config_string("paths","vplpath",VPLpath);
    flush_config_file();

    show_mouse(NULL);
    destroy_bitmap(DrawGrid); destroy_bitmap(Preview); destroy_bitmap(ClipboardSprite); destroy_bitmap(CRTpreview); destroy_bitmap(ToolBar);

	return shutdown_dialog(player);
}
END_OF_MAIN();

//==========================================================Functions========================================================
//------------------------------Timed mouse event handler -------------------------------------------------------------------

void GetControls()  //timed function, handles keyboard and mouse events during dialog execution for the drawing part
{
 if (InputProcessing==true) {BuffPos(); return;} //timer thread safety
 InputProcessing=true;
 //clear_keybuf();
 poll_mouse(); poll_keyboard(); CalcActChar();
 get_mouse_mickeys(&mickeyx,&mickeyy);

 if (ClashTimer<0) { ClashTimer=ClashBlinkSpeed; BlinkOn=1; if(ClashTestMode==1) {DetectClashes();GridDrawer(GridCol);} }
 else if (ClashTimer==ClashBlinkSpeed-(ClashBlinkSpeed/ClashBlinkRatio)) { BlinkOn=0; if(ClashTestMode==1) {DetectClashes();GridDrawer(GridCol);} }
 ClashTimer--; 
 FlashingColor = (ClashTimer&16) ? 0xE0E0E0 : 0x101010;
 
 GUIregion=CheckRange();
 if (GUIregion == 0) textprintf_ex(screen,font,TxtInfoPosX, TxtInfoPosY+32,0x80FFFF,0x252a49,(Mag_min>2)?"Pixel   X%.3d    Y%.3d":"Pixel: X%.3d  Y%.3d", GetDataX(), GetDataY());
 else if (GUIregion!=PrevGUIregion) GridBlitter(); //clear the screen from garbage possibly left there

 if (ZoomRectColCnt>0) {ZoomRectColCnt--; ZoomRectCol=abs(ZoomRectColCnt-ZoomRectSpeed/2)*8; ZoomRectCol=makecol(ZoomRectCol,ZoomRectCol,ZoomRectCol); ShowZoomLocation(); } 
 else ZoomRectColCnt=ZoomRectSpeed;

 if ((mouse_b&1 || mouse_b&2) && GUIregion==2)
 { //handle repetitions
  if (RepeatCounter>0) RepeatCounter--;
  else RepeatCounter=RepeatSpeed2;
 }

 if (mouse_b & 1)  //left mouse-button to draw selected Char-colour
 {
  if (GUIregion == 0 ) //the cursor is in grid-window area
  {
   if (key_shifts&KB_SHIFT_FLAG && DrawMode!=5) PickColor1();
   else if (key_shifts&KB_CTRL_FLAG) SetBlockCol(DrawCol1);
   else switch (DrawMode)
   {
    case 0: {DrawBmpData(GetDataX(),GetDataY(),DrawCol1);break;}
    case 1: case 2: case 3: { ShapeDrawn=1;ShapeRightButt=0; ShapePreview(); break; }
    case 4: { Filler(); break; }
    case 5:
    {
     ShapeDrawn=1;ShapeRightButt=0;
     if (MButtBuf != mouse_b) { SelectionStartX=GetDataX(); SelectionStartY=GetDataY(); }
     else { SelectionEndX=GetDataX(); SelectionEndY=GetDataY(); }
     SelectionPreview(0); 
     break;
    }
   }
  }
  if ((GUIregion == 1) && (MButtBuf != mouse_b)) //mouse is in the preview area
  { 
   if (PreviewZoom==1 && MagnifyFactor>Mag_min)
   {
    GridInPosX=(mouse_x-PreviewPosX)-(GridSizeX/MagnifyFactor)/2; GridInPosY=(mouse_y-PreviewPosY)-(GridSizeY/MagnifyFactor)/2;
    SetBackRange();
    GridDrawer(GridCol); PrevBlitter(); ShowZoomLocation();
   }
  }
  if (GUIregion == 2) //mouse is in the ToolBar area
  {
   if (RepeatCounter==0 || (RepeatCounter==RepeatSpeed1-1 && MButtBuf!=mouse_b))
   { //repeatable buttons
    switch ((mouse_x - TBPosX)/TButtSize)
    {
     case 2: {//increase diameter
              if (DrawMode == 0) IncPenDiameter();
              else { DrawMode=0; DispToolBar(); GridBlitter(); }
              break;}
     case 7: Undoer(); break;
    }
   }
   if (MButtBuf != mouse_b)
   { //one-shot buttons
    switch ((mouse_x - TBPosX)/TButtSize)
    {
     case 0: F11er();break;
     case 1: F9er(); break;
     case 3: F5er(); break;
     case 4: F6er(); break;
     case 5: F7er(); break;
     case 6: F8er(); break;
    }
   }
  }
 }
 else if (mouse_b & 2) //right mouse button to draw background colour
 {
  if (GUIregion == 0 )
  {
   if (key_shifts&KB_SHIFT_FLAG && DrawMode!=5) { DrawCol2=BmpData[GetDataX()][GetDataY()]; DispSelCol(); }
   else if (key_shifts&KB_CTRL_FLAG) SetBlockCol(DrawCol2);
   else switch (DrawMode)
   {
    case 0: {DrawBmpData(GetDataX(),GetDataY(),DrawCol2);break;} //in AFLI-bug area right button always clears
    case 1: case 2: case 3: {ShapeDrawn=1;ShapeRightButt=1; ShapePreview(); break;}
    case 4: {Filler();break;}
    case 5: 
    { //clipboard move checking
     ShapeDrawn=1;ShapeRightButt=1;
     if(MButtBuf != mouse_b)
     {
      CursorInSelection();
      if(key_shifts&KB_SHIFT_FLAG) CopyCutSelection(); //cut and copy
      DisplayClipBoard();
     }
     else SelectionPreview(1);
     break; 
    }
   }
  }
  else if ((GUIregion == 1) && (MButtBuf != mouse_b)) //the preview area
  {
   PrevRightClick=1; 
  }
  else if (GUIregion == 2) //mouse is in the toolbar area
  {
   if (RepeatCounter==0 || (RepeatCounter==RepeatSpeed1-1 && MButtBuf!=mouse_b))
    switch ((mouse_x - TBPosX)/TButtSize)
    { //repeatable buttons 
     case 2: { //decrease diameter
              if (DrawMode==0) DecPenDiameter();
              else { DrawMode=0; DispToolBar(); GridBlitter(); }
              break;}
     case 7: Redoer(); break;
    }
   if (MButtBuf != mouse_b)
   { //one-shot buttons
    switch ((mouse_x - TBPosX)/TButtSize)
    { 
     case 0: F11er();break;
     case 1: F10er(); break;
    }
   }
  }
 } 
 else if (mouse_b & 4) //middle mouse-button to move zoomed area
 {
  if (GUIregion==0)
  {
   if (MButtBuf != mouse_b) {TempPosX=GetDataX();TempPosY=GetDataY();}
   GridInPosX-=GetDataX()-TempPosX;GridInPosY-=GetDataY()-TempPosY;
   SetBackRange();
   TempPosX=GetDataX();TempPosY=GetDataY();
   GridDrawer(GridCol); PrevBlitter(); ShowZoomLocation();
  }
 } 
 else if ( mouse_z != WheelBuf ) //mouse wheel to increase/decrease magnification
 {
  Zoomer();
 }
 else //here is the point where no L/middle/scroll/R mouse-button is pressed -------------------------------------------
 {
  if (ShapeDrawn != 0) //a line/rectangle/circle should be drawn
  {
   ShapeDrawn=0; //end of shapedrawing, init flags
   switch (DrawMode)
   {
    case 1: LineShape(); break;
    case 2: RectDraw(); break;
    case 3: CircleDraw(); break;
    case 5: 
    {
     if (!ShapeRightButt) {SelectionEndX=GetDataX(); SelectionEndY=GetDataY(); GridDrawer(GridCol); CopyCutSelection(); }
     else PasteMoveSelection();
     break;
    }
   }
   ShapeRightButt=0;
  }
  if (DrawMode==5) SelectionPreview(0); 
  else PenPreview(); //display pen-diameter if bigger
  RepeatCounter=RepeatSpeed1;
  if (GUIregion == 0) {TempStartX=TempPosX=TempPosX2=GetDataX(); TempStartY=TempPosY=TempPosY2=GetDataY(); mousestartx=mouse_x; mousestarty=mouse_y; }   //temp x and y for starting position or center of line/circle/rect
 }

//this part happens in any wayz, both if mouse event happened or not

 BuffPos();
 colbuf=FlashingColor;
 InputProcessing=false; //give place for next timed event
}
END_OF_FUNCTION(GetControls)


void BuffPos() //store the changing mouse-event to detect singleclicks/wheel differences 
     {
      WheelBuf = mouse_z; MButtBuf = mouse_b; 
      mouse_x_buf=mouse_x; mouse_y_buf=mouse_y;
      PrevGUIregion=GUIregion;
     }

//----------------------------------------------
void ShapePreview()
     {
      if (mouse_x!=mouse_x_buf || mouse_y!=mouse_y_buf || colbuf!=FlashingColor) //draw only when position or colour changes
      { 
       if (ShapeDrawn != 0 && GUIregion==0)  //draw shape-preview on screen (in normal resolution)
       {
        GridBlitter();
        switch (DrawMode) //draw only when colour changes
        {
         case 1: {fastline(screen,mousestartx,mousestarty,mouse_x,mouse_y,FlashingColor); break;}
         case 2: {rect(screen,mousestartx,mousestarty,mouse_x,mouse_y,FlashingColor); break;}
         case 3: 
         {
          int r= (int)(sqrt(pow(mouse_x-mousestartx,2)+pow(mouse_y-mousestarty,2))); 
          set_clip_rect(screen,GridPosX,GridPosY,GridPosX+GridSizeX-1,GridPosY+GridSizeY-1);
          circle(screen,mousestartx,mousestarty,r,FlashingColor); 
          set_clip_rect(screen,0,0,GuiSizeX,GuiSizeY);
          break; 
         }
        }
       }
      }
     }

void PenPreview()
     {
      if (mouse_x!=mouse_x_buf || mouse_y!=mouse_y_buf || colbuf!=FlashingColor) //draw only when position or colour changes
      {
       if (DrawMode<=3 && GUIregion==0 && PenDiameter>4)
       {
        GridBlitter();
        set_clip_rect(screen,GridPosX,GridPosY,GridPosX+GridSizeX-1,GridPosY+GridSizeY-1);
        circle(screen,mouse_x-((mouse_x-GridPosX-1)%MagnifyFactor)+MagnifyFactor/2-1,mouse_y-((mouse_y-GridPosY-1)%MagnifyFactor)+MagnifyFactor/2-1,(PenDiameter/4-1)*MagnifyFactor,FlashingColor);
        set_clip_rect(screen,0,0,GuiSizeX,GuiSizeY);
       }
      }
     }

void SelectionPreview(int DisplayContent)
     {
      int selX1,selY1,selX2,selY2;
      if (mouse_x!=mouse_x_buf || mouse_y!=mouse_y_buf || colbuf!=FlashingColor) //draw only when position or colour changes 
      {
       GridBlitter();
       selX1=GridPosX+GetDataScreenX(SelectionStartX+(SelectionEndX<SelectionStartX));
       selY1=GridPosY+GetDataScreenY(SelectionStartY+(SelectionEndY<SelectionStartY));
       selX2=GridPosX+GetDataScreenX(SelectionEndX+(SelectionEndX>=SelectionStartX));
       selY2=GridPosY+GetDataScreenY(SelectionEndY+(SelectionEndY>=SelectionStartY));
       set_clip_rect(screen,GridPosX,GridPosY,GridPosX+GridSizeX-1,GridPosY+GridSizeY-1);
       rect(screen,selX1,selY1,selX2,selY2,FlashingColor);
       set_clip_rect(screen,0,0,GuiSizeX,GuiSizeY);
       if ( DisplayContent==1) DisplayClipBoard();
      }
     }

//-------------------------------------------------drawing, pixelling the graphic data------------------------------------
void DrawBmpData(int x, int y, unsigned char col) //pen/brush drawing
     {
      if (MButtBuf == mouse_b)
      {
       if (x!=TempPosX2 || y!=TempPosY2) 
       { 
        DrawBmpLine(TempPosX2,TempPosY2,x,y,col); 
        GridDrawer(GridCol);PrevDrawer();
       }
      }
      else 
      { //UNDO point
       StoreUndo(); DrawBmpPixel(x,y,col); GridDrawer(GridCol);PrevDrawer(); 
      }
      TempPosX2=x; TempPosY2=y;
     }

void LineShape() //draw line using mouse-click and release positions as endpoints
     {
      StoreUndo(); //UNDO point
      DrawBmpLine(TempStartX,TempStartY,GetDataX(),GetDataY(),(ShapeRightButt==0)?DrawCol1:DrawCol2);
      GridDrawer(GridCol);PrevDrawer();
     }

void ShowProgress(int percent)
     {
      textprintf_ex(screen,font,GridSizeX-200, GridSizeY-15,0xFFFFFF,0," Progress: %3.d percents ",percent);
     }

void RectDraw() //draw rectangle (normal/filled) using mouse-click and release positions as endpoints
     {
      int maxx=GetDataX(), maxy=GetDataY();
      StoreUndo(); //UNDO point
      if (RectFill == 0)
      {
       DrawBmpLine(TempStartX,TempStartY,maxx,TempStartY,(ShapeRightButt==0)?DrawCol1:DrawCol2);
       DrawBmpLine(TempStartX,TempStartY,TempStartX,maxy,(ShapeRightButt==0)?DrawCol1:DrawCol2);
       DrawBmpLine(TempStartX,maxy,maxx,maxy,(ShapeRightButt==0)?DrawCol1:DrawCol2);
       DrawBmpLine(maxx,TempStartY,maxx,maxy,(ShapeRightButt==0)?DrawCol1:DrawCol2);
      }
      else  //filled rectangle
      {
       if ((DitherMode==0 || DrawCol1==DrawCol2) && ClashTestMode<2 ) 
       { 
        int zoomtemp = PreviewZoom; PreviewZoom=1;DrawPrv(); 
        rectfill(Preview,TempStartX,TempStartY,maxx,maxy, (ShapeRightButt==0)?C64Palette[DrawCol1]:C64Palette[DrawCol2]);
        ConvBackBMP(Preview); PreviewZoom = zoomtemp;
       }
       else
       { //dither- and clashmode-aware rectangle
        int step= (PenDiameter!=8) ? PenDiameter/4 : 1;
        if (TempStartX==maxx || TempStartY==maxy) DrawBmpLine(TempStartX,TempStartY,maxx,maxy,(ShapeRightButt==0)?DrawCol1:DrawCol2);
        else if ((TempStartX <= maxx) && (TempStartY <= maxy))
        {
         for (int i=TempStartX; i<=maxx; i += step)
         {
          for (int j=TempStartY; j<=maxy; j += step)
          {
           DrawBmpPixel(i,j,(ShapeRightButt==0)?DrawCol1:DrawCol2);
          }
          //GridDrawer(GridCol); 
          ShowProgress((i-TempStartX)*100/(maxx-TempStartX));
         }
        }
        else if ((TempStartX > maxx) && (TempStartY <= maxy))
        {
         for (int i=TempStartX; i>=maxx; i -= step)
         {
          for (int j=TempStartY; j<=maxy; j += step)
          {
           DrawBmpPixel(i,j,(ShapeRightButt==0)?DrawCol1:DrawCol2);
          }
          //GridDrawer(GridCol); 
          ShowProgress((i-TempStartX)*100/(maxx-TempStartX));
         }
        }
        else if ((TempStartX <= maxx) && (TempStartY > maxy))
        {
         for (int i=TempStartX; i<=maxx; i += step)
         {
          for (int j=TempStartY; j>=maxy; j -= step)
          {
           DrawBmpPixel(i,j,(ShapeRightButt==0)?DrawCol1:DrawCol2);
          }
          //GridDrawer(GridCol); 
          ShowProgress((i-TempStartX)*100/(maxx-TempStartX));
         }
        }
        else if ((TempStartX > maxx) && (TempStartY > maxy))
        {
         for (int i=TempStartX; i>=maxx; i -= step)
         {
          for (int j=TempStartY; j>=maxy; j -= step)
          {
           DrawBmpPixel(i,j,(ShapeRightButt==0)?DrawCol1:DrawCol2);
          }
          //GridDrawer(GridCol); 
          ShowProgress((i-TempStartX)*100/(maxx-TempStartX));
         }
        }
       }
      }
      GridDrawer(GridCol);PrevDrawer();
     }

void Circler(int x, int y, int r, unsigned char col)
     {
      float step = (60/(r*6.28)) * (PenDiameter/4);
      for (float angle = 0; angle < 360; angle+=step)
      {
       DrawBmpPixel((int)(x+sin(angle*rad)*r+0.5), (int)(y+cos(angle*rad)*r+0.5), col);
      }
     }

void CircleDraw()
     {
      int maxx=GetDataX(), maxy=GetDataY();
      int radius = (int)(sqrt(pow(maxx-TempStartX,2)+pow(maxy-TempStartY,2)));
      StoreUndo(); //UNDO point 
      if (CircFill == 0)
      {
       if ((DitherMode==0 || DrawCol1==DrawCol2) && PenDiameter<=4 && ClashTestMode<2) 
        {
         int zoomtemp = PreviewZoom; PreviewZoom=1;DrawPrv(); 
         circle(Preview,TempStartX,TempStartY,radius,(ShapeRightButt==0)?C64Palette[DrawCol1]:C64Palette[DrawCol2]); 
         ConvBackBMP(Preview); PreviewZoom = zoomtemp; 
        }
       else Circler(TempStartX,TempStartY,radius,(ShapeRightButt==0)?DrawCol1:DrawCol2); 
      }
      else //filled circle
      {
       if ((DitherMode==0 || DrawCol1==DrawCol2) && ClashTestMode<2 ) 
       { 
        int zoomtemp = PreviewZoom; PreviewZoom=1;DrawPrv(); 
        circlefill(Preview,TempStartX,TempStartY,radius,(ShapeRightButt==0)?C64Palette[DrawCol1]:C64Palette[DrawCol2]);
        ConvBackBMP(Preview); PreviewZoom = zoomtemp; 
       }
       else
       { //pattern / clash-sensitive filled circle
        for (int i = 0; i<radius; i+= PenDiameter/4 )
        {
         Circler(TempStartX,TempStartY,i,(ShapeRightButt==0)?DrawCol1:DrawCol2);
         //GridDrawer(GridCol); 
         ShowProgress(i*100/radius);
        }
       }
      }
      GridDrawer(GridCol);PrevDrawer();
     }

void Filler() //other bitmap with full zoom!!!
     {
      if (MButtBuf == mouse_b) return;
      int zoomtemp = PreviewZoom;
      PreviewZoom=1;DrawPrv();
      if (RButt == 0) floodfill(Preview,GetDataX(),GetDataY(),C64Palette[DrawCol1]);
      else floodfill(Preview,GetDataX(),GetDataY(),C64Palette[DrawCol2]);
      //UNDO point
      StoreUndo();
      if (ClashTestMode<2)
      { //normal solid fill
       ConvBackBMP(Preview);
      } 
      else
      { // tested &/ pattern-fill
       unsigned char detcol;
       for (int i = 0;i<FieldSizeX;i++)
       {
        for (int j = 0;j<FieldSizeY;j++)
        {
         detcol = GetMatchCol(getpixel(Preview, i,j));   //detect colour , getr(),getg(),getb() for calculations
         CarefulPixel(i,j,detcol);
        }
        //GridDrawer(GridCol); 
        ShowProgress(i*100/FieldSizeX); 
       }
      }
      GridDrawer(GridCol);
      PreviewZoom = zoomtemp; PrevDrawer(); 
     }

void DrawBmpLine(int x1, int y1, int x2, int y2, unsigned char col)
     {
      int dy = y2 - y1;
      int dx = x2 - x1;
      float t = (float) 0.5;                      // offset for rounding

      DrawBmpPixel(x1,y1,col);
      if (abs(dx) > abs(dy)) {          // slope < 1
            float m = (float) dy / (float) dx;      // compute slope
            t += y1;
            dx = (dx < 0) ? -1 : 1;
            m *= dx;
            while (x1 != x2) {
                x1 += dx;                           // step to next x value
                t += m;                             // add slope to y value
                DrawBmpPixel(x1,(int) t,col);
            }
        } else {                                    // slope >= 1
            float m = (float) dx / (float) dy;      // compute slope
            t += x1;
            dy = (dy < 0) ? -1 : 1;
            m *= dy;
            while (y1 != y2) {
                y1 += dy;                           // step to next y value
                t += m;                             // add slope to x value
                DrawBmpPixel((int) t,y1,col);
            }
        }
     }


bool CanIpaintBlk(int &x, int &y, unsigned char &col)
     {
      int charnum = x/ChrSizeX + (y/ChrSizeY)*NoOfChrX;
      if (ConvertChr(charnum)<2) return true;
      else if (ConvertChr(charnum)==2 && (col==ConvChr[0][8][0] || col==ConvChr[1][8][0]) ) return true;
      return false;
     }

bool CanIpaintSlice(int &x, int &y, unsigned char &col)
     {
      //int charnum = x/ChrSizeX + (y/ChrSizeY)*NoOfChrX;
      if (ConvertSlice(x,y)<2) return true;
      else if (ConvertSlice(x,y)==2 && (col==ConvChr[0][8][y%8] || col==ConvChr[1][8][y%8]) ) return true;
      return false;
     }

void SETchrBlk(int &x,int &y,unsigned char &ToChange, unsigned char &colour)
     {
      if (colour==ToChange) return;
      SetBlkCol(x-x%ChrSizeX,y-y%ChrSizeY,ToChange,colour);
     }

void SETchrSlice(int &x,int &y,unsigned char &ToChange, unsigned char &colour)
     {
      if (colour==ToChange) return;
      SetSlcCol(x-x%ChrSizeX,y,ToChange,colour);
     }

void CarefulPixel(int &x, int &y, unsigned char col )
     {
      if (x<0 || y<0 || x>=FieldSizeX || y>=FieldSizeY || BmpData[x][y]==col) return;
      if (AFLImode==false)
      {
       if (!CanIpaintBlk(x,y,col))
       { //handle clashes in different ways
        if (ClashTestMode==2) return; //DENY painting to avoid clash
        else if (ClashTestMode==3) //handle REUSE mode 
        { //(if drawing colour equals opposite colour, swap action of left/right mouse-buttons)
         if (DrawCol1==ConvChr[1][8][0] || DrawCol2==ConvChr[0][8][0]) col=(mouse_b & 2)?ConvChr[0][8][0]:ConvChr[1][8][0]; 
         else col=(mouse_b & 2)?ConvChr[1][8][0]:ConvChr[0][8][0]; //REUSE existing block-colours
        }
        else if (ClashTestMode==4) SETchrBlk(x,y,BmpData[x][y],col); //SET new block-colour
       }
      }
      else
      { //AFLI-mode - test slice only
       if (!CanIpaintSlice(x,y,col))
       { //handle clashes in different ways
        if (ClashTestMode==2) return; //DENY painting to avoid clash
        else if (ClashTestMode==3) //handle REUSE mode 
        { //(if drawing colour equals opposite colour, swap action of left/right mouse-buttons)
         if (DrawCol1==ConvChr[1][8][y%ChrSizeY] || DrawCol2==ConvChr[0][8][y%ChrSizeY]) col=(mouse_b & 2)?ConvChr[0][8][y%ChrSizeY]:ConvChr[1][8][y%ChrSizeY];
         else col=(mouse_b & 2)?ConvChr[1][8][y%ChrSizeY]:ConvChr[0][8][y%ChrSizeY]; //REUSE existing slice-colours
        }
        else if (ClashTestMode==4) SETchrSlice(x,y,BmpData[x][y],col); //SET new slice-colour
	   }
      }
      BmpData[x][y]=col;
     }

void DrawBmpPixel(int x, int y, unsigned char colour) //make the dot/plot/line, whatever in graphic data with coordinates & colour
     {
      if (PenDiameter<=4)
      { //one-pixel pen
       if (DitherMode==0) CarefulPixel(x,y,colour); //mode 0 - no dither
       else if (DitherMode==1) //mode 1 - dither even
       {
        if ((x%2)^(y%2)==0) CarefulPixel(x,y,colour);
        else {if (Dither2Col==1) CarefulPixel(x,y,DrawCol2);} //two colour-mode for even dithering
       }
       else if (DitherMode==2) //mode 2 - dither odd
       {
        if ((x%2)^(y%2)==1) CarefulPixel(x,y,colour);
        else {if (Dither2Col==1) CarefulPixel(x,y,DrawCol2);} //two colour-mode for odd dithering
       }
      }
      else
      { //bigger pen
       int circorx,circory,step;
       for (int radius=1; radius < PenDiameter/2; radius++)
       {
        step=80/radius;
        for (int angle = 0; angle < 360; angle += step)
        {
         circorx = x+(int)(sin(angle*rad)*radius/2.23); circory = y+(int)(cos(angle*rad)*radius/2.23);
         //if (0 <= circorx && circorx < FieldSizeX && 0 <= circory && circory < FieldSizeY) 
         //{
          if (DitherMode==0) CarefulPixel(circorx,circory,colour); //mode 0 - no dither
          else if (DitherMode==1) //mode 1 - dither even
          {
           if ((circorx%2)^(circory%2)==0) CarefulPixel(circorx,circory,colour);
           else {if (Dither2Col==1) CarefulPixel(circorx,circory,DrawCol2);} //two colour-mode for even dithering
          }
          else if (DitherMode==2) //mode 2 - dither odd
          {
           if ((circorx%2)^(circory%2)==1) CarefulPixel(circorx,circory,colour);
           else {if (Dither2Col==1) CarefulPixel(circorx,circory,DrawCol2);} //two colour-mode for odd dithering
          }
         //}
        }
       }
      }
     }


//----------------------------------------------graph-positioning calculation routines---------------------------------------------
void Zoomer()  //zoom to the actual data-coordinate
     {
      if (CheckRange()==0)
      {
       if (mouse_z < Mag_min) {position_mouse_z(Mag_min);GridInPosX=GridInPosY=0;}
       if (mouse_z > Mag_max) {position_mouse_z(Mag_max);}
       int PrevDataX=GetDataX(), PrevDataY=GetDataY();
       MagnifyFactor = mouse_z;
       int DeltaX = GetDataX()-PrevDataX, DeltaY = GetDataY()-PrevDataY; GridInPosX-=DeltaX; GridInPosY-=DeltaY;
       SetBackRange();
       GridDrawer(GridCol); PrevDrawer();
       textprintf_ex(screen,font,TxtInfoPosX,TxtInfoPosY+52,0x80FFFF,0x252a49,(Mag_min>2)?"Zoom: %dX ":"Zoom:%dX ", MagnifyFactor);
       dispGridBri();
      }
      else if (CheckRange()==1)
      {
       if (mouse_z<WheelBuf && PreviewZoom>1) PreviewZoom--;
       else if (mouse_z>=WheelBuf && PreviewZoom<4) PreviewZoom++;
       PrevDrawer();PrevText(); position_mouse_z(WheelBuf);
      }
      return;
     }

void dispGridBri()
     {
       textprintf_ex(screen,font,TxtInfoPosX, TxtInfoPosY+62,0x80FFFF,0x252a49,(Mag_min>2)?"Grid-bright.ratio: %1.2f":"BrightRatio: %1.2f", GridBrightness );
     }

void CalcActChar()
     {
      if (CheckRange() != 0) return;
      int x = GetDataX()/ChrSizeX;
      int y = GetDataY()/ChrSizeY;
      ActChar = x + y * NoOfChrX;
      if (ActChrBuf != ActChar) 
      {
       textprintf_ex(screen,font,TxtInfoPosX,TxtInfoPosY+42,0x80FFFF,0x252a49,(Mag_min>2)?"Char  X%.2d Y%.2d Memo:$%.3X":"ChX%.2d-Y%.2d Mem$%.3X", x, y, ActChar);
       if (PreviewZoom != 1) PrevDrawer();
      }
      ActChrBuf = ActChar;
     }

int CheckRange() //checks whether the mouse is in the gridfield/datafield - avoid border-effects
    {            //also checks whether the mouse is in the preview-screen or not
     if ((GridPosX < mouse_x) && (mouse_x < GridPosX+GridSizeX) && (GridPosY < mouse_y) && (mouse_y < GridPosY+GridSizeY) && 
         (mouse_x < GridPosX+(FieldSizeX-GridInPosX)*MagnifyFactor) && (mouse_y < GridPosY+(FieldSizeY-GridInPosY)*MagnifyFactor)) return 0;
     if ((PreviewPosX <mouse_x) && (mouse_x < (PreviewPosX+FieldSizeX)) && 
        (PreviewPosY < mouse_y) && (mouse_y < (PreviewPosY+FieldSizeY))) return 1;
     if ((TBPosX <mouse_x) && (mouse_x < (TBPosX+TBSizeX)) && 
        (TBPosY < mouse_y) && (mouse_y < (TBPosY+TBSizeY))) return 2;
     return -1;
    }

void SetBackRange()
     {
      if (GridInPosX < 0) GridInPosX=0;
      if (GridInPosY < 0) GridInPosY=0;
      if ( (FieldSizeX-GridInPosX)*MagnifyFactor < GridSizeX ) GridInPosX=FieldSizeX-GridSizeX/MagnifyFactor;
      if ( (FieldSizeY-GridInPosY)*MagnifyFactor < GridSizeY ) GridInPosY=FieldSizeY-GridSizeY/MagnifyFactor;
      if (MagnifyFactor == Mag_min) GridInPosX=GridInPosY=0;
     }

int GetDataX() //calculate data pointer from window-relative mouse x-coordinate, handle outranges
    {
     return (mouse_x-1-GridPosX)/MagnifyFactor+GridInPosX;
    }

int GetDataY() //calculate data pointer from window-relative mouse y-coordinate, handle outranges
    {
     return (mouse_y-1-GridPosY)/MagnifyFactor+GridInPosY;
    }

int GetDataScreenX(int x) //calculate window position from data-pointer
    {
     return (x-GridInPosX)*MagnifyFactor;
    }

int GetDataScreenY(int y)
    {
     return (y-GridInPosY)*MagnifyFactor;
    }

//---------------------------------------------------PIXELDRAWER/GRAPHDRAWER functions for display--------------------------------
unsigned int ClashCol (unsigned int col)
{
 int r=(int)(getr(col)*GridBrightness), g=(int)(getg(col)*GridBrightness), b=(int)(getb(col)*GridBrightness);
 if (BlinkOn) 
 { 
  r=(r+BlinkStrength*2>=255) ? r-(int)(BlinkStrength*GridBrightness*2) : r+BlinkStrength*2; 
  g=(g+BlinkStrength>=255) ? g-(int)(BlinkStrength*GridBrightness) : g+BlinkStrength; 
  b=(b+BlinkStrength>=255) ? b-(int)(BlinkStrength*GridBrightness) : b+BlinkStrength; 
 }
 if (r<0) r=0; if(g<0) g=0; if(b<0) b=0;
 if (r>255) r=255; if(g>255) g=255; if(b>255) b=255;
 return makecol(r,g,b);
}

unsigned int BrightComp(unsigned int col)
{
 int r=(int)(getr(col)*GridBrightness), g=(int)(getg(col)*GridBrightness), b=(int)(getb(col)*GridBrightness);
 if (r>255) r=255; if(g>255) g=255; if(b>255) b=255;
 return makecol(r,g,b);
}

void BmpDrawer() //draws the magnified Bitmap
     {
      int bolder=(MagnifyFactor>Grid_treshold && GridMode && (!CRTmode||MagnifyFactor>CRTemu_treshold) ) ? 1 : 0; 
      int X,Y,Col, XpixPos, YpixPos, ChrLine; 
      int CRTpixYsize=(int)((MagnifyFactor)*0.8), CRTblur1x=(int)ceil(MagnifyFactor/2.00); //, CRTblur2x=(int)ceil(MagnifyFactor/3.00*2);
      int Xmax=GridSizeX/MagnifyFactor+1, Ymax=GridSizeY/MagnifyFactor+1, fieldXmax=(FieldSizeX-GridInPosX+1), fieldYmax=(FieldSizeY-GridInPosY+1);
      int pixtop, pixbottom, CRTpixbottom; 
      float BlurRatio=(PALblur/2)/256.00, BlurRatioN=1-(PALblur/2)/256.00; 
      unsigned int prevCol, midCol, nextCol, RprevCol,GprevCol,BprevCol, RmidCol,GmidCol,BmidCol, RnextCol,GnextCol,BnextCol, BlurCol1,BlurCol2;
      bool CRTenabled=((CRTmode==2 || CRTmode==3) && MagnifyFactor<=CRTemu_treshold);

      if (CRTenabled==0)
      { //normal pixel drawing
       for (Y = 0;Y<Ymax && Y<fieldYmax; Y++)
       {
        YpixPos=Y*MagnifyFactor; pixtop=YpixPos; pixbottom=YpixPos+MagnifyFactor-1;
        ChrLine=(AFLImode) ? (Y+GridInPosY)%ChrSizeY : 0; //not checking all ClashCnt 2d-array entries for clash in normal bmp-mode
        for (X = 0; X<Xmax && X<fieldXmax; X++)
        {
         XpixPos=X*MagnifyFactor; 
         if (AFLImode && (X+GridInPosX)<24) 
         { //dipslay AFLI-bug colours as they'll appear on C64
	      if (BmpData[X+GridInPosX][Y+GridInPosY]==0xF) Col=0xF;
          else if ((X+GridInPosX)<8) Col=FLIbugCol1; else if ((X+GridInPosX)>=16) Col=FLIbugCol3; else Col=FLIbugCol2;
         }
	     else Col=BmpData[X+GridInPosX][Y+GridInPosY]; //normal colours
         if (   ClashTestMode==1 && ClashCnt[ (X+GridInPosX)/ChrSizeX+((Y+GridInPosY)/ChrSizeY)*NoOfChrX ][ChrLine] > 2   )
         {
          rectfill(DrawGrid, XpixPos, pixtop, XpixPos+MagnifyFactor-1, pixbottom, ClashCol(C64Palette[Col]) );    
          if (BlinkOn || !GridMode) rect(DrawGrid, XpixPos, YpixPos, XpixPos+MagnifyFactor, YpixPos+MagnifyFactor, 0x804020);
         }
         else
         {
          rectfill(DrawGrid, XpixPos, pixtop, 
          XpixPos+MagnifyFactor-1, pixbottom, BrightComp(C64Palette[Col]) );
         }
        }
       }
      }
      else 
      { //CRT emulated pixel drawing
       for (Y = 0;Y<Ymax && Y<fieldYmax; Y++)
       {
        YpixPos=Y*MagnifyFactor; pixtop=YpixPos+bolder; pixbottom=YpixPos+MagnifyFactor-1; CRTpixbottom=YpixPos+CRTpixYsize; prevCol=0;
        ChrLine=(AFLImode) ? (Y+GridInPosY)%ChrSizeY : 0; //not checking all ClashCnt entries for clash in normal bmp-mode
        for (X = 0; X<Xmax && X<fieldXmax; X++)
        {
         XpixPos=X*MagnifyFactor; Col=BmpData[X+GridInPosX][Y+GridInPosY];
         if (   ClashTestMode==1 && ClashCnt[ (X+GridInPosX)/ChrSizeX+((Y+GridInPosY)/ChrSizeY)*NoOfChrX ][ChrLine] > 2   )
         {
          rectfill(DrawGrid, XpixPos, pixtop, XpixPos+MagnifyFactor-1, pixbottom, ClashCol(C64Palette[Col]) );    
          if (BlinkOn || !GridMode) rect(DrawGrid, XpixPos, YpixPos, XpixPos+MagnifyFactor, YpixPos+MagnifyFactor, 0x804020);
         }
         else
         {
          midCol=BrightComp(C64Palette[Col]); 
          nextCol=C64Palette[ BmpData[X+GridInPosX+1][Y+GridInPosY] ];
          RmidCol=(unsigned int)(midCol*BlurRatioN); GmidCol=(unsigned int)((midCol&0xFF00)*BlurRatioN); BmidCol=(unsigned int)((midCol&0xFF)*BlurRatioN);
          RprevCol=(unsigned int)(prevCol*BlurRatio); GprevCol=(unsigned int)((prevCol&0xFF00)*BlurRatio); BprevCol=(unsigned int)((prevCol&0xFF)*BlurRatio);
          RnextCol=(unsigned int)(nextCol*BlurRatio); GnextCol=(unsigned int)((nextCol&0xFF00)*BlurRatio); BnextCol=(unsigned int)((nextCol&0xFF)*BlurRatio);
          BlurCol1=(RprevCol+RmidCol)&0xFF0000 | (GprevCol+GmidCol)&0xFF00 | BprevCol+BmidCol;
          BlurCol2=(RmidCol+RnextCol)&0xFF0000 | (GmidCol+GnextCol)&0xFF00 | BmidCol+BnextCol;
          rectfill(DrawGrid, XpixPos+bolder   , pixtop, XpixPos+CRTblur1x      , CRTpixbottom, BlurCol1);
          //rectfill(DrawGrid, XpixPos+bolder   , pixtop, XpixPos+CRTblur1x      , CRTpixbottom, midCol);
          rectfill(DrawGrid, XpixPos+CRTblur1x, pixtop, XpixPos+MagnifyFactor-1, CRTpixbottom, BlurCol2);
          rectfill(DrawGrid, XpixPos+bolder,CRTpixbottom,XpixPos+CRTblur1x,pixbottom, (BlurCol1&0xFE0000)/2+(BlurCol1&0xFE00)/2+(BlurCol1&0xFF)/2 ); //between scanlines
          rectfill(DrawGrid, XpixPos+CRTblur1x,CRTpixbottom,XpixPos+MagnifyFactor-1,pixbottom,  (BlurCol2&0xFE0000)/2+(BlurCol2&0xFE00)/2+(BlurCol2&0xFF)/2 ); //between scanlines
         }
         prevCol=C64Palette[Col];
        }
        //rectfill(DrawGrid, 0, CRTpixbottom+1, GridSizeX-1, pixbottom, 0x101010); //between scanlines
       }
      }
     }

void SettingDispl()
     {
      static const char *ClashTxt[]={" OFF ","TEST ","DENY ","REUSE"," SET "};
      static const char *GridTxt[]={" OFF "," ALL ","BLOCK","","OFF-A","ALL-A","SLICE"};
      static const char *CRTtext[]={" OFF ","PREV.","BOTH ","GRID "};
      textprintf_ex(screen,font, (Mag_min>2)?MenuPosX-400:HermIRESdialog[32].x-40, (Mag_min>2)?MenuPosY+90:HermIRESdialog[32].y+5, 0x80FFFF,0x000000,"%s",CRTtext[CRTmode]);
      textprintf_ex(screen,font, (Mag_min>2)?MenuPosX-300:HermIRESdialog[31].x-40, (Mag_min>2)?MenuPosY+90:HermIRESdialog[31].y+5, 0x80FFFF,0x000000,"%s",GridTxt[GridMode+AFLImode*4]);
      textprintf_ex(screen,font, (Mag_min>2)?MenuPosX-200:HermIRESdialog[30].x-40, (Mag_min>2)?MenuPosY+90:HermIRESdialog[30].y+5, 0x80FFFF,0x000000,"%s",ClashTxt[ClashTestMode]);
      textprintf_ex(screen,font, (Mag_min>2)?MenuPosX-90:HermIRESdialog[29].x-30, (Mag_min>2)?MenuPosY+90:HermIRESdialog[29].y+5, 0x80FFFF,0x000000,(EnableBriGrid)?"ON ":"OFF");
     }

void PrevText()
     {
      if (Mag_min>2) textprintf_ex(screen,font,TxtInfoPosX+80,TxtInfoPosY+52,0x80FFFF,0x252a49," Preview: %dX", PreviewZoom);
      else textprintf_ex(screen,font,TxtInfoPosX+64,TxtInfoPosY+52,0x80FFFF,0x252a49," Prev: %dX", PreviewZoom);
     }

void BorderDrawer()
     {
      rectfill(screen, GridPosX-BorderColWidth,GridPosY-BorderColWidth,GridPosX+GridSizeX+BorderColWidth,GridPosY+GridSizeY+BorderColWidth,C64Palette[BorderCol]);
      rectfill(screen, PreviewPosX-BorderColWidth,PreviewPosY-BorderColWidth,PreviewPosX+FieldSizeX+BorderColWidth,PreviewPosY+FieldSizeY+BorderColWidth,C64Palette[BorderCol]);
     }

void DrawGridLines(BITMAP * Bitmap)
     {
      int GridWidth = MagnifyFactor*FieldSizeX, GridSkip;
      int GridHeight = MagnifyFactor*FieldSizeY;
      if (GridMode)
      {
       for(int i=0,j=0; i<(GridHeight+1); i+=MagnifyFactor,j++)
       { //draw horizontal grid-lines
        if ((j+GridInPosY)%ChrSizeY) {if (MagnifyFactor>Grid_treshold && GridMode==1) fastline(Bitmap,0,i,GridWidth,i,GridCol);}
        else 
        {
		 if (AFLImode) 
		 {
		  fastline(Bitmap,0,i,GridWidth,i,ChrRangeCol*0.75);
		  if (GridInPosX<24) fastline(Bitmap,0,i,(24-GridInPosX)*MagnifyFactor,i,0x000000); 
		 }
         else fastline(Bitmap,0,i,GridWidth,i,ChrRangeCol);
        }
       }
       for(int i=0,j=0; i<(GridWidth+1); i+=MagnifyFactor,j++)
       { //draw vertical grid-lines, i counts coordinate, j counts data
        if ((j+GridInPosX)%ChrSizeX) {if (MagnifyFactor>Grid_treshold && GridMode==1) fastline(Bitmap,i,0,i,GridHeight,GridCol);}
        else
        { 
         if (AFLImode && (i+GridInPosX*MagnifyFactor)<24*MagnifyFactor) fastline(Bitmap,i,0,i,GridHeight,0x000000);
         else fastline(Bitmap,i,0,i,GridHeight,ChrRangeCol);
        }
       }
      }
     }

void GridBlitter()
{
 blit(DrawGrid, screen, 0, 0, GridPosX, GridPosY, GridSizeX, GridSizeY);
}

void GridDrawer(int GridCol)  //function to draw magnify-grid
     {
      if (Displaying==true) return; //don't start other thread if drawing not yet done
      Displaying=true;
      int i,j,posY;
      GridBrightness=(GridMode==1 && EnableBriGrid && (MagnifyFactor>Grid_treshold) ) ? (float)MagnifyFactor/(float)(MagnifyFactor-1) : 1.00; 
      BmpDrawer();
      drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
      if(Brightness>128) { set_trans_blender(0,0,0,Brightness-128); rectfill(DrawGrid,0,0,GridSizeX,GridSizeY,0xFFFFFF); }
      else if (Brightness<128) { set_trans_blender(0,0,0,127-Brightness); rectfill(DrawGrid,0,0,GridSizeX,GridSizeY,0); }
      solid_mode();
      DrawGridLines(DrawGrid);
      GridBlitter();
      Displaying=false;
     }

int PrevStartX, PrevStartY;
void DrawPrv() //draw preview bitmap without blit to screen (invisible change) - used by fill routine and simple circle/rectangle routines
     {
      int ZoomCordX, ZoomCordY, ZoomPixCol;
      int xmul=ChrSizeX*NoOfChrX/PreviewZoom, ymul=ChrSizeY*NoOfChrY/PreviewZoom;
      if (PreviewZoom==1) PrevStartX=PrevStartY=0;
      else
      {
       PrevStartX = SelChrPosX(ActChar)-xmul/2;
       PrevStartY = SelChrPosY(ActChar)-ymul/2;
       if (PrevStartX < 0) PrevStartX=0;
       if (PrevStartY < 0) PrevStartY=0;
       if (PrevStartX >= FieldSizeX-xmul) PrevStartX=FieldSizeX-xmul;
       if (PrevStartY >= FieldSizeY-ymul) PrevStartY=FieldSizeY-ymul;
      }
      for (int i = 0;i<FieldSizeX;i++)
      {
       for (int j = 0;j<FieldSizeY;j++)
       {
        ZoomCordX = i/PreviewZoom+PrevStartX ; ZoomCordY = j/PreviewZoom+PrevStartY ;
        if (AFLImode && ZoomCordX<24) 
        { //dipslay AFLI-bug colours as they'll appear on C64
	     if (BmpData[ZoomCordX][ZoomCordY]==0xF) ZoomPixCol=0xF;
         else if (ZoomCordX<8) ZoomPixCol=FLIbugCol1; else if (ZoomCordX>=16) ZoomPixCol=FLIbugCol3; else ZoomPixCol=FLIbugCol2;
        }
        else ZoomPixCol = BmpData[ZoomCordX][ZoomCordY];
        putpixel(Preview,i,j,C64Palette[ZoomPixCol]);
       }
      }
     }

void PrevBlitter()
     {
      blit(CRTpreview, screen, 0, 0, PreviewPosX, PreviewPosY, FieldSizeX+1, FieldSizeY+1);
     }

void ShowZoomLocation()
     {
      if (MagnifyFactor>Mag_min) 
      { //display selection-rectangle
       set_clip_rect(screen,PreviewPosX,PreviewPosY,PreviewPosX+FieldSizeX-1,PreviewPosY+FieldSizeY-1);
       rect(screen, PreviewPosX+(GridInPosX-PrevStartX)*PreviewZoom, PreviewPosY+(GridInPosY-PrevStartY)*PreviewZoom, 
        PreviewPosX+(GridInPosX-PrevStartX+GridSizeX/MagnifyFactor)*PreviewZoom, PreviewPosY+(GridInPosY-PrevStartY+GridSizeY/MagnifyFactor)*PreviewZoom,ZoomRectCol);
       set_clip_rect(screen,0,0,GuiSizeX-1,GuiSizeY-1);
      }
     }

void PrevDrawer() //function to draw preview box - using variable 'PreviewZoom' for magnification factoring
     {
      int i,j,posY;
      DrawPrv();
      blit(Preview,CRTpreview,0,0,0,0,FieldSizeX+1,FieldSizeY+1);
      drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
      if (CRTmode==1 || CRTmode==2)
      {
       set_trans_blender(0, 0, 0, PALblur/2*0.66); draw_trans_sprite(CRTpreview, Preview, (int)ceil(PreviewZoom/2.00), 0);     //draw blurred pixels part1
       set_trans_blender(0, 0, 0, PALblur/3*0.66); draw_trans_sprite(CRTpreview, Preview, (int)(0-PreviewZoom/2.00), 0);     //draw blurred pixels part2
       set_trans_blender(0, 0, 0, PALblur/4); draw_trans_sprite(CRTpreview, Preview, PreviewZoom, 0);     //draw blurred pixels part3
       set_trans_blender(0, 0, 0, PALblur/6); draw_trans_sprite(CRTpreview, Preview, (0-PreviewZoom), 0);     //draw blurred pixels part4
       if (PreviewZoom>1)
       {
        for (i=0;i<(FieldSizeY/PreviewZoom);i++)
        {
         for(j=0;j<PreviewZoom;j++)
         {
          posY=i*PreviewZoom+j;
          if (j==PreviewZoom-2 || j==0) { set_trans_blender(0, 0, 0, 15*PreviewZoom); hline(CRTpreview,0,posY,FieldSizeX+1,0x000000); } //scanline-edges
          if (j==PreviewZoom-1) {set_trans_blender(0, 0, 0, 30*PreviewZoom); hline(CRTpreview,0,posY,FieldSizeX+1,0x000000); } //between scanlines
         }
        }
       }
      }
      if(Brightness>128) { set_trans_blender(0,0,0,Brightness-128); rectfill(CRTpreview,0,0,FieldSizeX,FieldSizeY,0xFFFFFF); }
      else if (Brightness<128) { set_trans_blender(0,0,0,127-Brightness); rectfill(CRTpreview,0,0,FieldSizeX,FieldSizeY,0); }
      solid_mode(); 
      PrevBlitter(); ShowZoomLocation();
     }

void DispToolBar()
     {
      clear_to_color(ToolBar, TBCol);
      for (int i=0;i<NoOfButt;i++){rect(ToolBar, i*TButtSize, 0, (i+1)*TButtSize, TBSizeY-1, 0xF0F0F0);} //draw graph-button borders
      rect (ToolBar, 4, 4, TButtSize-4,TButtSize-4, (DrawMode==5) ? TBSelCol:0x505050);  //button0 - selection tool
       rect(ToolBar,TButtSize/2-3,2,TButtSize/2+3,TButtSize-2,TBCol); rect(ToolBar,2,TButtSize/2-3,TButtSize-2,TButtSize/2+3,TBCol);
      if (Dither2Col == 1) rectfill(ToolBar,TButtSize+8,8,TButtSize+16,16,TBSelCol);
      if (DitherMode == 0) rectfill(ToolBar,TButtSize+8,8,TButtSize+14,14,TBFGCol); //button 1 - dithermode
      else if (DitherMode == 1) {rectfill(ToolBar,TButtSize+8,8,TButtSize+11,11,TBFGCol);rectfill(ToolBar,TButtSize+12,12,TButtSize+15,15,TBFGCol);}
      else if (DitherMode == 2) {rectfill(ToolBar,TButtSize+12,8,TButtSize+15,11,TBFGCol);rectfill(ToolBar,TButtSize+8,12,TButtSize+11,15,TBFGCol);}                            
      circlefill(ToolBar,(int)(TButtSize*2.5),TButtSize/2,PenDiameter/4,(DrawMode==0)?TBSelCol:TBFGCol); //button 2 - dot mode (0)
      fastline(ToolBar,TButtSize*3+5,5,TButtSize*4-5,TBSizeY-5,(DrawMode==1)?TBSelCol:TBFGCol); //button 3 - line mode (1)
      if (RectFill == 0) rect(ToolBar,TButtSize*4+5,5,TButtSize*5-5,TBSizeY-5,(DrawMode==2)?TBSelCol:TBFGCol); //button 4 - rectangle modes (2)
         else rectfill(ToolBar,TButtSize*4+5,5,TButtSize*5-5,TBSizeY-5,(DrawMode==2)?TBSelCol:TBFGCol);
      if (CircFill == 0) circle(ToolBar,(int)(TButtSize*5.5),TBSizeY/2,TButtSize/2-4,(DrawMode==3)?TBSelCol:TBFGCol); //button 5 - circle modes (3)
         else circlefill(ToolBar,(int)(TButtSize*5.5),TBSizeY/2,TButtSize/2-4,(DrawMode==3)?TBSelCol:TBFGCol);
      circlefill(ToolBar,(int)(TButtSize*6.5),(int)(TBSizeY*2.5/4),4,(DrawMode==4)?TBSelCol:TBFGCol); //button6 - fill mode (4)
      triangle(ToolBar,TButtSize*6+9,TBSizeY/2,TButtSize*6+15,TBSizeY/2,(int)(TButtSize*6.5),4,(DrawMode==4)?TBSelCol:TBFGCol);
      triangle(ToolBar,TButtSize*7+5,TBSizeY/2,TButtSize*7+10,TBSizeY/2-5,TButtSize*7+10,TBSizeY/2+5,TBFGCol); //undo (left click)
      triangle(ToolBar,TButtSize*7+17,TBSizeY/2,TButtSize*7+12,TBSizeY/2-5,TButtSize*7+12,TBSizeY/2+5,TBFGCol); //redo (right click)
      blit(ToolBar, screen, 0, 0, TBPosX, TBPosY, TBSizeX, TBSizeY);
     }

void InitBmp()  //fills background colour
     {
      for (int i = 0;i<FieldSizeX+8;i++)
      {
       for (int j = 0;j<FieldSizeY+8;j++)
       {
		if (AFLImode && i<24) BmpData[i][j]=0xF;
        else BmpData[i][j] = (i>=FieldSizeX || j>=FieldSizeY) ? 0: (AFLImode&&i<24)?0xF:DrawCol2; //16;
       }
      }
      for (int i=0; i<1040; i++) 
      {
	   for (int j=0; j<8; j++) ClashCnt[i][j]=0;
      }
     }

void DispSelCol()
     {
      textprintf_ex(screen,font,TxtInfoPosX, TxtInfoPosY+00,0x80FFFF,0x252a49,(Mag_min>2)?" Drawing Colour 1: %c":" DrawColour 1: %c",HexChar[DrawCol1]);
      textprintf_ex(screen,font,TxtInfoPosX, TxtInfoPosY+10,0x80FFFF,0x252a49,(Mag_min>2)?" Drawing Colour 2: %c":" DrawColour 2: %c",HexChar[DrawCol2]);
      textprintf_ex(screen,font,TxtInfoPosX, TxtInfoPosY+20,0x80FFFF,0x252a49,(Mag_min>2)?" C64 Border Color: %c":"Border Colour: %c",HexChar[BorderCol]);
      textprintf_ex(screen,font,(Mag_min>2)?TxtInfoPosX+165:GuiSizeX-10, TxtInfoPosY+00,0,C64Palette[DrawCol1]," ");
      textprintf_ex(screen,font,(Mag_min>2)?TxtInfoPosX+165:GuiSizeX-10, TxtInfoPosY+10,0,C64Palette[DrawCol2]," ");
      textprintf_ex(screen,font,(Mag_min>2)?TxtInfoPosX+165:GuiSizeX-10, TxtInfoPosY+20,0,C64Palette[BorderCol]," ");
     }

//---------------------------------------------------------------------------------------------------------
//------------------GUI-dialog event handling callback routines--------------------------------------------
int SelCol0()    //routine for all hexa keys, allegro GUI dialog sucks! - or I'm too new to it, and cannot pass arguments :(
 {               //there were other ways to reduce code, but I was too lazy, and wanted a homogene interface handler with GUI
  SelCol=0; return ChangeCol();
 }

int SelCol1()
 {
  SelCol=1; return ChangeCol();
 }

int SelCol2()
 {
  SelCol=2; return ChangeCol();
 }

int SelCol3()
 {
  SelCol=3; return ChangeCol();
 }

int SelCol4()
 {
  SelCol=4; return ChangeCol();
 }

int SelCol5()
 {
  SelCol=5; return ChangeCol();
 }

int SelCol6()
 {
  SelCol=6; return ChangeCol();
 }

int SelCol7()
 {
  SelCol=7; return ChangeCol();
 }

int SelCol8()
 {
  SelCol=8; return ChangeCol();
 }

int SelCol9()
 {
  SelCol=9; return ChangeCol();
 }

int SelColA()
 {
  SelCol=10; return ChangeCol();
 }

int SelColB()
 {
  SelCol=11; return ChangeCol();
 }

int SelColC()
 {
  if (key_shifts & KB_CTRL_FLAG)
  {
   if (DrawMode==5) {CopyCutSelection(); return D_O_K;}
   else return CopyChar();
  }
  else
  {
  SelCol=12; return ChangeCol();
  }
 }

int SelColD()
 {
  SelCol=13; return ChangeCol();
 }

int SelColE()
 {
  SelCol=14; return ChangeCol();
 }

int SelColF()
 {
  SelCol=15; return ChangeCol();
 }

int ChangeFullCol()
    {
     //UNDO POINT
     StoreUndo();     
     for (int i=0;i<FieldSizeX;i++)
     {
      for (int j=0;j<FieldSizeY;j++)
      {
       if (BmpData[i][j] == DrawCol1) BmpData[i][j]=SelCol;
      }
     }
    }

int ChangeCol()
    {
     remove_timer();
     if (RButt==2 || (key_shifts & KB_ALT_FLAG)) //middle button? Alt pressed with number-keys?
     { //select Border-colour
       BorderCol=SelCol;BorderDrawer();GridDrawer(GridCol);PrevDrawer();DispSelCol(); 
     }
     else if (RButt==1) { DrawCol2=SelCol;DispSelCol(); }
     else if (key_shifts & KB_CTRL_FLAG) {ChangeFullCol();GridDrawer(GridCol);PrevDrawer();DrawCol1=SelCol;DispSelCol();} //change a colour entirely
     else if (key_shifts & KB_SHIFT_FLAG) {DrawCol2=SelCol;DispSelCol();}
     else {DrawCol1=SelCol;DispSelCol();} //no shift keys, normal colour-selection
     SetTimer();
     return (D_REDRAWME|D_WANTFOCUS);
    }

int SwapColor12()
{
 int temp;
 temp=DrawCol1;DrawCol1=DrawCol2;DrawCol2=temp;
 DispSelCol();
 return D_O_K;
}

//==========================================Custom GUI button handlers======================================================

void CloseButton()
     {
      CloseButtState=TRUE;
     }
END_OF_FUNCTION(CloseButton);

int Quit(void)
{
   remove_timer();
   if (alert("Really Quit?", NULL, NULL, "&Yes", "&No", 'y', 'n') == 1)
       return D_CLOSE;
   else
      {CloseButtState=FALSE;position_mouse_z(WheelBuf); SetTimer(); return (D_REDRAWME|D_WANTFOCUS);}
}

/* A custom dialog procedure, derived from d_button_proc. It intercepts
 * the D_CLOSE return of d_button_proc, and calls the function in dp3.
 */
int my_button_proc(int msg, DIALOG *d, int c)
{
   if (mouse_b & 2) RButt=1; else if (mouse_b & 4) RButt=2; else RButt=0; //check which mouse-button was pressed on the button
   int ret = d_button_proc(msg, d, c);
   if (ret == D_CLOSE && d->dp3)
     {
      SelCol=d->d1; //signs color selection
      return ((int (*)(void))d->dp3)();
     }
   return ret;
}

void SetTimer()
     {
      install_int_ex(GetControls, MSEC_TO_TIMER(ControlTimer)); //timer for controls
     }
//-------------------------------------------------------------------------------------------------------------
int SelChrPosX(int Chrnum)
  {
   return (Chrnum - (int)(Chrnum/NoOfChrX)*NoOfChrX ) * ChrSizeX; 
  }

int SelChrPosY(int Chrnum)
  {
   return (Chrnum/NoOfChrX) * ChrSizeY;
  }

int Pluser()  //numpad plus key handler
 {
  remove_timer(); //prevent call-interference with timer
   if (CheckRange()==0) {WheelBuf++; position_mouse_z(WheelBuf);}
   Zoomer();
  SetTimer();
  return D_O_K;
 }

int Minuser()  //numpad minus key handler
 {
  remove_timer(); //prevent call-interference with timer
   if (CheckRange()==0) {WheelBuf--; position_mouse_z(WheelBuf);}
   Zoomer();
  SetTimer();
  return D_O_K;
 }

int Spacer()   //SPACE key handler
 {
  remove_timer();
  if (key_shifts & (KB_SHIFT_FLAG | KB_CTRL_FLAG))
  {
   if (CheckRange() == 0)
   {
    if (MagnifyFactor == Mag_max/2) WheelBuf=Mag_min; else WheelBuf=Mag_max/2;
   }
  }
  else
  {
   if (CheckRange() == 0)
   {
    if (MagnifyFactor == Mag_max) WheelBuf=Mag_min; else WheelBuf=Mag_max;
   }
  }
  position_mouse_z(WheelBuf); Zoomer();
  SetTimer();  
  return D_O_K;
 } 

int PickColor1()
{
 DrawCol1=BmpData[GetDataX()][GetDataY()]; DispSelCol();
 return D_O_K;
}

int Deleter()   //delete one Char
 {
  int ipos = SelChrPosX(ActChar), jpos = SelChrPosY(ActChar), IsNeeded=0;
  int DelCol=(key_shifts & KB_SHIFT_FLAG) ? DrawCol1:DrawCol2;
  for (int i=ipos; i<(ipos+ChrSizeX); i++) for (int j=jpos; j<(jpos+ChrSizeY); j++)
   if (BmpData[i][j]!=DelCol) IsNeeded++;
  if (IsNeeded==0) return D_O_K;
  //UNDO POINT
  remove_timer();
  StoreUndo();
  for (int i=ipos; i<(ipos+ChrSizeX); i++)
  {
   for (int j=jpos; j<(jpos+ChrSizeY); j++)
   {
    BmpData[i][j]=DelCol;
   }
  }
  GridDrawer(GridCol);PrevDrawer();
  SetTimer();
  return D_O_K;
 }

void SetBlkCol(int x, int y, int ToChange, int colour)
     {
      int i,j;
      for (i=x; i<(x+ChrSizeX); i++)
      {
       for (j=y; j<(y+ChrSizeY); j++)
       {
        if (BmpData[i][j]==ToChange) BmpData[i][j]=colour;
       }
      }
     }

void SetSlcCol(int x, int y, int ToChange, int colour)
     {
      int i;
      for (i=x; i<(x+ChrSizeX); i++)
      {
        if (BmpData[i][y]==ToChange) BmpData[i][y]=colour;
      }
     }

void SetBlockCol(int colour)
 {
  int ipos = SelChrPosX(ActChar), jpos = SelChrPosY(ActChar);
  
  if (AFLImode && ipos<24)
  { //change FLI-bug column colour
   if (ipos<8) FLIbugCol1=colour; else if (ipos>=16) FLIbugCol3=colour; else FLIbugCol2=colour;
  }
  else
  {
   unsigned int ToChange=BmpData[GetDataX()][GetDataY()];
   if (ToChange==colour) return; //test, if anything to do at all... (prevents repeat too)
   //UNDO POINT
   if(MButtBuf != mouse_b) StoreUndo(); //StoreUndo();
   SetBlkCol(ipos,jpos,ToChange,colour);
  }
  GridDrawer(GridCol);PrevDrawer();
 }

int CopyChar()    //copies current Char to buffer 
 {
  remove_timer();
  int ipos = SelChrPosX(ActChar), jpos = SelChrPosY(ActChar);
   for (int i=ipos; i<(ipos+ChrSizeX); i++)
   {
    for (int j=jpos; j<(jpos+ChrSizeY); j++)
    {
     CopyBuffer[(i-ipos)][(j-jpos)] = BmpData[i][j];
    }
   }
  SetTimer();
  return D_O_K;
 }

int Paster()    //copies current Char to buffer 
 {
  if (key_shifts & KB_CTRL_FLAG)
  {
   int ipos = SelChrPosX(ActChar), jpos = SelChrPosY(ActChar), IsNeeded=0;
   for (int i=ipos; i<(ipos+ChrSizeX); i++)
   { for (int j=jpos; j<(jpos+ChrSizeY); j++) 
    { if (BmpData[i][j]!=CopyBuffer[(i-ipos)][(j-jpos)]) IsNeeded++; }  //test, if anything to do at all..
   }
   if (IsNeeded==0) return D_O_K;
   remove_timer();
   //UNDO POINT
   StoreUndo();
   for (int i=ipos; i<(ipos+ChrSizeX); i++)
   {
    for (int j=jpos; j<(jpos+ChrSizeY); j++)
    {
     BmpData[i][j] = CopyBuffer[(i-ipos)][(j-jpos)];
    }
   }
   GridDrawer(GridCol);PrevDrawer();
   SetTimer();
  }
  return D_O_K;
 }

int Cutter() //cut Char and send deleted data to buffer
    {
     CopyChar(); Deleter();
     return D_O_K;
    }

int Homer()
    {
     remove_timer();
     if(key_shifts&KB_ALT_FLAG) { SelectionStartX=0; CopyCutSelection(); }
     else GridInPosX=0;
     GridDrawer(GridCol); PrevBlitter(); ShowZoomLocation();
     SetTimer();
     return D_O_K;
    }

int Ender()
    {
     remove_timer();
     if(key_shifts&KB_ALT_FLAG) { SelectionEndX=FieldSizeX-1; CopyCutSelection(); }
     else GridInPosX=FieldSizeX-GridSizeX/MagnifyFactor;
     GridDrawer(GridCol); PrevBlitter(); ShowZoomLocation();
     SetTimer();
     return D_O_K;
    }

int PageUp()
    {
     remove_timer();
     if(key_shifts&KB_ALT_FLAG) { SelectionStartY=0; CopyCutSelection(); }
     else GridInPosY=0;
     GridDrawer(GridCol); PrevBlitter(); ShowZoomLocation();
     SetTimer();
     return D_O_K;
    }

int PageDn()
    {
     remove_timer();
     if(key_shifts&KB_ALT_FLAG) { SelectionEndY=FieldSizeY-1; CopyCutSelection(); }
     else GridInPosY=FieldSizeY-GridSizeY/MagnifyFactor;
     GridDrawer(GridCol); PrevBlitter(); ShowZoomLocation();
     SetTimer();
     return D_O_K;
    }

int Lefter()
    {
     remove_timer();
     if(key_shifts&KB_CTRL_FLAG) { if(SelectionStartX>0) SelectionStartX--; CopyCutSelection();}
     else if(key_shifts&KB_ALT_FLAG) { if(SelectionEndX>0) SelectionEndX--; CopyCutSelection();}
     else { if (GridInPosX>8) GridInPosX-=8; else GridInPosX=0; }
     GridDrawer(GridCol); PrevBlitter(); ShowZoomLocation();
     SetTimer();
     return D_O_K;
    }

int Righter()
    {
     remove_timer();
     if(key_shifts&KB_CTRL_FLAG) { if(SelectionStartX<FieldSizeX) SelectionStartX++; CopyCutSelection(); }
     else if(key_shifts&KB_ALT_FLAG) { if(SelectionEndX<FieldSizeX) SelectionEndX++; CopyCutSelection(); }
     else
     {
      int maxGrPosX=FieldSizeX-GridSizeX/MagnifyFactor;
      if (GridInPosX<maxGrPosX-8) GridInPosX+=8; else GridInPosX=maxGrPosX;
     }
     GridDrawer(GridCol); PrevBlitter(); ShowZoomLocation();
     SetTimer();
     return D_O_K;
    }

int Upper()
    {
     remove_timer();
     if(key_shifts&KB_CTRL_FLAG) { if(SelectionStartY>0) SelectionStartY--; CopyCutSelection(); }
     else if(key_shifts&KB_ALT_FLAG) { if(SelectionEndY>0) SelectionEndY--; CopyCutSelection(); }
     else { if (GridInPosY>8) GridInPosY-=8; else GridInPosY=0; }
     GridDrawer(GridCol); PrevBlitter(); ShowZoomLocation();
     SetTimer();
     return D_O_K;
    }

int Downer()
    {
     remove_timer();
     if(key_shifts&KB_CTRL_FLAG) { if(SelectionStartY<FieldSizeY) SelectionStartY++; CopyCutSelection(); }
     else if(key_shifts&KB_ALT_FLAG) { if(SelectionEndY<FieldSizeY) SelectionEndY++; CopyCutSelection(); }
     else
     {
      int maxGrPosY=FieldSizeY-GridSizeY/MagnifyFactor;
      if (GridInPosY<maxGrPosY-8) GridInPosY+=8; else GridInPosY=maxGrPosY;
     }
     GridDrawer(GridCol); PrevBlitter(); ShowZoomLocation();
     SetTimer();
     return D_O_K;
    }

int CursorInSelection()
    {
      if ((SelectionStartX <= SelectionEndX) && (SelectionStartY <= SelectionEndY))
      {
       if(SelectionStartX<=GetDataX() && GetDataX()<=SelectionEndX && SelectionStartY<=GetDataY() && GetDataY()<=SelectionEndY) 
        { CursorInSelX=(GetDataX()-SelectionStartX); CursorInSelY=(GetDataY()-SelectionStartY); }
       else {CursorInSelX=CursorInSelY=-1; return -1;}
      }
      else if ((SelectionStartX > SelectionEndX) && (SelectionStartY <= SelectionEndY))
      {
       if(SelectionEndX<=GetDataX() && GetDataX()<=SelectionStartX && SelectionStartY<=GetDataY() && GetDataY()<=SelectionEndY)
        { CursorInSelX=(GetDataX()-SelectionEndX); CursorInSelY=(GetDataY()-SelectionStartY); }
       else {CursorInSelX=CursorInSelY=-1; return -1;}
      }
      else if ((SelectionStartX <= SelectionEndX) && (SelectionStartY > SelectionEndY))
      {
       if(SelectionStartX<=GetDataX() && GetDataX()<=SelectionEndX && SelectionEndY<=GetDataY() && GetDataY()<=SelectionStartY)
        { CursorInSelX=(GetDataX()-SelectionStartX); CursorInSelY=(GetDataY()-SelectionEndY); }
       else {CursorInSelX=CursorInSelY=-1; return -1;}
      }
      else
      {
       if(SelectionEndX<=GetDataX() && GetDataX()<=SelectionStartX && SelectionEndY<=GetDataY() && GetDataY()<=SelectionStartY)
        { CursorInSelX=(GetDataX()-SelectionEndX); CursorInSelY=(GetDataY()-SelectionEndY); }
       else {CursorInSelX=CursorInSelY=-1; return -1;}
      }
     return 0;
    }

void CopyCutSelection()
    {
     //copy selection to copy-buffer (or additionally cut if Shift pressed)
     //UNDO point
     if (key_shifts&KB_SHIFT_FLAG) {StoreUndo();MovingSelectiON=true;} else MovingSelectiON=false;
     ClipBoardSizeX=0; //init
     {
      if ((SelectionStartX <= SelectionEndX) && (SelectionStartY <= SelectionEndY))
      {
       for (int i=SelectionStartX;i<=SelectionEndX&&i<FieldSizeX;i++,ClipBoardSizeX++)
       {
        ClipBoardSizeY=0; //init
        for (int j=SelectionStartY;j<=SelectionEndY&&j<FieldSizeY;j++,ClipBoardSizeY++)
        {
         BmpClipBoard[i-SelectionStartX][j-SelectionStartY]=BmpData[i][j];
         if(key_shifts&KB_SHIFT_FLAG) BmpData[i][j]=DrawCol2; //cut and copy
        }
       }
      }
      else if ((SelectionStartX > SelectionEndX) && (SelectionStartY <= SelectionEndY))
      {
       for (int i=SelectionStartX;i>=SelectionEndX&&i>=0;i--,ClipBoardSizeX++)
       {
        ClipBoardSizeY=0; //init
        for (int j=SelectionStartY;j<=SelectionEndY&&j<FieldSizeX;j++,ClipBoardSizeY++)
        {
         BmpClipBoard[SelectionStartX-i][j-SelectionStartY]=BmpData[i][j];
         if(key_shifts&KB_SHIFT_FLAG) BmpData[i][j]=DrawCol2; //cut and copy
        }
       }
      }
      else if ((SelectionStartX <= SelectionEndX) && (SelectionStartY > SelectionEndY))
      {
       for (int i=SelectionStartX;i<=SelectionEndX&&i<FieldSizeX;i++,ClipBoardSizeX++) 
       {
        ClipBoardSizeY=0; //init
        for (int j=SelectionStartY;j>=SelectionEndY&&j>=0;j--,ClipBoardSizeY++)
        {
         BmpClipBoard[i-SelectionStartX][SelectionStartY-j]=BmpData[i][j];
         if(key_shifts&KB_SHIFT_FLAG) BmpData[i][j]=DrawCol2; //cut and copy
        }
       }
      }
      else
      {
       for (int i=SelectionStartX;i>=SelectionEndX&&i>=0;i--,ClipBoardSizeX++) 
       {
        ClipBoardSizeY=0; //init
        for (int j=SelectionStartY;j>=SelectionEndY&&j>=0;j--,ClipBoardSizeY++) 
        {
         BmpClipBoard[SelectionStartX-i][SelectionStartY-j]=BmpData[i][j];
         if(key_shifts&KB_SHIFT_FLAG) BmpData[i][j]=DrawCol2; //cut and copy
        }
       }
      }
     }
     if(key_shifts&KB_SHIFT_FLAG) { GridDrawer(GridCol); PrevDrawer(); }
    }

void PasteMoveSelection()
    { //paste selection to the position where right mouse-button is released
     int PastePosX=GetDataX(), PastePosY=GetDataY();
     int StartX=0, StartY=0, pixX, pixY;
     if (CursorInSelX!=-1 && CursorInSelY!=-1) 
     {
      PastePosX-=CursorInSelX;
      if (PastePosX<0) { StartX=abs(PastePosX); PastePosX=0;} 
      PastePosY-=CursorInSelY;
      if (PastePosY<0) { StartY=abs(PastePosY); PastePosY=0;} 
     }
     if (PastePosX<0 || PastePosY<0) return; //to be on the safe side
     if(!MovingSelectiON) StoreUndo(); //UNDO point
     if (ClashTestMode<2)
     {
      for (int i=StartX;(i<ClipBoardSizeX)&&(PastePosX+i<FieldSizeX);i++)
      {
       for (int j=StartY;(j<ClipBoardSizeY)&&(PastePosY+j<FieldSizeY);j++)
       {
        BmpData[i+PastePosX-StartX][j+PastePosY-StartY] = BmpClipBoard[i][j];
       }
      }
     }
     else
     {
      if (ClashTestMode==4) //init pasted area for 'set' mode
      {
       for (int i=StartX;(i<ClipBoardSizeX)&&(PastePosX+i<FieldSizeX);i++)
       {
        pixX=i+PastePosX-StartX;
        for (int j=StartY;(j<ClipBoardSizeY)&&(PastePosY+j<FieldSizeY);j++)
        {
         pixY=j+PastePosY-StartY;
         BmpData[pixX][pixY]=DrawCol2;
        }
       }
      }
      for (int i=StartX;(i<ClipBoardSizeX)&&(PastePosX+i<FieldSizeX);i++)
      { //do the essential pasting
       pixX=i+PastePosX-StartX;
       for (int j=StartY;(j<ClipBoardSizeY)&&(PastePosY+j<FieldSizeY);j++)
       {
        pixY=j+PastePosY-StartY;
        CarefulPixel(pixX,pixY,BmpClipBoard[i][j]); 
       }
       ShowProgress((i-StartX)*100/(ClipBoardSizeX-StartX)); 
      }
      GridDrawer(GridCol);
     }
     GridDrawer(GridCol); PrevDrawer();
    }

void DisplayClipBoard()
     {
      int GridMpX=mouse_x-GridPosX-1, GridMpY=mouse_y-GridPosY-1; 
      int disposX=GridMpX-(GridMpX % MagnifyFactor), disposY= GridMpY-(GridMpY % MagnifyFactor), pixX, pixY;
      int startX=0,startY=0;
      if (CursorInSelX!=-1 && CursorInSelY!=-1) 
      {
       disposX-=CursorInSelX*MagnifyFactor; 
       if (disposX<0) {startX=abs(disposX)/MagnifyFactor;disposX=0;}
       disposY-=CursorInSelY*MagnifyFactor;
       if (disposY<0) {startY=abs(disposY)/MagnifyFactor;disposY=0;}
      }
      for (int i=startX;i<ClipBoardSizeX;i++)
      {
       pixX=i*MagnifyFactor-startX*MagnifyFactor;
       for (int j=startY;j<ClipBoardSizeY;j++)
       {
        pixY=j*MagnifyFactor-startY*MagnifyFactor;
        rectfill(ClipboardSprite,pixX,pixY,pixX+MagnifyFactor,pixY+MagnifyFactor,C64Palette[ BmpClipBoard[i][j] ] );
       }
      }
      set_clip_rect(screen,GridPosX,GridPosY,GridPosX+GridSizeX-1,GridPosY+GridSizeY-1);
      blit(ClipboardSprite, screen, 0, 0, GridPosX+disposX, GridPosY+disposY, (ClipBoardSizeX-startX)*MagnifyFactor, (ClipBoardSizeY-startY)*MagnifyFactor);
      set_clip_rect(screen,0,0,GuiSizeX-1,GuiSizeY-1);
     }

//=================================================GUI button procedures============================
int ClearBmp()
    {
     remove_timer();
     if (alert("Really Clear the whole Bitmap?", NULL, NULL, "&Yes", "&No", 'y', 'n') == 1)
       {
        //UNDO POINT
        StoreUndo();
        InitBmp();
        GridDrawer(GridCol);PrevDrawer();
        SetTimer();
        return (D_REDRAWME|D_WANTFOCUS);
       }
     else
      {CloseButtState=FALSE;position_mouse_z(WheelBuf); SetTimer(); return (D_REDRAWME|D_WANTFOCUS);}
    }

int Help(void)
    {
     remove_timer();
     alert("mouse->left:draw, right:rubber, middle:move, scroll:zoom",
           "0..9 A..F - select drawcolour, with SHIFT - drawcolour 2",
           "SPACE-zoomswitch, F1..F4-pendiameter, F5..F8-drawingmode",
           "Check out the README.txt for more details!", 0, 0, 0); 
     SetTimer();
     return (D_REDRAWME|D_WANTFOCUS);
    }

//--------------------------------------FILE OPERATIONS----------------------------------
void LoadPrg(char *filepath)   //write a new binary file with the graphic-data  
     {
      int i,j,xrough,yrough,yfine, prgaddr=0; //counts the read Chars, whenever reaches max., protects the loader
      InitBmp();   
      PACKFILE *PRGFile = pack_fopen(filepath,"r");
      pack_fread(&prgaddr,2,PRGFile); //copy the unneeded loadaddress to a yet unused space, will be overwritten soon
      if (file_size_ex(filepath)<10000) //if bigger than 10kbyte, it's AFLI
      { //load normal hires prg content
       if (prgaddr==0x801) pack_fseek(PRGFile,EXEdataAdd-BASICstartAdd);
       pack_fread(&C64bmp,0x1F40,PRGFile); //read bitmap 
       for (i=0;i<0x03E8;i++) ColorMap[i][0]=pack_getc(PRGFile);  //pack_fread(&ColorMap,0x03E8,PRGFile);  
       pack_fread(&BorderCol,1,PRGFile);
       for (i=0;i<0x1F40;i++)
       {
        for (j=0;j<8;j++)
        {
         yrough=(i/320)*8; yfine=(i-yrough*40)%8; xrough=(i-yrough*40)-yfine;
         BmpData[xrough+j][yrough+yfine] = ((C64bmp[i]&pow2[j])==0) ? ColorMap[i/8][0]&0x0F : ColorMap[i/8][0]/16;
        }
       }
      }
      else
      { //load AFLI prg content
       if (prgaddr==0x801) pack_fseek(PRGFile,AFLIEXEdataAdd-BASICstartAdd);
       pack_fread(&C64bmp,0x1F40,PRGFile); //read bitmap 
	   for (i=0;i<0x2000-0x1f40;i++) pack_getc(PRGFile);
	   for (i=0;i<7;i++) { for(j=0;j<1000;j++) ColorMap[j][i]=pack_getc(PRGFile); for(j=0;j<24;j++) pack_getc(PRGFile); }
	   for(j=0;j<1000;j++) ColorMap[j][7]=pack_getc(PRGFile); 
	   pack_fread(&BorderCol,1,PRGFile);
	   pack_fread(&FLIbugCol1,sizeof(unsigned char),PRGFile);
       pack_fread(&FLIbugCol2,sizeof(unsigned char),PRGFile);
       pack_fread(&FLIbugCol3,sizeof(unsigned char),PRGFile);
	   for (i=0;i<0x1F40;i++)
       {
        for (j=0;j<8;j++)
        {
         yrough=(i/320)*8; yfine=(i-yrough*40)%8; xrough=(i-yrough*40)-yfine;
         BmpData[xrough+j][yrough+yfine] = ((C64bmp[i]&pow2[j])==0) ? ColorMap[i/8][yfine]&0x0F : ColorMap[i/8][yfine]/16;
        }
       }
      }
      pack_fclose(PRGFile);
     } 

int Load()   //.prg or .hbm (.bmp/png ?) loader
    {
     if (key_shifts&KB_LWIN_FLAG || key_shifts&KB_RWIN_FLAG || key_shifts&KB_MENU_FLAG) return 0;
     int i,j;
     remove_timer();
     if (FileSelector("Select File (.hbm/.prg/.bmp/.png) to open",LOADpath,"hbm;prg;bmp;png",480,400,400) != 0)
     {
      LoadFile();
     }
     WheelBuf=MagnifyFactor=Mag_min; position_mouse_z(WheelBuf); GridInPosX=GridInPosY=0;
     BorderDrawer(); GridDrawer(GridCol); PrevDrawer(); DispSelCol();
     for (i=0;i<1000;i++) { for (j=0;j<8;j++) ClashCnt[i][j]=0; }   //init
     SetTimer();
     return (D_REDRAWME|D_WANTFOCUS);
    }

int HexStrToInt(char ch)
    {
     int Nybble;
     for(Nybble=0;Nybble<=16;Nybble++) if (HexChar[Nybble]==toupper(ch)) break;
     if (Nybble>=16) return -1;
     return Nybble;
    }


void LoadPalette()
    {
     char ChRead;
     int i, HexValue, Red,Green,Blue;
      fix_filename_slashes(VPLpath);
      if (exists(VPLpath))
      {
       PACKFILE *VPLfile = pack_fopen(VPLpath,"r"); //read .vpl
       for(i=0;i<16;i++)
       {
        ChRead=0;
        while (ChRead!=EOF)
        { //look for 1st digit at the beginning of row...
         HexValue=-1;
         while ( (ChRead=pack_getc(VPLfile))!=EOF && ChRead!='\n') ; //look for new line
         ChRead=pack_getc(VPLfile); HexValue=HexStrToInt(ChRead); 
         if (HexValue!=-1) break;
        }
        Red = HexValue*16+HexStrToInt(pack_getc(VPLfile)); pack_getc(VPLfile);
        Green = HexStrToInt(pack_getc(VPLfile))*16 + HexStrToInt(pack_getc(VPLfile)); pack_getc(VPLfile);
        Blue = HexStrToInt(pack_getc(VPLfile))*16 + HexStrToInt(pack_getc(VPLfile));
        C64Palette[i]=makecol(Red,Green,Blue);
       }
       pack_fclose(VPLfile);
       for(int i=0;i<16;i++) {HermIRESdialog[i+1].bg=C64Palette[i]; object_message(&HermIRESdialog[i+1],MSG_DRAW,0); } //update palette-button colours
       //for (unsigned int i=0;i<16;i++) {BackPalette[C64Palette[i]]=i;} //copy C64Palette array to Backpalette associative map
       textprintf_ex(screen,font,(Mag_min>2)?MenuPosX-8:PalButtPosX+10, (Mag_min>2)?MenuPosY+24:PalButtPosY+PalButtSizeY,0x004488,GUIbgColor,"%.11s            ",get_filename(VPLpath));
      }
    }

int LoadVPL()   //load .vpl palette
    {
     remove_timer();
     if (FileSelector("Select Palette File (.vpl) to open",VPLpath,"vpl",480,400,400) != 0)
     {
      LoadPalette();
     }
     BorderDrawer(); GridDrawer(GridCol); PrevDrawer(); DispSelCol();
     SetTimer();
     return (D_REDRAWME|D_WANTFOCUS);
    }

void LoadFile()
     {
      int i,j;
      fix_filename_slashes(LOADpath);
      if (exists(LOADpath))
      {
       ExeCaption[0]=0;
       //UNDO POINT
       StoreUndo();
       rectfill(screen,GridSizeX/2-130, GridSizeY/2-40,GridSizeX/2+130, GridSizeY/2+50,0x000032);
       textprintf_ex(screen,font,GridSizeX/2-120, GridSizeY/2,0xFFFFC0,0x000000," *** LOADING IN PROGRESS *** ");

       if (ustrcmp(get_extension(LOADpath),"hbm") == 0)
       { 
        PACKFILE *HBMfile = pack_fopen(LOADpath,"rp"); //read packed hbm
        pack_fread(&BorderCol,sizeof(unsigned char),HBMfile);
        for(i=0;i<FieldSizeX;i++) pack_fread(&BmpData[i][0],FieldSizeY,HBMfile);
        pack_fread(&FLIbugCol1,sizeof(unsigned char),HBMfile);
        pack_fread(&FLIbugCol2,sizeof(unsigned char),HBMfile);
        pack_fread(&FLIbugCol3,sizeof(unsigned char),HBMfile);
        pack_fclose(HBMfile);
       }
       else if (ustrcmp(get_extension(LOADpath),"prg") == 0)
       {
        LoadPrg(LOADpath);
       }
       else if (ustrcmp(get_extension(LOADpath),"bmp") == 0)
       {
        LoadBMP();
       }
       else if (ustrcmp(get_extension(LOADpath),"png") == 0)
       {
        LoadPNG();
       }
       textprintf_ex(screen,font,(Mag_min>2)?MenuPosX-8:MenuPosX-50, MenuPosY-10,0x004488,GUIbgColor,"%.26s                                          ",get_filename(SAVEpath));
      }
     }

void ConvBackBMP(BITMAP *bitmap) //convert a pointed (referenced) bmp into C64 colour Bitmap-data
     {
      unsigned char detcol;
      if (ClashTestMode<2)
      {
       for (int i = 0;i<FieldSizeX;i++)
       {
        for (int j = 0;j<FieldSizeY;j++)
        {
         detcol = GetMatchCol(getpixel(bitmap, i,j));   //detect colour , getr(),getg(),getb() for calculations
         BmpData[i][j] = detcol;
        } 
        //ShowProgress(i*100/FieldSizeX); 
       }
      }
      else
      { //C64 limitation-aware clash-test modes
       int clashmtemp=ClashTestMode; ClashTestMode=4; //in case of import, force 'SET' mode (no point for the others)
       InitBmp(); //reset bitmap first
       for (int i = 0;i<FieldSizeX;i++)
       {
        for (int j = 0;j<FieldSizeY;j++)
        {
         detcol = GetMatchCol(getpixel(bitmap, i,j));   //detect colour , getr(),getg(),getb() for calculations
         CarefulPixel(i,j,detcol);
        }
        //ShowProgress(i*100/FieldSizeX);  
       }
       ClashTestMode=clashmtemp;
      }
     }

void LoadBMP()  //loading and converting (cut/stertch/colour) the BMP file to BmpData 
     {
      BITMAP *ImportBMP; 
      ImportBMP = load_bmp(LOADpath,BMPalette);
      rectfill(screen,GridSizeX/2-160, GridSizeY/2-40,GridSizeX/2+160, GridSizeY/2+50,0x000032);
      textprintf_ex(screen,font,GridSizeX/2-160, GridSizeY/2,0xFFFFC0,0x000000," *** PICTURE CONVERSION IN PROGRESS *** ");
      ConvBackBMP(ImportBMP);
      destroy_bitmap(ImportBMP);
      BorderCol=DefaultBorderCol; BorderDrawer();
     }

void LoadPNG()  //loading and converting (cut/stertch/colour) the PNG file to BmpData 
     {
      BITMAP *ImportBMP; 
      ImportBMP = load_png(LOADpath,BMPalette);
      rectfill(screen,GridSizeX/2-160, GridSizeY/2-40,GridSizeX/2+160, GridSizeY/2+50,0x000032);
      textprintf_ex(screen,font,GridSizeX/2-160, GridSizeY/2,0xFFFFC0,0x000000," *** PICTURE CONVERSION IN PROGRESS *** ");
      ConvBackBMP(ImportBMP);
      destroy_bitmap(ImportBMP);
      BorderCol=DefaultBorderCol; BorderDrawer();
     }


unsigned char GetMatchCol(unsigned int inputcol)  //get the code of the closest c64 colour for the given RGB colour
        {
         int red = getr(inputcol), green = getg(inputcol), blue = getb(inputcol), rdelta, gdelta, bdelta, resultcol, mintemp=256;
         int sumerrors[16]; //comparable errors for C64 palette colours to decide which fits the best
         for (int i=0;i<16;i++) //comparing through the palette for error-deltas, getting the C64 colour with smallest error
         {
          rdelta = abs(getr(C64Palette[i])-red);
          gdelta = abs(getg(C64Palette[i])-green);
          bdelta = abs(getb(C64Palette[i])-blue);
          sumerrors[i]=rdelta+gdelta+bdelta;
          if (sumerrors[i] < mintemp) {mintemp=sumerrors[i];resultcol=i;}
         }        
         return resultcol;
        }

 //------------------------------------saver (.hbm)----------------

void SaveHBM(char *filepath)
      {
       //write a new packed file with the graphic-data  
        PACKFILE *HBMfile = pack_fopen(filepath,"wp");
        pack_fwrite(&BorderCol,sizeof(unsigned char),HBMfile);
        for(int i=0;i<FieldSizeX;i++) pack_fwrite(&BmpData[i][0],FieldSizeY,HBMfile);
        pack_fwrite(&FLIbugCol1,sizeof(unsigned char),HBMfile);
        pack_fwrite(&FLIbugCol2,sizeof(unsigned char),HBMfile);
        pack_fwrite(&FLIbugCol3,sizeof(unsigned char),HBMfile);
        pack_fclose(HBMfile);
      }

int Save()
    {
     if (key_shifts & KB_SHIFT_FLAG) return SavePNG();
     remove_timer();
trial:
     replace_extension(SAVEpath,SAVEpath,"hbm",sizeof(SAVEpath));
     if (FileSelector("Give a name and path for the .hbm file",SAVEpath,"hbm",480,400,400) != 0)
     {
      fix_filename_slashes(SAVEpath);
      if (ustrcmp(get_extension(SAVEpath),"hbm")) strcat(SAVEpath,".hbm"); // replace_extension(SAVEpath,SAVEpath,"hbm",sizeof(SAVEpath));
      if (exists(SAVEpath))
      {
       if (alert("File exists. Overwrite?", NULL, NULL, "&Yes", "&No", 'y', 'n') == 1) SaveHBM(SAVEpath);
       else goto trial;
      }
      else SaveHBM(SAVEpath);
     }
     SetTimer();
     return (D_REDRAWME|D_WANTFOCUS);
    }

//-------------------------------------------.prg (.bmp/png?) converter & saver -------------
int ConvertChr(int Charnum) //convert the selected Char's layers to C64 format in ConvChr
     {
      int k, ipos=SelChrPosX(Charnum), jpos=SelChrPosY(Charnum), colindex = 0, coltest, mempos, bytepos, Chrx, Chry;
      for (int colour=0; colour <= 15; colour++)
      {
       coltest=0; //counts, how much times the currently tested colour appeared
       for (int j=jpos; j<(jpos+ChrSizeY); j++)
       {
	    for (int i=ipos; i<(ipos+ChrSizeX); i++)
        {
         Chrx= i-ipos; Chry= j-jpos;
         mempos = Chry; bytepos = Chrx-(Chrx/8)*8;
         if ( BmpData[i][j]==colour)
         { //set the Char-pixel for the current colour
           coltest++; //counts, how mutch times the currently tested colour appeared
           ConvChr[colindex][mempos][0] |= pow2[bytepos];
         }
         else
         { //reset the Char-pixel for current colour
          ConvChr[colindex][mempos][0] &= 255-pow2[bytepos];
         }
        }
       }
       if (coltest > 0) {                      //if the colour occured, goes to next Char-layer
                         ConvChr[colindex][8][0]= colour; //and store the current colour to Char layer's 8th position
                         colindex++;                                   //and even stored the index of the overlay Char
                        }                                              //in the upper nybble of the colourbyte
      }
      ClashCnt[Charnum][0]=colindex; //register clash/colourcount
      if (colindex==1 && ConvChr[0][8][0]==BmpData[0][0]) {ConvChr[1][8][0]=ConvChr[0][8][0]; for (k=0;k<8;k++) ConvChr[0][k][0]=0; } //if only one colour used, it should be 
      //else if (colindex==1 && ConvChr[1][8]==BmpData[0][0]) {ConvChr[0][8]=ConvChr[1][8]; for (k=0;k<8;k++) ConvChr[0][k]=0xFF; }
      ColorMap[Charnum][0]=ConvChr[0][8][0]*16+ConvChr[1][8][0];
      return colindex; //returns number of used layers (colours)
     }

int ConvertSlice(int x, int y) //for AFLI mode
	{
		int colindex = 0, coltest, ipos=x-x%ChrSizeX, Chrx, bytepos, mempos=y%ChrSizeY;
		
		if (x<24) //FLI-bug area is handled differently, everything what is not colour 0xF is considered the same
		{
		 ConvChr[1][mempos][0]=0; //0b00000000;
		 for (int i=ipos; i<(ipos+ChrSizeX); i++)
		 { Chrx= i-ipos; bytepos = Chrx-(Chrx/8)*8;
		  if (BmpData[i][y]==0xF) ConvChr[0][mempos][0] |= pow2[bytepos];
		  else ConvChr[0][mempos][0] &= 255-pow2[bytepos];
		  ConvChr[0][8][mempos]=0xF; 
		  if (x<8) ConvChr[1][8][mempos]=FLIbugCol1; else if (x>=16) ConvChr[1][8][mempos]=FLIbugCol3; else ConvChr[1][8][mempos]=FLIbugCol2;
	     }
		 return 0; //no colour-clash to report in this case
		}
		
	    for (int colour=0; colour <= 15; colour++)
        { 
		 coltest=0; //counts, how much times the currently tested colour appeared
         for (int i=ipos; i<(ipos+ChrSizeX); i++)
         {
		  Chrx= i-ipos; bytepos = Chrx-(Chrx/8)*8;
          if ( BmpData[i][y]==colour)
          { //set the Char-pixel for the current colour
            coltest++; //counts, how mutch times the currently tested colour appeared
            ConvChr[colindex][mempos][0] |= pow2[bytepos];
          }
          else
          { //reset the Char-pixel for current colour
           ConvChr[colindex][mempos][0] &= 255-pow2[bytepos];
          }
	     }
	     if (coltest > 0) {                      //if the colour occured, goes to next Char-layer
                           ConvChr[colindex][8][mempos]= colour; //and store the current colour to Char layer's 8th position
                           colindex++;                                   //and even stored the index of the overlay Char
                          }             
	    }
        return colindex; //returns number of used layers (colours) in the AFLI 8x1 slice
	}

void ConvertAFLIchr(int charnum)
	{
	 int ipos=SelChrPosX(charnum), jpos=SelChrPosY(charnum), Chry;
	 for (int j=jpos; j<(jpos+ChrSizeY); j++)
     { Chry = j-jpos;
	  ClashCnt[charnum][Chry]=ConvertSlice(ipos,j); //register clash/colourcount
	  ColorMap[charnum][Chry]=ConvChr[0][8][Chry]*16+ConvChr[1][8][Chry];
	 }
    }

void DetectClashes()
     {
      if (AFLImode==false) { for (int i=0 ; i<NoOfChrX*NoOfChrY ; i++) ConvertChr(i); }
      else 
      { //AFLI-mode clash-detection of the whole picture:
	   for (int i=0 ; i<NoOfChrX*NoOfChrY ; i++) ConvertAFLIchr(i); //converts and makes the clash-testing
	  }
     }

void SaveCaption(PACKFILE *PRGFile)
	{
	   int j, i=0,titlend=0; 
	   if (strlen(ExeCaption)<24) for(;i<(24-strlen(ExeCaption))/2;i++) pack_putc( (strlen(ExeCaption))?0x20:0 ,PRGFile);
       for (j=0 ;i<40;i++,j++) //pack_fwrite(&filename,5,PRGFile);
       {
        if (ExeCaption[j]==0) titlend=1; //or ExeCaption[j]=='.'
        if (titlend==0) pack_putc(toupper(ExeCaption[j]),PRGFile);
        else  pack_putc(0,PRGFile);
       }
	}

void SaveAFLIdata (PACKFILE *PRGFile)
	{
	   int i,j;
       for (i=0 ; i<NoOfChrX*NoOfChrY ; i++) 
       { //save AFLI bitmap data
        ConvertAFLIchr(i); //converts and makes the clash-testing
        for (j=0; j<8; j++) pack_putc(ConvChr[0][j][0],PRGFile); //pack_fwrite(&ConvChr,8,PRGFile);
       }
       for (i=0; i<21; i++) { pack_putc(0x55,PRGFile); pack_putc(0xAA,PRGFile); pack_putc(0xFF,PRGFile); } //FLI-bug underlay-sprite rows
       pack_putc(0,PRGFile); //last hidden byte of underlay-sprite 
       int lowSpH=16; //lowest sprite's height
       for (i=0; i<21; i++) { pack_putc((i<lowSpH)?0x55:0,PRGFile); pack_putc((i<lowSpH)?0xAA:0,PRGFile); pack_putc((i<lowSpH)?0xFF:0,PRGFile); } //FLI-bug underlay-sprite rows 
       pack_putc(0,PRGFile); //last hidden byte of underlay-sprite 
       for (i=0 ; i<(0x2000-0x1fc0); i++) pack_putc(0,PRGFile); //leave the gap between bitmap and colmap
       for (i=0; i<7; i++)
       { //save AFLI colour-data (8 video-RAMs)
        for (j=0 ; j<NoOfChrX*NoOfChrY ; j++) pack_putc(ColorMap[j][i],PRGFile);
        for (j=0 ; j<(1024-8-NoOfChrX*NoOfChrY); j++) pack_putc(0,PRGFile); //complete to 1024-8
        for (j=0 ; j<8; j++) pack_putc((0x1f40/0x40)+j/6,PRGFile); //set FLI-bug underlay sprite pointers (lowest sprite is 6th, shorter one)
	   }
	   for (j=0 ; j<NoOfChrX*NoOfChrY ; j++) pack_putc(ColorMap[j][7],PRGFile);
	   pack_fwrite(&BorderCol,sizeof(unsigned char),PRGFile); //border colour
       pack_fwrite(&FLIbugCol1,sizeof(unsigned char),PRGFile);
       pack_fwrite(&FLIbugCol2,sizeof(unsigned char),PRGFile);
       pack_fwrite(&FLIbugCol3,sizeof(unsigned char),PRGFile);
       
	}

void SavePRG(char *filepath)   //write a new binary file with the graphic-data  
     {
      int colournum, i, j; //colournum signs how many colours (layers) the specific Char contains      
      PACKFILE *PRGFile = pack_fopen(filepath,"w");
      if (AFLImode==0)
      { //normal hires-bitmap export
       pack_fwrite(&PrgStartAdd,2,PRGFile);
       for (i=0 ; i<NoOfChrX*NoOfChrY ; i++)
       { //save hires bitmap-data
        ConvertChr(i);
        for (j=0; j<8; j++) pack_putc(ConvChr[0][j][0],PRGFile); //pack_fwrite(&ConvChr,8,PRGFile);
       }
       for (j=0 ; j<NoOfChrX*NoOfChrY ; j++) pack_putc(ColorMap[j][0],PRGFile); //pack_fwrite(&ColorMap,1000,PRGFile); //save hires colour-data
       pack_fwrite(&BorderCol,sizeof(unsigned char),PRGFile); //border colour
      }
      else
      { //AFLI export
       pack_fwrite(&AFLIprgStartAdd,2,PRGFile);
	   SaveAFLIdata(PRGFile);
      }
      GridDrawer(GridCol);
      pack_fclose(PRGFile);
     } 

void SaveEXE(char *filepath)   //write a new binary file with the graphic-data  
     {
      int colournum, i,j; //colournum signs how many colours (layers) the specific Char contains      
      PACKFILE *PRGFile = pack_fopen(filepath,"w");
      //textprintf_ex(screen,font,TxtInfoPosX, TxtInfoPosY-14,0x80FFFF,0x0000FF,"%s",filename);
      //pack_fwrite(&BASICstartAdd,2,PRGFile);  //already contained in the array!
      if (AFLImode==0)
      { //normal hires 'exe'
       pack_fwrite(&bmpExe,0x201-40,PRGFile);
	   SaveCaption(PRGFile);
       for (i=0 ; i<NoOfChrX*NoOfChrY ; i++)
       {
        ConvertChr(i);
        for (j=0; j<8; j++) pack_putc(ConvChr[0][j][0],PRGFile);  //pack_fwrite(&ConvChr,8,PRGFile);
       }
       for (i=0; i<1000; i++) pack_putc(ColorMap[i][0],PRGFile);  //pack_fwrite(&ColorMap,1000,PRGFile);
       pack_fwrite(&BorderCol,sizeof(unsigned char),PRGFile); //border colour
      }
      else
      { //AFLI 'exe'
       pack_fwrite(&AFLIexe,0x301-40,PRGFile);
	   SaveCaption(PRGFile);
	   SaveAFLIdata(PRGFile);
      }
      GridDrawer(GridCol);
      pack_fclose(PRGFile);
     } 

int ExportC64() //save the data in C64 Bitmap (Art Studio 1) format .prg binary file (load-address included)
    {
     remove_timer();
trial2:
     replace_extension(SAVEpath,SAVEpath,"prg",sizeof(SAVEpath));
     if (FileSelector("Give a name and path for the .prg file",SAVEpath,"prg",480,400,400) != 0)
     {
      fix_filename_slashes(SAVEpath);
      if (ustrcmp(get_extension(SAVEpath),"prg")) strcat(SAVEpath,".prg"); //replace_extension(SAVEpath,SAVEpath,"prg",sizeof(SAVEpath));
      if (exists(SAVEpath))
      {
       if (alert("File exists. Overwrite?", NULL, NULL, "&Yes", "&No", 'y', 'n') == 1) SavePRG(SAVEpath);
       else goto trial2;
      }
      else SavePRG(SAVEpath);
     }
     SetTimer();
     return (D_REDRAWME|D_WANTFOCUS);
    }

int ExportExe () //convert to C64 executalbe
    {
     int i;
     remove_timer();
trial2:
     replace_extension(SAVEpath,SAVEpath,"prg",sizeof(SAVEpath));

      char * filename=get_filename(SAVEpath);
      if (ExeCaption[0]==0) { for (i=0;i<24&&filename[i];i++) ExeCaption[i]=filename[i]; ExeCaption[i]=0;}

      set_dialog_color(EditCaption, gui_fg_color, gui_bg_color); 
      EditCaption[0].x=GuiSizeX-245; EditCaption[0].y=GuiSizeY-100; 
      EditCaption[1].x=GuiSizeX-230; EditCaption[1].y=GuiSizeY-70; EditCaption[1].fg=0xFFFFFF; EditCaption[1].bg=0;
      EditCaption[2].x=GuiSizeX-130; EditCaption[2].y=GuiSizeY-90; EditCaption[2].fg=0xFFFFFF; EditCaption[2].dp=(char*)"Edit caption, press Enter.";
      popup_dialog(EditCaption,1);

     if (FileSelector("Give a name and path for the .prg file",SAVEpath,"prg",480,400,400) != 0)
     {
      fix_filename_slashes(SAVEpath);
      if (ustrcmp(get_extension(SAVEpath),"prg")) strcat(SAVEpath,".prg"); //replace_extension(SAVEpath,SAVEpath,"prg",sizeof(SAVEpath));
      if (exists(SAVEpath))
      {
       if (alert("File exists. Overwrite?", NULL, NULL, "&Yes", "&No", 'y', 'n') == 1) SaveEXE(SAVEpath);
       else goto trial2;
      }
      else SaveEXE(SAVEpath);
     }
     SetTimer();
     return (D_REDRAWME|D_WANTFOCUS);
    }

//---------------------------------------------------------------------------------
void SavePNGfile(char *filepath)
     {
      save_png(filepath,(!CRTmode)?Preview:CRTpreview,BMPalette);
     }

int SavePNG()
    {
     PrevRightClick = 0;
     remove_timer();
trial3:
     replace_extension(SAVEpath,SAVEpath,"png",sizeof(SAVEpath));
     if (FileSelector("You can now save a bitmap, give name and path.",SAVEpath,"png",480,400,400) != 0)
     {
      fix_filename_slashes(SAVEpath);
      if (ustrcmp(get_extension(SAVEpath),"png")) strcat(SAVEpath,".png"); //replace_extension(SAVEpath,SAVEpath,"png",sizeof(SAVEpath));  // leaving this lets the user rename & set the picture-type to bmp/pcx/tga
      if (exists(SAVEpath))
      {
       if (alert("File exists. Overwrite?", NULL, NULL, "&Yes", "&No", 'y', 'n') == 1) SavePNGfile(SAVEpath);
       else goto trial3;
      }
      else SavePNGfile(SAVEpath);
     }
     SetTimer();
     return (D_REDRAWME|D_WANTFOCUS);
    }

//------------------------
int ToggleGrid()
    {
     remove_timer();
     if (RButt==1 || (key_shifts & KB_SHIFT_FLAG)) //middle button? Shift pressed with the key?
     {
      if (GridMode>0) { GridMode--; GridDrawer(GridCol); } 
      else { GridMode=2; GridDrawer(0); } 
     }
     else
     {
      if (GridMode<2) { GridMode++; GridDrawer(GridCol); } //if (GridMode==false) { GridMode=true; GridDrawer(GridCol); }
      else { GridMode=0; GridDrawer(0); }                     //else { GridMode=false; GridDrawer(0); }
     }
     SettingDispl(); dispGridBri();
     SetTimer();
     return (D_REDRAWME|D_WANTFOCUS);
    }
    
void AFLIbuttonCol()
	{
	 HermIRESdialog[33].bg=0x808080*AFLImode; HermIRESdialog[33].fg=(AFLImode)?0xf0f0f0:0x404040;
	}
 
int ToggleAFLImode()
	{
     remove_timer();
     AFLImode=(AFLImode)?false:true;
     AFLIbuttonCol(); GridDrawer(0); SettingDispl(); dispGridBri(); PrevDrawer();
     SetTimer();
     return (D_REDRAWME|D_WANTFOCUS);     
	}

int ClashTest()
    {
     remove_timer();
     if (RButt==1 || (key_shifts & KB_SHIFT_FLAG)) //middle button? Shift pressed with the key?
     {
      if (ClashTestMode>0) { ClashTestMode--; DetectClashes(); }
      else ClashTestMode=4;
     }
     else
     { 
      if (ClashTestMode<4) { ClashTestMode++; DetectClashes(); } //if (ClashTestMode==false) { ClashTestMode=true; DetectClashes(); }
      else { ClashTestMode=0; } //else { ClashTestMode=false; GridDrawer(GridCol); }
     }
     GridDrawer(GridCol);
     SettingDispl();
     SetTimer();
     return (D_REDRAWME|D_WANTFOCUS);
    }

int ToggleBriGrid()
    {
     remove_timer();
     if (EnableBriGrid==false) { EnableBriGrid=true; GridDrawer(GridCol); }
     else { EnableBriGrid=false; GridDrawer(GridCol); }
     SettingDispl(); dispGridBri();
     SetTimer();
     return (D_REDRAWME|D_WANTFOCUS);
    }

int ToggleCRTemul()
    {
     remove_timer();
     if (RButt==1 || (key_shifts & KB_SHIFT_FLAG)) //middle button? Shift pressed with the key?
     {
      if (CRTmode>0) { CRTmode--; } //if (CRTmode==false) { CRTmode=true; GridDrawer(GridCol); }
      else { CRTmode=3; } //else { CRTmode=false; GridDrawer(GridCol); }
     }
     else
     {
      if (CRTmode<3) { CRTmode++; } //if (CRTmode==false) { CRTmode=true; GridDrawer(GridCol); }
      else { CRTmode=0; } //else { CRTmode=false; GridDrawer(GridCol); }         
     }
     GridDrawer(GridCol); PrevDrawer(); SettingDispl();
     SetTimer();
     return (D_REDRAWME|D_WANTFOCUS);
    }

int SetBlur()
{
 remove_timer();
 PALblur=HermIRESdialog[18].d2; GridDrawer(GridCol); PrevDrawer();
 SetTimer();
 return (D_REDRAWME|D_WANTFOCUS);
}

int SetBrightness()
{
 remove_timer();
 Brightness=HermIRESdialog[17].d2; GridDrawer(GridCol); PrevDrawer();
 SetTimer();
 return (D_REDRAWME|D_WANTFOCUS);
}

int ResetBrightness()
{
 HermIRESdialog[17].d2=128;
 object_message(&HermIRESdialog[17],MSG_DRAW,0); 
 return SetBrightness();
}

int ResetPALblur()
{
 HermIRESdialog[18].d2=DefaultBlur;
 object_message(&HermIRESdialog[18],MSG_DRAW,0); 
 return SetBlur();
}

//==================================================Pencil Tools==============================================
int F1er()
    {
     DrawMode=0; PenDiameter = 4; DispToolBar(); GridBlitter();
     return D_O_K;
    }

int F2er()
    {
     DrawMode=0; PenDiameter = 8; DispToolBar(); GridBlitter();
     return D_O_K;
    }

int F3er()
    {
     DrawMode=0; PenDiameter = 16; DispToolBar(); GridBlitter();
     return D_O_K;
    }

int F4er()
    {
     DrawMode=0; PenDiameter = 32; DispToolBar(); GridBlitter();
     return D_O_K;
    }

int F5er()
    {
     DrawMode = 1;DispToolBar(); GridBlitter();
     return D_O_K;
    }

int F6er()
    {
     if (DrawMode == 2) (RectFill == 1)? RectFill=0:RectFill=1; else DrawMode=2;
     DispToolBar(); GridBlitter();
     return D_O_K;
    }

int F7er()
    {
     if (DrawMode == 3) (CircFill == 1)? CircFill=0:CircFill=1; else DrawMode=3;
     DispToolBar(); GridBlitter();
     return D_O_K;
    }

int F8er()
    {
     DrawMode = 4; DispToolBar(); GridBlitter();
     return D_O_K;
    }

int F9er()
    {
     (DitherMode < 2)? DitherMode++:DitherMode=0;
     DispToolBar();
     return D_O_K;
    }

int F10er()
    {
     (Dither2Col!=1)?Dither2Col=1:Dither2Col=0; DispToolBar();
     return D_O_K;
    }

int F11er()
    {
     DrawMode=5; DispToolBar(); GridBlitter();
     return D_O_K;
    }

int IncPenDiameter()
    {
     PenDiameter = (PenDiameter<32) ? PenDiameter+4:PenDiameter; DispToolBar();
     return D_O_K;
    }

int DecPenDiameter()
    {
     PenDiameter = (PenDiameter>4) ? PenDiameter-4:PenDiameter; DispToolBar();
     if (PenDiameter==4) GridBlitter();
     return D_O_K;
    }

//===============================================UNDO/REDO=================================
void displayUndo()
{
 textprintf_ex(screen,font,TBPosX+TBSizeX-22, TBPosY+TBSizeY+1,0x004488,GUIbgColor,"%3.d",(UndoPointer-UndoBase)&0xFF);
}

void CopyBmpToUndo()
     {
      for (int i=0;i<FieldSizeX;i++)
      {
       for (int j=0;j<FieldSizeY;j++)
       {
        UndoStore[UndoPointer][i][j]= BmpData[i][j];
       }
      }
     }

void StoreUndo()
     {
      CopyBmpToUndo();
      (UndoPointer < 255) ? UndoPointer++: UndoPointer=0;
      RedoMax=UndoPointer;
      if (UndoPointer == UndoBase)
      {
       UndoBase++; UndoBase &= 0xFF;
       RedoMax=(UndoBase-1) & 0xFF;
      }
      displayUndo();
     }

int Zeer()
    {
     if (key_shifts & KB_CTRL_FLAG)
     {
      if (key_shifts & KB_SHIFT_FLAG)
      {
       remove_timer();
       Redoer();
       SetTimer();
      }
      else
      {
       remove_timer();
       Undoer();
       SetTimer();
      }
     }
     return D_O_K; //for keyboard-launcher
    }

int Yeer()
    {
     if (key_shifts & KB_CTRL_FLAG)
     {
      remove_timer();
      Redoer();
      SetTimer();
     }
     return D_O_K; //for keyboard-launcher
    }

void GetBmpFromUndo()
     {
      for (int i=0;i<FieldSizeX;i++)
      {
       for (int j=0;j<FieldSizeY;j++)
       {
        BmpData[i][j] = UndoStore[UndoPointer][i][j];
       }
      }
      GridDrawer(GridCol);PrevDrawer(); displayUndo();
     }

void Undoer()
     {
      CopyBmpToUndo();
      if(UndoPointer != UndoBase)
      {
       UndoPointer--; UndoPointer &= 0xFF;
       GetBmpFromUndo(); 
      }
     }

void Redoer()
     {
      if(UndoPointer != RedoMax)
      {
       UndoPointer++; UndoPointer &= 0xFF;
       GetBmpFromUndo();
      }
     }

//===========================================EOF=================================================================================
