/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.board;

import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.pia.PIA;
import org.javatari.atari.pia.RAM;
import org.javatari.atari.tia.TIA;
import org.javatari.general.board.BUS16Bits;
import org.javatari.general.board.ClockDriven;
import org.javatari.general.m6502.M6502;
import org.javatari.parameters.Parameters;
import org.javatari.utils.Randomizer;

public final class BUS
implements BUS16Bits,
ClockDriven {
    public Cartridge cartridge;
    public final M6502 cpu;
    public final RAM ram;
    public final TIA tia;
    public final PIA pia;
    private byte data = 0;
    private boolean cartridgeNeedsClock = false;
    private boolean cartridgeNeedsBusMonitoring = false;
    private static final boolean DATA_RETENTION = Parameters.BUS_DATA_RETENTION;

    public BUS(M6502 cpu, TIA tia, PIA pia, RAM ram) {
        this.cpu = cpu;
        this.ram = ram;
        this.tia = tia;
        this.pia = pia;
        cpu.connectBus(this);
        tia.connectBus(this);
        pia.connectBus(this);
    }

    public void powerOn() {
        this.data = 0;
        if (this.cartridge == null) {
            this.tia.videoOutput().showOSD("NO CARTRIDGE INSERTED!", true);
            this.data = (byte)Randomizer.instance.nextInt(256);
        }
        this.ram.powerOn();
        this.pia.powerOn();
        this.tia.powerOn();
        if (this.cartridge != null) {
            this.cartridge.powerOn();
        }
    }

    public void powerOff() {
        if (this.cartridge != null) {
            this.cartridge.powerOff();
        }
        this.tia.powerOff();
        this.pia.powerOff();
        this.ram.powerOff();
    }

    @Override
    public void clockPulse() {
        this.pia.clockPulse();
        this.cpu.clockPulse();
        if (this.cartridgeNeedsClock) {
            this.cartridge.clockPulse();
        }
    }

    @Override
    public byte readByte(int address) {
        if (this.cartridgeNeedsBusMonitoring) {
            this.cartridge.monitorBusBeforeRead(address, this.data);
        }
        if ((address & 0x1000) == 4096) {
            if (this.cartridge != null) {
                this.data = this.cartridge.readByte(address);
            }
        } else {
            this.data = (address & 0x1280) == 128 ? this.ram.readByte(address) : ((address & 0x1280) == 640 ? this.pia.readByte(address) : (DATA_RETENTION ? (byte)(this.data & 0x3F | this.tia.readByte(address)) : this.tia.readByte(address)));
        }
        return this.data;
    }

    @Override
    public void writeByte(int address, byte b) {
        if (this.cartridgeNeedsBusMonitoring) {
            this.cartridge.monitorBusBeforeWrite(address, b);
        }
        this.data = b;
        if ((address & 0x1080) == 0) {
            this.tia.writeByte(address, b);
        } else if ((address & 0x1280) == 128) {
            this.ram.writeByte(address, b);
        } else if ((address & 0x1280) == 640) {
            this.pia.writeByte(address, b);
        } else if (this.cartridge != null) {
            this.cartridge.writeByte(address, b);
        }
    }

    public void cartridge(Cartridge cartridge) {
        this.cartridge = cartridge;
        if (cartridge != null) {
            this.data = 0;
            cartridge.connectBus(this);
            this.cartridgeNeedsClock = cartridge.needsClock();
            this.cartridgeNeedsBusMonitoring = cartridge.needsBusMonitoring();
        } else {
            this.cartridgeNeedsClock = false;
            this.cartridgeNeedsBusMonitoring = false;
        }
    }
}

