/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import org.javatari.atari.cartridge.CartridgeInfo;
import org.javatari.atari.cartridge.ROM;
import org.javatari.atari.cartridge.formats.CartridgeSavestate;

public class CartridgeInfoLibrary {
    private static HashMap<String, CartridgeInfo> library;
    private static MessageDigest digest;

    static CartridgeInfo getInfo(ROM rom) {
        if (CartridgeSavestate.checkIdentifier(rom.content)) {
            return CartridgeInfoLibrary.getInfoForSavestate(rom.content);
        }
        return CartridgeInfoLibrary.getInfo(CartridgeInfoLibrary.computeHash(rom.content));
    }

    private static CartridgeInfo getInfo(String romHash) {
        CartridgeInfo info;
        if (library == null) {
            CartridgeInfoLibrary.initLibrary();
        }
        if ((info = library.get(romHash)) != null) {
            System.out.println("Cartridge: " + info.name);
            return info;
        }
        System.out.println("Cartridge unknown: " + romHash);
        info = new CartridgeInfo();
        info.hash = romHash;
        return info;
    }

    private static String computeHash(byte[] content) {
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                System.out.println("Could not create MD5 Digest");
                return "NO_HASH";
            }
        }
        digest.reset();
        digest.update(content);
        BigInteger d = new BigInteger(1, digest.digest());
        return String.format("%032x", d);
    }

    private static CartridgeInfo getInfoForSavestate(byte[] content) {
        CartridgeInfo info = new CartridgeInfo();
        info.name = "Savestate";
        System.out.println("Cartridge: " + info.name);
        return info;
    }

    private static void initLibrary() {
        library = new HashMap();
        try {
            InputStream fileStream = CartridgeInfoLibrary.class.getClassLoader().getResourceAsStream("org/javatari/atari/cartridge/CartridgeInfoLibrary.dat");
            ObjectInputStream objStream = new ObjectInputStream(fileStream);
            CartridgeInfo[] infos = (CartridgeInfo[])objStream.readObject();
            objStream.close();
            CartridgeInfo[] cartridgeInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                CartridgeInfo info = cartridgeInfoArray[n2];
                library.put(info.hash, info);
                ++n2;
            }
        }
        catch (Exception e) {
            System.out.println("Could not load Cartridge Info library");
        }
    }
}

