/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import java.util.Arrays;
import org.javatari.atari.board.BUS;
import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.ROM;
import org.javatari.atari.cartridge.formats.CartridgeBankedByMaskedRange;
import org.javatari.atari.console.savestate.SaveStateSocket;

public class Cartridge24K_28K_32K_FA2
extends CartridgeBankedByMaskedRange {
    private transient BUS bus;
    private transient SaveStateSocket saveStateSocket;
    private long harmonyFlashOpStartTime = Long.MIN_VALUE;
    private int harmonyFlashOpInProgress = 0;
    private byte[] harmonyFlashMemory = new byte[256];
    private static final int SIZE24K = 24576;
    private static final int SIZE28K = 28672;
    private static final int SIZE32K = 32768;
    private static final int BASE_BANKSW_ADDRESS = 4085;
    private static final int FLASH_OP_HOTSPOT = 4084;
    private static final int FLASH_OP_CONTROL = 255;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("FA2", "24K/28K/32K CBS RAM Plus"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge createCartridge(ROM rom) {
            return new Cartridge24K_28K_32K_FA2(rom, this);
        }

        @Override
        public CartridgeFormatOption getOption(ROM rom) {
            if (rom.content.length != 24576 && rom.content.length != 28672 && rom.content.length != 32768) {
                return null;
            }
            return new CartridgeFormatOption(102, this, rom);
        }
    };
    public static final long serialVersionUID = 1L;

    protected Cartridge24K_28K_32K_FA2(ROM rom, CartridgeFormat format) {
        super(rom, format, 4085, true, 256);
    }

    @Override
    public void connectBus(BUS bus) {
        this.bus = bus;
    }

    @Override
    public void connectSaveStateSocket(SaveStateSocket socket) {
        this.saveStateSocket = socket;
    }

    @Override
    public byte readByte(int address) {
        byte op;
        byte b = super.readByte(address);
        if (this.maskedAddress != 4084) {
            return b;
        }
        if (this.harmonyFlashOpInProgress == 0 && ((op = this.extraRAM[255]) == 1 || op == 2)) {
            this.performFlashOperation(op);
            return (byte)(b | 0x40);
        }
        if (this.harmonyFlashOpInProgress == 0) {
            return (byte)(b & 0xBF);
        }
        this.detectFlashOperationCompletion();
        if (this.harmonyFlashOpInProgress != 0) {
            return (byte)(b | 0x40);
        }
        return (byte)(b & 0xBF);
    }

    private void performFlashOperation(int op) {
        this.harmonyFlashOpInProgress = op;
        this.harmonyFlashOpStartTime = System.currentTimeMillis();
        if (op == 1) {
            this.readMemoryFromFlash();
        } else if (op == 2) {
            this.saveMemoryToFlash();
        }
    }

    private void readMemoryFromFlash() {
        this.bus.tia.videoOutput().showOSD("Reading from Cartridge Flash Memory...", true);
        if (this.saveStateSocket != null) {
            try {
                byte[] data = (byte[])this.saveStateSocket.media().loadResourceFromFile(this.flashMemoryResourceName());
                if (data.length == 256) {
                    this.harmonyFlashMemory = data;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.extraRAM = Arrays.copyOf(this.harmonyFlashMemory, this.extraRAM.length);
    }

    private void saveMemoryToFlash() {
        this.bus.tia.videoOutput().showOSD("Writing to Cartridge Flash Memory...", true);
        this.harmonyFlashMemory = Arrays.copyOf(this.extraRAM, this.extraRAM.length);
        if (this.saveStateSocket != null) {
            this.saveStateSocket.media().saveResourceToFile(this.flashMemoryResourceName(), this.harmonyFlashMemory);
        }
    }

    private void detectFlashOperationCompletion() {
        if (System.currentTimeMillis() - this.harmonyFlashOpStartTime > 1100L) {
            this.harmonyFlashOpStartTime = Long.MIN_VALUE;
            this.harmonyFlashOpInProgress = 0;
            this.extraRAM[255] = 0;
            this.bus.tia.videoOutput().showOSD("Done.", true);
            if (this.saveStateSocket != null) {
                this.saveStateSocket.externalStateChange();
            }
        }
    }

    private String flashMemoryResourceName() {
        return String.valueOf(this.rom.info.hash) + ".hfm";
    }

    @Override
    public Cartridge24K_28K_32K_FA2 clone() {
        Cartridge24K_28K_32K_FA2 clone = (Cartridge24K_28K_32K_FA2)super.clone();
        clone.harmonyFlashMemory = (byte[])this.harmonyFlashMemory.clone();
        return clone;
    }
}

