/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.ROM;
import org.javatari.atari.cartridge.formats.CartridgeBankedByBusMonitoring;

public class Cartridge8K_512K_3F
extends CartridgeBankedByBusMonitoring {
    protected final int selectableSliceMaxBank;
    protected final int fixedSliceAddressOffset;
    protected static final int BANK_SIZE = 2048;
    protected static final int MIN_SIZE = 8192;
    protected static final int MAX_SIZE = 524288;
    protected static final int FIXED_SLICE_START_ADDRESS = 2048;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("3F", "8K-512K Tigervision"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge createCartridge(ROM rom) {
            return new Cartridge8K_512K_3F(rom, this);
        }

        @Override
        public CartridgeFormatOption getOption(ROM rom) {
            if (rom.content.length % 2048 != 0 || rom.content.length < 8192 || rom.content.length > 524288) {
                return null;
            }
            return new CartridgeFormatOption(112, this, rom);
        }
    };
    public static final long serialVersionUID = 1L;

    protected Cartridge8K_512K_3F(ROM rom, CartridgeFormat format) {
        super(rom, format);
        this.selectableSliceMaxBank = (this.bytes.length - 2048) / 2048 - 1;
        this.fixedSliceAddressOffset = this.bytes.length - 4096;
    }

    @Override
    public byte readByte(int address) {
        this.maskAddress(address);
        if (this.maskedAddress >= 2048) {
            return this.bytes[this.fixedSliceAddressOffset + this.maskedAddress];
        }
        return this.bytes[this.bankAddressOffset + this.maskedAddress];
    }

    @Override
    public void monitorBusBeforeRead(int address, byte data) {
    }

    @Override
    public void monitorBusBeforeWrite(int address, byte data) {
        int bank;
        if (address <= 63 && (bank = data & 0xFF) <= this.selectableSliceMaxBank) {
            this.bankAddressOffset = bank * 2048;
        }
    }

    @Override
    protected void performBankSwitchOnMonitoredAccess(int address) {
    }
}

