/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.ROM;
import org.javatari.atari.console.savestate.ConsoleState;

public final class CartridgeSavestate
extends Cartridge {
    public static final CartridgeFormat FORMAT = new CartridgeFormat("JAT", "Javatari Savestate"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge createCartridge(ROM rom) {
            return new CartridgeSavestate(rom, null);
        }

        @Override
        public CartridgeFormatOption getOption(ROM rom) {
            if (!CartridgeSavestate.checkIdentifier(rom.content)) {
                return null;
            }
            return new CartridgeFormatOption(90, this, rom);
        }
    };
    public static final long serialVersionUID = 1L;
    public static final byte[] contentIdentifier = new byte[]{74, 97, 118, 97, 116, 97, 114, 105, 83, 97, 118, 101, 115, 116, 97, 116, 101, 86, 48, 48, 48};

    private CartridgeSavestate(ROM rom) {
        super(rom, FORMAT);
    }

    public ConsoleState getConsoleState() {
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(this.rom.content);
            byteStream.skip(contentIdentifier.length);
            ObjectInputStream objStream = new ObjectInputStream(byteStream);
            return (ConsoleState)objStream.readObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static CartridgeSavestate createFromConsoleState(ConsoleState state) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            byteStream.write(contentIdentifier);
            byteStream.flush();
            ObjectOutputStream objStream = new ObjectOutputStream(byteStream);
            objStream.writeObject(state);
            objStream.flush();
            byte[] content = byteStream.toByteArray();
            ROM rom = new ROM("CreatedSavestate", content);
            return new CartridgeSavestate(rom);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean checkIdentifier(byte[] content) {
        if (content.length < contentIdentifier.length) {
            return false;
        }
        int i = 0;
        while (i < contentIdentifier.length) {
            if (content[i] != contentIdentifier[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /* synthetic */ CartridgeSavestate(ROM rOM, CartridgeSavestate cartridgeSavestate) {
        this(rOM);
    }
}

