/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.tia.audio;

import org.javatari.atari.tia.audio.ChannelStream;
import org.javatari.general.av.audio.AudioMonitor;
import org.javatari.general.av.audio.AudioSignal;
import org.javatari.general.board.ClockDriven;
import org.javatari.parameters.Parameters;

public abstract class AudioGenerator
implements AudioSignal,
ClockDriven {
    protected final ChannelStream channel0 = new ChannelStream();
    protected final ChannelStream channel1 = new ChannelStream();
    protected final byte[] samples = new byte[4096];
    protected int generatedSamples = 0;
    protected int frameSamples = 0;
    private int samplesPerFrame = 0;
    private AudioMonitor monitor;
    private static final int SAMPLE_RATE = Parameters.TIA_AUDIO_SAMPLE_RATE;
    private static final int SEND_CHUNK = Parameters.TIA_AUDIO_SEND_CHUNK;
    private static final int MIN_MONITOR_BUFFER_CHUNKS = Parameters.TIA_AUDIO_MIN_MONITOR_BUFFER_CHUNKS;
    private static final int MONITOR_BUFFER_CHUNKS_ADD_FACTOR = Parameters.TIA_AUDIO_MONITOR_BUFFER_CHUNKS_ADD_FACTOR;
    private static final int MAX_SAMPLES = 4096;
    private static final boolean SYNC_WITH_AUDIO_MONITOR = Parameters.TIA_SYNC_WITH_AUDIO_MONITOR;

    @Override
    public void connectMonitor(AudioMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void clockPulse() {
        if (this.frameSamples < this.samplesPerFrame) {
            this.generateNextSamples(1);
        }
        if (this.generatedSamples >= SEND_CHUNK) {
            this.sendGeneratedSamples();
        }
    }

    public AudioMonitor monitor() {
        return this.monitor;
    }

    public ChannelStream channel0() {
        return this.channel0;
    }

    public ChannelStream channel1() {
        return this.channel1;
    }

    public void fps(double fps) {
        this.samplesPerFrame = (int)Math.round((double)SAMPLE_RATE / fps);
        if (this.samplesPerFrame > 4096) {
            this.samplesPerFrame = 4096;
        }
    }

    public void signalOff() {
        this.generatedSamples = 0;
        this.frameSamples = 0;
        if (this.monitor != null) {
            this.monitor.nextSamples(null, 0);
        }
    }

    public void finishFrame() {
        int available;
        int missingSamples = this.samplesPerFrame - this.frameSamples;
        if (missingSamples > 0) {
            this.generateNextSamples(missingSamples);
        }
        if ((available = this.sendGeneratedSamples()) >= 0 && available < MIN_MONITOR_BUFFER_CHUNKS * SEND_CHUNK) {
            int add = MIN_MONITOR_BUFFER_CHUNKS * SEND_CHUNK - available + SEND_CHUNK / MONITOR_BUFFER_CHUNKS_ADD_FACTOR;
            if (add > 4096) {
                add = 4096;
            }
            this.generateNextSamples(add);
            this.sendGeneratedSamples();
        }
        this.frameSamples = 0;
        if (SYNC_WITH_AUDIO_MONITOR && this.monitor != null) {
            this.monitor.synchOutput();
        }
    }

    private int sendGeneratedSamples() {
        int available = -1;
        if (this.monitor != null) {
            available = this.monitor.nextSamples(this.samples, this.generatedSamples);
        }
        this.generatedSamples = 0;
        return available;
    }

    protected abstract void generateNextSamples(int var1);
}

