/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.general.m6502;

import java.io.Serializable;
import org.javatari.general.board.BUS16Bits;
import org.javatari.general.board.Clock;
import org.javatari.general.board.ClockDriven;
import org.javatari.general.m6502.Instruction;
import org.javatari.general.m6502.instructions.ADC;
import org.javatari.general.m6502.instructions.AND;
import org.javatari.general.m6502.instructions.ASL;
import org.javatari.general.m6502.instructions.BIT;
import org.javatari.general.m6502.instructions.BRK;
import org.javatari.general.m6502.instructions.Bxx;
import org.javatari.general.m6502.instructions.CLx;
import org.javatari.general.m6502.instructions.CPx;
import org.javatari.general.m6502.instructions.DEC;
import org.javatari.general.m6502.instructions.DEx;
import org.javatari.general.m6502.instructions.EOR;
import org.javatari.general.m6502.instructions.INC;
import org.javatari.general.m6502.instructions.INx;
import org.javatari.general.m6502.instructions.JMP;
import org.javatari.general.m6502.instructions.JSR;
import org.javatari.general.m6502.instructions.LDx;
import org.javatari.general.m6502.instructions.LSR;
import org.javatari.general.m6502.instructions.NOP;
import org.javatari.general.m6502.instructions.ORA;
import org.javatari.general.m6502.instructions.PHA;
import org.javatari.general.m6502.instructions.PHP;
import org.javatari.general.m6502.instructions.PLA;
import org.javatari.general.m6502.instructions.PLP;
import org.javatari.general.m6502.instructions.ROL;
import org.javatari.general.m6502.instructions.ROR;
import org.javatari.general.m6502.instructions.RTI;
import org.javatari.general.m6502.instructions.RTS;
import org.javatari.general.m6502.instructions.SBC;
import org.javatari.general.m6502.instructions.SEx;
import org.javatari.general.m6502.instructions.STx;
import org.javatari.general.m6502.instructions.Txx;
import org.javatari.general.m6502.instructions.uANC;
import org.javatari.general.m6502.instructions.uANE;
import org.javatari.general.m6502.instructions.uARR;
import org.javatari.general.m6502.instructions.uASR;
import org.javatari.general.m6502.instructions.uDCP;
import org.javatari.general.m6502.instructions.uISB;
import org.javatari.general.m6502.instructions.uKIL;
import org.javatari.general.m6502.instructions.uLAS;
import org.javatari.general.m6502.instructions.uLAX;
import org.javatari.general.m6502.instructions.uLXA;
import org.javatari.general.m6502.instructions.uNOP;
import org.javatari.general.m6502.instructions.uRLA;
import org.javatari.general.m6502.instructions.uRRA;
import org.javatari.general.m6502.instructions.uSAX;
import org.javatari.general.m6502.instructions.uSBX;
import org.javatari.general.m6502.instructions.uSHA;
import org.javatari.general.m6502.instructions.uSHS;
import org.javatari.general.m6502.instructions.uSHX;
import org.javatari.general.m6502.instructions.uSHY;
import org.javatari.general.m6502.instructions.uSLO;
import org.javatari.general.m6502.instructions.uSRE;
import org.javatari.utils.Debugger;

public final class M6502
implements ClockDriven {
    public byte A;
    public byte X;
    public byte Y;
    public byte SP;
    public int PC;
    public boolean CARRY;
    public boolean ZERO;
    public boolean OVERFLOW;
    public boolean NEGATIVE;
    public boolean DECIMAL_MODE;
    public boolean INTERRUPT_DISABLE;
    public boolean RDY;
    public BUS16Bits bus;
    public boolean trace = false;
    public boolean debug = false;
    public boolean pageCrossed = false;
    private int remainingCycles = -1;
    private Instruction currentInstruction;
    public final Instruction[] instructions = new Instruction[]{new BRK(this), new ORA(this, 31), new uKIL(this), new uSLO(this, 31), new uNOP(this, 20), new ORA(this, 20), new ASL(this, 20), new uSLO(this, 20), new PHP(this), new ORA(this, 1), new ASL(this, 0), new uANC(this), new uNOP(this, 10), new ORA(this, 10), new ASL(this, 10), new uSLO(this, 10), new Bxx(this, 7, false), new ORA(this, 32), new uKIL(this), new uSLO(this, 32), new uNOP(this, 21), new ORA(this, 21), new ASL(this, 21), new uSLO(this, 21), new CLx(this, 0), new ORA(this, 12), new NOP(this), new uSLO(this, 12), new uNOP(this, 11), new ORA(this, 11), new ASL(this, 11), new uSLO(this, 11), new JSR(this), new AND(this, 31), new uKIL(this), new uRLA(this, 31), new BIT(this, 20), new AND(this, 20), new ROL(this, 20), new uRLA(this, 20), new PLP(this), new AND(this, 1), new ROL(this, 0), new uANC(this), new BIT(this, 10), new AND(this, 10), new ROL(this, 10), new uRLA(this, 10), new Bxx(this, 7, true), new AND(this, 32), new uKIL(this), new uRLA(this, 32), new uNOP(this, 21), new AND(this, 21), new ROL(this, 21), new uRLA(this, 21), new SEx(this, 0), new AND(this, 12), new NOP(this), new uRLA(this, 12), new uNOP(this, 11), new AND(this, 11), new ROL(this, 11), new uRLA(this, 11), new RTI(this), new EOR(this, 31), new uKIL(this), new uSRE(this, 31), new uNOP(this, 20), new EOR(this, 20), new LSR(this, 20), new uSRE(this, 20), new PHA(this), new EOR(this, 1), new LSR(this, 0), new uASR(this), new JMP(this, 10), new EOR(this, 10), new LSR(this, 10), new uSRE(this, 10), new Bxx(this, 6, false), new EOR(this, 32), new uKIL(this), new uSRE(this, 32), new uNOP(this, 21), new EOR(this, 21), new LSR(this, 21), new uSRE(this, 21), new CLx(this, 2), new EOR(this, 12), new NOP(this), new uSRE(this, 12), new uNOP(this, 11), new EOR(this, 11), new LSR(this, 11), new uSRE(this, 11), new RTS(this), new ADC(this, 31), new uKIL(this), new uRRA(this, 31), new uNOP(this, 20), new ADC(this, 20), new ROR(this, 20), new uRRA(this, 20), new PLA(this), new ADC(this, 1), new ROR(this, 0), new uARR(this), new JMP(this, 30), new ADC(this, 10), new ROR(this, 10), new uRRA(this, 10), new Bxx(this, 6, true), new ADC(this, 32), new uKIL(this), new uRRA(this, 32), new uNOP(this, 21), new ADC(this, 21), new ROR(this, 21), new uRRA(this, 21), new SEx(this, 2), new ADC(this, 12), new NOP(this), new uRRA(this, 12), new uNOP(this, 11), new ADC(this, 11), new ROR(this, 11), new uRRA(this, 11), new uNOP(this, 1), new STx(this, 0, 31), new uNOP(this, 1), new uSAX(this, 31), new STx(this, 6, 20), new STx(this, 0, 20), new STx(this, 5, 20), new uSAX(this, 20), new DEx(this, 6), new uNOP(this, 1), new Txx(this, 5, 0), new uANE(this), new STx(this, 6, 10), new STx(this, 0, 10), new STx(this, 5, 10), new uSAX(this, 10), new Bxx(this, 0, false), new STx(this, 0, 32), new uKIL(this), new uSHA(this, 32), new STx(this, 6, 21), new STx(this, 0, 21), new STx(this, 5, 22), new uSAX(this, 22), new Txx(this, 6, 0), new STx(this, 0, 12), new Txx(this, 5, 20), new uSHS(this), new uSHY(this), new STx(this, 0, 11), new uSHX(this), new uSHA(this, 12), new LDx(this, 6, 1), new LDx(this, 0, 31), new LDx(this, 5, 1), new uLAX(this, 31), new LDx(this, 6, 20), new LDx(this, 0, 20), new LDx(this, 5, 20), new uLAX(this, 20), new Txx(this, 0, 6), new LDx(this, 0, 1), new Txx(this, 0, 5), new uLXA(this), new LDx(this, 6, 10), new LDx(this, 0, 10), new LDx(this, 5, 10), new uLAX(this, 10), new Bxx(this, 0, true), new LDx(this, 0, 32), new uKIL(this), new uLAX(this, 32), new LDx(this, 6, 21), new LDx(this, 0, 21), new LDx(this, 5, 22), new uLAX(this, 22), new CLx(this, 6), new LDx(this, 0, 12), new Txx(this, 20, 5), new uLAS(this), new LDx(this, 6, 11), new LDx(this, 0, 11), new LDx(this, 5, 12), new uLAX(this, 12), new CPx(this, 6, 1), new CPx(this, 0, 31), new uNOP(this, 1), new uDCP(this, 31), new CPx(this, 6, 20), new CPx(this, 0, 20), new DEC(this, 20), new uDCP(this, 20), new INx(this, 6), new CPx(this, 0, 1), new DEx(this, 5), new uSBX(this), new CPx(this, 6, 10), new CPx(this, 0, 10), new DEC(this, 10), new uDCP(this, 10), new Bxx(this, 1, false), new CPx(this, 0, 32), new uKIL(this), new uDCP(this, 32), new uNOP(this, 21), new CPx(this, 0, 21), new DEC(this, 21), new uDCP(this, 21), new CLx(this, 3), new CPx(this, 0, 12), new NOP(this), new uDCP(this, 12), new uNOP(this, 11), new CPx(this, 0, 11), new DEC(this, 11), new uDCP(this, 11), new CPx(this, 5, 1), new SBC(this, 31), new uNOP(this, 1), new uISB(this, 31), new CPx(this, 5, 20), new SBC(this, 20), new INC(this, 20), new uISB(this, 20), new INx(this, 5), new SBC(this, 1), new NOP(this), new SBC(this, 1), new CPx(this, 5, 10), new SBC(this, 10), new INC(this, 10), new uISB(this, 10), new Bxx(this, 1, true), new SBC(this, 32), new uKIL(this), new uISB(this, 32), new uNOP(this, 21), new SBC(this, 21), new INC(this, 21), new uISB(this, 21), new SEx(this, 3), new SBC(this, 12), new NOP(this), new uISB(this, 12), new uNOP(this, 11), new SBC(this, 11), new INC(this, 11), new uISB(this, 11)};
    public static final byte STACK_INITIAL_SP = -1;
    public static final int STACK_PAGE = 256;
    public static final byte BREAK_COMMAND_FLAG = 16;
    public static final int NMI_HANDLER_ADDRESS = 65530;
    public static final int POWER_ON_RESET_ADDRESS = 65532;
    public static final int IRQ_HANDLER_ADDRESS = 65534;

    public void connectBus(BUS16Bits bus) {
        this.bus = bus;
    }

    public void reset() {
        this.PC = this.memoryReadWord(65532);
        this.INTERRUPT_DISABLE = true;
        this.currentInstruction = null;
        this.remainingCycles = -1;
    }

    @Override
    public void clockPulse() {
        if (this.remainingCycles == 1) {
            this.currentInstruction.execute();
            this.remainingCycles = 0;
            return;
        }
        if (!this.RDY) {
            return;
        }
        if (this.remainingCycles-- > 0) {
            return;
        }
        this.currentInstruction = this.instructions[M6502.toUnsignedByte(this.bus.readByte(this.PC++))];
        this.remainingCycles = this.currentInstruction.fetch() - 1;
    }

    public void powerOn() {
        this.PC = 0;
        this.SP = (byte)-1;
        this.Y = 0;
        this.X = 0;
        this.A = 0;
        this.PS((byte)0);
        this.INTERRUPT_DISABLE = true;
        this.RDY = true;
        this.reset();
    }

    public void powerOff() {
    }

    public void fetchImpliedAddress() {
        this.bus.readByte(this.PC);
    }

    public int fetchImmediateAddress() {
        return this.PC++;
    }

    public int fetchRelativeAddress() {
        int res;
        this.pageCrossed = ((res = this.bus.readByte(this.PC++) + this.PC) & 0xFF00) != (this.PC & 0xFF00);
        return res;
    }

    public int fetchZeroPageAddress() {
        return M6502.toUnsignedByte(this.bus.readByte(this.PC++));
    }

    public int fetchZeroPageXAddress() {
        byte base = this.bus.readByte(this.PC++);
        this.bus.readByte(M6502.toUnsignedByte(base));
        return M6502.toUnsignedByte(base + this.X);
    }

    public int fetchZeroPageYAddress() {
        byte base = this.bus.readByte(this.PC++);
        this.bus.readByte(M6502.toUnsignedByte(base));
        return M6502.toUnsignedByte(base + this.Y);
    }

    public int fetchAbsoluteAddress() {
        return this.memoryReadWord((this.PC += 2) - 2);
    }

    public int fetchAbsoluteXAddress() {
        int addr = this.fetchAbsoluteAddress();
        int res = addr + M6502.toUnsignedByte(this.X);
        boolean bl = this.pageCrossed = (res & 0xFF00) != (addr & 0xFF00);
        if (this.pageCrossed) {
            this.bus.readByte(addr & 0xFF00 | res & 0xFF);
        }
        return res;
    }

    public int fetchAbsoluteYAddress() {
        int addr = this.fetchAbsoluteAddress();
        int res = addr + M6502.toUnsignedByte(this.Y);
        boolean bl = this.pageCrossed = (res & 0xFF00) != (addr & 0xFF00);
        if (this.pageCrossed) {
            this.bus.readByte(addr & 0xFF00 | res & 0xFF);
        }
        return res;
    }

    public int fetchIndirectAddress() {
        return this.memoryReadWordWrappingPage(this.fetchAbsoluteAddress());
    }

    public int fetchIndirectXAddress() {
        return this.memoryReadWordWrappingPage(this.fetchZeroPageXAddress());
    }

    public int fetchIndirectYAddress() {
        int addr = this.memoryReadWordWrappingPage(this.fetchZeroPageAddress());
        int res = addr + M6502.toUnsignedByte(this.Y);
        boolean bl = this.pageCrossed = (res & 0xFF00) != (addr & 0xFF00);
        if (this.pageCrossed) {
            this.bus.readByte(addr & 0xFF00 | res & 0xFF);
        }
        return res;
    }

    public int memoryReadWord(int address) {
        return M6502.toUnsignedByte(this.bus.readByte(address)) | M6502.toUnsignedByte(this.bus.readByte(address + 1)) << 8;
    }

    public int memoryReadWordWrappingPage(int address) {
        if ((address & 0xFF) == 255) {
            return M6502.toUnsignedByte(this.bus.readByte(address)) | M6502.toUnsignedByte(this.bus.readByte(address & 0xFF00)) << 8;
        }
        return this.memoryReadWord(address);
    }

    public void pushByte(byte b) {
        byte by = this.SP;
        this.SP = (byte)(by - 1);
        this.bus.writeByte(256 + M6502.toUnsignedByte(by), b);
    }

    public void dummyStackRead() {
        this.bus.readByte(256 + M6502.toUnsignedByte(this.SP));
    }

    public byte pullByte() {
        this.SP = (byte)(this.SP + 1);
        return this.bus.readByte(256 + M6502.toUnsignedByte(this.SP));
    }

    public void pushWord(int w) {
        this.pushByte((byte)(w >>> 8));
        this.pushByte((byte)w);
    }

    public int pullWord() {
        return this.pullByte() & 0xFF | (this.pullByte() & 0xFF) << 8;
    }

    public byte PS() {
        byte b = (byte)((this.NEGATIVE ? 128 : 0) | (this.OVERFLOW ? 64 : 0) | (this.DECIMAL_MODE ? 8 : 0) | (this.INTERRUPT_DISABLE ? 4 : 0) | (this.ZERO ? 2 : 0) | (this.CARRY ? 1 : 0) | 0x10);
        return b;
    }

    public void PS(byte b) {
        this.NEGATIVE = (b & 0x80) != 0;
        this.OVERFLOW = (b & 0x40) != 0;
        this.DECIMAL_MODE = (b & 8) != 0;
        this.INTERRUPT_DISABLE = (b & 4) != 0;
        this.ZERO = (b & 2) != 0;
        this.CARRY = (b & 1) != 0;
    }

    public String printState() {
        String str = "";
        str = String.valueOf(str) + "A: " + String.format("%02x", this.A) + ", X: " + String.format("%02x", this.X) + ", Y: " + String.format("%02x", this.Y) + ", SP: " + String.format("%02x", this.SP) + ", PC: " + String.format("%04x", this.PC) + ", Flags: " + String.format("%08d", Integer.parseInt(Integer.toBinaryString(this.PS() & 0xFF))) + ", Instr: " + (this.currentInstruction != null ? this.currentInstruction.getClass().getSimpleName() : "none") + ", RemCycles: " + this.remainingCycles;
        return str;
    }

    public String printMemory(int fromAddress, int count) {
        String str = "";
        int i = 0;
        while (i < count) {
            str = String.valueOf(str) + String.format("%02x ", this.bus.readByte(fromAddress + i));
            ++i;
        }
        return str;
    }

    public void debug(String title) {
        if (this.trace) {
            this.showDebug(title);
        } else if (this.debug) {
            System.out.println(title);
        }
    }

    public void showDebug(String title) {
        int res;
        System.out.println("PROCESSOR PAUSED\n" + this.printState());
        do {
            if ((res = Debugger.show(title, "PROCESSOR STATUS:\n\n" + this.printState() + "\n\n", new String[]{"Continue", this.trace ? "Stop Trace" : "Start Trace", "Abort"})) != 1) continue;
            boolean bl = this.trace = !this.trace;
        } while (res != 0 && res != 2);
        if (res == 2) {
            ((Clock)Thread.currentThread()).terminate();
        }
    }

    public M6502State saveState() {
        M6502State state = new M6502State();
        state.PC = this.PC;
        state.A = this.A;
        state.X = this.X;
        state.Y = this.Y;
        state.SP = this.SP;
        state.CARRY = this.CARRY;
        state.ZERO = this.ZERO;
        state.OVERFLOW = this.OVERFLOW;
        state.NEGATIVE = this.NEGATIVE;
        state.DECIMAL_MODE = this.DECIMAL_MODE;
        state.INTERRUPT_DISABLE = this.INTERRUPT_DISABLE;
        state.RDY = this.RDY;
        state.trace = this.trace;
        state.debug = this.debug;
        state.pageCrossed = this.pageCrossed;
        if (this.currentInstruction != null) {
            state.currentInstruction = this.currentInstruction.clone();
        }
        state.remainingCycles = this.remainingCycles;
        return state;
    }

    public void loadState(M6502State state) {
        this.PC = state.PC;
        this.A = state.A;
        this.X = state.X;
        this.Y = state.Y;
        this.SP = state.SP;
        this.CARRY = state.CARRY;
        this.ZERO = state.ZERO;
        this.OVERFLOW = state.OVERFLOW;
        this.NEGATIVE = state.NEGATIVE;
        this.DECIMAL_MODE = state.DECIMAL_MODE;
        this.INTERRUPT_DISABLE = state.INTERRUPT_DISABLE;
        this.RDY = state.RDY;
        this.trace = state.trace;
        this.debug = state.debug;
        this.pageCrossed = state.pageCrossed;
        this.currentInstruction = state.currentInstruction;
        if (this.currentInstruction != null) {
            this.currentInstruction.cpu = this;
        }
        this.remainingCycles = state.remainingCycles;
    }

    public static int toUnsignedByte(byte b) {
        return b & 0xFF;
    }

    public static int toUnsignedByte(int i) {
        return i & 0xFF;
    }

    public static class M6502State
    implements Serializable {
        byte A;
        byte X;
        byte Y;
        byte SP;
        int PC;
        boolean CARRY;
        boolean ZERO;
        boolean OVERFLOW;
        boolean NEGATIVE;
        boolean DECIMAL_MODE;
        boolean INTERRUPT_DISABLE;
        boolean BREAK_COMMAND;
        boolean RDY;
        boolean trace;
        boolean debug;
        boolean pageCrossed;
        Instruction currentInstruction;
        int remainingCycles;
        public static final long serialVersionUID = 2L;
    }
}

