/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.pc.cartridge;

import java.awt.Dimension;
import java.io.File;
import java.security.AccessControlException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.javatari.parameters.Parameters;
import org.javatari.pc.cartridge.ROMLoader;

public final class FileROMChooser {
    private static JFileChooser chooser;
    private static File lastLoadFileChosen;
    private static File lastSaveFileChosen;

    public static File chooseFileToLoad() throws AccessControlException {
        if (chooser != null && chooser.isShowing()) {
            return null;
        }
        if (lastLoadFileChosen == null) {
            lastLoadFileChosen = new File(Parameters.LAST_ROM_LOAD_FILE_CHOSEN);
        }
        if (chooser == null) {
            FileROMChooser.createChooser();
        }
        chooser.setFileFilter(new FileNameExtensionFilter("ROM and Savestate files (.bin .rom .a26 .zip .jat)", ROMLoader.VALID_LOAD_FILE_EXTENSIONS));
        chooser.setSelectedFile(lastLoadFileChosen);
        int res = chooser.showOpenDialog(null);
        if (res != 0) {
            return null;
        }
        lastLoadFileChosen = chooser.getSelectedFile();
        Parameters.LAST_ROM_LOAD_FILE_CHOSEN = lastLoadFileChosen.toString();
        Parameters.savePreferences();
        return lastLoadFileChosen;
    }

    public static File chooseFileToSavestate() throws AccessControlException {
        if (chooser != null && chooser.isShowing()) {
            return null;
        }
        if (lastSaveFileChosen == null) {
            lastSaveFileChosen = new File(Parameters.LAST_ROM_SAVE_FILE_CHOSEN);
        }
        if (chooser == null) {
            FileROMChooser.createChooser();
        }
        chooser.setFileFilter(new FileNameExtensionFilter("Javatari Savestate files (.jat)", "jat"));
        chooser.setSelectedFile(lastSaveFileChosen);
        int res = chooser.showSaveDialog(null);
        if (res != 0) {
            return null;
        }
        lastSaveFileChosen = chooser.getSelectedFile();
        if (!lastSaveFileChosen.toString().toUpperCase().endsWith("jat".toUpperCase())) {
            lastSaveFileChosen = new File(lastSaveFileChosen + "." + "jat");
        }
        Parameters.LAST_ROM_SAVE_FILE_CHOSEN = lastSaveFileChosen.toString();
        Parameters.savePreferences();
        return lastSaveFileChosen;
    }

    private static synchronized void createChooser() throws AccessControlException {
        if (chooser != null) {
            return;
        }
        chooser = new JFileChooser();
        chooser.setPreferredSize(new Dimension(580, 400));
    }
}

