/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.pc.savestate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessControlException;
import org.javatari.atari.cartridge.formats.CartridgeSavestate;
import org.javatari.atari.console.savestate.ConsoleState;
import org.javatari.atari.console.savestate.SaveStateMedia;
import org.javatari.atari.console.savestate.SaveStateSocket;
import org.javatari.pc.cartridge.FileROMChooser;

public final class FileSaveStateMedia
implements SaveStateMedia {
    private String savesDirectory;
    private static final String BASE_DIR = "javatarisaves";

    public void connect(SaveStateSocket socket) {
        socket.connectMedia(this);
    }

    @Override
    public boolean saveStateFile(ConsoleState state) {
        File file;
        block3: {
            try {
                file = FileROMChooser.chooseFileToSavestate();
                if (file != null) break block3;
                return false;
            }
            catch (AccessControlException e) {
                return false;
            }
        }
        return this.internalSaveToFile(file.toString(), state, true, false);
    }

    @Override
    public boolean saveState(int slot, ConsoleState state) {
        return this.internalSaveToFile("javatarisave" + slot + "." + "jat", state, true, true);
    }

    @Override
    public ConsoleState loadState(int slot) {
        try {
            return (ConsoleState)this.internalLoadFromFile("javatarisave" + slot + "." + "jat", true, true);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public boolean saveResourceToFile(String fileName, Object data) {
        return this.internalSaveToFile(fileName, data, false, true);
    }

    @Override
    public Object loadResourceFromFile(String fileName) {
        return this.internalLoadFromFile(fileName, false, true);
    }

    private boolean internalSaveToFile(String fileName, Object data, boolean isSavestate, boolean insideSavesDirectory) {
        try {
            block7: {
                File dir = new File(this.savesDirectory());
                if (!dir.isDirectory()) {
                    dir.mkdir();
                }
                FileOutputStream file = null;
                try {
                    ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                    if (isSavestate) {
                        byteStream.write(CartridgeSavestate.contentIdentifier);
                        byteStream.flush();
                    }
                    ObjectOutputStream stream = new ObjectOutputStream(byteStream);
                    stream.writeObject(data);
                    file = new FileOutputStream(insideSavesDirectory ? this.insideSavesDirectory(fileName) : fileName);
                    file.write(byteStream.toByteArray());
                }
                finally {
                    if (file == null) break block7;
                    file.close();
                }
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private Object internalLoadFromFile(String fileName, boolean isSavestate, boolean insideSavesDirectory) {
        Object object;
        block8: {
            FileInputStream file = null;
            try {
                file = new FileInputStream(insideSavesDirectory ? this.insideSavesDirectory(fileName) : fileName);
                byte[] data = new byte[file.available()];
                file.read(data);
                ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
                if (isSavestate) {
                    if (!CartridgeSavestate.checkIdentifier(data)) {
                        throw new IllegalStateException("Invalid Javatari Savestate file");
                    }
                    byteStream.skip(CartridgeSavestate.contentIdentifier.length);
                }
                ObjectInputStream objStream = new ObjectInputStream(byteStream);
                object = objStream.readObject();
                if (file == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        file.close();
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            file.close();
        }
        return object;
    }

    private String insideSavesDirectory(String fileName) {
        return String.valueOf(this.savesDirectory()) + File.separator + fileName;
    }

    private String savesDirectory() {
        if (this.savesDirectory != null) {
            return this.savesDirectory;
        }
        try {
            String userHome = System.getProperty("user.home");
            if (userHome != null && !userHome.isEmpty()) {
                this.savesDirectory = String.valueOf(userHome) + File.separator + BASE_DIR;
                return this.savesDirectory;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.savesDirectory = BASE_DIR;
        return BASE_DIR;
    }
}

