/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.pc.screen;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.List;
import javax.jnlp.FileContents;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeInsertionListener;
import org.javatari.atari.cartridge.CartridgeSocket;
import org.javatari.atari.console.savestate.SaveStateSocket;
import org.javatari.general.av.video.VideoMonitor;
import org.javatari.general.av.video.VideoSignal;
import org.javatari.general.av.video.VideoStandard;
import org.javatari.general.board.Clock;
import org.javatari.general.board.ClockDriven;
import org.javatari.parameters.Parameters;
import org.javatari.pc.cartridge.FileROMChooser;
import org.javatari.pc.cartridge.FileServiceROMChooser;
import org.javatari.pc.cartridge.ROMLoader;
import org.javatari.pc.cartridge.URLROMChooser;
import org.javatari.pc.screen.CRTTriadComposite;
import org.javatari.pc.screen.MonitorControls;
import org.javatari.pc.screen.MonitorDisplay;
import org.javatari.pc.screen.ROMTransferHandlerUtil;
import org.javatari.utils.Environment;
import org.javatari.utils.SwingHelper;

public final class Monitor
implements ClockDriven,
VideoMonitor,
CartridgeInsertionListener {
    public Clock clock;
    public String refreshMonitor = "refreshMonitor";
    private MonitorControls monitorControls;
    private boolean fixedSizeMode = FIXED_SIZE;
    private boolean cartridgeChangeEnabled = CARTRIDGE_CHANGE;
    private VideoSignal videoSignal;
    private CartridgeSocket cartridgeSocket;
    private SaveStateSocket savestateSocket;
    private final double fps;
    private VideoStandard signalStandard;
    private int signalWidth;
    private int signalHeight;
    private VideoStandard videoStandardDetected;
    private int videoStandardDetectionFrameCount;
    private int videoStandardDetectionFrameLineCount = 0;
    private int videoStandardDetectionAdtLinesPerFrame = 0;
    private int[] backBuffer;
    private int[] frontBuffer;
    private int displayWidth;
    private int displayHeight;
    private double displayHeightPct;
    private int displayOriginX;
    private int displayOriginY;
    private double displayOriginYPct;
    private float displayScaleX;
    private float displayScaleY;
    private boolean powerOn = false;
    private boolean signalOn = false;
    private SignalOffRefresher signalOffRefresher;
    private int osdFramesLeft = -1;
    private String osdMessage;
    private JLabel osdComponent;
    private boolean crtFilter = CRT_FILTER;
    private int crtMode = CRT_MODE < 0 ? 0 : CRT_MODE;
    private int debug = 0;
    private boolean showStats = false;
    private int line = 0;
    private int frame = 0;
    private int lastFrameRendered = -1;
    private MonitorDisplay display;
    private BufferedImage frameImage;
    private BufferedImage scanlinesTextureImage;
    private CRTTriadComposite crtTriadComposite;
    private BufferedImage intermFrameImage;
    private Image logoIcon;
    private final Runnable refresher = new Runnable(){

        @Override
        public void run() {
            Monitor.this.refresh();
        }
    };
    private static final String[] crtModeNames = new String[]{"OFF", "Phosphor", "Phosphor Scanlines", "RGB", "RGB Phosphor"};
    private static final int EXTRA_UPPER_VSYNC_TOLERANCE = 5;
    public static final double DEFAULT_FPS = Parameters.SCREEN_DEFAULT_FPS;
    public static final int BUFFER_VSYNC = Parameters.SCREEN_BUFFER_VSYNC;
    public static final int MULTI_BUFFERING = Parameters.SCREEN_MULTI_BUFFERING;
    public static final boolean PAGE_FLIPPING = Parameters.SCREEN_PAGE_FLIPPING;
    private static final int VSYNC_TOLERANCE = Parameters.SCREEN_VSYNC_TOLERANCE;
    private static final boolean BUFFER_SYNC_WAIT = Parameters.SCREEN_BUFFER_SYNC_WAIT;
    private static final int DEFAULT_ORIGIN_X = Parameters.SCREEN_DEFAULT_ORIGIN_X;
    private static final double DEFAULT_ORIGIN_Y_PCT = Parameters.SCREEN_DEFAULT_ORIGIN_Y_PCT;
    private static final int DEFAULT_WIDTH = Parameters.SCREEN_DEFAULT_WIDTH;
    private static final double DEFAULT_HEIGHT_PCT = Parameters.SCREEN_DEFAULT_HEIGHT_PCT;
    public static final float DEFAULT_SCALE_X = Parameters.SCREEN_DEFAULT_SCALE_X;
    public static final float DEFAULT_SCALE_ASPECT_X = Parameters.SCREEN_DEFAULT_SCALE_ASPECT_X;
    private static final float DEFAULT_SCALE_Y = Parameters.SCREEN_DEFAULT_SCALE_Y;
    private static final int OSD_FRAMES = Parameters.SCREEN_OSD_FRAMES;
    private static final boolean CRT_FILTER = Parameters.SCREEN_CRT_FILTER;
    private static final int CRT_MODE = Parameters.SCREEN_CRT_MODE;
    private static final float CRT_RETENTION_ALPHA = Parameters.SCREEN_CRT_RETENTION_ALPHA;
    private static final float SCANLINES_STRENGTH = Parameters.SCREEN_SCANLINES_STRENGTH;
    private static final float FRAME_ACCELERATION = Parameters.SCREEN_FRAME_ACCELERATION;
    private static final float IMTERM_FRAME_ACCELERATION = Parameters.SCREEN_INTERM_FRAME_ACCELERATION;
    private static final float SCANLINES_ACCELERATION = Parameters.SCREEN_SCANLINES_ACCELERATION;
    private static final boolean CARTRIDGE_CHANGE = Parameters.SCREEN_CARTRIDGE_CHANGE;
    private static final boolean FIXED_SIZE = Parameters.SCREEN_FIXED_SIZE;
    public static final long serialVersionUID = 0L;

    public Monitor() {
        this.fps = DEFAULT_FPS;
        this.init();
    }

    public void connect(VideoSignal videoSignal, CartridgeSocket cartridgeSocket, SaveStateSocket savestateSocket) {
        this.cartridgeSocket = cartridgeSocket;
        this.savestateSocket = savestateSocket;
        cartridgeSocket.addInsertionListener(this);
        this.videoSignal = videoSignal;
        videoSignal.connectMonitor(this);
        this.adjustToVideoSignal();
    }

    public synchronized void setDisplay(MonitorDisplay monitorDisplay) {
        this.display = monitorDisplay;
        float scX = this.display.displayDefaultOpenningScaleX(this.displayWidth, this.displayHeight);
        this.setDisplayScale(scX, scX / DEFAULT_SCALE_ASPECT_X);
        this.displayCenter();
    }

    public void setFixedSize(boolean fixed) {
        this.fixedSizeMode = fixed;
    }

    public boolean isFixedSize() {
        return this.fixedSizeMode;
    }

    public void setCartridgeChangeEnabled(boolean state) {
        this.cartridgeChangeEnabled = state;
    }

    public boolean isCartridgeChangeEnabled() {
        return this.cartridgeChangeEnabled;
    }

    public void addControlInputComponents(List<Component> inputs) {
        this.monitorControls.addInputComponents(inputs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void powerOn() {
        String string = this.refreshMonitor;
        synchronized (string) {
            this.cleanFrontBuffer();
            this.cleanBackBuffer();
            this.powerOn = true;
            this.signalState(false);
            this.clock.go();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void powerOff() {
        String string = this.refreshMonitor;
        synchronized (string) {
            this.clock.pause();
            this.powerOn = false;
            this.signalState(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        String string = this.refreshMonitor;
        synchronized (string) {
            this.clock.terminate();
        }
    }

    @Override
    public synchronized boolean nextLine(int[] pixels, boolean vSynchSignal) {
        if (!this.signalState(pixels != null)) {
            return false;
        }
        boolean vSynched = false;
        if (this.line < this.signalHeight) {
            if (this.line >= this.displayOriginY && this.line < this.displayOriginY + this.displayHeight) {
                System.arraycopy(pixels, this.displayOriginX, this.backBuffer, (this.line - this.displayOriginY) * this.displayWidth, this.displayWidth);
            }
        } else {
            vSynched = this.maxLineExceeded();
        }
        ++this.line;
        if (this.videoStandardDetected == null) {
            ++this.videoStandardDetectionFrameLineCount;
        }
        if (vSynchSignal) {
            if (this.videoStandardDetected == null) {
                this.videoStandardDetectionNewFrame();
            }
            vSynched = this.newFrame() || vSynched;
        }
        return vSynched;
    }

    @Override
    public VideoStandard videoStandardDetected() {
        return this.videoStandardDetected;
    }

    @Override
    public void videoStandardDetectionStart() {
        this.videoStandardDetected = null;
        this.videoStandardDetectionFrameCount = 0;
        this.videoStandardDetectionFrameLineCount = 0;
    }

    @Override
    public int currentLine() {
        return this.line;
    }

    @Override
    public void synchOutput() {
        if (this.fps < 0.0) {
            this.clock.interrupt();
        } else {
            this.synchOutputInSwing();
        }
    }

    @Override
    public void showOSD(String message, boolean overlap) {
        if (!overlap && this.osdFramesLeft > 0) {
            return;
        }
        this.osdMessage = message;
        this.osdFramesLeft = message == null ? 0 : OSD_FRAMES;
    }

    @Override
    public void clockPulse() {
        this.synchOutputInSwing();
        if (this.fps < 0.0 && !Thread.interrupted()) {
            try {
                Thread.sleep(32L, 0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void cartridgeInsert(Cartridge cart, boolean autoPower) {
        this.cartridgeSocket.insert(cart, autoPower);
        this.display.displayRequestFocus();
    }

    @Override
    public void cartridgeInserted(Cartridge cartridge) {
        if (CRT_MODE >= 0) {
            return;
        }
        if (this.crtMode == 0 || this.crtMode == 1) {
            this.setCrtMode(cartridge == null ? 0 : (cartridge.getInfo().crtMode == -1 ? 0 : cartridge.getInfo().crtMode));
        }
    }

    private void synchOutputInSwing() {
        if (BUFFER_SYNC_WAIT) {
            SwingHelper.edtSmartInvokeAndWait(this.refresher);
        } else {
            SwingHelper.edtInvokeLater(this.refresher);
        }
    }

    private boolean newFrame() {
        if (this.line < this.signalHeight - VSYNC_TOLERANCE) {
            return false;
        }
        int[] aux = this.frontBuffer;
        this.frontBuffer = this.backBuffer;
        this.backBuffer = aux;
        if (this.debug > 0) {
            this.cleanBackBuffer();
        }
        if (this.showStats) {
            this.showOSD((Object)((Object)this.videoSignal.standard()) + "  " + this.line + " lines,  CRT mode: " + crtModeNames[this.crtMode], true);
        }
        this.line = 0;
        ++this.frame;
        return true;
    }

    private boolean maxLineExceeded() {
        if (this.line > this.signalHeight + VSYNC_TOLERANCE + 5) {
            return this.newFrame();
        }
        return false;
    }

    private boolean signalState(boolean state) {
        if (state) {
            this.signalOn = true;
            this.adjustToVideoSignal();
        } else {
            this.signalOn = false;
            this.adjustToVideoSignalOff();
        }
        return state;
    }

    private void cleanFrontBuffer() {
        Arrays.fill(this.frontBuffer, Color.BLACK.getRGB());
    }

    private void cleanBackBuffer() {
        Arrays.fill(this.backBuffer, this.debug > 0 ? Color.GREEN.getRGB() : Color.BLACK.getRGB());
    }

    private void videoStandardDetectionNewFrame() {
        int linesCount = this.videoStandardDetectionFrameLineCount;
        this.videoStandardDetectionFrameLineCount = 0;
        if ((linesCount >= 250 && linesCount <= 281 || linesCount >= 300 && linesCount <= 325) && ++this.videoStandardDetectionFrameCount >= 5) {
            this.videoStandardDetectionFinish(linesCount);
        }
    }

    private void videoStandardDetectionFinish(int linesCount) {
        int prevAdd;
        this.videoStandardDetected = linesCount < 290 ? VideoStandard.NTSC : VideoStandard.PAL;
        int newAdd = linesCount - this.videoStandardDetected.height;
        newAdd = newAdd > 2 ? (newAdd > 6 ? 6 : newAdd) - 2 : 0;
        if (newAdd != (prevAdd = this.videoStandardDetectionAdtLinesPerFrame)) {
            this.videoStandardDetectionAdtLinesPerFrame = newAdd;
            this.adjustToVideoStandard(this.videoStandardDetected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayUpdateSize() {
        if (this.display == null) {
            return;
        }
        String string = this.refreshMonitor;
        synchronized (string) {
            Dimension size = new Dimension((int)((float)this.displayWidth * this.displayScaleX), (int)((float)this.displayHeight * this.displayScaleY));
            this.display.displaySize(size);
            this.display.displayMinimumSize(new Dimension((int)((float)this.displayWidth * DEFAULT_SCALE_X / DEFAULT_SCALE_Y), this.displayHeight));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayCenter() {
        if (this.display == null) {
            return;
        }
        String string = this.refreshMonitor;
        synchronized (string) {
            this.display.displayCenter();
        }
    }

    private Graphics2D displayGraphics() {
        if (this.display == null) {
            return null;
        }
        Graphics2D displayGraphics = this.display.displayGraphics();
        displayGraphics.setComposite(AlphaComposite.Src);
        if (displayGraphics != null && this.crtFilter) {
            displayGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        return displayGraphics;
    }

    private void displayFrameFinished(Graphics2D graphics) {
        if (this.display == null) {
            return;
        }
        this.display.displayFinishFrame(graphics);
    }

    private void init() {
        this.monitorControls = new MonitorControls(this);
        this.prepareResources();
        this.adjustToVideoStandard(VideoStandard.NTSC);
        this.setDisplayDefaultSize();
        this.clock = new Clock("Video Monitor", this, this.fps);
        this.paintLogo();
    }

    private void prepareResources() {
        this.backBuffer = new int[VideoStandard.PAL.width * VideoStandard.PAL.height];
        this.frontBuffer = new int[VideoStandard.PAL.width * VideoStandard.PAL.height];
        this.frameImage = new BufferedImage(VideoStandard.PAL.width, VideoStandard.PAL.height, 2);
        if (FRAME_ACCELERATION >= 0.0f) {
            this.frameImage.setAccelerationPriority(FRAME_ACCELERATION);
        }
        try {
            this.logoIcon = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/Logo.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.osdComponent = new JLabel();
        this.osdComponent.setForeground(Color.GREEN);
        this.osdComponent.setBackground(new Color(0x50000000, true));
        this.osdComponent.setFont(new Font(Environment.ARIAL_FONT ? "Arial" : (Environment.LIBERATION_FONT ? "Liberation Sans" : "SansSerif"), 1, 15));
        this.osdComponent.setBorder(new EmptyBorder(5, 12, 5, 12));
        this.osdComponent.setOpaque(true);
        this.scanlinesTextureImage = new BufferedImage(2048, 1280, 3);
        Graphics2D g = this.scanlinesTextureImage.createGraphics();
        g.setColor(new Color((int)(SCANLINES_STRENGTH * 255.0f) << 24, true));
        int i = 1;
        while (i < this.scanlinesTextureImage.getHeight()) {
            g.drawLine(0, i, this.scanlinesTextureImage.getWidth(), i);
            i += 2;
        }
        g.dispose();
        if (SCANLINES_ACCELERATION >= 0.0f) {
            this.scanlinesTextureImage.setAccelerationPriority(SCANLINES_ACCELERATION);
        }
        this.crtTriadComposite = new CRTTriadComposite();
        this.intermFrameImage = new BufferedImage(2048, 1280, 1);
        if (IMTERM_FRAME_ACCELERATION >= 0.0f) {
            this.intermFrameImage.setAccelerationPriority(IMTERM_FRAME_ACCELERATION);
        }
    }

    private void adjustToVideoSignal() {
        if (this.signalStandard != this.videoSignal.standard()) {
            this.adjustToVideoStandard(this.videoSignal.standard());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void adjustToVideoStandard(VideoStandard videoStandard) {
        String string = this.refreshMonitor;
        synchronized (string) {
            this.signalStandard = videoStandard;
            this.signalWidth = videoStandard.width;
            this.signalHeight = videoStandard.height;
            this.setDisplaySize(this.displayWidth, this.displayHeightPct);
            this.setDisplayOrigin(this.displayOriginX, this.displayOriginYPct);
        }
    }

    private void adjustToVideoSignalOff() {
        this.line = 0;
        this.display.displayClear();
        this.paintLogo();
        if (this.fps == 0.0 && this.powerOn && this.signalOffRefresher == null) {
            SignalOffRefresher ref;
            this.signalOffRefresher = ref = new SignalOffRefresher();
            ref.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintLogo() {
        String string = this.refreshMonitor;
        synchronized (string) {
            Graphics2D canvasGraphics = this.displayGraphics();
            if (canvasGraphics == null) {
                return;
            }
            Dimension ces = this.display.displayEffectiveSize();
            int w = ces.width;
            int h = ces.height;
            Graphics2D intermGraphics = this.intermFrameImage.createGraphics();
            intermGraphics.setBackground(Color.BLACK);
            intermGraphics.clearRect(0, 0, w, h);
            int lw = this.logoIcon.getWidth(null);
            int lh = this.logoIcon.getHeight(null);
            float r = h < lh ? (float)h / (float)lh : 1.0f;
            lw = (int)((float)lw * r);
            lh = (int)((float)lh * r);
            intermGraphics.drawImage(this.logoIcon, (w - lw) / 2, (h - lh) / 2, lw, lh, null);
            this.paintOSD(intermGraphics);
            canvasGraphics.drawImage(this.intermFrameImage, 0, 0, w, h, 0, 0, w, h, null);
            intermGraphics.dispose();
            this.displayFrameFinished(canvasGraphics);
        }
    }

    private void paintOSD(Graphics2D canvasGraphics) {
        if (--this.osdFramesLeft < 0) {
            return;
        }
        canvasGraphics.setComposite(AlphaComposite.SrcOver);
        this.osdComponent.setText(this.osdMessage);
        Dimension s = this.osdComponent.getPreferredSize();
        SwingUtilities.paintComponent(canvasGraphics, this.osdComponent, this.display.displayContainer(), this.display.displayEffectiveSize().width - s.width - 12, 12, s.width, s.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        if (!this.signalOn) {
            this.paintLogo();
            return;
        }
        String string = this.refreshMonitor;
        synchronized (string) {
            int f = this.frame;
            if (this.lastFrameRendered == f) {
                return;
            }
            int[] drawBuffer = this.frontBuffer;
            Graphics2D displayGraphics = this.displayGraphics();
            if (displayGraphics == null) {
                return;
            }
            Dimension ces = this.display.displayEffectiveSize();
            int displayEffectiveWidth = ces.width;
            int displayEffectiveHeight = ces.height;
            if (this.crtMode >= 3 || MULTI_BUFFERING < 2 && (this.osdFramesLeft >= 0 || this.crtMode > 0)) {
                int intermWidth = Math.min(displayEffectiveWidth, 2048);
                int intermHeight = Math.min(displayEffectiveHeight, 1280);
                Graphics2D intermGraphics = this.intermFrameImage.createGraphics();
                intermGraphics.setComposite(AlphaComposite.Src);
                this.renderFrame(intermGraphics, drawBuffer, intermWidth, intermHeight);
                if (this.crtMode == 2) {
                    this.renderScanlines(intermGraphics, intermWidth, intermHeight);
                }
                if (this.crtMode >= 3) {
                    intermGraphics.setComposite(this.crtTriadComposite);
                    intermGraphics.drawImage(this.intermFrameImage, 0, 0, intermWidth, intermHeight, 0, 0, intermWidth, intermHeight, null);
                }
                this.paintOSD(intermGraphics);
                intermGraphics.dispose();
                displayGraphics.drawImage(this.intermFrameImage, 0, 0, intermWidth, intermHeight, 0, 0, intermWidth, intermHeight, null);
            } else {
                this.renderFrame(displayGraphics, drawBuffer, displayEffectiveWidth, displayEffectiveHeight);
                if (this.crtMode == 2) {
                    this.renderScanlines(displayGraphics, displayEffectiveWidth, displayEffectiveHeight);
                }
                this.paintOSD(displayGraphics);
            }
            this.displayFrameFinished(displayGraphics);
            this.lastFrameRendered = f;
        }
    }

    private void renderFrame(Graphics2D graphics, int[] drawBuffer, int effectiveWidth, int effectiveHeight) {
        if (this.crtMode > 0 && this.crtMode != 3) {
            graphics.setBackground(Color.BLACK);
            graphics.clearRect(0, 0, effectiveWidth, effectiveHeight);
            graphics.setComposite(AlphaComposite.getInstance(3, CRT_RETENTION_ALPHA));
            graphics.drawImage(this.frameImage, 0, 0, effectiveWidth, effectiveHeight, 0, 0, this.displayWidth, this.displayHeight, null);
        }
        this.frameImage.getRaster().setDataElements(0, 0, this.displayWidth, this.displayHeight, drawBuffer);
        graphics.drawImage(this.frameImage, 0, 0, effectiveWidth, effectiveHeight, 0, 0, this.displayWidth, this.displayHeight, null);
    }

    private void renderScanlines(Graphics2D graphics, int effectiveWidth, int effectiveHeight) {
        graphics.setComposite(AlphaComposite.SrcOver);
        graphics.drawImage(this.scanlinesTextureImage, 0, 0, effectiveWidth, effectiveHeight, 0, 0, effectiveWidth, effectiveHeight, null);
    }

    private synchronized void setDisplayDefaultSize() {
        this.setDisplaySize(DEFAULT_WIDTH, DEFAULT_HEIGHT_PCT);
        this.setDisplayOrigin(DEFAULT_ORIGIN_X, DEFAULT_ORIGIN_Y_PCT);
        if (this.display != null) {
            float scX = this.display.displayDefaultOpenningScaleX(this.displayWidth, this.displayHeight);
            this.setDisplayScale(scX, scX / DEFAULT_SCALE_ASPECT_X);
        } else {
            this.setDisplayScale(DEFAULT_SCALE_X, DEFAULT_SCALE_Y);
        }
        this.displayCenter();
    }

    private synchronized void setDisplayOrigin(int x, double yPct) {
        this.displayOriginX = x;
        if (this.displayOriginX < 0) {
            this.displayOriginX = 0;
        } else if (this.displayOriginX > this.signalWidth - this.displayWidth) {
            this.displayOriginX = this.signalWidth - this.displayWidth;
        }
        this.displayOriginYPct = yPct;
        if (this.displayOriginYPct < 0.0) {
            this.displayOriginYPct = 0.0;
        } else if (this.displayOriginYPct / 100.0 * (double)this.signalHeight > (double)(this.signalHeight - this.displayHeight)) {
            this.displayOriginYPct = ((double)this.signalHeight - (double)this.displayHeight) / (double)this.signalHeight * 100.0;
        }
        int adtOriginY = this.videoStandardDetectionAdtLinesPerFrame / 2;
        this.displayOriginY = (int)(this.displayOriginYPct / 100.0 * (double)this.signalHeight) + adtOriginY;
        if (this.displayOriginY + this.displayHeight > this.signalHeight) {
            this.displayOriginY = this.signalHeight - this.displayHeight;
        }
    }

    private synchronized void setDisplaySize(int width, double heightPct) {
        this.displayWidth = width;
        if (this.displayWidth < 10) {
            this.displayWidth = 10;
        } else if (this.displayWidth > this.signalWidth) {
            this.displayWidth = this.signalWidth;
        }
        this.displayHeightPct = heightPct;
        if (this.displayHeightPct < 10.0) {
            this.displayHeightPct = 10.0;
        } else if (this.displayHeightPct > 100.0) {
            this.displayHeightPct = 100.0;
        }
        this.displayHeight = (int)(this.displayHeightPct / 100.0 * (double)(this.signalHeight + this.videoStandardDetectionAdtLinesPerFrame));
        if (this.displayHeight > this.signalHeight) {
            this.displayHeight = this.signalHeight;
        }
        this.setDisplayOrigin(this.displayOriginX, this.displayOriginYPct);
        this.displayUpdateSize();
    }

    private void setDisplayScale(float x, float y) {
        this.displayScaleX = x;
        if (this.displayScaleX < 1.0f) {
            this.displayScaleX = 1.0f;
        }
        this.displayScaleY = y;
        if (this.displayScaleY < 1.0f) {
            this.displayScaleY = 1.0f;
        }
        this.displayUpdateSize();
    }

    private void setDisplayScaleDefaultAspect(float y) {
        int scaleY = (int)y;
        if (scaleY < 1) {
            scaleY = 1;
        }
        this.setDisplayScale((float)scaleY * DEFAULT_SCALE_ASPECT_X, scaleY);
    }

    private void loadCartridgeFromFile(boolean autoPower) {
        Cartridge cart;
        block6: {
            if (this.cartridgeChangeDisabledWarning()) {
                return;
            }
            this.display.displayLeaveFullscreen();
            cart = null;
            try {
                File file = FileROMChooser.chooseFileToLoad();
                if (file != null) {
                    cart = ROMLoader.load(file);
                }
            }
            catch (AccessControlException e) {
                FileContents fileContents = FileServiceROMChooser.chooseFileToLoad();
                if (fileContents == null) break block6;
                cart = ROMLoader.load(fileContents);
            }
        }
        if (cart != null) {
            this.cartridgeInsert(cart, autoPower);
        } else {
            this.display.displayRequestFocus();
        }
    }

    private void loadCartridgeFromURL(boolean autoPower) {
        if (this.cartridgeChangeDisabledWarning()) {
            return;
        }
        this.display.displayLeaveFullscreen();
        Cartridge cart = null;
        String url = URLROMChooser.chooseURLToLoad();
        if (url != null) {
            cart = ROMLoader.load(url, false);
        }
        if (cart != null) {
            this.cartridgeInsert(cart, autoPower);
        } else {
            this.display.displayRequestFocus();
        }
    }

    private void loadCartridgeEmpty() {
        if (this.cartridgeChangeDisabledWarning()) {
            return;
        }
        this.cartridgeSocket.insert(null, false);
    }

    private void loadCartridgePaste() {
        if (this.cartridgeChangeDisabledWarning()) {
            return;
        }
        try {
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transf = clip.getContents("Ignored");
            if (transf == null) {
                return;
            }
            Cartridge cart = ROMTransferHandlerUtil.importCartridgeData(transf);
            if (cart != null) {
                this.cartridgeInsert(cart, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveStateCartridge() {
        this.savestateSocket.saveStateFile();
        this.display.displayRequestFocus();
    }

    private boolean cartridgeChangeDisabledWarning() {
        if (!this.isCartridgeChangeEnabled()) {
            this.showOSD("Cartridge change is disabled", true);
            return true;
        }
        return false;
    }

    private void crtModeToggle() {
        this.setCrtMode(this.crtMode + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCrtMode(int mode) {
        String string = this.refreshMonitor;
        synchronized (string) {
            int newMode;
            int n = newMode = mode > 4 || mode < 0 ? 0 : mode;
            if (this.crtMode == newMode) {
                return;
            }
            this.crtMode = newMode;
            this.showOSD("CRT mode: " + crtModeNames[this.crtMode], true);
        }
    }

    public void controlActivated(Control control) {
        switch (control) {
            case LOAD_CARTRIDGE_FILE: {
                this.loadCartridgeFromFile(true);
                break;
            }
            case LOAD_CARTRIDGE_FILE_NO_AUTO_POWER: {
                this.loadCartridgeFromFile(false);
                break;
            }
            case LOAD_CARTRIDGE_URL: {
                this.loadCartridgeFromURL(true);
                break;
            }
            case LOAD_CARTRIDGE_URL_NO_AUTO_POWER: {
                this.loadCartridgeFromURL(false);
                break;
            }
            case LOAD_CARTRIDGE_EMPTY: {
                this.loadCartridgeEmpty();
                break;
            }
            case LOAD_CARTRIDGE_PASTE: {
                this.loadCartridgePaste();
                break;
            }
            case SAVE_STATE_CARTRIDGE: {
                this.saveStateCartridge();
                break;
            }
            case CRT_FILTER: {
                this.crtFilter = !this.crtFilter;
                this.showOSD(this.crtFilter ? "CRT Filter: ON" : "CRT Filter: OFF", true);
                break;
            }
            case CRT_MODES: {
                this.crtModeToggle();
                break;
            }
            case STATS: {
                this.showStats = !this.showStats;
                this.showOSD(null, true);
                break;
            }
            case DEBUG: {
                ++this.debug;
                if (this.debug <= 4) break;
                this.debug = 0;
                break;
            }
            case ORIGIN_X_MINUS: {
                this.setDisplayOrigin(this.displayOriginX + 1, this.displayOriginYPct);
                break;
            }
            case ORIGIN_X_PLUS: {
                this.setDisplayOrigin(this.displayOriginX - 1, this.displayOriginYPct);
                break;
            }
            case ORIGIN_Y_MINUS: {
                this.setDisplayOrigin(this.displayOriginX, this.displayOriginYPct + 0.5);
                break;
            }
            case ORIGIN_Y_PLUS: {
                this.setDisplayOrigin(this.displayOriginX, this.displayOriginYPct - 0.5);
                break;
            }
            case SIZE_DEFAULT: {
                this.setDisplayDefaultSize();
            }
        }
        if (this.fixedSizeMode) {
            return;
        }
        switch (control) {
            case WIDTH_MINUS: {
                this.setDisplaySize(this.displayWidth - 1, this.displayHeightPct);
                break;
            }
            case WIDTH_PLUS: {
                this.setDisplaySize(this.displayWidth + 1, this.displayHeightPct);
                break;
            }
            case HEIGHT_MINUS: {
                this.setDisplaySize(this.displayWidth, this.displayHeightPct - 0.5);
                break;
            }
            case HEIGHT_PLUS: {
                this.setDisplaySize(this.displayWidth, this.displayHeightPct + 0.5);
                break;
            }
            case SCALE_X_MINUS: {
                this.setDisplayScale(this.displayScaleX - 0.5f, this.displayScaleY);
                break;
            }
            case SCALE_X_PLUS: {
                this.setDisplayScale(this.displayScaleX + 0.5f, this.displayScaleY);
                break;
            }
            case SCALE_Y_MINUS: {
                this.setDisplayScale(this.displayScaleX, this.displayScaleY - 0.5f);
                break;
            }
            case SCALE_Y_PLUS: {
                this.setDisplayScale(this.displayScaleX, this.displayScaleY + 0.5f);
                break;
            }
            case SIZE_MINUS: {
                this.setDisplayScaleDefaultAspect(this.displayScaleY - 1.0f);
                break;
            }
            case SIZE_PLUS: {
                this.setDisplayScaleDefaultAspect(this.displayScaleY + 1.0f);
            }
        }
    }

    public static enum Control {
        WIDTH_PLUS,
        HEIGHT_PLUS,
        WIDTH_MINUS,
        HEIGHT_MINUS,
        ORIGIN_X_PLUS,
        ORIGIN_Y_PLUS,
        ORIGIN_X_MINUS,
        ORIGIN_Y_MINUS,
        SCALE_X_PLUS,
        SCALE_Y_PLUS,
        SCALE_X_MINUS,
        SCALE_Y_MINUS,
        SIZE_PLUS,
        SIZE_MINUS,
        SIZE_DEFAULT,
        LOAD_CARTRIDGE_FILE,
        LOAD_CARTRIDGE_FILE_NO_AUTO_POWER,
        LOAD_CARTRIDGE_URL,
        LOAD_CARTRIDGE_URL_NO_AUTO_POWER,
        LOAD_CARTRIDGE_EMPTY,
        LOAD_CARTRIDGE_PASTE,
        SAVE_STATE_CARTRIDGE,
        CRT_FILTER,
        CRT_MODES,
        DEBUG,
        STATS;

    }

    private final class SignalOffRefresher
    extends Thread {
        private SignalOffRefresher() {
        }

        @Override
        public void run() {
            try {
                SignalOffRefresher.sleep(33L);
            }
            catch (InterruptedException interruptedException) {}
            while (Monitor.this.powerOn && !Monitor.this.signalOn) {
                Monitor.this.synchOutput();
                try {
                    SignalOffRefresher.sleep(33L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Monitor.this.signalOffRefresher = null;
        }
    }
}

