/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.pc.screen;

import java.awt.BufferCapabilities;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.ImageCapabilities;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import org.javatari.atari.cartridge.CartridgeSocket;
import org.javatari.atari.console.savestate.SaveStateSocket;
import org.javatari.atari.controls.ConsoleControlsSocket;
import org.javatari.general.av.video.VideoSignal;
import org.javatari.parameters.Parameters;
import org.javatari.pc.room.EmbeddedRoom;
import org.javatari.pc.room.Room;
import org.javatari.pc.screen.Monitor;
import org.javatari.pc.screen.MonitorDisplay;
import org.javatari.utils.SwingHelper;
import org.javatari.utils.slickframe.HotspotPanel;

public final class MonitorPanel
extends HotspotPanel
implements MonitorDisplay {
    private Monitor monitor;
    private Canvas canvas;
    private BufferStrategy bufferStrategy;
    private boolean popupEnabled;
    private BufferedImage topLeft;
    private BufferedImage bottomLeft;
    private BufferedImage topRight;
    private BufferedImage bottomRight;
    private BufferedImage top;
    private BufferedImage bottomBar;
    private BufferedImage bottomLeftBar;
    private BufferedImage bottomLeftBarNoPower;
    private BufferedImage bottomRightBar;
    private BufferedImage bottomRightBarFixedSize;
    private BufferedImage logoBar;
    private BufferedImage popup;
    private int totalCanvasVertPadding;
    private int totalCanvasHorizPadding;
    private static final Insets SLICK_INSETS = new Insets(4, 4, 30, 4);
    public static final int BORDER_SIZE = Parameters.SCREEN_BORDER_SIZE;
    private static final boolean EMBEDDED_POPUP = Parameters.SCREEN_EMBEDDED_POPUP;
    public static final long serialVersionUID = 1L;

    public MonitorPanel() {
        this.totalCanvasVertPadding = MonitorPanel.SLICK_INSETS.top + MonitorPanel.SLICK_INSETS.bottom + BORDER_SIZE * 2;
        this.totalCanvasHorizPadding = MonitorPanel.SLICK_INSETS.left + MonitorPanel.SLICK_INSETS.right + BORDER_SIZE * 2;
        this.setup();
        this.addHotspots();
        this.monitor = new Monitor();
        this.monitor.setDisplay(this);
    }

    public void connect(VideoSignal videoSignal, ConsoleControlsSocket controlsSocket, CartridgeSocket cartridgeSocket, SaveStateSocket savestateSocket) {
        this.monitor.connect(videoSignal, cartridgeSocket, savestateSocket);
    }

    public Monitor monitor() {
        return this.monitor;
    }

    public void powerOn() {
        SwingHelper.edtSmartInvokeAndWait(new Runnable(){

            @Override
            public void run() {
                MonitorPanel.this.setVisible(true);
                MonitorPanel.this.monitor.powerOn();
            }
        });
    }

    public void powerOff() {
        this.monitor.powerOff();
    }

    public void destroy() {
        this.monitor.destroy();
    }

    private void setup() {
        this.loadImages();
        this.setBackground(Color.BLACK);
        this.setIgnoreRepaint(true);
        this.setLayout(null);
        this.canvas = new Canvas();
        this.canvas.setBackground(Color.BLACK);
        this.canvas.setIgnoreRepaint(true);
        this.canvas.setFocusTraversalKeysEnabled(false);
        this.add(this.canvas);
        this.positionCanvas();
        this.addControlInputComponents(this.keyControlsInputComponents());
        this.popupEnabled = EMBEDDED_POPUP && Room.currentRoom() instanceof EmbeddedRoom;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Insets ins = this.getInsets();
            this.totalCanvasHorizPadding = ins.left + ins.right + MonitorPanel.SLICK_INSETS.left + MonitorPanel.SLICK_INSETS.right + BORDER_SIZE * 2;
            this.totalCanvasVertPadding = ins.top + ins.bottom + MonitorPanel.SLICK_INSETS.top + MonitorPanel.SLICK_INSETS.bottom + BORDER_SIZE * 2;
            this.canvasSetRenderingMode();
            SwingHelper.edtInvokeLater(new Runnable(){

                @Override
                public void run() {
                    MonitorPanel.this.repaint();
                }
            });
        }
    }

    public List<Component> keyControlsInputComponents() {
        return Arrays.asList(this, this.canvas);
    }

    @Override
    public void displaySize(Dimension size) {
        Dimension panelDim = this.panelDimensionForCanvasDimension(size);
        if (this.getSize().equals(panelDim)) {
            return;
        }
        this.setSize(panelDim);
        this.setPreferredSize(panelDim);
        this.setMinimumSize(panelDim);
        this.setMaximumSize(panelDim);
        this.canvas.setSize(size);
        this.validate();
    }

    @Override
    public void displayCenter() {
    }

    @Override
    public Dimension displayEffectiveSize() {
        return this.canvas.getSize();
    }

    @Override
    public Graphics2D displayGraphics() {
        Graphics2D graphics = (Graphics2D)(this.bufferStrategy != null ? this.bufferStrategy.getDrawGraphics() : this.canvas.getGraphics());
        return graphics;
    }

    @Override
    public void displayFinishFrame(Graphics2D graphics) {
        graphics.dispose();
        if (this.bufferStrategy != null) {
            this.bufferStrategy.show();
        }
    }

    @Override
    public Container displayContainer() {
        return this;
    }

    @Override
    public void displayClear() {
        Graphics2D canvasGraphics = this.displayGraphics();
        canvasGraphics.setColor(Color.BLACK);
        canvasGraphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.displayFinishFrame(canvasGraphics);
    }

    @Override
    public float displayDefaultOpenningScaleX(int displayWidh, int displayHeight) {
        return Monitor.DEFAULT_SCALE_X;
    }

    @Override
    public void displayMinimumSize(Dimension minSize) {
    }

    @Override
    public void displayRequestFocus() {
        this.requestFocus();
    }

    @Override
    public void displayLeaveFullscreen() {
    }

    public void canvasSetRenderingMode() {
        if (Monitor.MULTI_BUFFERING <= 0) {
            return;
        }
        BufferCapabilities desiredCaps = new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), Monitor.PAGE_FLIPPING ? BufferCapabilities.FlipContents.BACKGROUND : null);
        Class<?> extBufCapClass = null;
        try {
            extBufCapClass = Class.forName("sun.java2d.pipe.hw.ExtendedBufferCapabilities");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (extBufCapClass != null && Monitor.BUFFER_VSYNC != -1) {
            try {
                Class<?> vSyncTypeClass = Class.forName("sun.java2d.pipe.hw.ExtendedBufferCapabilities$VSyncType");
                Constructor<?> extBufCapConstructor = extBufCapClass.getConstructor(BufferCapabilities.class, vSyncTypeClass);
                Object vSyncType = vSyncTypeClass.getField(Monitor.BUFFER_VSYNC == 1 ? "VSYNC_ON" : "VSYNC_OFF").get(null);
                BufferCapabilities extBuffCaps = (BufferCapabilities)extBufCapConstructor.newInstance(desiredCaps, vSyncType);
                this.canvas.createBufferStrategy(Monitor.MULTI_BUFFERING, extBuffCaps);
            }
            catch (Exception vSyncTypeClass) {
                // empty catch block
            }
        }
        if (this.canvas.getBufferStrategy() == null) {
            try {
                this.canvas.createBufferStrategy(Monitor.MULTI_BUFFERING, desiredCaps);
            }
            catch (Exception vSyncTypeClass) {
                // empty catch block
            }
        }
        if (this.canvas.getBufferStrategy() == null) {
            System.out.println("Could not create desired BufferStrategy. Switching to default...");
            this.canvas.createBufferStrategy(Monitor.MULTI_BUFFERING);
        }
        this.bufferStrategy = this.canvas.getBufferStrategy();
        if (this.bufferStrategy != null) {
            System.out.println("Buffer Strategy: " + this.bufferStrategy.getClass().getSimpleName());
        }
        BufferCapabilities grantedCaps = this.bufferStrategy.getCapabilities();
        System.out.println("Backbuffer Accelerated: " + grantedCaps.getBackBufferCapabilities().isAccelerated());
        System.out.println("PageFlipping Active: " + grantedCaps.isPageFlipping() + ", " + grantedCaps.getFlipContents());
        if (extBufCapClass != null && grantedCaps.getClass().equals(extBufCapClass)) {
            try {
                System.out.println("VSynch active: " + extBufCapClass.getMethod("getVSync", null).invoke((Object)grantedCaps, new Object[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addControlInputComponents(List<Component> inputs) {
        MonitorPanelControlKeyListener lis = new MonitorPanelControlKeyListener();
        for (Component component : inputs) {
            component.addKeyListener(lis);
        }
    }

    private Dimension panelDimensionForCanvasDimension(Dimension size) {
        return new Dimension(size.width + this.totalCanvasHorizPadding, size.height + this.totalCanvasVertPadding);
    }

    private void positionCanvas() {
        this.canvas.setLocation(MonitorPanel.SLICK_INSETS.left + BORDER_SIZE, MonitorPanel.SLICK_INSETS.top + BORDER_SIZE);
    }

    private void addHotspots() {
        this.addHotspot(new Rectangle(-10000, -27, 24, 28), new Runnable(){

            @Override
            public void run() {
            }
        });
        this.addHotspot(new Rectangle(-30, -25, 21, 20), "Open Settings", new Runnable(){

            @Override
            public void run() {
                Room.currentRoom().openSettings(MonitorPanel.this);
                MonitorPanel.this.requestFocus();
            }
        });
        if (this.popupEnabled) {
            this.addHotspot(new Rectangle(7, -25, 23, 20), "Detach Screen", new Runnable(){

                @Override
                public void run() {
                    ((EmbeddedRoom)Room.currentRoom()).popUpScreen(false);
                }
            });
        }
    }

    private void loadImages() {
        try {
            this.topLeft = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/TopLeft.png");
            this.bottomLeft = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/BottomLeft.png");
            this.topRight = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/TopRight.png");
            this.bottomRight = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/BottomRight.png");
            this.top = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/Top.png");
            this.bottomLeftBar = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/BottomLeftBar.png");
            this.bottomLeftBarNoPower = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/BottomLeftBarNoPower.png");
            this.bottomRightBar = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/BottomRightBar.png");
            this.bottomRightBarFixedSize = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/BottomRightBarFixedSize.png");
            this.bottomBar = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/BottomBar.png");
            this.logoBar = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/LogoBar.png");
            this.popup = SwingHelper.loadAsCompatibleImage("org/javatari/pc/screen/images/Popup.png");
        }
        catch (IOException ex) {
            System.out.println("Screen Window: unable to load images\n" + ex);
        }
    }

    @Override
    public void paintComponent(Graphics origGraphics) {
        super.paintComponent(origGraphics);
        Insets ins = this.getInsets();
        int w = this.getWidth() - ins.left - ins.right;
        int h = this.getHeight() - ins.top - ins.bottom;
        Graphics g = origGraphics.create(ins.left, ins.top, w, h);
        g.setColor(Color.BLACK);
        g.fillRect(MonitorPanel.SLICK_INSETS.left, MonitorPanel.SLICK_INSETS.top, this.getWidth() - MonitorPanel.SLICK_INSETS.left - MonitorPanel.SLICK_INSETS.right, this.getHeight() - MonitorPanel.SLICK_INSETS.top - MonitorPanel.SLICK_INSETS.bottom);
        int halfH = (h - 30) / 2;
        int halfW = w / 2;
        int maxHalfW = Math.min(halfW - 11, 512);
        int x = 0;
        while (x < w) {
            g.drawImage(this.top, x, 0, null);
            x += 512;
        }
        g.drawImage(this.topLeft, 0, 0, null);
        g.drawImage(this.topRight, w - 4, 0, null);
        x = 512;
        while (x < w - 512) {
            g.drawImage(this.bottomBar, x, h - 30, x + 256, h, 0, 0, 256, 30, null);
            x += 256;
        }
        BufferedImage bLeftBar = this.monitor.isFixedSize() ? this.bottomLeftBarNoPower : this.bottomLeftBar;
        g.drawImage(bLeftBar, 0, h - 30, maxHalfW, h, 0, 0, maxHalfW, 30, null);
        BufferedImage bRightBar = this.monitor.isFixedSize() ? this.bottomRightBarFixedSize : this.bottomRightBar;
        g.drawImage(bRightBar, w - maxHalfW, h - 30, w, h, 512 - maxHalfW, 0, 512, 30, null);
        g.drawImage(this.logoBar, halfW - 12, h - 30, null);
        g.drawImage(this.bottomLeft, 0, halfH, 4, h - 30, 0, 600 - halfH, 4, 600, null);
        g.drawImage(this.bottomRight, w - 4, halfH, w, h - 30, 0, 600 - halfH, 4, 600, null);
        if (this.popupEnabled) {
            g.drawImage(this.popup, 11, h - 22, null);
        }
        this.paintHotspots(g);
        g.dispose();
    }

    private class MonitorPanelControlKeyListener
    extends KeyAdapter {
        static final int KEY_EXIT = 27;
        static final int KEY_FULL_SCR = 10;

        private MonitorPanelControlKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            switch (e.getModifiersEx()) {
                case 0: {
                    if (code == 27) {
                        Room.currentRoom().currentConsole().powerOff();
                    }
                    return;
                }
                case 512: {
                    if (!MonitorPanel.this.popupEnabled || code != 10) break;
                    ((EmbeddedRoom)Room.currentRoom()).popUpScreen(true);
                }
            }
        }
    }
}

