/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.utils;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;

public final class SwingHelper {
    public static BufferedImage loadImage(String fileName) throws IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource(fileName);
        if (url == null) {
            throw new IOException("Could not find image: " + fileName);
        }
        return ImageIO.read(url);
    }

    public static BufferedImage loadAsCompatibleImage(String fileName) throws IOException {
        return SwingHelper.asCompatibleImage(SwingHelper.loadImage(fileName));
    }

    public static BufferedImage loadAsCompatibleTranslucentImage(String fileName) throws IOException {
        return SwingHelper.asCompatibleImage(SwingHelper.loadImage(fileName), 3);
    }

    public static BufferedImage asCompatibleImage(Image img) {
        BufferedImage ret = SwingHelper.defaultScreenDeviceConfiguration().createCompatibleImage(img.getWidth(null), img.getHeight(null));
        Graphics2D gc = ret.createGraphics();
        gc.drawImage(img, 0, 0, null);
        gc.dispose();
        return ret;
    }

    public static BufferedImage asCompatibleImage(Image img, int transparency) {
        BufferedImage ret = SwingHelper.defaultScreenDeviceConfiguration().createCompatibleImage(img.getWidth(null), img.getHeight(null), transparency);
        Graphics2D gc = ret.createGraphics();
        gc.setComposite(AlphaComposite.Src);
        gc.drawImage(img, 0, 0, null);
        gc.dispose();
        return ret;
    }

    public static VolatileImage asCompatibleVolatileImage(Image img) {
        VolatileImage ret = SwingHelper.defaultScreenDeviceConfiguration().createCompatibleVolatileImage(img.getWidth(null), img.getHeight(null));
        Graphics2D gc = ret.createGraphics();
        gc.drawImage(img, 0, 0, null);
        gc.dispose();
        return ret;
    }

    public static VolatileImage asCompatibleVolatileImage(Image img, int transparency) {
        VolatileImage ret = SwingHelper.defaultScreenDeviceConfiguration().createCompatibleVolatileImage(img.getWidth(null), img.getHeight(null), transparency);
        Graphics2D gc = ret.createGraphics();
        gc.setComposite(AlphaComposite.Src);
        gc.drawImage(img, 0, 0, null);
        gc.dispose();
        return ret;
    }

    public static GraphicsConfiguration defaultScreenDeviceConfiguration() {
        return SwingHelper.defaultScreenDevice().getDefaultConfiguration();
    }

    public static GraphicsDevice defaultScreenDevice() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (env == null) {
            throw new UnsupportedOperationException("Could not get Local Graphics Environment");
        }
        GraphicsDevice dev = env.getDefaultScreenDevice();
        if (dev == null) {
            throw new UnsupportedOperationException("Could not get Default Graphics Device");
        }
        return dev;
    }

    public static void edtInvokeLater(Runnable block) {
        SwingUtilities.invokeLater(block);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void edtSmartInvokeAndWait(Runnable block) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(block);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (InvocationTargetException e) {
                if (!(e.getCause() instanceof RuntimeException)) return;
                throw (RuntimeException)e.getCause();
            }
        } else {
            block.run();
        }
    }

    public static GraphicsConfiguration getGraphicsConfigurationForCurrentLocation(Window window) {
        GraphicsDevice[] screens;
        GraphicsConfiguration ownedConfig = window.getGraphicsConfiguration();
        Point currLocation = window.getLocation();
        if (ownedConfig.getBounds().contains(currLocation)) {
            return ownedConfig;
        }
        GraphicsDevice[] graphicsDeviceArray = screens = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        int n = screens.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice screen = graphicsDeviceArray[n2];
            GraphicsConfiguration[] graphicsConfigurationArray = screen.getConfigurations();
            int n3 = graphicsConfigurationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                GraphicsConfiguration config = graphicsConfigurationArray[n4];
                if (config.getBounds().contains(currLocation)) {
                    return config;
                }
                ++n4;
            }
            ++n2;
        }
        return ownedConfig;
    }
}

