/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.javatari.atari.board.BUS;
import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.ROM;
import org.javatari.atari.cartridge.ROMFormatDenialDetailException;
import org.javatari.atari.cartridge.formats.CartridgeBankedByBusMonitoring;
import org.javatari.utils.Randomizer;

public final class Cartridge8K_64K_AR
extends CartridgeBankedByBusMonitoring {
    private int bank0AddressOffset = 0;
    private int bank1AddressOffset = 0;
    private byte[] header = new byte[256];
    private byte valueToWrite = 0;
    private boolean writeEnabled = false;
    private int lastAddress = -1;
    private int addressChangeCountdown = 0;
    private boolean biosRomPower = false;
    private int romStartupAddress = 0;
    private byte romControlRegister = 0;
    private byte romPageCount = 0;
    private byte romChecksum = 0;
    private byte romMultiLoadIndex = 0;
    private int romProgressBarSpeed = 0;
    private byte[] romPageOffsets;
    private int tapeOffset = 0;
    private transient BUS bus;
    private static final int BIOS_INT_PART_NO_ADDR = 64256;
    private static final int BIOS_INT_CONTROL_REG_ADDR = 64257;
    private static final int BIOS_INT_START_ADDR = 64258;
    private static final int BIOS_INT_RANDOM_SEED_ADDR = 64260;
    private static final int BIOS_INT_PART_LOADED_OK = 64261;
    private static final int BIOS_INT_EMUL_LOAD_HOTSPOT = 3072;
    private static final int HEADER_SIZE = 256;
    private static final int PAGE_SIZE = 256;
    private static final int BANK_SIZE = 2048;
    private static final int BIOS_BANK_OFFSET = 6144;
    private static final int PART_SIZE = 8448;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("AR", "8K-64K Arcadia/Starpath/Supercharger"){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge createCartridge(ROM rom) {
            return new Cartridge8K_64K_AR(rom, null);
        }

        @Override
        public CartridgeFormatOption getOption(ROM rom) {
            if (rom.content.length % 8448 != 0 || rom.content.length / 8448 < 1 || rom.content.length / 8448 > 8) {
                return null;
            }
            if (Cartridge8K_64K_AR.peekPartNoOnTape(rom.content, 0) != 0) {
                throw new ROMFormatDenialDetailException("Wrong Supercharger Tape ROM file. This is NOT a Tape Start ROM!\nTry loading a First Part ROM or a Full Tape ROM.");
            }
            return new CartridgeFormatOption(101, this, rom);
        }
    };
    public static final long serialVersionUID = 1L;

    private Cartridge8K_64K_AR(ROM rom) {
        super(rom, FORMAT);
        this.bytes = new byte[8192];
        this.loadBIOSFromFile();
    }

    @Override
    public void powerOn() {
        this.setControlRegister((byte)0);
        this.tapeOffset = 0;
    }

    @Override
    public void connectBus(BUS bus) {
        this.bus = bus;
    }

    @Override
    public byte readByte(int address) {
        if (this.maskedAddress < 2048) {
            return this.bytes[this.bank0AddressOffset + this.maskedAddress];
        }
        return this.bytes[this.bank1AddressOffset + this.maskedAddress - 2048];
    }

    @Override
    public void writeByte(int address, byte b) {
        if (this.bank1AddressOffset == 6144 && this.maskedAddress >= 3072 && this.maskedAddress < 3328) {
            this.loadPart(this.maskedAddress - 3072);
            return;
        }
    }

    @Override
    protected void performBankSwitchOnMonitoredAccess(int address) {
        this.maskAddress(address);
        if ((address &= 0x1FFF) == 8184) {
            this.setControlRegister(this.valueToWrite);
            return;
        }
        if (this.addressChangeCountdown > 0) {
            if (address != this.lastAddress) {
                this.lastAddress = address;
                if (--this.addressChangeCountdown == 0 && (address & 0x1000) == 4096) {
                    if (this.maskedAddress < 2048) {
                        this.bytes[this.bank0AddressOffset + this.maskedAddress] = this.valueToWrite;
                    } else if (this.bank1AddressOffset < 6144) {
                        this.bytes[this.bank1AddressOffset + this.maskedAddress - 2048] = this.valueToWrite;
                    }
                }
            }
            return;
        }
        if ((address & 0x1000) == 4096 && this.maskedAddress <= 255) {
            this.valueToWrite = (byte)this.maskedAddress;
            if (this.writeEnabled) {
                this.lastAddress = address;
                this.addressChangeCountdown = 5;
            }
        }
    }

    @Override
    public Cartridge8K_64K_AR clone() {
        Cartridge8K_64K_AR clone = (Cartridge8K_64K_AR)super.clone();
        clone.bytes = (byte[])this.bytes.clone();
        clone.header = (byte[])this.header.clone();
        if (this.romPageOffsets != null) {
            clone.romPageOffsets = (byte[])this.romPageOffsets.clone();
        }
        return clone;
    }

    private void setControlRegister(byte controlRegister) {
        int banksConfig = controlRegister >> 2 & 7;
        switch (banksConfig) {
            case 0: {
                this.bank0AddressOffset = 4096;
                this.bank1AddressOffset = 6144;
                break;
            }
            case 1: {
                this.bank0AddressOffset = 0;
                this.bank1AddressOffset = 6144;
                break;
            }
            case 2: {
                this.bank0AddressOffset = 4096;
                this.bank1AddressOffset = 0;
                break;
            }
            case 3: {
                this.bank0AddressOffset = 0;
                this.bank1AddressOffset = 4096;
                break;
            }
            case 4: {
                this.bank0AddressOffset = 4096;
                this.bank1AddressOffset = 6144;
                break;
            }
            case 5: {
                this.bank0AddressOffset = 2048;
                this.bank1AddressOffset = 6144;
                break;
            }
            case 6: {
                this.bank0AddressOffset = 4096;
                this.bank1AddressOffset = 2048;
                break;
            }
            case 7: {
                this.bank0AddressOffset = 2048;
                this.bank1AddressOffset = 4096;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid bank configuration");
            }
        }
        this.addressChangeCountdown = 0;
        this.writeEnabled = (controlRegister & 2) != 0;
        this.biosRomPower = (controlRegister & 1) == 0;
    }

    private void loadPart(int part) {
        boolean tapeRewound = false;
        while (true) {
            if (this.tapeOffset > this.rom.content.length - 1) {
                if (tapeRewound) {
                    if (part == 0) {
                        this.bus.tia.videoOutput().showOSD("Could not load Tape from Start. Not a Start Tape ROM!", true);
                    } else {
                        this.bus.tia.videoOutput().showOSD("Could not find next Part to load in Tape!", true);
                    }
                    this.signalPartLoadedOK(false);
                    return;
                }
                this.tapeOffset = 0;
                tapeRewound = true;
            }
            if (Cartridge8K_64K_AR.peekPartNoOnTape(this.rom.content, this.tapeOffset) == part) {
                if (part == 0) {
                    this.bus.tia.videoOutput().showOSD("Loaded Tape from Start", true);
                } else {
                    this.bus.tia.videoOutput().showOSD("Loaded next Part from Tape", true);
                }
                this.loadNextPart();
                return;
            }
            this.tapeOffset += 8448;
        }
    }

    private void loadNextPart() {
        this.loadHeaderData();
        this.loadPagesIntoBanks();
        this.patchPartDataIntoBIOS();
    }

    private void loadHeaderData() {
        System.arraycopy(this.rom.content, this.tapeOffset + 8192, this.header, 0, this.header.length);
        this.romStartupAddress = this.header[1] << 8 | this.header[0] & 0xFF;
        this.romControlRegister = this.header[2];
        this.romPageCount = this.header[3];
        this.romChecksum = this.header[4];
        this.romMultiLoadIndex = this.header[5];
        this.romProgressBarSpeed = this.header[7] << 8 | this.header[6] & 0xFF;
        this.romPageOffsets = new byte[this.romPageCount];
        System.arraycopy(this.header, 16, this.romPageOffsets, 0, this.romPageCount);
    }

    private void loadPagesIntoBanks() {
        Arrays.fill(this.bytes, 1792, 2047, (byte)0);
        int romOffset = this.tapeOffset;
        byte[] byArray = this.romPageOffsets;
        int n = this.romPageOffsets.length;
        int n2 = 0;
        while (n2 < n) {
            byte pageInfo = byArray[n2];
            int bankOffset = (pageInfo & 3) * 2048;
            int pageOffset = (pageInfo >> 2) * 256;
            if (bankOffset + pageOffset + 255 < 6144) {
                System.arraycopy(this.rom.content, romOffset, this.bytes, bankOffset + pageOffset, 256);
            }
            romOffset += 256;
            ++n2;
        }
        this.tapeOffset += 8448;
    }

    private void patchPartDataIntoBIOS() {
        this.bytes[6913] = this.romControlRegister;
        this.bytes[6912] = this.romMultiLoadIndex;
        this.bytes[6916] = (byte)Randomizer.instance.nextInt();
        this.bytes[6914] = (byte)(this.romStartupAddress & 0xFF);
        this.bytes[6915] = (byte)(this.romStartupAddress >> 8 & 0xFF);
        this.signalPartLoadedOK(true);
    }

    private void signalPartLoadedOK(boolean ok) {
        this.bytes[6917] = (byte)(ok ? 1 : 0);
    }

    private void loadBIOSFromFile() {
        try {
            InputStream stream = this.getClass().getResourceAsStream("StarpathMockBios.bin");
            try {
                int read;
                int totalRead = 0;
                while ((read = stream.read(this.bytes, 6144 + totalRead, 2048 - totalRead)) != -1 && (totalRead += read) < 2048) {
                }
                if (totalRead != 2048) {
                    throw new IllegalStateException("Unexpected EOF");
                }
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not load Starpath BIOS file");
        }
    }

    private static int peekPartNoOnTape(byte[] tapeContent, int tapeOffset) {
        return tapeContent[tapeOffset + 8192 + 5];
    }

    /* synthetic */ Cartridge8K_64K_AR(ROM rOM, Cartridge8K_64K_AR cartridge8K_64K_AR) {
        this(rOM);
    }
}

