/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.network;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.console.Console;
import org.javatari.atari.console.savestate.ConsoleState;
import org.javatari.atari.console.savestate.SaveStateMedia;
import org.javatari.atari.controls.ConsoleControls;
import org.javatari.atari.controls.ConsoleControlsSocket;
import org.javatari.atari.network.ControlChange;
import org.javatari.atari.network.ControlChangeForPaddle;
import org.javatari.atari.network.RemoteReceiver;
import org.javatari.atari.network.ServerUpdate;
import org.javatari.general.board.ClockDriven;

public final class ClientConsole
extends Console
implements ClockDriven {
    private RemoteReceiver remoteReceiver;
    private boolean isPaused = false;
    private static List<ConsoleControls.Control> DISABLED_CONTROLS = Arrays.asList(ConsoleControls.Control.CARTRIDGE_FORMAT);

    public ClientConsole(RemoteReceiver receiver) {
        this.setupReceiver(receiver);
    }

    public RemoteReceiver remoteReceiver() {
        return this.remoteReceiver;
    }

    @Override
    public synchronized void go() {
        this.isPaused = false;
    }

    @Override
    public synchronized void pause() {
        this.isPaused = true;
    }

    @Override
    public void extendedPowerOff() {
        try {
            this.remoteReceiver.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.extendedPowerOff();
    }

    @Override
    protected void mainClockCreate() {
    }

    @Override
    protected void mainClockAdjustToNormal() {
    }

    @Override
    protected void mainClockAdjustToAlternate() {
    }

    @Override
    protected void mainClockDestroy() {
    }

    @Override
    protected void socketsCreate() {
        this.controlsSocket = new ClientConsoleControlsSocketAdapter();
        this.controlsSocket.addForwardedInput(new Console.ConsoleControlsInputAdapter());
        this.controlsSocket.addForwardedInput(this.tia);
        this.controlsSocket.addForwardedInput(this.pia);
        this.cartridgeSocket = new ClientConsoleCartridgeSocketAdapter();
        this.saveStateSocket = new ClientConsoleSaveStateSocketAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clockPulse() {
        while (this.isPaused && this.powerOn) {
            try {
                Thread.sleep(8L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ClientConsole clientConsole = this;
        synchronized (clientConsole) {
            this.tia.clockPulse();
        }
    }

    @Override
    protected void cycleCartridgeFormat() {
    }

    @Override
    protected void powerFry() {
    }

    void connected() {
        this.showOSD("Connected to Player 1 Server", true);
    }

    void disconnected() {
        this.powerOff();
        this.showOSD("Disconnected from Player 1 Server", true);
    }

    void receiveServerUpdate(ServerUpdate update) {
        if (update.powerChange != null) {
            this.receiveServerPower(update.powerChange);
        }
        if (update.consoleState != null) {
            this.receiveServerState(update.consoleState);
        }
        if (update.controlChanges != null) {
            ((ClientConsoleControlsSocketAdapter)this.controlsSocket).serverControlChanges(update.controlChanges);
        }
        if (this.powerOn) {
            this.clockPulse();
        }
    }

    List<ControlChange> controlChangesToSend() {
        return ((ClientConsoleControlsSocketAdapter)this.controlsSocket).getChangesToSend();
    }

    private void receiveServerPower(boolean serverPowerOn) {
        if (serverPowerOn && !this.powerOn) {
            this.powerOn();
        } else if (!serverPowerOn && this.powerOn) {
            this.powerOff();
        }
    }

    private void receiveServerState(ConsoleState state) {
        this.loadState(state);
    }

    private void setupReceiver(RemoteReceiver receiver) {
        this.remoteReceiver = receiver;
        this.remoteReceiver.clientConsole(this);
    }

    private class ClientConsoleCartridgeSocketAdapter
    extends Console.CartridgeSocketAdapter {
        private ClientConsoleCartridgeSocketAdapter() {
        }

        @Override
        public void insert(Cartridge cartridge, boolean autoPower) {
            ClientConsole.this.showOSD("Only the Server can change Cartridges", true);
        }
    }

    private class ClientConsoleControlsSocketAdapter
    extends ConsoleControlsSocket {
        private List<ControlChange> queuedChanges = new ArrayList<ControlChange>();

        private ClientConsoleControlsSocketAdapter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void controlStateChanged(ConsoleControls.Control control, boolean state) {
            if (DISABLED_CONTROLS.contains((Object)control)) {
                ClientConsole.this.showOSD("This function is only available on the Server", true);
                return;
            }
            List<ControlChange> list = this.queuedChanges;
            synchronized (list) {
                this.queuedChanges.add(new ControlChange(control, state));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void controlStateChanged(ConsoleControls.Control control, int position) {
            List<ControlChange> list = this.queuedChanges;
            synchronized (list) {
                this.queuedChanges.add(new ControlChangeForPaddle(control, position));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ControlChange> getChangesToSend() {
            List<ControlChange> list = this.queuedChanges;
            synchronized (list) {
                block4: {
                    if (!this.queuedChanges.isEmpty()) break block4;
                    return null;
                }
                ArrayList<ControlChange> changesToSend = new ArrayList<ControlChange>(this.queuedChanges);
                this.queuedChanges.clear();
                return changesToSend;
            }
        }

        public void serverControlChanges(List<ControlChange> changes) {
            for (ControlChange change : changes) {
                if (change instanceof ControlChangeForPaddle) {
                    super.controlStateChanged(change.control, ((ControlChangeForPaddle)change).position);
                    continue;
                }
                super.controlStateChanged(change.control, change.state);
            }
        }
    }

    private class ClientConsoleSaveStateSocketAdapter
    extends Console.SaveStateSocketAdapter {
        private ClientConsoleSaveStateSocketAdapter() {
        }

        @Override
        public void connectMedia(SaveStateMedia media) {
        }

        @Override
        public void connectCartridge(Cartridge cartridge) {
            cartridge.connectSaveStateSocket(null);
        }
    }
}

