/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.general.m6502.instructions;

import org.javatari.general.m6502.Instruction;
import org.javatari.general.m6502.M6502;

public final class JMP
extends Instruction {
    private final int type;
    private int newPC;
    public static final long serialVersionUID = 1L;

    public JMP(M6502 cpu, int type) {
        super(cpu);
        this.type = type;
    }

    @Override
    public int fetch() {
        if (this.type == 10) {
            this.newPC = this.cpu.fetchAbsoluteAddress();
            return 3;
        }
        if (this.type == 30) {
            this.newPC = this.cpu.fetchIndirectAddress();
            return 5;
        }
        throw new IllegalStateException("JMP Invalid Operand Type: " + this.type);
    }

    @Override
    public void execute() {
        this.cpu.PC = this.newPC;
    }
}

