/*
 * Decompiled with CFR 0.152.
 */
package de.relaunch64.popelganda.Editor;

import de.relaunch64.popelganda.Editor.EditorPaneLineNumbers;
import de.relaunch64.popelganda.Editor.EditorPaneProperties;
import de.relaunch64.popelganda.Editor.FunctionExtractor;
import de.relaunch64.popelganda.Editor.LabelExtractor;
import de.relaunch64.popelganda.Editor.MyUndoManager;
import de.relaunch64.popelganda.Editor.SectionExtractor;
import de.relaunch64.popelganda.Editor.SyntaxHighlighting;
import de.relaunch64.popelganda.Editor.SyntaxScheme;
import de.relaunch64.popelganda.Relaunch64App;
import de.relaunch64.popelganda.Relaunch64View;
import de.relaunch64.popelganda.database.Settings;
import de.relaunch64.popelganda.util.ConstantsR64;
import de.relaunch64.popelganda.util.FileTools;
import de.relaunch64.popelganda.util.Tools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.Utilities;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class EditorPanes {
    private final List<EditorPaneProperties> editorPaneArray = new ArrayList<EditorPaneProperties>();
    private JTabbedPane tabbedPane = null;
    private JComboBox jComboBoxCompiler = null;
    private JComboBox jComboBoxScripts = null;
    private final Relaunch64View mainFrame;
    private final Settings settings;
    private boolean eatReaturn = false;
    private JPopupMenu suggestionPopup = null;
    private JList suggestionList;
    private String suggestionSubWord;
    private static final String sugListContainerName = "sugListContainerName";
    private final ResourceMap resourceMap = Application.getInstance(Relaunch64App.class).getContext().getResourceMap(Relaunch64View.class);
    KeyListener SugestionKeyListener = new KeyAdapter(){

        @Override
        public void keyTyped(KeyEvent evt) {
            int index;
            if (evt.getKeyCode() == 38) {
                evt.consume();
                index = Math.min(EditorPanes.this.suggestionList.getSelectedIndex() - 1, 0);
                EditorPanes.this.suggestionList.setSelectedIndex(index);
            }
            if (evt.getKeyCode() == 40) {
                evt.consume();
                index = Math.min(EditorPanes.this.suggestionList.getSelectedIndex() + 1, EditorPanes.this.suggestionList.getModel().getSize() - 1);
                EditorPanes.this.suggestionList.setSelectedIndex(index);
            }
        }

        @Override
        public void keyReleased(KeyEvent evt) {
            if (evt.getKeyCode() == 10) {
                evt.consume();
                EditorPanes.this.insertSelection();
            }
        }
    };

    public EditorPanes(JTabbedPane tp, JComboBox cbc, JComboBox cbs, Relaunch64View frame, Settings set) {
        this.mainFrame = frame;
        this.settings = set;
        this.editorPaneArray.clear();
        this.tabbedPane = tp;
        this.jComboBoxCompiler = cbc;
        this.jComboBoxScripts = cbs;
    }

    public int addEditorPane(JEditorPane editorPane, File fp, String content, int c, int script) {
        this.setSyntaxScheme(editorPane, c);
        UIDefaults defaults = new UIDefaults();
        defaults.put("EditorPane[Enabled].backgroundPainter", SyntaxScheme.getBackgroundColor());
        editorPane.putClientProperty("Nimbus.Overrides", defaults);
        editorPane.putClientProperty("Nimbus.Overrides.InheritDefaults", true);
        editorPane.setBackground(SyntaxScheme.getBackgroundColor());
        if (content != null && !content.isEmpty()) {
            editorPane.setText(content);
        } else {
            editorPane.setText("");
        }
        editorPane.setFocusTraversalKeys(0, null);
        editorPane.setFocusTraversalKeys(1, null);
        editorPane.setFocusTraversalKeysEnabled(false);
        DocumentListener docListen = this.addDocumentListenerToEditorPane(editorPane);
        MyUndoManager undoman = this.addUndoManagerToEditorPane(editorPane);
        editorPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JEditorPane ep = (JEditorPane)evt.getSource();
                if (9 == evt.getKeyCode() && evt.isControlDown()) {
                    int selected = EditorPanes.this.tabbedPane.getSelectedIndex();
                    if (evt.isShiftDown()) {
                        if (--selected < 0) {
                            selected = EditorPanes.this.tabbedPane.getTabCount() - 1;
                        }
                    } else if (++selected >= EditorPanes.this.tabbedPane.getTabCount()) {
                        selected = 0;
                    }
                    EditorPanes.this.tabbedPane.setSelectedIndex(selected);
                    evt.consume();
                } else if (9 == evt.getKeyCode() && !evt.isShiftDown()) {
                    String selString = ep.getSelectedText();
                    if (selString != null && !selString.isEmpty()) {
                        int selstart = ep.getSelectionStart();
                        int selend = ep.getSelectionEnd();
                        String[] lines = selString.split("\n");
                        StringBuilder sb = new StringBuilder("");
                        for (String l : lines) {
                            sb.append("\t").append(l).append("\n");
                        }
                        ep.replaceSelection(sb.toString());
                        ep.setSelectionStart(selstart);
                        ep.setSelectionEnd(selend + lines.length);
                    } else {
                        try {
                            ep.getDocument().insertString(ep.getCaretPosition(), "\t", null);
                        }
                        catch (BadLocationException ex) {
                            // empty catch block
                        }
                    }
                    evt.consume();
                } else if (9 == evt.getKeyCode() && evt.isShiftDown()) {
                    String selString = ep.getSelectedText();
                    if (selString != null && !selString.isEmpty()) {
                        int selstart = ep.getSelectionStart();
                        int selend = ep.getSelectionEnd();
                        String[] lines = selString.split("\n");
                        StringBuilder sb = new StringBuilder("");
                        for (String l : lines) {
                            l = l.replaceFirst("\t", "");
                            sb.append(l).append("\n");
                        }
                        ep.replaceSelection(sb.toString());
                        ep.setSelectionStart(selstart);
                        ep.setSelectionEnd(selend - lines.length);
                    }
                    evt.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                if (10 == evt.getKeyCode() && !evt.isShiftDown() && !EditorPanes.this.eatReaturn) {
                    EditorPanes.this.autoInsertTab();
                } else if (10 == evt.getKeyCode() && EditorPanes.this.eatReaturn) {
                    EditorPanes.this.eatReaturn = false;
                } else if (evt.getKeyCode() == 32 && evt.isControlDown()) {
                    EditorPanes.this.showSuggestion();
                } else if (Character.isWhitespace(evt.getKeyChar())) {
                    EditorPanes.this.hideSuggestion();
                }
            }
        });
        editorPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                int selection = e.getMark() - e.getDot();
                if (selection != 0) {
                    EditorPanes.this.mainFrame.autoConvertNumbers(EditorPanes.this.getActiveEditorPane().getSelectedText());
                }
            }
        });
        editorPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                if (EditorPanes.this.suggestionPopup != null) {
                    EditorPanes.this.suggestionPopup.setVisible(false);
                    EditorPanes.this.suggestionPopup = null;
                }
            }
        });
        EditorPaneProperties editorPaneProperties = new EditorPaneProperties();
        editorPaneProperties.setEditorPane(editorPane);
        editorPaneProperties.setDocListener(docListen);
        editorPaneProperties.setUndoManager(undoman);
        editorPaneProperties.setFilePath(fp);
        editorPaneProperties.setCompiler(c);
        editorPaneProperties.setScript(script);
        editorPaneProperties.setModified(false);
        this.editorPaneArray.add(editorPaneProperties);
        this.setCursor(editorPane);
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
        return this.editorPaneArray.size();
    }

    private void autoInsertTab() {
        JEditorPane ep = this.getActiveEditorPane();
        try {
            int caret = ep.getCaretPosition();
            int rowstart = Utilities.getRowStart(ep, caret);
            int prevrow = Utilities.getRowStart(ep, rowstart - 1);
            if (prevrow >= 0) {
                char c;
                int offlen = rowstart - prevrow;
                String line = ep.getText(prevrow, offlen);
                StringBuilder tabs = new StringBuilder("");
                for (int i = 0; i < offlen && (' ' == (c = line.charAt(i)) || '\t' == c); ++i) {
                    tabs.append(c);
                }
                ep.getDocument().insertString(caret, tabs.toString(), null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public int getCurrentRow() {
        JEditorPane ep = this.getActiveEditorPane();
        int caretPosition = ep.getCaretPosition();
        return this.getRow(ep, caretPosition);
    }

    public int getRow(JEditorPane ep, int caretPosition) {
        return ep != null ? ep.getDocument().getDefaultRootElement().getElementIndex(caretPosition) : 0;
    }

    public int getColumn(JEditorPane ep) {
        int caretPosition;
        int oriCaret = caretPosition = ep.getCaretPosition();
        int currentLine = ep.getDocument().getDefaultRootElement().getElementIndex(caretPosition);
        while (currentLine == ep.getDocument().getDefaultRootElement().getElementIndex(caretPosition) && caretPosition >= 0) {
            --caretPosition;
        }
        return oriCaret - caretPosition;
    }

    public int getLineNumber(JEditorPane ep, int caretPosition) {
        return this.getRow(ep, caretPosition);
    }

    public int getCurrentLineNumber() {
        return this.getCurrentRow() + 1;
    }

    public void gotoLineFromCaret(int caretpos) {
        JEditorPane ep = this.getActiveEditorPane();
        this.gotoLine(ep, this.getRow(ep, caretpos));
    }

    public boolean gotoLine(int line) {
        return this.gotoLine(this.getActiveEditorPane(), line);
    }

    public boolean gotoLine(JEditorPane ep, int line) {
        if (line > 0) {
            --line;
            if (ep != null) {
                try {
                    Element e = ep.getDocument().getDefaultRootElement().getElement(line);
                    if (e != null) {
                        int caret = e.getStartOffset();
                        ep.setCaretPosition(caret);
                        ep.scrollRectToVisible(ep.modelToView(caret));
                        e = ep.getDocument().getDefaultRootElement().getElement(line - 10);
                        if (e != null) {
                            caret = e.getStartOffset();
                        }
                        ep.scrollRectToVisible(ep.modelToView(caret));
                        e = ep.getDocument().getDefaultRootElement().getElement(line + 10);
                        if (e != null) {
                            caret = e.getStartOffset();
                        }
                        ep.scrollRectToVisible(ep.modelToView(caret));
                        ep.requestFocusInWindow();
                        return true;
                    }
                }
                catch (IllegalArgumentException | IndexOutOfBoundsException | BadLocationException exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public void undo() {
        EditorPaneProperties ep = this.getActiveEditorPaneProperties();
        if (ep != null) {
            ep.getUndoManager().undo();
            this.setFocus();
        }
    }

    public void redo() {
        EditorPaneProperties ep = this.getActiveEditorPaneProperties();
        if (ep != null) {
            ep.getUndoManager().redo();
            this.setFocus();
        }
    }

    private void setCursor(JEditorPane editorPane) {
        editorPane.requestFocusInWindow();
        try {
            editorPane.setCaretPosition(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private DocumentListener addDocumentListenerToEditorPane(JEditorPane editorPane) {
        DocumentListener docListen = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                EditorPanes.this.setModified(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditorPanes.this.setModified(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditorPanes.this.setModified(true);
            }
        };
        editorPane.getDocument().addDocumentListener(docListen);
        return docListen;
    }

    private MyUndoManager addUndoManagerToEditorPane(JEditorPane editorPane) {
        MyUndoManager undomanager = new MyUndoManager();
        editorPane.getDocument().addUndoableEditListener(undomanager);
        return undomanager;
    }

    private void removeDocumentListenerFromEditorPane(EditorPaneProperties editorPaneProp) {
        JEditorPane editorPane = editorPaneProp.getEditorPane();
        DocumentListener docListen = editorPaneProp.getDocListener();
        if (editorPane != null && docListen != null) {
            editorPane.getDocument().removeDocumentListener(docListen);
            editorPaneProp.setDocListener(null);
        }
    }

    private void removeUndoManagerFromEditorPane(EditorPaneProperties editorPaneProp) {
        JEditorPane editorPane = editorPaneProp.getEditorPane();
        MyUndoManager undomanager = editorPaneProp.getUndoManager();
        if (editorPane != null && undomanager != null) {
            editorPane.getDocument().removeUndoableEditListener(undomanager);
            editorPaneProp.setUndoManager(null);
        }
    }

    private JEditorPane setSyntaxScheme(JEditorPane editorPane, int c) {
        final int compiler = c;
        final HashMap<String, MutableAttributeSet> kw = SyntaxScheme.getKeywordHashMap();
        final HashMap<String, MutableAttributeSet> ckw = SyntaxScheme.getCompilerKeywordHashMap(compiler);
        final HashMap<String, MutableAttributeSet> io = SyntaxScheme.getIllegalOpcodeHashMap();
        StyledEditorKit editorKit = new StyledEditorKit(){

            @Override
            public Document createDefaultDocument() {
                return new SyntaxHighlighting(kw, ckw, io, SyntaxScheme.getFontName(), SyntaxScheme.getFontSize(), SyntaxScheme.getCommentString(compiler), SyntaxScheme.getDelimiterList(compiler), SyntaxScheme.getStyleAttributes(), compiler, EditorPanes.this.settings.getTabWidth());
            }
        };
        editorPane.setEditorKitForContentType("text/plain", editorKit);
        editorPane.setContentType("text/plain");
        return editorPane;
    }

    public String getCompilerCommentString() {
        return this.getCompilerCommentString(this.getActiveCompiler());
    }

    public String getCompilerCommentString(int compiler) {
        return SyntaxScheme.getCommentString(compiler);
    }

    public void insertSection(String name) {
        this.eatReaturn = true;
        ArrayList names = SectionExtractor.getSectionNames(this.getActiveSourceCode(), this.getCompilerCommentString());
        if (null == names || names.isEmpty() || !names.contains(name)) {
            JEditorPane ep = this.getActiveEditorPane();
            Element e = ep.getDocument().getDefaultRootElement().getElement(this.getCurrentLineNumber() - 1);
            if (e != null) {
                try {
                    String insertString = this.getCompilerCommentString() + " ----- @" + name + "@ -----" + System.getProperty("line.separator");
                    ep.getDocument().insertString(e.getStartOffset(), insertString, SyntaxScheme.DEFAULT_COMMENT);
                }
                catch (BadLocationException ex) {}
            }
        } else {
            ConstantsR64.r64logger.log(Level.WARNING, "Section name already exists. Could not insert section.");
        }
    }

    public void gotoSection(String name) {
        this.gotoLine(SectionExtractor.getSections(this.getActiveSourceCode(), this.getCompilerCommentString()), name);
    }

    public void gotoSection(String name, int index) {
        this.gotoLine(SectionExtractor.getSections(this.getSourceCode(index), this.getCompilerCommentString()), name);
    }

    public void gotoLabel(String name) {
        this.gotoLine(LabelExtractor.getLabels(this.getActiveSourceCode(), this.getActiveCompiler()), name);
    }

    public void gotoLabel(String name, int index) {
        this.gotoLine(LabelExtractor.getLabels(this.getSourceCode(index), this.getActiveCompiler()), name);
    }

    public void gotoFunction(String name) {
        this.gotoLine(FunctionExtractor.getFunctions(this.getActiveSourceCode(), this.getActiveCompiler()), name);
    }

    public void gotoFunction(String name, int index) {
        this.gotoLine(FunctionExtractor.getFunctions(this.getSourceCode(index), this.getActiveCompiler()), name);
    }

    public void gotoMacro(String name) {
        this.gotoLine(FunctionExtractor.getMacros(this.getActiveSourceCode(), this.getActiveCompiler()), name);
    }

    public void gotoMacro(String name, int index) {
        this.gotoLine(FunctionExtractor.getMacros(this.getSourceCode(index), this.getActiveCompiler()), name);
    }

    public boolean checkIfSyntaxChangeRequired() {
        int selectedComp = this.jComboBoxCompiler.getSelectedIndex();
        int selectedTab = this.tabbedPane.getSelectedIndex();
        return this.editorPaneArray.get(selectedTab).getCompiler() != selectedComp;
    }

    public void changeSyntaxScheme(int compiler, int script) {
        int selectedTab = this.tabbedPane.getSelectedIndex();
        if (selectedTab != -1) {
            EditorPaneProperties ep = this.editorPaneArray.get(selectedTab);
            if (this.getActiveFilePath() != null) {
                int rd = this.settings.findRecentDoc(this.getActiveFilePath().getPath());
                this.settings.setRecentDoc(rd, this.getActiveFilePath().getPath(), compiler, script);
            }
            JEditorPane editorpane = ep.getEditorPane();
            this.removeDocumentListenerFromEditorPane(ep);
            this.removeUndoManagerFromEditorPane(ep);
            String text = editorpane.getText();
            this.setSyntaxScheme(editorpane, compiler);
            editorpane.setText(text);
            ep.setDocListener(this.addDocumentListenerToEditorPane(editorpane));
            ep.setUndoManager(this.addUndoManagerToEditorPane(editorpane));
            ep.setCompiler(compiler);
            this.setCursor(editorpane);
        }
    }

    public int addNewTab(File fp, String content, String title, int compiler, int script) {
        JScrollPane scrollPane = new JScrollPane();
        JEditorPane editorPane = new JEditorPane();
        editorPane.setName("jEditorPaneMain");
        EditorPaneLineNumbers epln = new EditorPaneLineNumbers(editorPane, this.settings);
        scrollPane.setRowHeaderView(epln);
        editorPane.setDragEnabled(true);
        DropTarget dropTarget = new DropTarget(editorPane, this.mainFrame);
        scrollPane.setViewportView(editorPane);
        this.tabbedPane.addTab(title, scrollPane);
        if (fp != null && fp.exists()) {
            this.tabbedPane.setToolTipTextAt(this.tabbedPane.getTabCount() - 1, fp.getPath());
        }
        return this.addEditorPane(editorPane, fp, content, compiler, script);
    }

    public JEditorPane getActiveEditorPane() {
        return this.getEditorPane(this.tabbedPane.getSelectedIndex());
    }

    public JEditorPane getEditorPane(int index) {
        try {
            EditorPaneProperties ep = this.editorPaneArray.get(index);
            return ep.getEditorPane();
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public String getActiveSourceCode() {
        return this.getSourceCode(this.getActiveEditorPane());
    }

    public String getSourceCode(int index) {
        JEditorPane ep = this.getEditorPane(index);
        if (ep != null) {
            return ep.getText();
        }
        return null;
    }

    public String getSourceCode(JEditorPane ep) {
        if (ep != null) {
            return ep.getText();
        }
        return null;
    }

    public void setSourceCode(int index, String source) {
        JEditorPane ep = this.getEditorPane(index);
        if (ep != null) {
            ep.setText(source);
        }
    }

    public void setSourceCode(String source) {
        this.setSourceCode(this.tabbedPane.getSelectedIndex(), source);
    }

    public int getActiveCompiler() {
        return this.getCompiler(this.tabbedPane.getSelectedIndex());
    }

    public int getCompiler(int index) {
        try {
            EditorPaneProperties ep = this.editorPaneArray.get(index);
            return ep.getCompiler();
        }
        catch (IndexOutOfBoundsException ex) {
            return 0;
        }
    }

    public int getScript(int index) {
        try {
            EditorPaneProperties ep = this.editorPaneArray.get(index);
            return ep.getScript();
        }
        catch (IndexOutOfBoundsException ex) {
            return -1;
        }
    }

    public File getActiveFilePath() {
        return this.getFilePath(this.tabbedPane.getSelectedIndex());
    }

    public File getFilePath(int index) {
        if (index != -1) {
            EditorPaneProperties ep = this.editorPaneArray.get(index);
            return ep.getFilePath();
        }
        return null;
    }

    public EditorPaneProperties getActiveEditorPaneProperties() {
        return this.getEditorPaneProperties(this.tabbedPane.getSelectedIndex());
    }

    public EditorPaneProperties getEditorPaneProperties(int selectedTab) {
        try {
            EditorPaneProperties ep = this.editorPaneArray.get(selectedTab);
            return ep;
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public void setFocus() {
        JEditorPane ep = this.getActiveEditorPane();
        if (ep != null) {
            ep.requestFocusInWindow();
        }
    }

    private void setModified(boolean m) {
        int selectedTab = this.tabbedPane.getSelectedIndex();
        try {
            String title = this.tabbedPane.getTitleAt(selectedTab);
            if (m) {
                if (!title.startsWith("*")) {
                    title = "* " + title;
                    this.tabbedPane.setTitleAt(selectedTab, title);
                }
                this.editorPaneArray.get(selectedTab).setModified(m);
            } else {
                if (title.startsWith("* ")) {
                    title = title.substring(2);
                    this.tabbedPane.setTitleAt(selectedTab, title);
                }
                this.editorPaneArray.get(selectedTab).setModified(m);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            ConstantsR64.r64logger.log(Level.WARNING, ex.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadFile(File filepath, int compiler, int script) {
        int opened = this.getOpenedFileTab(filepath);
        if (opened != -1) {
            this.tabbedPane.setSelectedIndex(opened);
            return false;
        }
        int selectedTab = this.tabbedPane.getSelectedIndex();
        if (selectedTab == -1) return false;
        try {
            if (filepath == null) return false;
            if (!filepath.exists()) return false;
            byte[] buffer = new byte[(int)filepath.length()];
            try {
                block18: {
                    FileInputStream in;
                    block19: {
                        in = new FileInputStream(filepath);
                        Throwable throwable = null;
                        try {
                            ((InputStream)in).read(buffer);
                            if (in == null) break block18;
                            if (throwable == null) break block19;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (in == null) throw throwable4;
                                if (throwable == null) {
                                    ((InputStream)in).close();
                                    throw throwable4;
                                }
                                try {
                                    ((InputStream)in).close();
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                    throw throwable4;
                                }
                            }
                        }
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    ((InputStream)in).close();
                }
            }
            catch (IOException ex) {
                ConstantsR64.r64logger.log(Level.WARNING, ex.getLocalizedMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                boolean updateTabPane = this.closeInitialTab();
                selectedTab = this.addNewTab(filepath, new String(buffer), this.getFileName(filepath), compiler, script) - 1;
                if (updateTabPane) {
                    this.updateTabbedPane();
                }
                this.setCursor(this.editorPaneArray.get(selectedTab).getEditorPane());
                return true;
            }
        }
        catch (IndexOutOfBoundsException ex) {
            ConstantsR64.r64logger.log(Level.WARNING, ex.getLocalizedMessage());
            return false;
        }
    }

    public int getOpenedFileTab(File fp) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            File opened = this.editorPaneArray.get(i).getFilePath();
            if (opened == null || !opened.equals(fp)) continue;
            return i;
        }
        return -1;
    }

    private boolean closeInitialTab() {
        File f = this.editorPaneArray.get(0).getFilePath();
        String t = this.tabbedPane.getTitleAt(0);
        String c = this.editorPaneArray.get(0).getEditorPane().getText();
        boolean m = this.editorPaneArray.get(0).isModified();
        if (null == f && t.equalsIgnoreCase("untitled") && (null == c || c.isEmpty()) && !m) {
            try {
                this.editorPaneArray.remove(0);
                this.tabbedPane.remove(0);
                return true;
            }
            catch (IndexOutOfBoundsException | UnsupportedOperationException ex) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean saveFile(File filepath) {
        return this.saveFile(this.tabbedPane.getSelectedIndex(), filepath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveFile(int selectedTab, File filepath, boolean ignoreModified) {
        if (selectedTab != -1) {
            if (!ignoreModified && !this.editorPaneArray.get(selectedTab).isModified()) {
                return true;
            }
            if (filepath != null && filepath.exists()) {
                Writer fw = null;
                try {
                    String content = this.editorPaneArray.get(selectedTab).getEditorPane().getText();
                    fw = new FileWriter(filepath);
                    fw.write(content);
                }
                catch (IOException ex) {
                    ConstantsR64.r64logger.log(Level.WARNING, ex.getLocalizedMessage());
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (fw != null) {
                        try {
                            fw.close();
                            this.setModified(false);
                            this.setTabTitle(selectedTab, filepath);
                            this.editorPaneArray.get(selectedTab).setFilePath(filepath);
                        }
                        catch (IOException ex) {
                            ConstantsR64.r64logger.log(Level.WARNING, ex.getLocalizedMessage());
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    public boolean saveFile() {
        int selectedTab = this.tabbedPane.getSelectedIndex();
        if (selectedTab != -1) {
            File fp = this.editorPaneArray.get(selectedTab).getFilePath();
            if (fp != null && fp.exists()) {
                return this.saveFile(fp);
            }
            return this.saveFileAs();
        }
        return false;
    }

    public boolean saveAllFiles() {
        boolean allOk = true;
        for (int i = 0; i < this.getCount(); ++i) {
            File fp = this.editorPaneArray.get(i).getFilePath();
            if (fp != null && fp.exists()) {
                if (this.saveFile(i, fp, false)) continue;
                allOk = false;
                continue;
            }
            if (this.saveFileAs(i)) continue;
            allOk = false;
        }
        return allOk;
    }

    public boolean saveFileAs() {
        return this.saveFileAs(this.tabbedPane.getSelectedIndex());
    }

    public boolean saveFileAs(int selectedTab) {
        if (selectedTab != -1) {
            File fileToSave;
            File fp = this.editorPaneArray.get(selectedTab).getFilePath();
            String fpath = "";
            String fname = "";
            if (null != fp) {
                fpath = fp.getPath();
                fname = fp.getName();
            }
            if ((fileToSave = FileTools.chooseFile(null, 1, 0, fpath, fname, "Save ASM File", ConstantsR64.FILE_EXTENSIONS, "ASM-Files")) != null) {
                if (!FileTools.hasValidFileExtension(fileToSave)) {
                    fileToSave = new File(fileToSave.getPath() + ".asm");
                }
                if (!fileToSave.exists()) {
                    try {
                        if (fileToSave.createNewFile()) {
                            this.eatReaturn = true;
                            return this.saveFile(selectedTab, fileToSave, true);
                        }
                        return false;
                    }
                    catch (IOException ex) {
                        ConstantsR64.r64logger.log(Level.WARNING, ex.getLocalizedMessage());
                    }
                } else {
                    int optionDocExists = JOptionPane.showConfirmDialog(null, this.resourceMap.getString("askForOverwriteFileMsg", new Object[0]), this.resourceMap.getString("askForOverwriteFileTitle", new Object[0]), 0, -1);
                    if (optionDocExists != 0) {
                        return false;
                    }
                    return this.saveFile(selectedTab, fileToSave, true);
                }
            }
        }
        return false;
    }

    private void setTabTitle(int index, File fp) {
        String fn = this.getFileName(fp);
        if (fn != null) {
            this.tabbedPane.setTitleAt(index, fn);
            this.tabbedPane.setToolTipTextAt(index, fp.getPath());
        } else {
            this.tabbedPane.setTitleAt(index, "untitled");
            this.tabbedPane.setToolTipTextAt(index, "");
        }
    }

    public void updateTabbedPane() {
        int selectedTab = this.tabbedPane.getSelectedIndex();
        if (selectedTab != -1 && !this.editorPaneArray.isEmpty()) {
            try {
                this.jComboBoxCompiler.setSelectedIndex(this.editorPaneArray.get(selectedTab).getCompiler());
                this.jComboBoxScripts.setSelectedIndex(this.editorPaneArray.get(selectedTab).getScript());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private String getFileName(File f) {
        String fname;
        int extpos;
        if (f != null && f.exists() && (extpos = (fname = f.getName()).lastIndexOf(".")) != -1) {
            return fname.substring(0, extpos);
        }
        return null;
    }

    public int getCount() {
        return null == this.editorPaneArray ? 0 : this.editorPaneArray.size();
    }

    public boolean isModified() {
        return this.isModified(this.tabbedPane.getSelectedIndex());
    }

    public boolean isModified(int selectedTab) {
        EditorPaneProperties ep = this.getEditorPaneProperties(selectedTab);
        if (ep != null) {
            return ep.isModified();
        }
        return false;
    }

    public boolean closeFile() {
        EditorPaneProperties ep = this.getActiveEditorPaneProperties();
        if (ep != null) {
            if (ep.isModified()) {
                int option = JOptionPane.showConfirmDialog(null, this.resourceMap.getString("msgSaveChanges", new Object[0]), this.resourceMap.getString("msgSaveChangesTitle", new Object[0]), 1, -1);
                if (2 == option || -1 == option) {
                    return false;
                }
                if (0 == option && !this.saveFile()) {
                    return false;
                }
            }
            int selectedTab = this.tabbedPane.getSelectedIndex();
            try {
                this.editorPaneArray.remove(selectedTab);
                return true;
            }
            catch (IndexOutOfBoundsException | UnsupportedOperationException runtimeException) {
                // empty catch block
            }
        }
        return false;
    }

    public void insertSeparatorLine() {
        this.eatReaturn = true;
        JEditorPane ep = this.getActiveEditorPane();
        Element e = ep.getDocument().getDefaultRootElement().getElement(this.getCurrentLineNumber() - 1);
        if (e != null) {
            try {
                String insertString = this.getCompilerCommentString() + " ----------------------------------------" + System.getProperty("line.separator");
                ep.getDocument().insertString(e.getStartOffset(), insertString, SyntaxScheme.DEFAULT_COMMENT);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void insertBreakPoint(int compiler) {
        JEditorPane ep = this.getActiveEditorPane();
        Element e = ep.getDocument().getDefaultRootElement().getElement(this.getCurrentLineNumber() - 1);
        if (e != null) {
            try {
                String insertString = "";
                switch (compiler) {
                    case 0: {
                        insertString = ":break()" + System.getProperty("line.separator");
                    }
                }
                ep.getDocument().insertString(e.getStartOffset(), insertString, null);
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
    }

    public void insertBreakPoint() {
        this.insertBreakPoint(this.getActiveCompiler());
    }

    public void preventAutoInsertTab() {
        this.eatReaturn = true;
    }

    protected void showSuggestion() {
        block7: {
            this.hideSuggestion();
            try {
                Point location;
                this.suggestionSubWord = this.getCaretString(false);
                if (null == this.suggestionSubWord) {
                    return;
                }
                JEditorPane ep = this.getActiveEditorPane();
                Object[] labels = LabelExtractor.getLabelNames(this.suggestionSubWord.trim(), true, this.getActiveSourceCode(), this.getActiveCompiler());
                if (labels == null || labels.length <= 0) break block7;
                try {
                    int position = ep.getCaretPosition();
                    location = ep.modelToView(position).getLocation();
                }
                catch (BadLocationException e2) {
                    return;
                }
                this.suggestionPopup = new JPopupMenu();
                this.suggestionPopup.removeAll();
                this.suggestionPopup.setOpaque(false);
                this.suggestionPopup.setBorder(null);
                this.suggestionList = this.createSuggestionList(labels);
                if (labels.length > 20) {
                    JScrollPane listScrollPane = new JScrollPane(this.suggestionList);
                    listScrollPane.setBorder(null);
                    listScrollPane.setPreferredSize(new Dimension(150, 300));
                    listScrollPane.setName(sugListContainerName);
                    this.suggestionPopup.add((Component)listScrollPane, "Center");
                } else {
                    this.suggestionPopup.add((Component)this.suggestionList, "Center");
                }
                this.suggestionPopup.show(ep, location.x, ep.getBaseline(0, 0) + location.y);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EditorPanes.this.suggestionList.requestFocusInWindow();
                    }
                });
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    protected void hideSuggestion() {
        if (this.suggestionPopup != null) {
            this.suggestionPopup.setVisible(false);
            this.suggestionPopup = null;
        }
        this.getActiveEditorPane().requestFocusInWindow();
    }

    protected JList createSuggestionList(Object[] labels) {
        JList<Object> sList = new JList<Object>(labels);
        sList.setSelectionMode(0);
        sList.setSelectedIndex(0);
        sList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    EditorPanes.this.insertSelection();
                }
            }
        });
        sList.addKeyListener(this.SugestionKeyListener);
        return sList;
    }

    protected boolean insertSelection() {
        if (this.suggestionList.getSelectedValue() != null) {
            try {
                JEditorPane ep = this.getActiveEditorPane();
                String selectedSuggestion = ((String)this.suggestionList.getSelectedValue()).substring(this.suggestionSubWord.length());
                ep.getDocument().insertString(ep.getCaretPosition(), selectedSuggestion, null);
                ep.requestFocusInWindow();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (EditorPanes.this.suggestionPopup != null) {
                            EditorPanes.this.suggestionPopup.setVisible(false);
                        }
                    }
                });
                return true;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    public String getCaretString(boolean wholeWord) {
        int start;
        String addDelim;
        String text;
        JEditorPane ep = this.getActiveEditorPane();
        int position = ep.getCaretPosition();
        try {
            text = wholeWord ? ep.getDocument().getText(0, ep.getDocument().getLength()) : ep.getDocument().getText(0, position);
        }
        catch (BadLocationException ex) {
            return null;
        }
        switch (this.getActiveCompiler()) {
            case 1: 
            case 2: {
                addDelim = "\n\r:";
                break;
            }
            default: {
                addDelim = "\n\r";
            }
        }
        for (start = Math.max(0, position - 1); start > 0; --start) {
            if (!Character.isWhitespace(text.charAt(start)) && !Tools.isDelimiter(text.substring(start, start + 1), addDelim)) {
                continue;
            }
            ++start;
            break;
        }
        if (start > position) {
            return null;
        }
        if (wholeWord) {
            int end;
            for (end = start; end < text.length() && !Character.isWhitespace(text.charAt(end)) && !Tools.isDelimiter(text.substring(end, end + 1), addDelim); ++end) {
            }
            return text.substring(start, end);
        }
        return text.substring(start, position);
    }

    protected boolean gotoLine(LinkedHashMap<Integer, String> map, String name) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Integer> lines = new ArrayList<Integer>();
        if (map != null && !map.isEmpty() && name != null && !name.isEmpty()) {
            Collection<String> c = map.values();
            Iterator<String> i = c.iterator();
            while (i.hasNext()) {
                names.add(i.next());
            }
            Set<Integer> ks = map.keySet();
            Iterator<Integer> ksi = ks.iterator();
            while (ksi.hasNext()) {
                lines.add(ksi.next());
            }
            int pos = names.indexOf(name);
            if (pos != -1) {
                return this.gotoLine((Integer)lines.get(pos));
            }
        }
        return false;
    }

    public void insertString(String text) {
        this.insertString(text, this.getActiveEditorPane().getCaretPosition());
    }

    public void insertString(String text, int position) {
        JEditorPane ep = this.getActiveEditorPane();
        try {
            ep.getDocument().insertString(position, text, null);
            ep.requestFocusInWindow();
        }
        catch (BadLocationException ex) {
            // empty catch block
        }
    }

    public void commentLine() {
        this.commentLine(this.getActiveEditorPane(), this.getActiveCompiler());
    }

    public void commentLine(JEditorPane ep, int compiler) {
        String commentString = SyntaxScheme.getCommentString(compiler);
        String selString = ep.getSelectedText();
        if (selString != null && !selString.isEmpty()) {
            int selstart = ep.getSelectionStart();
            int selend = ep.getSelectionEnd();
            String[] lines = selString.split("\n");
            int countNewLines = Tools.countMatches(selString, '\n');
            StringBuilder sb = new StringBuilder("");
            int chardiff = 0;
            for (String l : lines) {
                if (l.trim().startsWith(commentString)) {
                    l = l.replaceFirst(Pattern.quote(commentString), "");
                    chardiff -= commentString.length();
                } else {
                    l = commentString + l;
                    chardiff += commentString.length();
                }
                sb.append(l);
                if (countNewLines > 0) {
                    sb.append("\n");
                }
                --countNewLines;
            }
            ep.replaceSelection(sb.toString());
            ep.setSelectionStart(selstart);
            ep.setSelectionEnd(selend + chardiff);
        }
    }
}

