/*
 * Decompiled with CFR 0.152.
 */
package de.relaunch64.popelganda.Editor;

import de.relaunch64.popelganda.Editor.EditorPanes;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public class InsertBreakPoint {
    private static final String lb = System.getProperty("line.separator");
    public static final String breakPointMacro = lb + "//----------------------------------------------------------" + lb + "// Breakpoint Macro" + lb + "//----------------------------------------------------------" + lb + ".var _createDebugFiles = debug && cmdLineVars.get(\"afo\") == \"true\"" + lb + ".print \"File creation \" + [_createDebugFiles" + lb + "    ? \"enabled (creating breakpoint file)\"" + lb + "    : \"disabled (no breakpoint file created)\"]" + lb + ".var brkFile" + lb + ".if(_createDebugFiles) {" + lb + "    .eval brkFile = createFile(\"breakpoints.txt\")" + lb + "    }" + lb + ".macro break() {" + lb + ".if(_createDebugFiles) {" + lb + "    .eval brkFile.writeln(\"break \" + toHexString(*))" + lb + "    }" + lb + "}" + lb + "//------------------------------------------------------" + lb;

    public static void insertBreakPoint(EditorPanes editorPane) {
        if (null == editorPane) {
            return;
        }
        if (editorPane.getActiveCompiler() != 0) {
            JOptionPane.showMessageDialog(null, "Breakpoints are currently only supported under KickAssembler!");
            return;
        }
        boolean addMacro = false;
        if (!InsertBreakPoint.sourceHasBreakpointMacro(editorPane.getActiveSourceCode(), editorPane.getActiveCompiler())) {
            int option = JOptionPane.showConfirmDialog(null, "The breakpoint function requires a macro to be added to the source.\nWithout this macro, breakpoints won't work.\n\nDo you want to add this macro now to the end of the source?", "Insert Breakpoint", 1, -1);
            if (option == 2) {
                return;
            }
            if (option == 0) {
                addMacro = true;
            }
        }
        editorPane.insertBreakPoint();
        if (addMacro) {
            int endpos = editorPane.getActiveEditorPane().getDocument().getLength();
            editorPane.insertString(breakPointMacro, endpos);
        }
    }

    public static boolean sourceHasBreakpointMacro(String source, int compiler) {
        switch (compiler) {
            case 0: {
                return source != null && source.contains(".macro break()");
            }
        }
        return false;
    }

    public static void removeBreakPoints(EditorPanes editorPane) {
        if (null == editorPane) {
            return;
        }
        String source = editorPane.getActiveSourceCode();
        String bpm1 = ":break()\n";
        String bpm2 = ":break()\r\n";
        source = source.replaceAll(Pattern.quote(breakPointMacro), "");
        source = source.replace(bpm1, "").replace(bpm2, "");
        editorPane.setSourceCode(source);
    }
}

