/*
 * Decompiled with CFR 0.152.
 */
package de.relaunch64.popelganda.Editor;

import de.relaunch64.popelganda.Editor.SyntaxScheme;
import de.relaunch64.popelganda.util.Tools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public class LabelExtractor {
    public static boolean isValidLabel(String keyword, int compiler) {
        return !(keyword = keyword.trim()).startsWith(SyntaxScheme.getMacroString(compiler)) && !keyword.startsWith(SyntaxScheme.getCommentString(compiler)) && !keyword.startsWith("$") && !keyword.startsWith("#");
    }

    public static String getLabelFromLine(String line, int compiler, boolean removeLastColon) {
        if (LabelExtractor.isValidLabel(line = line.trim(), compiler)) {
            String keyword;
            String addDelim;
            int i = 0;
            switch (compiler) {
                case 1: 
                case 2: {
                    addDelim = ":";
                    break;
                }
                case 0: {
                    addDelim = "";
                    break;
                }
                default: {
                    addDelim = "";
                }
            }
            try {
                while (!Tools.isDelimiter(line.substring(i, i + 1), addDelim) && i < line.length()) {
                    ++i;
                }
                keyword = line.substring(0, i);
            }
            catch (IndexOutOfBoundsException ex) {
                keyword = line.substring(0, line.length());
            }
            if (keyword.endsWith(":") && removeLastColon) {
                keyword = keyword.substring(0, keyword.length() - 1);
            }
            if (keyword != null && !keyword.isEmpty() && keyword.length() > 2 && !SyntaxScheme.getKeywordHashMap().containsKey(keyword.toUpperCase())) {
                return keyword;
            }
        }
        return null;
    }

    public static Object[] getLabelNames(String subWord, boolean removeLastColon, String source, int compiler) {
        ArrayList labels = LabelExtractor.getLabelNames(false, removeLastColon, source, compiler);
        if (null == labels || labels.isEmpty()) {
            return null;
        }
        if (!subWord.isEmpty()) {
            for (int i = labels.size() - 1; i >= 0; --i) {
                if (((String)labels.get(i)).startsWith(subWord)) continue;
                labels.remove(i);
            }
        }
        Collections.sort(labels);
        return labels.toArray();
    }

    public static ArrayList getLabelNames(boolean sortList, boolean removeLastColon, String source, int compiler) {
        ArrayList<String> labelValues = new ArrayList<String>();
        if (source != null) {
            BufferedReader br = new BufferedReader(new StringReader(source));
            LineNumberReader lineReader = new LineNumberReader(br);
            try {
                String line;
                while ((line = lineReader.readLine()) != null) {
                    String keyword = LabelExtractor.getLabelFromLine(line, compiler, removeLastColon);
                    if (keyword == null || labelValues.contains(keyword)) continue;
                    labelValues.add(keyword);
                }
                if (sortList) {
                    Collections.sort(labelValues);
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return labelValues;
    }

    public static LinkedHashMap getLabels(String source, int compiler) {
        LinkedHashMap<Integer, String> labelValues = new LinkedHashMap<Integer, String>();
        int lineNumber = 0;
        if (source != null) {
            BufferedReader br = new BufferedReader(new StringReader(source));
            LineNumberReader lineReader = new LineNumberReader(br);
            try {
                String line;
                while ((line = lineReader.readLine()) != null) {
                    ++lineNumber;
                    String keyword = LabelExtractor.getLabelFromLine(line, compiler, false);
                    if (keyword == null || labelValues.containsValue(keyword)) continue;
                    labelValues.put(lineNumber, keyword);
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return labelValues;
    }

    public static ArrayList getLabelLineNumbers(String source, int compiler) {
        ArrayList retval = new ArrayList();
        LinkedHashMap map = LabelExtractor.getLabels(source, compiler);
        if (map != null && !map.isEmpty()) {
            Set ks = map.keySet();
            Iterator i = ks.iterator();
            while (i.hasNext()) {
                retval.add(i.next());
            }
            return retval;
        }
        return null;
    }
}

