/*
 * Decompiled with CFR 0.152.
 */
package de.relaunch64.popelganda.Editor;

import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class MyUndoManager
extends UndoManager
implements UndoableEditListener {
    private final UndoManager undomanager = new UndoManager();
    private boolean registerUndoEvents = true;

    public MyUndoManager() {
        this.undomanager.setLimit(1000);
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        if (this.registerUndoEvents) {
            AbstractDocument.DefaultDocumentEvent de;
            if (e.getEdit() instanceof AbstractDocument.DefaultDocumentEvent && (de = (AbstractDocument.DefaultDocumentEvent)e.getEdit()).getType() == DocumentEvent.EventType.CHANGE) {
                e.getEdit().die();
                return;
            }
            this.undomanager.addEdit(e.getEdit());
        }
    }

    public void enableRegisterUndoEvents(boolean enable) {
        this.registerUndoEvents = enable;
    }

    @Override
    public void undo() {
        try {
            if (this.undomanager.canUndo()) {
                this.undomanager.undo();
            }
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    @Override
    public void redo() {
        try {
            if (this.undomanager.canRedo()) {
                this.undomanager.redo();
            }
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }

    @Override
    public boolean canUndo() {
        return this.undomanager.canUndo();
    }

    @Override
    public boolean canRedo() {
        return this.undomanager.canRedo();
    }

    @Override
    public void discardAllEdits() {
        this.undomanager.discardAllEdits();
    }
}

