/*
 * Decompiled with CFR 0.152.
 */
package de.relaunch64.popelganda.Editor;

import de.relaunch64.popelganda.Editor.ColorSchemes;
import de.relaunch64.popelganda.util.FileTools;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class SyntaxScheme {
    public static final SimpleAttributeSet DEFAULT_NORMAL;
    public static final SimpleAttributeSet DEFAULT_NUMBER;
    public static final SimpleAttributeSet DEFAULT_COMMENT;
    public static final SimpleAttributeSet DEFAULT_STRING;
    public static final SimpleAttributeSet DEFAULT_HEXA;
    public static final SimpleAttributeSet DEFAULT_BIN;
    public static final SimpleAttributeSet DEFAULT_LOHI;
    public static final SimpleAttributeSet DEFAULT_JUMP;
    public static final SimpleAttributeSet DEFAULT_KEYWORD;
    public static final SimpleAttributeSet DEFAULT_COMPILER_KEYWORD;
    public static final SimpleAttributeSet DEFAULT_ILLEGAL_OPCODE;
    public static final String DEF_FONT_NAME;
    public static final int DEF_FONT_SIZE;
    public static final Color DEF_BACK_COLOR;
    public static final Color DEF_LINE_BACK_COLOR;
    public static final Color DEF_LINE_COLOR;
    public static final Color DEF_LINE_BORDER_COLOR;
    public static final Color DEF_LINE_HIGHLIGHT_COLOR;

    public static void changeScheme(int scheme) {
        Document syntaxFile = SyntaxScheme.loadSyntax();
        SyntaxScheme.changeScheme(scheme, syntaxFile);
        SyntaxScheme.saveSyntax(syntaxFile);
    }

    public static void changeScheme(int scheme, Document syntaxFile) {
        Color cNormal = ColorSchemes.getColor(scheme, 0);
        Color cComment = ColorSchemes.getColor(scheme, 1);
        Color cString = ColorSchemes.getColor(scheme, 2);
        Color cNumber = ColorSchemes.getColor(scheme, 3);
        Color cHexa = ColorSchemes.getColor(scheme, 4);
        Color cBin = ColorSchemes.getColor(scheme, 5);
        Color cJump = ColorSchemes.getColor(scheme, 6);
        Color cLohi = ColorSchemes.getColor(scheme, 8);
        Color cKeywords = ColorSchemes.getColor(scheme, 9);
        Color cCompilerKeywords = ColorSchemes.getColor(scheme, 10);
        Color cIllegalOpcodes = ColorSchemes.getColor(scheme, 7);
        Color backgroundColor = ColorSchemes.getColor(scheme, 99);
        Color lineBackground = ColorSchemes.getColor(scheme, 98);
        Color lineBorder = ColorSchemes.getColor(scheme, 97);
        Color lineColor = ColorSchemes.getColor(scheme, 96);
        Color lineHighlight = ColorSchemes.getColor(scheme, 95);
        try {
            Element e = syntaxFile.getRootElement().getChild("cNormal");
            e.setAttribute("r", String.valueOf(cNormal.getRed()));
            e.setAttribute("g", String.valueOf(cNormal.getGreen()));
            e.setAttribute("b", String.valueOf(cNormal.getBlue()));
            e = syntaxFile.getRootElement().getChild("cComment");
            e.setAttribute("r", String.valueOf(cComment.getRed()));
            e.setAttribute("g", String.valueOf(cComment.getGreen()));
            e.setAttribute("b", String.valueOf(cComment.getBlue()));
            e = syntaxFile.getRootElement().getChild("cString");
            e.setAttribute("r", String.valueOf(cString.getRed()));
            e.setAttribute("g", String.valueOf(cString.getGreen()));
            e.setAttribute("b", String.valueOf(cString.getBlue()));
            e = syntaxFile.getRootElement().getChild("cNumber");
            e.setAttribute("r", String.valueOf(cNumber.getRed()));
            e.setAttribute("g", String.valueOf(cNumber.getGreen()));
            e.setAttribute("b", String.valueOf(cNumber.getBlue()));
            e = syntaxFile.getRootElement().getChild("cHexa");
            e.setAttribute("r", String.valueOf(cHexa.getRed()));
            e.setAttribute("g", String.valueOf(cHexa.getGreen()));
            e.setAttribute("b", String.valueOf(cHexa.getBlue()));
            e = syntaxFile.getRootElement().getChild("cBin");
            e.setAttribute("r", String.valueOf(cBin.getRed()));
            e.setAttribute("g", String.valueOf(cBin.getGreen()));
            e.setAttribute("b", String.valueOf(cBin.getBlue()));
            e = syntaxFile.getRootElement().getChild("cString");
            e.setAttribute("r", String.valueOf(cString.getRed()));
            e.setAttribute("g", String.valueOf(cString.getGreen()));
            e.setAttribute("b", String.valueOf(cString.getBlue()));
            e = syntaxFile.getRootElement().getChild("cJump");
            e.setAttribute("r", String.valueOf(cJump.getRed()));
            e.setAttribute("g", String.valueOf(cJump.getGreen()));
            e.setAttribute("b", String.valueOf(cJump.getBlue()));
            e = syntaxFile.getRootElement().getChild("cLohi");
            e.setAttribute("r", String.valueOf(cLohi.getRed()));
            e.setAttribute("g", String.valueOf(cLohi.getGreen()));
            e.setAttribute("b", String.valueOf(cLohi.getBlue()));
            e = syntaxFile.getRootElement().getChild("cKeywords");
            e.setAttribute("r", String.valueOf(cKeywords.getRed()));
            e.setAttribute("g", String.valueOf(cKeywords.getGreen()));
            e.setAttribute("b", String.valueOf(cKeywords.getBlue()));
            e = syntaxFile.getRootElement().getChild("cCompilerKeywords");
            e.setAttribute("r", String.valueOf(cCompilerKeywords.getRed()));
            e.setAttribute("g", String.valueOf(cCompilerKeywords.getGreen()));
            e.setAttribute("b", String.valueOf(cCompilerKeywords.getBlue()));
            e = syntaxFile.getRootElement().getChild("cIllegalOpcodes");
            e.setAttribute("r", String.valueOf(cIllegalOpcodes.getRed()));
            e.setAttribute("g", String.valueOf(cIllegalOpcodes.getGreen()));
            e.setAttribute("b", String.valueOf(cIllegalOpcodes.getBlue()));
            e = syntaxFile.getRootElement().getChild("backgroundColor");
            e.setAttribute("r", String.valueOf(backgroundColor.getRed()));
            e.setAttribute("g", String.valueOf(backgroundColor.getGreen()));
            e.setAttribute("b", String.valueOf(backgroundColor.getBlue()));
            e = syntaxFile.getRootElement().getChild("lineBackground");
            e.setAttribute("r", String.valueOf(lineBackground.getRed()));
            e.setAttribute("g", String.valueOf(lineBackground.getGreen()));
            e.setAttribute("b", String.valueOf(lineBackground.getBlue()));
            e = syntaxFile.getRootElement().getChild("lineBorder");
            e.setAttribute("r", String.valueOf(lineBorder.getRed()));
            e.setAttribute("g", String.valueOf(lineBorder.getGreen()));
            e.setAttribute("b", String.valueOf(lineBorder.getBlue()));
            e = syntaxFile.getRootElement().getChild("lineColor");
            e.setAttribute("r", String.valueOf(lineColor.getRed()));
            e.setAttribute("g", String.valueOf(lineColor.getGreen()));
            e.setAttribute("b", String.valueOf(lineColor.getBlue()));
            e = syntaxFile.getRootElement().getChild("lineHighlight");
            e.setAttribute("r", String.valueOf(lineHighlight.getRed()));
            e.setAttribute("g", String.valueOf(lineHighlight.getGreen()));
            e.setAttribute("b", String.valueOf(lineHighlight.getBlue()));
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
    }

    protected static File getFile() {
        return FileTools.createFilePath("relaunch64-syntaxscheme.xml");
    }

    public static Document loadSyntax() {
        File sFile = SyntaxScheme.getFile();
        Document syntaxFile = new Document(new Element("SyntaxScheme"));
        if (sFile.exists()) {
            try {
                SAXBuilder builder = new SAXBuilder();
                syntaxFile = builder.build(sFile);
            }
            catch (IOException | JDOMException exception) {
                // empty catch block
            }
        }
        return syntaxFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveSyntax(Document syntaxFile) {
        File sFile = SyntaxScheme.getFile();
        OutputStream dest = null;
        try {
            XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
            dest = new FileOutputStream(sFile);
            out.output(syntaxFile, dest);
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException ex) {
                    return false;
                }
            }
        }
        return true;
    }

    public static void setFont(Document syntaxFile, String fontFamily) {
        Element e = syntaxFile.getRootElement().getChild("fontFamily");
        if (null == e) {
            e = new Element("fontFamily");
            syntaxFile.getRootElement().addContent(e);
        }
        e.setText(fontFamily);
    }

    public static void setFontSize(Document syntaxFile, int fontSize) {
        Element e = syntaxFile.getRootElement().getChild("fontSize");
        if (null == e) {
            e = new Element("fontSize");
            syntaxFile.getRootElement().addContent(e);
        }
        e.setText(String.valueOf(fontSize));
    }

    public static HashMap<String, MutableAttributeSet> getStyleAttributes() {
        HashMap<String, MutableAttributeSet> sasArray = new HashMap<String, MutableAttributeSet>();
        sasArray.put("normal", DEFAULT_NORMAL);
        sasArray.put("comment", DEFAULT_COMMENT);
        sasArray.put("string", DEFAULT_STRING);
        sasArray.put("number", DEFAULT_NUMBER);
        sasArray.put("hexa", DEFAULT_HEXA);
        sasArray.put("lohi", DEFAULT_LOHI);
        sasArray.put("binary", DEFAULT_BIN);
        sasArray.put("jump", DEFAULT_JUMP);
        sasArray.put("keyword", DEFAULT_KEYWORD);
        sasArray.put("compilerkeyword", DEFAULT_COMPILER_KEYWORD);
        sasArray.put("illegalopcode", DEFAULT_ILLEGAL_OPCODE);
        return sasArray;
    }

    public static String getFontName() {
        return DEF_FONT_NAME;
    }

    public static int getFontSize() {
        return DEF_FONT_SIZE;
    }

    public static Color getBackgroundColor() {
        return DEF_BACK_COLOR;
    }

    public static Color getLineBackgroundColor() {
        return DEF_LINE_BACK_COLOR;
    }

    public static Color getLineForegroundColor() {
        return DEF_LINE_COLOR;
    }

    public static Color getLineBorderColor() {
        return DEF_LINE_BORDER_COLOR;
    }

    public static Color getLineHighlightColor() {
        return DEF_LINE_HIGHLIGHT_COLOR;
    }

    public static String getDelimiterList(int compiler) {
        String str = ",;:{}()[]+-/%<=>&!|^~*";
        switch (compiler) {
            case 1: {
                str = ",:{}()[]+-/<=>&|^~*";
                break;
            }
            case 0: {
                str = ",;:{}()[]+-/<=>&|^~*";
                break;
            }
            case 2: {
                str = ",:{}()[]+-/<=>&|^~*";
            }
        }
        return str;
    }

    public static String getCommentString(int compiler) {
        String str = "//";
        switch (compiler) {
            case 1: 
            case 2: {
                str = ";";
                break;
            }
            case 0: {
                str = "//";
            }
        }
        return str;
    }

    public static String getMacroString(int compiler) {
        String str = ".";
        switch (compiler) {
            case 1: {
                str = "!";
                break;
            }
            case 0: 
            case 2: {
                str = ".";
            }
        }
        return str;
    }

    public static HashMap<String, MutableAttributeSet> getKeywordHashMap() {
        HashMap<String, MutableAttributeSet> asmKeywords = new HashMap<String, MutableAttributeSet>();
        asmKeywords.put("LDA", DEFAULT_KEYWORD);
        asmKeywords.put("STA", DEFAULT_KEYWORD);
        asmKeywords.put("INC", DEFAULT_KEYWORD);
        asmKeywords.put("DEC", DEFAULT_KEYWORD);
        asmKeywords.put("LDX", DEFAULT_KEYWORD);
        asmKeywords.put("STX", DEFAULT_KEYWORD);
        asmKeywords.put("INX", DEFAULT_KEYWORD);
        asmKeywords.put("DEX", DEFAULT_KEYWORD);
        asmKeywords.put("LDY", DEFAULT_KEYWORD);
        asmKeywords.put("STY", DEFAULT_KEYWORD);
        asmKeywords.put("INY", DEFAULT_KEYWORD);
        asmKeywords.put("DEY", DEFAULT_KEYWORD);
        asmKeywords.put("CMP", DEFAULT_KEYWORD);
        asmKeywords.put("CPX", DEFAULT_KEYWORD);
        asmKeywords.put("CPY", DEFAULT_KEYWORD);
        asmKeywords.put("TAX", DEFAULT_KEYWORD);
        asmKeywords.put("TAY", DEFAULT_KEYWORD);
        asmKeywords.put("TXA", DEFAULT_KEYWORD);
        asmKeywords.put("TYA", DEFAULT_KEYWORD);
        asmKeywords.put("TSX", DEFAULT_KEYWORD);
        asmKeywords.put("TXS", DEFAULT_KEYWORD);
        asmKeywords.put("AND", DEFAULT_KEYWORD);
        asmKeywords.put("ORA", DEFAULT_KEYWORD);
        asmKeywords.put("EOR", DEFAULT_KEYWORD);
        asmKeywords.put("ADC", DEFAULT_KEYWORD);
        asmKeywords.put("SBC", DEFAULT_KEYWORD);
        asmKeywords.put("SEC", DEFAULT_KEYWORD);
        asmKeywords.put("CLC", DEFAULT_KEYWORD);
        asmKeywords.put("ASL", DEFAULT_KEYWORD);
        asmKeywords.put("LSR", DEFAULT_KEYWORD);
        asmKeywords.put("ROL", DEFAULT_KEYWORD);
        asmKeywords.put("ROR", DEFAULT_KEYWORD);
        asmKeywords.put("BIT", DEFAULT_KEYWORD);
        asmKeywords.put("JMP", DEFAULT_KEYWORD);
        asmKeywords.put("JSR", DEFAULT_KEYWORD);
        asmKeywords.put("RTS", DEFAULT_KEYWORD);
        asmKeywords.put("RTI", DEFAULT_KEYWORD);
        asmKeywords.put("BCC", DEFAULT_KEYWORD);
        asmKeywords.put("BCS", DEFAULT_KEYWORD);
        asmKeywords.put("BEQ", DEFAULT_KEYWORD);
        asmKeywords.put("BNE", DEFAULT_KEYWORD);
        asmKeywords.put("BPL", DEFAULT_KEYWORD);
        asmKeywords.put("BMI", DEFAULT_KEYWORD);
        asmKeywords.put("BVC", DEFAULT_KEYWORD);
        asmKeywords.put("BVS", DEFAULT_KEYWORD);
        asmKeywords.put("SEI", DEFAULT_KEYWORD);
        asmKeywords.put("CLI", DEFAULT_KEYWORD);
        asmKeywords.put("SED", DEFAULT_KEYWORD);
        asmKeywords.put("CLD", DEFAULT_KEYWORD);
        asmKeywords.put("CLV", DEFAULT_KEYWORD);
        asmKeywords.put("PHA", DEFAULT_KEYWORD);
        asmKeywords.put("PLA", DEFAULT_KEYWORD);
        asmKeywords.put("PHP", DEFAULT_KEYWORD);
        asmKeywords.put("PLP", DEFAULT_KEYWORD);
        asmKeywords.put("NOP", DEFAULT_KEYWORD);
        asmKeywords.put("BRK", DEFAULT_KEYWORD);
        return asmKeywords;
    }

    public static HashMap<String, MutableAttributeSet> getIllegalOpcodeHashMap() {
        HashMap<String, MutableAttributeSet> asmKeywords = new HashMap<String, MutableAttributeSet>();
        asmKeywords.put("AAR", DEFAULT_ILLEGAL_OPCODE);
        asmKeywords.put("AHX", DEFAULT_ILLEGAL_OPCODE);
        asmKeywords.put("ALR", DEFAULT_ILLEGAL_OPCODE);
        asmKeywords.put("ANC", DEFAULT_ILLEGAL_OPCODE);
        asmKeywords.put("AXS", DEFAULT_ILLEGAL_OPCODE);
        asmKeywords.put("DCP", DEFAULT_ILLEGAL_OPCODE);
        asmKeywords.put("ISC", DEFAULT_ILLEGAL_OPCODE);
        asmKeywords.put("LAS", DEFAULT_ILLEGAL_OPCODE);
        asmKeywords.put("LAX", DEFAULT_ILLEGAL_OPCODE);
        asmKeywords.put("RLA", DEFAULT_ILLEGAL_OPCODE);
        asmKeywords.put("RRA", DEFAULT_ILLEGAL_OPCODE);
        asmKeywords.put("SAX", DEFAULT_ILLEGAL_OPCODE);
        asmKeywords.put("SBC", DEFAULT_ILLEGAL_OPCODE);
        asmKeywords.put("SHX", DEFAULT_ILLEGAL_OPCODE);
        asmKeywords.put("SHY", DEFAULT_ILLEGAL_OPCODE);
        asmKeywords.put("SLO", DEFAULT_ILLEGAL_OPCODE);
        asmKeywords.put("SRE", DEFAULT_ILLEGAL_OPCODE);
        asmKeywords.put("TAS", DEFAULT_ILLEGAL_OPCODE);
        asmKeywords.put("XAA", DEFAULT_ILLEGAL_OPCODE);
        return asmKeywords;
    }

    public static HashMap<String, MutableAttributeSet> getCompilerKeywordHashMap(int compiler) {
        HashMap<String, MutableAttributeSet> asmKeywords = new HashMap<String, MutableAttributeSet>();
        switch (compiler) {
            case 1: {
                asmKeywords.put("!08", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!8", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!16", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!24", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!32", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!ALIGN", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!AL", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!AS", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!BIN", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!BINARY", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!BY", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!BYTE", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!CONVTAB", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!CT", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!DO", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!EOF", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!ENDOFFILE", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!ERROR", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!IF", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!IFDEF", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!INITMEN", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!FI", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!FILL", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!FOR", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!MACRO", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!PET", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!PSEUDOPC", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!RAW", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!RL", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!RS", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!SCR", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!SCRXOR", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!SET", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!SL", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!SRC", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!SOURCE", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!TEXT", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!TO", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!TX", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!WARN", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!WO", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!WORD", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!ZN", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("!ZONE", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put("UNTIL", DEFAULT_COMPILER_KEYWORD);
                break;
            }
            case 0: {
                asmKeywords.put(".ALIGN", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".ASSERT", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".BYTE", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".CONST", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".DEFINE", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".DWORD", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".ENUM", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".EVAL", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".FILL", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".FOR", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".FUNCTION", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".GET", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".IF", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".IMPORT", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".IMPORTONCE", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".LABEL", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".MACRO", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".PC", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".PRINT", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".PSEUDOPC", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".RETURN", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".TEXT", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".VAR", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".WORD", DEFAULT_COMPILER_KEYWORD);
                break;
            }
            case 2: {
                asmKeywords.put(".AL", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".ALIGN", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".AS", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".ASSERT", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".BEND", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".BINARY", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".BINCLUDE", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".BLOCK", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".BREAK", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".BYTE", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".CASE", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".CDEF", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".CERROR", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".CHAR", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".CHECK", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".COMMENT", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".CONTINUE", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".CPU", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".CWARN", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".DATABANK", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".DEFAULT", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".DINT", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".DPAGE", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".DSECTION", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".DSTRUCT", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".DUNION", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".DWORD", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".EDEF", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".ELSE", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".ELSIF", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".ENC", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".END", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".ENDC", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".ENDF", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".ENDIF", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".ENDM", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".ENDP", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".ENDS", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".ENDSWITCH", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".ENDU", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".ENDWEAK", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".EOR", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".ERROR", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".FI", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".FILL", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".FOR", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".FUNCTION", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".GOTO", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".HERE", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".HIDEMAC", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".IF", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".IFEQ", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".IFMI", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".IFNE", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".IFPL", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".INCLUDE", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".INT", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".LBL", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".LINT", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".LOGICAL", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".LONG", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".MACRO", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".NEXT", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".NULL", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".OFFS", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".OPTION", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".PAGE", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".PEND", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".PROC", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".PROFF", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".PRON", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".PRTEXT", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".REPT", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".RTA", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".SECTION", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".SEGMENT", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".SEND", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".SHIFT", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".SHIFTL", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".SHOWMAC", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".STRUCT", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".SWITCH", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".TEXT", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".UNION", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".VAR", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".WARN", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".WEAK", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".WORD", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".XL", DEFAULT_COMPILER_KEYWORD);
                asmKeywords.put(".XS", DEFAULT_COMPILER_KEYWORD);
            }
        }
        return asmKeywords;
    }

    static {
        Document syntaxFile = SyntaxScheme.loadSyntax();
        int scheme = 0;
        Color cNormal = ColorSchemes.getColor(scheme, 0);
        Color cComment = ColorSchemes.getColor(scheme, 1);
        Color cString = ColorSchemes.getColor(scheme, 2);
        Color cNumber = ColorSchemes.getColor(scheme, 3);
        Color cHexa = ColorSchemes.getColor(scheme, 4);
        Color cBin = ColorSchemes.getColor(scheme, 5);
        Color cJump = ColorSchemes.getColor(scheme, 6);
        Color cLohi = ColorSchemes.getColor(scheme, 8);
        Color cKeywords = ColorSchemes.getColor(scheme, 9);
        Color cCompilerKeywords = ColorSchemes.getColor(scheme, 10);
        Color cIllegalOpcodes = ColorSchemes.getColor(scheme, 7);
        Color backgroundColor = ColorSchemes.getColor(scheme, 99);
        Color lineBackground = ColorSchemes.getColor(scheme, 98);
        Color lineBorder = ColorSchemes.getColor(scheme, 97);
        Color lineColor = ColorSchemes.getColor(scheme, 96);
        Color lineHighlight = ColorSchemes.getColor(scheme, 95);
        String fontFamily = "Monospaced";
        int fontSize = 13;
        try {
            Element e = syntaxFile.getRootElement().getChild("cNormal");
            if (null == e) {
                e = new Element("cNormal");
                e.setAttribute("r", String.valueOf(cNormal.getRed()));
                e.setAttribute("g", String.valueOf(cNormal.getGreen()));
                e.setAttribute("b", String.valueOf(cNormal.getBlue()));
                syntaxFile.getRootElement().addContent(e);
            } else {
                cNormal = new Color(Integer.parseInt(e.getAttributeValue("r")), Integer.parseInt(e.getAttributeValue("g")), Integer.parseInt(e.getAttributeValue("b")));
            }
            e = syntaxFile.getRootElement().getChild("cComment");
            if (null == e) {
                e = new Element("cComment");
                e.setAttribute("r", String.valueOf(cComment.getRed()));
                e.setAttribute("g", String.valueOf(cComment.getGreen()));
                e.setAttribute("b", String.valueOf(cComment.getBlue()));
                syntaxFile.getRootElement().addContent(e);
            } else {
                cComment = new Color(Integer.parseInt(e.getAttributeValue("r")), Integer.parseInt(e.getAttributeValue("g")), Integer.parseInt(e.getAttributeValue("b")));
            }
            e = syntaxFile.getRootElement().getChild("cString");
            if (null == e) {
                e = new Element("cString");
                e.setAttribute("r", String.valueOf(cString.getRed()));
                e.setAttribute("g", String.valueOf(cString.getGreen()));
                e.setAttribute("b", String.valueOf(cString.getBlue()));
                syntaxFile.getRootElement().addContent(e);
            } else {
                cString = new Color(Integer.parseInt(e.getAttributeValue("r")), Integer.parseInt(e.getAttributeValue("g")), Integer.parseInt(e.getAttributeValue("b")));
            }
            e = syntaxFile.getRootElement().getChild("cNumber");
            if (null == e) {
                e = new Element("cNumber");
                e.setAttribute("r", String.valueOf(cNumber.getRed()));
                e.setAttribute("g", String.valueOf(cNumber.getGreen()));
                e.setAttribute("b", String.valueOf(cNumber.getBlue()));
                syntaxFile.getRootElement().addContent(e);
            } else {
                cNumber = new Color(Integer.parseInt(e.getAttributeValue("r")), Integer.parseInt(e.getAttributeValue("g")), Integer.parseInt(e.getAttributeValue("b")));
            }
            e = syntaxFile.getRootElement().getChild("cHexa");
            if (null == e) {
                e = new Element("cHexa");
                e.setAttribute("r", String.valueOf(cHexa.getRed()));
                e.setAttribute("g", String.valueOf(cHexa.getGreen()));
                e.setAttribute("b", String.valueOf(cHexa.getBlue()));
                syntaxFile.getRootElement().addContent(e);
            } else {
                cHexa = new Color(Integer.parseInt(e.getAttributeValue("r")), Integer.parseInt(e.getAttributeValue("g")), Integer.parseInt(e.getAttributeValue("b")));
            }
            e = syntaxFile.getRootElement().getChild("cBin");
            if (null == e) {
                e = new Element("cBin");
                e.setAttribute("r", String.valueOf(cBin.getRed()));
                e.setAttribute("g", String.valueOf(cBin.getGreen()));
                e.setAttribute("b", String.valueOf(cBin.getBlue()));
                syntaxFile.getRootElement().addContent(e);
            } else {
                cBin = new Color(Integer.parseInt(e.getAttributeValue("r")), Integer.parseInt(e.getAttributeValue("g")), Integer.parseInt(e.getAttributeValue("b")));
            }
            e = syntaxFile.getRootElement().getChild("cString");
            if (null == e) {
                e = new Element("cString");
                e.setAttribute("r", String.valueOf(cString.getRed()));
                e.setAttribute("g", String.valueOf(cString.getGreen()));
                e.setAttribute("b", String.valueOf(cString.getBlue()));
                syntaxFile.getRootElement().addContent(e);
            } else {
                cString = new Color(Integer.parseInt(e.getAttributeValue("r")), Integer.parseInt(e.getAttributeValue("g")), Integer.parseInt(e.getAttributeValue("b")));
            }
            e = syntaxFile.getRootElement().getChild("cJump");
            if (null == e) {
                e = new Element("cJump");
                e.setAttribute("r", String.valueOf(cJump.getRed()));
                e.setAttribute("g", String.valueOf(cJump.getGreen()));
                e.setAttribute("b", String.valueOf(cJump.getBlue()));
                syntaxFile.getRootElement().addContent(e);
            } else {
                cJump = new Color(Integer.parseInt(e.getAttributeValue("r")), Integer.parseInt(e.getAttributeValue("g")), Integer.parseInt(e.getAttributeValue("b")));
            }
            e = syntaxFile.getRootElement().getChild("cLohi");
            if (null == e) {
                e = new Element("cLohi");
                e.setAttribute("r", String.valueOf(cLohi.getRed()));
                e.setAttribute("g", String.valueOf(cLohi.getGreen()));
                e.setAttribute("b", String.valueOf(cLohi.getBlue()));
                syntaxFile.getRootElement().addContent(e);
            } else {
                cLohi = new Color(Integer.parseInt(e.getAttributeValue("r")), Integer.parseInt(e.getAttributeValue("g")), Integer.parseInt(e.getAttributeValue("b")));
            }
            e = syntaxFile.getRootElement().getChild("cKeywords");
            if (null == e) {
                e = new Element("cKeywords");
                e.setAttribute("r", String.valueOf(cKeywords.getRed()));
                e.setAttribute("g", String.valueOf(cKeywords.getGreen()));
                e.setAttribute("b", String.valueOf(cKeywords.getBlue()));
                syntaxFile.getRootElement().addContent(e);
            } else {
                cKeywords = new Color(Integer.parseInt(e.getAttributeValue("r")), Integer.parseInt(e.getAttributeValue("g")), Integer.parseInt(e.getAttributeValue("b")));
            }
            e = syntaxFile.getRootElement().getChild("cCompilerKeywords");
            if (null == e) {
                e = new Element("cCompilerKeywords");
                e.setAttribute("r", String.valueOf(cCompilerKeywords.getRed()));
                e.setAttribute("g", String.valueOf(cCompilerKeywords.getGreen()));
                e.setAttribute("b", String.valueOf(cCompilerKeywords.getBlue()));
                syntaxFile.getRootElement().addContent(e);
            } else {
                cCompilerKeywords = new Color(Integer.parseInt(e.getAttributeValue("r")), Integer.parseInt(e.getAttributeValue("g")), Integer.parseInt(e.getAttributeValue("b")));
            }
            e = syntaxFile.getRootElement().getChild("cIllegalOpcodes");
            if (null == e) {
                e = new Element("cIllegalOpcodes");
                e.setAttribute("r", String.valueOf(cIllegalOpcodes.getRed()));
                e.setAttribute("g", String.valueOf(cIllegalOpcodes.getGreen()));
                e.setAttribute("b", String.valueOf(cIllegalOpcodes.getBlue()));
                syntaxFile.getRootElement().addContent(e);
            } else {
                cIllegalOpcodes = new Color(Integer.parseInt(e.getAttributeValue("r")), Integer.parseInt(e.getAttributeValue("g")), Integer.parseInt(e.getAttributeValue("b")));
            }
            e = syntaxFile.getRootElement().getChild("backgroundColor");
            if (null == e) {
                e = new Element("backgroundColor");
                e.setAttribute("r", String.valueOf(backgroundColor.getRed()));
                e.setAttribute("g", String.valueOf(backgroundColor.getGreen()));
                e.setAttribute("b", String.valueOf(backgroundColor.getBlue()));
                syntaxFile.getRootElement().addContent(e);
            } else {
                backgroundColor = new Color(Integer.parseInt(e.getAttributeValue("r")), Integer.parseInt(e.getAttributeValue("g")), Integer.parseInt(e.getAttributeValue("b")));
            }
            e = syntaxFile.getRootElement().getChild("lineBackground");
            if (null == e) {
                e = new Element("lineBackground");
                e.setAttribute("r", String.valueOf(lineBackground.getRed()));
                e.setAttribute("g", String.valueOf(lineBackground.getGreen()));
                e.setAttribute("b", String.valueOf(lineBackground.getBlue()));
                syntaxFile.getRootElement().addContent(e);
            } else {
                lineBackground = new Color(Integer.parseInt(e.getAttributeValue("r")), Integer.parseInt(e.getAttributeValue("g")), Integer.parseInt(e.getAttributeValue("b")));
            }
            e = syntaxFile.getRootElement().getChild("lineBorder");
            if (null == e) {
                e = new Element("lineBorder");
                e.setAttribute("r", String.valueOf(lineBorder.getRed()));
                e.setAttribute("g", String.valueOf(lineBorder.getGreen()));
                e.setAttribute("b", String.valueOf(lineBorder.getBlue()));
                syntaxFile.getRootElement().addContent(e);
            } else {
                lineBorder = new Color(Integer.parseInt(e.getAttributeValue("r")), Integer.parseInt(e.getAttributeValue("g")), Integer.parseInt(e.getAttributeValue("b")));
            }
            e = syntaxFile.getRootElement().getChild("lineColor");
            if (null == e) {
                e = new Element("lineColor");
                e.setAttribute("r", String.valueOf(lineColor.getRed()));
                e.setAttribute("g", String.valueOf(lineColor.getGreen()));
                e.setAttribute("b", String.valueOf(lineColor.getBlue()));
                syntaxFile.getRootElement().addContent(e);
            } else {
                lineColor = new Color(Integer.parseInt(e.getAttributeValue("r")), Integer.parseInt(e.getAttributeValue("g")), Integer.parseInt(e.getAttributeValue("b")));
            }
            e = syntaxFile.getRootElement().getChild("lineHighlight");
            if (null == e) {
                e = new Element("lineHighlight");
                e.setAttribute("r", String.valueOf(lineHighlight.getRed()));
                e.setAttribute("g", String.valueOf(lineHighlight.getGreen()));
                e.setAttribute("b", String.valueOf(lineHighlight.getBlue()));
                syntaxFile.getRootElement().addContent(e);
            } else {
                lineHighlight = new Color(Integer.parseInt(e.getAttributeValue("r")), Integer.parseInt(e.getAttributeValue("g")), Integer.parseInt(e.getAttributeValue("b")));
            }
            e = syntaxFile.getRootElement().getChild("fontFamily");
            if (null == e) {
                e = new Element("fontFamily");
                e.setText(fontFamily);
                syntaxFile.getRootElement().addContent(e);
            } else {
                fontFamily = e.getText();
            }
            e = syntaxFile.getRootElement().getChild("fontSize");
            if (null == e) {
                e = new Element("fontSize");
                e.setText(String.valueOf(fontSize));
                syntaxFile.getRootElement().addContent(e);
            } else {
                fontSize = Integer.parseInt(e.getText());
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        DEF_FONT_NAME = fontFamily;
        DEF_FONT_SIZE = fontSize;
        DEF_BACK_COLOR = backgroundColor;
        DEF_LINE_BACK_COLOR = lineBackground;
        DEF_LINE_BORDER_COLOR = lineBorder;
        DEF_LINE_COLOR = lineColor;
        DEF_LINE_HIGHLIGHT_COLOR = lineHighlight;
        DEFAULT_NORMAL = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_NORMAL, cNormal);
        StyleConstants.setFontFamily(DEFAULT_NORMAL, fontFamily);
        StyleConstants.setFontSize(DEFAULT_NORMAL, fontSize);
        DEFAULT_COMMENT = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_COMMENT, cComment);
        StyleConstants.setFontFamily(DEFAULT_COMMENT, fontFamily);
        StyleConstants.setFontSize(DEFAULT_COMMENT, fontSize);
        DEFAULT_STRING = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_STRING, cString);
        StyleConstants.setFontFamily(DEFAULT_STRING, fontFamily);
        StyleConstants.setFontSize(DEFAULT_STRING, fontSize);
        DEFAULT_NUMBER = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_NUMBER, cNumber);
        StyleConstants.setFontFamily(DEFAULT_NUMBER, fontFamily);
        StyleConstants.setFontSize(DEFAULT_NUMBER, fontSize);
        DEFAULT_HEXA = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_HEXA, cHexa);
        StyleConstants.setFontFamily(DEFAULT_HEXA, fontFamily);
        StyleConstants.setFontSize(DEFAULT_HEXA, fontSize);
        DEFAULT_BIN = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_BIN, cBin);
        StyleConstants.setFontFamily(DEFAULT_BIN, fontFamily);
        StyleConstants.setFontSize(DEFAULT_BIN, fontSize);
        DEFAULT_JUMP = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_JUMP, cJump);
        StyleConstants.setFontFamily(DEFAULT_JUMP, fontFamily);
        StyleConstants.setFontSize(DEFAULT_JUMP, fontSize);
        DEFAULT_LOHI = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_LOHI, cLohi);
        StyleConstants.setFontFamily(DEFAULT_LOHI, fontFamily);
        StyleConstants.setFontSize(DEFAULT_LOHI, fontSize);
        DEFAULT_KEYWORD = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_KEYWORD, cKeywords);
        StyleConstants.setFontFamily(DEFAULT_KEYWORD, fontFamily);
        StyleConstants.setFontSize(DEFAULT_KEYWORD, fontSize);
        DEFAULT_COMPILER_KEYWORD = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_COMPILER_KEYWORD, cCompilerKeywords);
        StyleConstants.setFontFamily(DEFAULT_COMPILER_KEYWORD, fontFamily);
        StyleConstants.setFontSize(DEFAULT_COMPILER_KEYWORD, fontSize);
        DEFAULT_ILLEGAL_OPCODE = new SimpleAttributeSet();
        StyleConstants.setForeground(DEFAULT_ILLEGAL_OPCODE, cIllegalOpcodes);
        StyleConstants.setFontFamily(DEFAULT_ILLEGAL_OPCODE, fontFamily);
        StyleConstants.setFontSize(DEFAULT_ILLEGAL_OPCODE, fontSize);
        SyntaxScheme.saveSyntax(syntaxFile);
    }
}

