/*
 * Decompiled with CFR 0.152.
 */
package de.relaunch64.popelganda;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;

public class FindReplace {
    private int findpos = -1;
    private final LinkedList<Integer[]> findselections = new LinkedList();
    private String findText;
    private String replaceText;
    private String content;
    private int activeTab = -1;
    private int lastActiveTab = -1;
    private JEditorPane editorPane = null;

    FindReplace() {
        this.resetValues();
    }

    public void initValues(String ft, String rt, int at, JEditorPane ep) {
        this.initValues(ft, rt, at, ep, false);
    }

    public void initValues(String ft, String rt, int at, JEditorPane ep, boolean forceInit) {
        boolean newFindTerm = ft != null && this.findText != null && !this.findText.equalsIgnoreCase(ft) || rt != null && this.replaceText != null && !this.replaceText.equalsIgnoreCase(rt);
        this.findText = ft;
        this.replaceText = rt;
        this.activeTab = at;
        this.editorPane = ep;
        this.updateContent();
        if (newFindTerm || forceInit) {
            this.initmatcher();
        }
    }

    public final void resetValues() {
        this.findselections.clear();
        this.findpos = -1;
    }

    private boolean initmatcher() {
        Pattern p;
        String text = this.findText;
        this.updateContent();
        if (null == text || text.isEmpty()) {
            this.resetValues();
            return false;
        }
        if (null == this.content || this.content.isEmpty()) {
            this.resetValues();
            return false;
        }
        this.lastActiveTab = this.activeTab;
        try {
            p = Pattern.compile(text);
        }
        catch (PatternSyntaxException e) {
            text = Pattern.quote(text);
            p = Pattern.compile(text);
        }
        Matcher findmatcher = p.matcher(this.content);
        this.findpos = -1;
        this.findselections.clear();
        while (findmatcher.find()) {
            this.findselections.add(new Integer[]{findmatcher.start(), findmatcher.end()});
        }
        return this.findselections.size() > 0;
    }

    public boolean findNext() {
        if (this.findselections.isEmpty() || this.lastActiveTab != this.activeTab) {
            this.initmatcher();
        }
        if (this.findselections.size() > 0) {
            ++this.findpos;
            if (this.findpos < this.findselections.size()) {
                if (this.findpos < 0) {
                    this.findpos = 0;
                }
                this.editorPane.setSelectionStart(this.findselections.get(this.findpos)[0]);
                this.editorPane.moveCaretPosition(this.findselections.get(this.findpos)[1]);
            } else {
                this.findpos = 0;
                this.editorPane.setSelectionStart(this.findselections.get(this.findpos)[0]);
                this.editorPane.moveCaretPosition(this.findselections.get(this.findpos)[1]);
            }
        } else {
            this.resetValues();
            return false;
        }
        this.editorPane.requestFocusInWindow();
        return true;
    }

    public boolean findPrev() {
        if (this.findselections.size() > 0) {
            --this.findpos;
            if (this.findpos >= 0) {
                if (this.findpos >= this.findselections.size()) {
                    this.findpos = this.findselections.size() - 1;
                }
                this.editorPane.setSelectionStart(this.findselections.get(this.findpos)[0]);
                this.editorPane.moveCaretPosition(this.findselections.get(this.findpos)[1]);
            } else {
                this.findpos = this.findselections.size() - 1;
                this.editorPane.setSelectionStart(this.findselections.get(this.findpos)[0]);
                this.editorPane.moveCaretPosition(this.findselections.get(this.findpos)[1]);
            }
        } else {
            this.resetValues();
            return false;
        }
        this.editorPane.requestFocusInWindow();
        return true;
    }

    public boolean replace() {
        if (this.editorPane.getText() != null) {
            if (this.editorPane.getSelectedText() != null) {
                this.editorPane.replaceSelection(this.replaceText);
            }
            if (!this.initmatcher()) {
                this.resetValues();
                return false;
            }
        } else {
            this.resetValues();
            return false;
        }
        this.findNext();
        return true;
    }

    public void replaceAll() {
        if (this.initmatcher()) {
            for (int cnt = this.findselections.size() - 1; cnt >= 0; --cnt) {
                this.editorPane.setSelectionStart(this.findselections.get(cnt)[0]);
                this.editorPane.moveCaretPosition(this.findselections.get(cnt)[1]);
                if (this.editorPane.getSelectedText() == null) continue;
                this.editorPane.replaceSelection(this.replaceText);
            }
        }
        if (this.findselections.size() > 0) {
            this.editorPane.setCaretPosition(this.findselections.get(this.findselections.size() - 1)[1]);
            this.resetValues();
        }
    }

    private void updateContent() {
        if (this.editorPane.getDocument().getLength() > 0) {
            try {
                this.content = this.editorPane != null ? this.editorPane.getDocument().getText(0, this.editorPane.getDocument().getLength()) : "";
            }
            catch (BadLocationException ex) {
                this.content = this.editorPane.getText();
            }
        }
    }
}

