/*
 * Decompiled with CFR 0.152.
 */
package de.relaunch64.popelganda;

import de.relaunch64.popelganda.CheckForUpdates;
import de.relaunch64.popelganda.Editor.EditorPaneLineNumbers;
import de.relaunch64.popelganda.Editor.EditorPanes;
import de.relaunch64.popelganda.Editor.FunctionExtractor;
import de.relaunch64.popelganda.Editor.InsertBreakPoint;
import de.relaunch64.popelganda.Editor.LabelExtractor;
import de.relaunch64.popelganda.Editor.SectionExtractor;
import de.relaunch64.popelganda.FindReplace;
import de.relaunch64.popelganda.InsertByteFromFileDlg;
import de.relaunch64.popelganda.InsertSinusTableDlg;
import de.relaunch64.popelganda.Relaunch64AboutBox;
import de.relaunch64.popelganda.Relaunch64App;
import de.relaunch64.popelganda.SettingsDlg;
import de.relaunch64.popelganda.database.CustomScripts;
import de.relaunch64.popelganda.database.Settings;
import de.relaunch64.popelganda.util.ConstantsR64;
import de.relaunch64.popelganda.util.FileTools;
import de.relaunch64.popelganda.util.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.application.TaskService;
import org.jdesktop.layout.GroupLayout;

public class Relaunch64View
extends FrameView
implements WindowListener,
DropTargetListener {
    private EditorPanes editorPanes;
    private final FindReplace findReplace;
    private final List<Integer> comboBoxHeadings = new ArrayList<Integer>();
    private final List<Integer> comboBoxHeadingsEditorPaneIndex = new ArrayList<Integer>();
    private static final int GOTO_LABEL = 1;
    private static final int GOTO_SECTION = 2;
    private static final int GOTO_FUNCTION = 3;
    private static final int GOTO_MACRO = 4;
    private int comboBoxGotoIndex = -1;
    private final Settings settings;
    private final CustomScripts customScripts;
    private final ArrayList<Integer> errorLines = new ArrayList();
    private final ResourceMap resourceMap = Application.getInstance(Relaunch64App.class).getContext().getResourceMap(Relaunch64View.class);
    private JMenuItem addTabMenuItem;
    private JMenuItem closeAllMenuItem;
    private JMenuItem closeFileMenuItem;
    private JMenuItem commentLineMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JMenu editMenu;
    private JMenu findMenu;
    private JMenuItem findNextMenuItem;
    private JMenuItem findPrevMenuItem;
    private JMenuItem findStartMenuItem;
    private JMenuItem focusScriptMenuItem;
    private JMenuItem focusSyntaxMenuItem;
    private JMenuItem gotoFunctionMenuItem;
    private JMenuItem gotoLabelMenuItem;
    private JMenuItem gotoLineMenuItem;
    private JMenuItem gotoMacroMenuItem;
    private JMenu gotoMenu;
    private JMenuItem gotoNextErrorMenuItem;
    private JMenuItem gotoNextLabel;
    private JMenuItem gotoNextSectionMenuItem;
    private JMenuItem gotoPrevErrorMenuItem;
    private JMenuItem gotoPrevLabel;
    private JMenuItem gotoPrevSectionMenuItem;
    private JMenuItem gotoSectionMenuItem;
    private JMenuItem helpMenuItem;
    private JMenuItem insertBasicStartMenuItem;
    private JMenuItem insertBreakPointMenuItem;
    private JMenuItem insertBytesFromFileMenuItem;
    private JMenuItem insertSectionMenuItem;
    private JMenuItem insertSeparatorMenuItem;
    private JMenuItem insertSinusMenuItem;
    private JButton jButtonFindNext;
    private JButton jButtonFindPrev;
    private JButton jButtonReplace;
    private JButton jButtonRunScript;
    private JComboBox jComboBoxCompilers;
    private JComboBox jComboBoxGoto;
    private JComboBox jComboBoxRunScripts;
    private JEditorPane jEditorPaneMain;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel9;
    private JPanel jPanelFind;
    private JPanel jPanelReplace;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPaneMainEditorPane;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator10;
    private JPopupMenu.Separator jSeparator11;
    private JPopupMenu.Separator jSeparator12;
    private JPopupMenu.Separator jSeparator13;
    private JPopupMenu.Separator jSeparator14;
    private JPopupMenu.Separator jSeparator15;
    private JPopupMenu.Separator jSeparator16;
    private JPopupMenu.Separator jSeparator17;
    private JPopupMenu.Separator jSeparator18;
    private JPopupMenu.Separator jSeparator19;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator20;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator8;
    private JPopupMenu.Separator jSeparator9;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JTabbedPane jTabbedPane1;
    private JTabbedPane jTabbedPaneLogs;
    private JTextArea jTextAreaCompilerOutput;
    private JTextArea jTextAreaLog;
    private JTextField jTextFieldConvBin;
    private JTextField jTextFieldConvDez;
    private JTextField jTextFieldConvHex;
    private JTextField jTextFieldFind;
    private JTextField jTextFieldGotoLine;
    private JTextField jTextFieldReplace;
    private JMenuItem jumpToLabelMenuItem;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JMenuItem openFileMenuItem;
    private JMenuItem pasteMenuItem;
    private JMenuItem recent1MenuItem;
    private JMenuItem recent2MenuItem;
    private JMenuItem recent3MenuItem;
    private JMenuItem recent4MenuItem;
    private JMenuItem recent5MenuItem;
    private JMenuItem recent6MenuItem;
    private JMenuItem recent7MenuItem;
    private JMenuItem recent8MenuItem;
    private JMenuItem recent9MenuItem;
    private JMenuItem recentAMenuItem;
    private JMenu recentDocsSubmenu;
    private JMenuItem redoMenuItem;
    private JMenuItem removeBreakpointMenuItem;
    private JMenuItem replaceAllMenuItem;
    private JMenuItem replaceMenuItem;
    private JMenuItem runScriptMenuItem;
    private JMenuItem saveAllMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem selectAllMenuItem;
    private JMenuItem settingsMenuItem;
    private JMenu sourceMenu;
    private JPanel statusPanel;
    private JMenuItem switchBothMenuItem;
    private JMenuItem switchLogPosMenuItem;
    private JMenuItem undoMenuItem;
    private JMenuItem viewLog1MenuItem;
    private JMenuItem viewLog2MenuItem;
    private JMenuItem viewMainTabMenuItem;
    private JMenu viewMenu;
    private JDialog aboutBox;
    private InsertByteFromFileDlg insertByteFromFileDlg;
    private InsertSinusTableDlg insertSinusTableDlg;
    private SettingsDlg settingsDlg;

    public Relaunch64View(SingleFrameApplication app, Settings set, String[] params) {
        super(app);
        ConstantsR64.r64logger.addHandler(new TextAreaHandler());
        ConstantsR64.r64logger.setLevel(Level.ALL);
        this.settings = set;
        this.findReplace = new FindReplace();
        this.customScripts = new CustomScripts();
        this.customScripts.loadScripts();
        this.setDefaultLookAndFeel();
        if (this.settings.isOSX()) {
            this.setupMacOSXApplicationListener();
        }
        this.initComponents();
        this.jPanelFind.setVisible(false);
        this.jPanelReplace.setVisible(false);
        this.initComboBoxes();
        this.initListeners();
        this.initDropTargets();
        this.jTextAreaLog.setText(Tools.getSystemInformation() + System.getProperty("line.separator"));
        this.getFrame().setIconImage(ConstantsR64.r64icon.getImage());
        this.getFrame().setTitle("Relaunch64");
        this.editorPanes = new EditorPanes(this.jTabbedPane1, this.jComboBoxCompilers, this.jComboBoxRunScripts, this, this.settings);
        EditorPaneLineNumbers epln = new EditorPaneLineNumbers(this.jEditorPaneMain, this.settings);
        this.jScrollPaneMainEditorPane.setRowHeaderView(epln);
        this.editorPanes.addEditorPane(this.jEditorPaneMain, null, null, this.settings.getPreferredCompiler(), this.settings.getLastUserScript());
        if (params != null && params.length > 0) {
            for (String p : params) {
                this.openFile(new File(p));
            }
        }
        if (this.settings.getReopenOnStartup()) {
            this.reopenFiles();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Relaunch64View.this.checkForUpdates();
                Relaunch64View.this.jEditorPaneMain.requestFocusInWindow();
            }
        });
    }

    private void setupMacOSXApplicationListener() {
        try {
            Class<?> appc = Class.forName("com.apple.eawt.Application");
            Object app = appc.newInstance();
            Class<?> lc = Class.forName("com.apple.eawt.ApplicationListener");
            Object listener = Proxy.newProxyInstance(lc.getClassLoader(), new Class[]{lc}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) {
                    if (method.getName().equals("handleQuit")) {
                        Relaunch64App.getApplication().exit();
                    }
                    if (method.getName().equals("handlePreferences")) {
                        Relaunch64View.this.settingsWindow();
                    }
                    if (method.getName().equals("handleAbout")) {
                        Relaunch64View.this.showAboutBox();
                        try {
                            this.setHandled(args[0], Boolean.TRUE);
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                            ConstantsR64.r64logger.log(Level.WARNING, ex.getLocalizedMessage());
                        }
                    }
                    return null;
                }

                private void setHandled(Object event, Boolean val) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
                    Method handleMethod = event.getClass().getMethod("setHandled", Boolean.TYPE);
                    handleMethod.invoke(event, val);
                }
            });
            ConstantsR64.r64logger.log(Level.INFO, "Apple Class Loader successfully initiated.");
            try {
                Method m = appc.getMethod("addApplicationListener", lc);
                m.invoke(app, listener);
                Method enablePreferenceMethod = appc.getMethod("setEnabledPreferencesMenu", Boolean.TYPE);
                enablePreferenceMethod.invoke(app, Boolean.TRUE);
                ConstantsR64.r64logger.log(Level.INFO, "Apple Preference Menu successfully initiated.");
            }
            catch (NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                ConstantsR64.r64logger.log(Level.SEVERE, ex.getLocalizedMessage());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            ConstantsR64.r64logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
    }

    private void initComboBoxes() {
        this.jSplitPane2.setOrientation(this.settings.getSearchFrameSplitLayout(3));
        this.jSplitPane1.setOrientation(this.settings.getSearchFrameSplitLayout(1));
        try {
            this.initScripts();
            this.jComboBoxCompilers.setSelectedIndex(this.settings.getPreferredCompiler());
            this.jComboBoxRunScripts.setSelectedIndex(this.settings.getLastUserScript());
            this.jComboBoxGoto.removeAllItems();
            this.jComboBoxGoto.addItem("Goto ...");
            this.jComboBoxGoto.setRenderer(new ComboBoxRenderer());
            this.jComboBoxGoto.setMaximumRowCount(20);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void initScripts() {
        this.jComboBoxRunScripts.removeAllItems();
        Object[] scriptNames = this.customScripts.getScriptNames();
        if (scriptNames != null && scriptNames.length > 0) {
            Arrays.sort(scriptNames);
            for (Object sn : scriptNames) {
                this.jComboBoxRunScripts.addItem(sn);
            }
        }
    }

    private void initListeners() {
        this.getApplication().addExitListener(new ConfirmExit());
        Relaunch64View.super.getFrame().addWindowListener(this);
        Relaunch64View.super.getFrame().setDefaultCloseOperation(0);
        this.jComboBoxCompilers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (Relaunch64View.this.editorPanes.checkIfSyntaxChangeRequired()) {
                    Relaunch64View.this.editorPanes.changeSyntaxScheme(Relaunch64View.this.jComboBoxCompilers.getSelectedIndex(), Relaunch64View.this.jComboBoxRunScripts.getSelectedIndex());
                }
                Relaunch64View.this.updateRecentDoc();
            }
        });
        this.jComboBoxRunScripts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Relaunch64View.this.editorPanes.getEditorPaneProperties(Relaunch64View.this.jTabbedPane1.getSelectedIndex()).setScript(Relaunch64View.this.jComboBoxRunScripts.getSelectedIndex());
                Relaunch64View.this.updateRecentDoc();
            }
        });
        this.jComboBoxGoto.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    Relaunch64View.this.editorPanes.preventAutoInsertTab();
                }
            }
        });
        this.jComboBoxGoto.addPopupMenuListener(new PopupMenuListener(){
            boolean cbCancelled = false;

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Relaunch64View.this.jComboBoxGoto.removeAllItems();
                String header = "Goto ...";
                switch (Relaunch64View.this.comboBoxGotoIndex) {
                    case 3: {
                        header = "Goto function ...";
                        break;
                    }
                    case 2: {
                        header = "Goto section ...";
                        break;
                    }
                    case 1: {
                        header = "Goto label ...";
                        break;
                    }
                    case 4: {
                        header = "Goto macro ...";
                    }
                }
                Relaunch64View.this.jComboBoxGoto.addItem(header);
                if (Relaunch64View.this.comboBoxGotoIndex < 1) {
                    return;
                }
                ArrayList<Integer> eps = new ArrayList<Integer>();
                ArrayList<String> completeComboBoxList = new ArrayList<String>();
                eps.add(Relaunch64View.this.jTabbedPane1.getSelectedIndex());
                for (int i = 0; i < Relaunch64View.this.editorPanes.getCount(); ++i) {
                    if (eps.contains(i)) continue;
                    eps.add(i);
                }
                Relaunch64View.this.comboBoxHeadings.clear();
                Relaunch64View.this.comboBoxHeadingsEditorPaneIndex.clear();
                Iterator iterator = eps.iterator();
                while (iterator.hasNext()) {
                    ArrayList token;
                    int epIndex = (Integer)iterator.next();
                    int doubleCounter = 2;
                    switch (Relaunch64View.this.comboBoxGotoIndex) {
                        case 2: {
                            token = SectionExtractor.getSectionNames(Relaunch64View.this.editorPanes.getSourceCode(epIndex), Relaunch64View.this.editorPanes.getCompilerCommentString());
                            break;
                        }
                        case 1: {
                            token = LabelExtractor.getLabelNames(true, false, Relaunch64View.this.editorPanes.getSourceCode(epIndex), Relaunch64View.this.editorPanes.getCompiler(epIndex));
                            break;
                        }
                        case 3: {
                            token = FunctionExtractor.getFunctionNames(Relaunch64View.this.editorPanes.getSourceCode(epIndex), Relaunch64View.this.editorPanes.getCompiler(epIndex));
                            break;
                        }
                        case 4: {
                            token = FunctionExtractor.getMacroNames(Relaunch64View.this.editorPanes.getSourceCode(epIndex), Relaunch64View.this.editorPanes.getCompiler(epIndex));
                            break;
                        }
                        default: {
                            token = SectionExtractor.getSectionNames(Relaunch64View.this.editorPanes.getSourceCode(epIndex), Relaunch64View.this.editorPanes.getCompilerCommentString());
                        }
                    }
                    if (token == null || token.isEmpty()) continue;
                    Relaunch64View.this.comboBoxHeadings.add(completeComboBoxList.size() + 1);
                    Relaunch64View.this.comboBoxHeadingsEditorPaneIndex.add(epIndex);
                    completeComboBoxList.add(FileTools.getFileName(Relaunch64View.this.editorPanes.getEditorPaneProperties(epIndex).getFilePath()));
                    for (String arg : token) {
                        String item = "   " + arg;
                        if (completeComboBoxList.contains(item)) {
                            item = item + " [#" + String.valueOf(doubleCounter) + "]";
                            ++doubleCounter;
                        }
                        completeComboBoxList.add(item);
                    }
                }
                for (String arg : completeComboBoxList) {
                    Relaunch64View.this.jComboBoxGoto.addItem(arg);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (this.cbCancelled) {
                    this.cbCancelled = false;
                    return;
                }
                int selectedIndex = Relaunch64View.this.jComboBoxGoto.getSelectedIndex();
                if (selectedIndex > 0) {
                    int index = 0;
                    Iterator iterator = Relaunch64View.this.comboBoxHeadings.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        if (i > selectedIndex) continue;
                        ++index;
                    }
                    Relaunch64View.this.jTabbedPane1.setSelectedIndex((Integer)Relaunch64View.this.comboBoxHeadingsEditorPaneIndex.get(index - 1));
                    Relaunch64View.this.editorPanes.setFocus();
                    String item = Relaunch64View.this.jComboBoxGoto.getSelectedItem().toString().trim();
                    int epIndex = (Integer)Relaunch64View.this.comboBoxHeadingsEditorPaneIndex.get(index - 1);
                    item = item.replaceAll(" \\[#\\d+\\]", "");
                    switch (Relaunch64View.this.comboBoxGotoIndex) {
                        case 3: {
                            Relaunch64View.this.editorPanes.gotoFunction(item, epIndex);
                            break;
                        }
                        case 2: {
                            Relaunch64View.this.editorPanes.gotoSection(item, epIndex);
                            break;
                        }
                        case 1: {
                            Relaunch64View.this.editorPanes.gotoLabel(item, epIndex);
                        }
                        case 4: {
                            Relaunch64View.this.editorPanes.gotoMacro(item, epIndex);
                        }
                    }
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                this.cbCancelled = true;
            }
        });
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Relaunch64View.this.editorPanes.updateTabbedPane();
                Relaunch64View.this.findReplace.resetValues();
            }
        });
        this.jTextFieldFind.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                if (27 == evt.getKeyCode()) {
                    Relaunch64View.this.findCancel();
                } else if (10 == evt.getKeyCode()) {
                    Relaunch64View.this.findNext();
                }
            }
        });
        this.jTextFieldReplace.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                if (27 == evt.getKeyCode()) {
                    Relaunch64View.this.replaceCancel();
                } else if (10 == evt.getKeyCode()) {
                    Relaunch64View.this.replaceTerm();
                }
            }
        });
        this.jTextFieldGotoLine.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                if (10 == evt.getKeyCode()) {
                    try {
                        int line = Integer.parseInt(Relaunch64View.this.jTextFieldGotoLine.getText());
                        Relaunch64View.this.editorPanes.gotoLine(line);
                    }
                    catch (NumberFormatException ex) {
                        Relaunch64View.this.specialFunctions();
                    }
                }
            }
        });
        this.jTabbedPane1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() == 3) {
                    Relaunch64View.this.closeFile();
                }
            }
        });
        this.jTabbedPaneLogs.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() == 3) {
                    switch (Relaunch64View.this.jTabbedPaneLogs.getSelectedIndex()) {
                        case 0: {
                            Relaunch64View.this.clearLog1();
                            break;
                        }
                        case 1: {
                            Relaunch64View.this.clearLog2();
                        }
                    }
                }
            }
        });
        this.jTextFieldConvDez.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                Relaunch64View.this.convertNumber("dez");
            }
        });
        this.jTextFieldConvHex.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                Relaunch64View.this.convertNumber("hex");
            }
        });
        this.jTextFieldConvBin.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                Relaunch64View.this.convertNumber("bin");
            }
        });
        this.recentDocsSubmenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent evt) {
                Relaunch64View.this.setRecentDocumentMenuItem(Relaunch64View.this.recent1MenuItem, 1);
                Relaunch64View.this.setRecentDocumentMenuItem(Relaunch64View.this.recent2MenuItem, 2);
                Relaunch64View.this.setRecentDocumentMenuItem(Relaunch64View.this.recent3MenuItem, 3);
                Relaunch64View.this.setRecentDocumentMenuItem(Relaunch64View.this.recent4MenuItem, 4);
                Relaunch64View.this.setRecentDocumentMenuItem(Relaunch64View.this.recent5MenuItem, 5);
                Relaunch64View.this.setRecentDocumentMenuItem(Relaunch64View.this.recent6MenuItem, 6);
                Relaunch64View.this.setRecentDocumentMenuItem(Relaunch64View.this.recent7MenuItem, 7);
                Relaunch64View.this.setRecentDocumentMenuItem(Relaunch64View.this.recent8MenuItem, 8);
                Relaunch64View.this.setRecentDocumentMenuItem(Relaunch64View.this.recent9MenuItem, 9);
                Relaunch64View.this.setRecentDocumentMenuItem(Relaunch64View.this.recentAMenuItem, 10);
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuCanceled(MenuEvent evt) {
            }
        });
        this.recent1MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File fp = Relaunch64View.this.settings.getRecentDoc(1);
                if (fp != null && fp.exists()) {
                    Relaunch64View.this.openFile(fp, Relaunch64View.this.settings.getRecentDocCompiler(1), Relaunch64View.this.settings.getRecentDocScript(1));
                }
            }
        });
        this.recent2MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File fp = Relaunch64View.this.settings.getRecentDoc(2);
                if (fp != null && fp.exists()) {
                    Relaunch64View.this.openFile(fp, Relaunch64View.this.settings.getRecentDocCompiler(2), Relaunch64View.this.settings.getRecentDocScript(2));
                }
            }
        });
        this.recent3MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File fp = Relaunch64View.this.settings.getRecentDoc(3);
                if (fp != null && fp.exists()) {
                    Relaunch64View.this.openFile(fp, Relaunch64View.this.settings.getRecentDocCompiler(3), Relaunch64View.this.settings.getRecentDocScript(3));
                }
            }
        });
        this.recent4MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File fp = Relaunch64View.this.settings.getRecentDoc(4);
                if (fp != null && fp.exists()) {
                    Relaunch64View.this.openFile(fp, Relaunch64View.this.settings.getRecentDocCompiler(4), Relaunch64View.this.settings.getRecentDocScript(4));
                }
            }
        });
        this.recent5MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File fp = Relaunch64View.this.settings.getRecentDoc(5);
                if (fp != null && fp.exists()) {
                    Relaunch64View.this.openFile(fp, Relaunch64View.this.settings.getRecentDocCompiler(5), Relaunch64View.this.settings.getRecentDocScript(5));
                }
            }
        });
        this.recent6MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File fp = Relaunch64View.this.settings.getRecentDoc(6);
                if (fp != null && fp.exists()) {
                    Relaunch64View.this.openFile(fp, Relaunch64View.this.settings.getRecentDocCompiler(6), Relaunch64View.this.settings.getRecentDocScript(6));
                }
            }
        });
        this.recent7MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File fp = Relaunch64View.this.settings.getRecentDoc(7);
                if (fp != null && fp.exists()) {
                    Relaunch64View.this.openFile(fp, Relaunch64View.this.settings.getRecentDocCompiler(7), Relaunch64View.this.settings.getRecentDocScript(7));
                }
            }
        });
        this.recent8MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File fp = Relaunch64View.this.settings.getRecentDoc(8);
                if (fp != null && fp.exists()) {
                    Relaunch64View.this.openFile(fp, Relaunch64View.this.settings.getRecentDocCompiler(8), Relaunch64View.this.settings.getRecentDocScript(8));
                }
            }
        });
        this.recent9MenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File fp = Relaunch64View.this.settings.getRecentDoc(9);
                if (fp != null && fp.exists()) {
                    Relaunch64View.this.openFile(fp, Relaunch64View.this.settings.getRecentDocCompiler(9), Relaunch64View.this.settings.getRecentDocScript(9));
                }
            }
        });
        this.recentAMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File fp = Relaunch64View.this.settings.getRecentDoc(10);
                if (fp != null && fp.exists()) {
                    Relaunch64View.this.openFile(fp, Relaunch64View.this.settings.getRecentDocCompiler(10), Relaunch64View.this.settings.getRecentDocScript(10));
                }
            }
        });
        if (!this.settings.isOSX()) {
            Object[] keys;
            ApplicationActionMap actionMap = Application.getInstance(Relaunch64App.class).getContext().getActionMap(Relaunch64View.class, this);
            for (Object o : keys = actionMap.keys()) {
                String acckey;
                Object accob = actionMap.get(o).getValue("AcceleratorKey");
                if (accob == null || !(acckey = accob.toString()).contains("meta")) continue;
                acckey = acckey.replace("meta", "ctrl");
                actionMap.get(o).putValue("AcceleratorKey", KeyStroke.getKeyStroke(acckey));
            }
        }
    }

    private void specialFunctions() {
        this.jTextFieldGotoLine.setText("");
    }

    private void setRecentDocuments() {
        this.setRecentDocumentMenuItem(this.recent1MenuItem, 1);
        this.setRecentDocumentMenuItem(this.recent2MenuItem, 2);
        this.setRecentDocumentMenuItem(this.recent3MenuItem, 3);
        this.setRecentDocumentMenuItem(this.recent4MenuItem, 4);
        this.setRecentDocumentMenuItem(this.recent5MenuItem, 5);
        this.setRecentDocumentMenuItem(this.recent6MenuItem, 6);
        this.setRecentDocumentMenuItem(this.recent7MenuItem, 7);
        this.setRecentDocumentMenuItem(this.recent8MenuItem, 8);
        this.setRecentDocumentMenuItem(this.recent9MenuItem, 9);
        this.setRecentDocumentMenuItem(this.recentAMenuItem, 10);
    }

    private void setRecentDocumentMenuItem(JMenuItem menuItem, int recentDocNr) {
        menuItem.setVisible(false);
        File recDoc = this.settings.getRecentDoc(recentDocNr);
        if (recDoc != null && recDoc.exists()) {
            menuItem.setVisible(true);
            menuItem.setText(FileTools.getFileName(recDoc));
            menuItem.setToolTipText(recDoc.getPath());
        }
    }

    private void convertNumber(String format) {
        switch (format) {
            case "hex": {
                String input = this.jTextFieldConvHex.getText();
                try {
                    this.jTextFieldConvDez.setText(String.valueOf(Integer.parseInt(input, 16)));
                    this.jTextFieldConvBin.setText(Integer.toBinaryString(Integer.parseInt(input, 16)));
                }
                catch (NumberFormatException ex) {}
                break;
            }
            case "bin": {
                String input = this.jTextFieldConvBin.getText();
                try {
                    this.jTextFieldConvDez.setText(String.valueOf(Integer.parseInt(input, 2)));
                    this.jTextFieldConvHex.setText(Integer.toHexString(Integer.parseInt(input, 2)));
                }
                catch (NumberFormatException ex) {}
                break;
            }
            case "dez": 
            case "dec": {
                String input = this.jTextFieldConvDez.getText();
                try {
                    this.jTextFieldConvHex.setText(Integer.toHexString(Integer.parseInt(input)));
                    this.jTextFieldConvBin.setText(Integer.toBinaryString(Integer.parseInt(input)));
                    break;
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
    }

    private void initDropTargets() {
        this.jEditorPaneMain.setDragEnabled(true);
        DropTarget dropTarget = new DropTarget(this.jEditorPaneMain, this);
    }

    public void autoConvertNumbers(String selection) {
        if (selection != null && !selection.trim().isEmpty()) {
            selection = selection.trim();
            boolean isHex = false;
            boolean isDez = false;
            boolean isBin = false;
            if (selection.startsWith("#$")) {
                selection = selection.substring(2);
                isHex = selection.matches("^[0-9A-Fa-f]+$");
            } else if (selection.startsWith("$")) {
                selection = selection.substring(1);
                isHex = selection.matches("^[0-9A-Fa-f]+$");
            } else if (selection.startsWith("#%")) {
                selection = selection.substring(2);
                isBin = selection.matches("[0-1]+");
            } else if (selection.startsWith("%")) {
                selection = selection.substring(1);
                isBin = selection.matches("[0-1]+");
            } else if (selection.startsWith("#")) {
                selection = selection.substring(1);
                isDez = selection.matches("[0-9]+");
            } else if (selection.matches("[0-9]+")) {
                isDez = true;
            } else {
                isHex = selection.matches("^[0-9A-Fa-f]+$");
            }
            if (isHex) {
                this.jTextFieldConvHex.setText(selection);
                this.convertNumber("hex");
            } else if (isDez) {
                this.jTextFieldConvDez.setText(selection);
                this.convertNumber("dez");
            } else if (isBin) {
                this.jTextFieldConvBin.setText(selection);
                this.convertNumber("bin");
            }
        }
    }

    @Action
    public void settingsWindow() {
        String selectedScriptName;
        Object o = this.jComboBoxRunScripts.getSelectedItem();
        String string = selectedScriptName = o != null ? o.toString() : null;
        if (null == this.settingsDlg) {
            this.settingsDlg = new SettingsDlg((Frame)this.getFrame(), this.settings, this.customScripts);
            this.settingsDlg.setLocationRelativeTo(this.getFrame());
        }
        Relaunch64App.getApplication().show(this.settingsDlg);
        this.initScripts();
        if (this.customScripts.findScript(selectedScriptName) != -1) {
            this.jComboBoxRunScripts.setSelectedItem(selectedScriptName);
        }
        this.saveSettings();
    }

    @Action
    public void commentLine() {
        this.editorPanes.commentLine();
    }

    @Action
    public void undoAction() {
        this.editorPanes.undo();
    }

    @Action
    public void redoAction() {
        this.editorPanes.redo();
    }

    @Action
    public void gotoLine() {
        this.jTextFieldGotoLine.requestFocusInWindow();
    }

    @Action
    public void gotoSection() {
        this.comboBoxGotoIndex = 2;
        this.jComboBoxGoto.showPopup();
        this.jComboBoxGoto.requestFocusInWindow();
    }

    @Action
    public void gotoLabel() {
        this.comboBoxGotoIndex = 1;
        this.jComboBoxGoto.showPopup();
        this.jComboBoxGoto.requestFocusInWindow();
    }

    @Action
    public void gotoFunction() {
        this.comboBoxGotoIndex = 3;
        this.jComboBoxGoto.showPopup();
        this.jComboBoxGoto.requestFocusInWindow();
    }

    @Action
    public void gotoMacro() {
        this.comboBoxGotoIndex = 4;
        this.jComboBoxGoto.showPopup();
        this.jComboBoxGoto.requestFocusInWindow();
    }

    @Action
    public void jumpToLabel() {
        this.editorPanes.gotoLabel(this.editorPanes.getCaretString(true));
    }

    @Action
    public void insertSection() {
        String sectionName = JOptionPane.showInputDialog(this.getFrame(), "Section name:", "Insert section", -1);
        if (sectionName != null && !sectionName.isEmpty()) {
            this.editorPanes.insertSection(sectionName);
        }
    }

    @Action
    public void insertSeparatorLine() {
        this.editorPanes.insertSeparatorLine();
    }

    @Action
    public void gotoNextSection() {
        ArrayList ln = SectionExtractor.getSectionLineNumbers(this.editorPanes.getActiveSourceCode(), this.editorPanes.getCompilerCommentString());
        ArrayList names = SectionExtractor.getSectionNames(this.editorPanes.getActiveSourceCode(), this.editorPanes.getCompilerCommentString());
        int currentLine = this.editorPanes.getCurrentLineNumber();
        String dest = null;
        boolean labelFound = false;
        for (int i = 0; i < ln.size(); ++i) {
            if ((Integer)ln.get(i) <= currentLine) continue;
            dest = (String)names.get(i);
            labelFound = true;
            break;
        }
        try {
            if (!labelFound) {
                dest = (String)names.get(0);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        this.editorPanes.gotoSection(dest);
    }

    @Action
    public void gotoPrevSection() {
        ArrayList ln = SectionExtractor.getSectionLineNumbers(this.editorPanes.getActiveSourceCode(), this.editorPanes.getCompilerCommentString());
        ArrayList names = SectionExtractor.getSectionNames(this.editorPanes.getActiveSourceCode(), this.editorPanes.getCompilerCommentString());
        int currentLine = this.editorPanes.getCurrentLineNumber();
        String dest = null;
        boolean labelFound = false;
        for (int i = ln.size() - 1; i >= 0; --i) {
            if ((Integer)ln.get(i) >= currentLine) continue;
            dest = (String)names.get(i);
            labelFound = true;
            break;
        }
        try {
            if (!labelFound) {
                dest = (String)names.get(names.size() - 1);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        this.editorPanes.gotoSection(dest);
    }

    @Action
    public void gotoNextError() {
        boolean labelFound = false;
        int currentLine = this.editorPanes.getCurrentLineNumber();
        for (Integer errorLine : this.errorLines) {
            if (errorLine <= currentLine) continue;
            this.editorPanes.gotoLine(errorLine);
            labelFound = true;
            break;
        }
        try {
            if (!labelFound) {
                this.editorPanes.gotoLine(this.errorLines.get(0));
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Action
    public void gotoPrevError() {
        boolean labelFound = false;
        int currentLine = this.editorPanes.getCurrentLineNumber();
        for (int i = this.errorLines.size() - 1; i >= 0; --i) {
            if (this.errorLines.get(i) >= currentLine) continue;
            this.editorPanes.gotoLine(this.errorLines.get(i));
            labelFound = true;
            break;
        }
        try {
            if (!labelFound) {
                this.editorPanes.gotoLine(this.errorLines.get(this.errorLines.size() - 1));
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Action
    public void gotoNextLabel() {
        ArrayList ln = LabelExtractor.getLabelLineNumbers(this.editorPanes.getActiveSourceCode(), this.editorPanes.getActiveCompiler());
        ArrayList names = LabelExtractor.getLabelNames(false, false, this.editorPanes.getActiveSourceCode(), this.editorPanes.getActiveCompiler());
        int currentLine = this.editorPanes.getCurrentLineNumber();
        String dest = null;
        boolean labelFound = false;
        for (int i = 0; i < ln.size(); ++i) {
            if ((Integer)ln.get(i) <= currentLine) continue;
            dest = (String)names.get(i);
            labelFound = true;
            break;
        }
        try {
            if (!labelFound) {
                dest = (String)names.get(0);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        this.editorPanes.gotoLabel(dest);
    }

    @Action
    public void gotoPrevLabel() {
        ArrayList ln = LabelExtractor.getLabelLineNumbers(this.editorPanes.getActiveSourceCode(), this.editorPanes.getActiveCompiler());
        ArrayList names = LabelExtractor.getLabelNames(false, false, this.editorPanes.getActiveSourceCode(), this.editorPanes.getActiveCompiler());
        int currentLine = this.editorPanes.getCurrentLineNumber();
        String dest = null;
        boolean labelFound = false;
        for (int i = ln.size() - 1; i >= 0; --i) {
            if ((Integer)ln.get(i) >= currentLine) continue;
            dest = (String)names.get(i);
            labelFound = true;
            break;
        }
        try {
            if (!labelFound) {
                dest = (String)names.get(names.size() - 1);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        this.editorPanes.gotoLabel(dest);
    }

    @Action
    public void setFocusToSource() {
        this.editorPanes.setFocus();
    }

    @Action
    public void addNewTab() {
        this.editorPanes.addNewTab(null, null, "untitled", this.settings.getPreferredCompiler(), this.jComboBoxRunScripts.getSelectedIndex());
    }

    @Action
    public void openFile() {
        File fileToOpen = FileTools.chooseFile(this.getFrame(), 0, 0, this.settings.getLastUsedPath().getAbsolutePath(), "", "Open ASM File", ConstantsR64.FILE_EXTENSIONS, "ASM-Files");
        this.openFile(fileToOpen);
    }

    private void openFile(File fileToOpen) {
        this.openFile(fileToOpen, this.settings.getPreferredCompiler());
    }

    private void openFile(File fileToOpen, int compiler) {
        this.openFile(fileToOpen, compiler, this.jComboBoxRunScripts.getSelectedIndex());
    }

    private void openFile(File fileToOpen, int compiler, int script) {
        if (this.editorPanes.loadFile(fileToOpen, compiler, script)) {
            this.settings.addToRecentDocs(fileToOpen.toString(), compiler, script);
            this.setRecentDocuments();
            this.settings.setLastUsedPath(fileToOpen);
            try {
                this.jComboBoxCompilers.setSelectedIndex(compiler);
                this.jComboBoxRunScripts.setSelectedIndex(script);
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
    }

    private void updateRecentDoc() {
        File cf = this.editorPanes.getActiveFilePath();
        int rd = this.settings.findRecentDoc(cf);
        if (rd != -1 && cf != null) {
            this.settings.setRecentDoc(rd, cf.toString(), this.jComboBoxCompilers.getSelectedIndex(), this.jComboBoxRunScripts.getSelectedIndex());
        }
    }

    private void reopenFiles() {
        ArrayList<Object[]> files = this.settings.getReopenFiles();
        if (files != null && !files.isEmpty()) {
            for (Object[] o : files) {
                File fp = new File(o[0].toString());
                int compiler = Integer.parseInt(o[1].toString());
                int script = Integer.parseInt(o[2].toString());
                this.openFile(fp, compiler, script);
            }
        }
    }

    @Action
    public void saveFile() {
        if (this.editorPanes.saveFile()) {
            this.settings.addToRecentDocs(this.editorPanes.getActiveFilePath().getPath(), this.jComboBoxCompilers.getSelectedIndex(), this.jComboBoxRunScripts.getSelectedIndex());
            this.setRecentDocuments();
        }
    }

    @Action
    public void saveAllFiles() {
        this.editorPanes.saveAllFiles();
    }

    @Action
    public void closeFile() {
        if (this.editorPanes.closeFile()) {
            if (this.jTabbedPane1.getTabCount() > 0) {
                int selectedTab = this.jTabbedPane1.getSelectedIndex();
                try {
                    this.jTabbedPane1.remove(selectedTab);
                }
                catch (IndexOutOfBoundsException ex) {
                    ConstantsR64.r64logger.log(Level.WARNING, ex.getLocalizedMessage());
                }
            }
            if (this.jTabbedPane1.getTabCount() < 1) {
                this.editorPanes = new EditorPanes(this.jTabbedPane1, this.jComboBoxCompilers, this.jComboBoxRunScripts, this, this.settings);
                this.editorPanes.addNewTab(null, null, "untitled", this.settings.getPreferredCompiler(), this.jComboBoxRunScripts.getSelectedIndex());
                this.jEditorPaneMain.requestFocusInWindow();
            }
        }
    }

    @Action
    public void closeAll() {
        int count = this.jTabbedPane1.getTabCount();
        for (int cnt = 0; cnt < count; ++cnt) {
            this.closeFile();
        }
    }

    @Action
    public void saveFileAs() {
        if (this.editorPanes.saveFileAs()) {
            this.settings.addToRecentDocs(this.editorPanes.getActiveFilePath().getPath(), this.jComboBoxCompilers.getSelectedIndex(), this.jComboBoxRunScripts.getSelectedIndex());
            this.setRecentDocuments();
        }
    }

    @Action
    public void runScript() {
        Object item = this.jComboBoxRunScripts.getSelectedItem();
        if (item != null) {
            String script = this.customScripts.getScript(item.toString());
            if (script != null && !script.isEmpty()) {
                File sourceFile;
                this.clearLog1();
                this.clearLog2();
                this.errorLines.clear();
                script = script.replaceAll("\r", "");
                String[] lines = script.split("\n");
                if (this.settings.getSaveOnCompile() && this.editorPanes.isModified()) {
                    this.editorPanes.saveFile();
                }
                String parentFile = null == (sourceFile = this.editorPanes.getActiveFilePath()).getParentFile() ? sourceFile.toString() : sourceFile.getParentFile().toString();
                File outFile = new File(parentFile + File.separator + FileTools.getFileName(sourceFile) + ".prg");
                File compressedFile = new File(parentFile + File.separator + FileTools.getFileName(sourceFile) + "-compressed.prg");
                for (String cmd : lines) {
                    String cf;
                    String of;
                    if ((cmd = cmd.trim()).isEmpty()) continue;
                    String log = "Processing script-line: " + cmd;
                    ConstantsR64.r64logger.log(Level.INFO, log);
                    String sf = sourceFile.toString();
                    if (sf.contains(" ") && !sf.startsWith("\"") && !sf.startsWith("'")) {
                        sf = "\"" + sf + "\"";
                    }
                    if ((of = outFile.toString()).contains(" ") && !of.startsWith("\"") && !of.startsWith("'")) {
                        of = "\"" + of + "\"";
                    }
                    if ((cf = compressedFile.toString()).contains(" ") && !cf.startsWith("\"") && !cf.startsWith("'")) {
                        cf = "\"" + cf + "\"";
                    }
                    cmd = cmd.replace("SOURCEFILE", sf);
                    cmd = cmd.replace("OUTFILE", of);
                    cmd = cmd.replace("UNCOMPFILE", of);
                    cmd = cmd.replace("COMPFILE", cf);
                    String cruncherStart = Tools.getCruncherStart(this.editorPanes.getActiveSourceCode(), this.editorPanes.getActiveCompiler());
                    if (cruncherStart != null) {
                        cmd = cmd.replace("START", cruncherStart);
                    }
                    try {
                        log = "Converted script-line: " + cmd;
                        ConstantsR64.r64logger.log(Level.INFO, log);
                        StringBuilder compilerLog = new StringBuilder("");
                        ProcessBuilder pb = new ProcessBuilder(cmd.split(" "));
                        pb = pb.directory(sourceFile.getParentFile());
                        pb = pb.redirectInput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.PIPE);
                        Process p = pb.start();
                        try (Scanner sc = new Scanner(p.getInputStream()).useDelimiter(System.getProperty("line.separator"));){
                            while (sc.hasNextLine()) {
                                compilerLog.append(System.getProperty("line.separator")).append(sc.nextLine());
                            }
                        }
                        sc = new Scanner(p.getErrorStream()).useDelimiter(System.getProperty("line.separator"));
                        var21_22 = null;
                        try {
                            while (sc.hasNextLine()) {
                                compilerLog.append(System.getProperty("line.separator")).append(sc.nextLine());
                            }
                        }
                        catch (Throwable throwable) {
                            var21_22 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (sc != null) {
                                if (var21_22 != null) {
                                    try {
                                        sc.close();
                                    }
                                    catch (Throwable throwable) {
                                        var21_22.addSuppressed(throwable);
                                    }
                                } else {
                                    sc.close();
                                }
                            }
                        }
                        compilerLog.append(System.getProperty("line.separator"));
                        this.jTextAreaCompilerOutput.append(compilerLog.toString());
                        p.waitFor();
                        p.destroy();
                        this.errorLines.addAll(Tools.getErrorLines(compilerLog.toString()));
                        if (this.errorLines.isEmpty() && p.exitValue() == 0) continue;
                        break;
                    }
                    catch (IOException | InterruptedException | SecurityException ex) {
                        ConstantsR64.r64logger.log(Level.WARNING, ex.getLocalizedMessage());
                        if (!ex.getLocalizedMessage().toLowerCase().contains("permission denied")) continue;
                        ConstantsR64.r64logger.log(Level.INFO, "Permission denied. Try to define user scripts in the preferences and use \"open\" or \"/bin/sh\" as parameters (see Help on Preference pane tab)!");
                    }
                }
                if (!this.errorLines.isEmpty()) {
                    this.selectLog2();
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.getFrame(), "Please open preferences and add a 'compile and run' script first!");
        }
    }

    @Action
    public void switchLogPosition() {
        int currentlayout = this.settings.getSearchFrameSplitLayout(1);
        currentlayout = 1 == currentlayout ? 0 : 1;
        this.settings.setSearchFrameSplitLayout(currentlayout, 1);
        this.jSplitPane1.setOrientation(currentlayout);
    }

    @Action
    public void switchBothPosition() {
        int currentlayout = this.settings.getSearchFrameSplitLayout(3);
        currentlayout = 1 == currentlayout ? 0 : 1;
        this.settings.setSearchFrameSplitLayout(currentlayout, 3);
        this.jSplitPane2.setOrientation(currentlayout);
    }

    @Action
    public void clearLog1() {
        this.jTextAreaLog.setText(Tools.getSystemInformation() + System.getProperty("line.separator"));
    }

    @Action
    public void clearLog2() {
        this.jTextAreaCompilerOutput.setText("");
    }

    @Action
    public void selectUserScripts() {
        this.jComboBoxRunScripts.showPopup();
        this.jComboBoxRunScripts.requestFocusInWindow();
    }

    @Action
    public void selectSyntax() {
        this.jComboBoxCompilers.showPopup();
        this.jComboBoxCompilers.requestFocusInWindow();
    }

    @Action
    public void selectLog1() {
        this.jTabbedPaneLogs.setSelectedIndex(0);
    }

    @Action
    public void selectLog2() {
        this.jTabbedPaneLogs.setSelectedIndex(1);
    }

    @Action
    public void selectAllText() {
        this.editorPanes.getActiveEditorPane().selectAll();
    }

    @Action
    public void findStart() {
        if (!this.jPanelFind.isVisible()) {
            this.jPanelFind.setVisible(true);
        }
        this.jTextFieldFind.requestFocusInWindow();
    }

    @Action
    public void findNext() {
        this.findReplace.initValues(this.jTextFieldFind.getText(), this.jTextFieldReplace.getText(), this.jTabbedPane1.getSelectedIndex(), this.editorPanes.getActiveEditorPane());
        this.jTextFieldFind.setForeground(this.findReplace.findNext() ? Color.black : Color.red);
    }

    @Action
    public void findPrev() {
        this.findReplace.initValues(this.jTextFieldFind.getText(), this.jTextFieldReplace.getText(), this.jTabbedPane1.getSelectedIndex(), this.editorPanes.getActiveEditorPane());
        this.jTextFieldFind.setForeground(this.findReplace.findPrev() ? Color.black : Color.red);
    }

    private void findCancel() {
        this.replaceCancel();
        this.findReplace.resetValues();
        this.jTextFieldFind.setForeground(Color.black);
        this.jPanelFind.setVisible(false);
        this.editorPanes.setFocus();
    }

    @Action
    public void replaceAll() {
        this.findReplace.initValues(this.jTextFieldFind.getText(), this.jTextFieldReplace.getText(), this.jTabbedPane1.getSelectedIndex(), this.editorPanes.getActiveEditorPane(), true);
        int findCounter = 0;
        while (this.findReplace.replace()) {
            ++findCounter;
        }
        JOptionPane.showMessageDialog(this.getFrame(), String.valueOf(findCounter) + " occurences were replaced.");
    }

    @Action
    public void replaceTerm() {
        this.jPanelFind.setVisible(true);
        if (!this.jPanelReplace.isVisible()) {
            this.jPanelReplace.setVisible(true);
            if (this.jTextFieldFind.getText().isEmpty()) {
                this.jTextFieldFind.requestFocusInWindow();
            } else {
                this.jTextFieldReplace.requestFocusInWindow();
            }
        } else {
            this.findReplace.initValues(this.jTextFieldFind.getText(), this.jTextFieldReplace.getText(), this.jTabbedPane1.getSelectedIndex(), this.editorPanes.getActiveEditorPane());
            this.jTextFieldReplace.setForeground(this.findReplace.replace() ? Color.black : Color.red);
        }
    }

    private void replaceCancel() {
        this.jTextFieldReplace.setForeground(Color.black);
        this.jPanelReplace.setVisible(false);
        this.editorPanes.setFocus();
    }

    @Action
    public void insertBytesFromFile() {
        if (null == this.insertByteFromFileDlg) {
            this.insertByteFromFileDlg = new InsertByteFromFileDlg((Frame)this.getFrame(), this.settings, this.editorPanes.getActiveCompiler());
            this.insertByteFromFileDlg.setLocationRelativeTo(this.getFrame());
        }
        Relaunch64App.getApplication().show(this.insertByteFromFileDlg);
        String bytetable = this.insertByteFromFileDlg.getByteTable();
        if (bytetable != null && !bytetable.isEmpty()) {
            this.editorPanes.insertString(bytetable);
        }
        this.insertByteFromFileDlg = null;
    }

    @Action
    public void insertBasicStart() {
        Tools.insertBasicStart(this.editorPanes);
    }

    @Action
    public void insertBreakPoint() {
        InsertBreakPoint.insertBreakPoint(this.editorPanes);
    }

    @Action
    public void removeAllBreakPoints() {
        InsertBreakPoint.removeBreakPoints(this.editorPanes);
    }

    @Action
    public void insertSinusTable() {
        if (null == this.insertSinusTableDlg) {
            this.insertSinusTableDlg = new InsertSinusTableDlg((Frame)this.getFrame(), this.editorPanes.getActiveCompiler());
            this.insertSinusTableDlg.setLocationRelativeTo(this.getFrame());
        }
        Relaunch64App.getApplication().show(this.insertSinusTableDlg);
        String bytetable = this.insertSinusTableDlg.getByteTable();
        if (bytetable != null && !bytetable.isEmpty()) {
            this.editorPanes.insertString(bytetable);
        }
        this.insertSinusTableDlg = null;
    }

    private void setDefaultLookAndFeel() {
        UIManager.LookAndFeelInfo[] installed_laf = UIManager.getInstalledLookAndFeels();
        String classname = "";
        for (UIManager.LookAndFeelInfo laf : installed_laf) {
            if (!laf.getClassName().toLowerCase().contains("nimbus")) continue;
            classname = laf.getClassName();
            break;
        }
        if (!classname.isEmpty()) {
            try {
                UIManager.setLookAndFeel(classname);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                ConstantsR64.r64logger.log(Level.WARNING, ex.getLocalizedMessage());
            }
        }
        if (this.settings.isOSX()) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Relaunch64");
        }
        System.setProperty("awt.useSystemAAFontSettings", "on");
    }

    private void saveSettings() {
        this.settings.setLastUserScript(this.jComboBoxRunScripts.getSelectedIndex());
        this.settings.setReopenFiles(this.editorPanes);
        this.settings.saveSettings();
        this.customScripts.saveScripts();
    }

    @Action
    public void showHelp() {
        if (this.aboutBox == null) {
            JFrame mainFrame = Relaunch64App.getApplication().getMainFrame();
            this.aboutBox = new Relaunch64AboutBox((Frame)mainFrame, Application.getInstance(Relaunch64App.class).getClass().getResource("/de/relaunch64/popelganda/resources/help.html"));
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        Relaunch64App.getApplication().show(this.aboutBox);
        this.aboutBox.dispose();
        this.aboutBox = null;
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = Relaunch64App.getApplication().getMainFrame();
            this.aboutBox = new Relaunch64AboutBox((Frame)mainFrame, Application.getInstance(Relaunch64App.class).getClass().getResource("/de/relaunch64/popelganda/resources/licence.html"));
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        Relaunch64App.getApplication().show(this.aboutBox);
        this.aboutBox.dispose();
        this.aboutBox = null;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        boolean validDropLocation = false;
        Transferable tr = dtde.getTransferable();
        try {
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List files;
                String name;
                dtde.acceptDrop(0x40000003);
                Component c = dtde.getDropTargetContext().getDropTarget().getComponent();
                if (c != null && (name = c.getName()) != null && !name.isEmpty()) {
                    if (name.equalsIgnoreCase("jEditorPaneMain")) {
                        validDropLocation = true;
                    } else {
                        ConstantsR64.r64logger.log(Level.WARNING, "No valid drop location, drop rejected");
                        dtde.rejectDrop();
                    }
                }
                if ((files = (List)tr.getTransferData(DataFlavor.javaFileListFlavor)) != null && files.size() > 0) {
                    String relpath;
                    String insert;
                    ArrayList<File> anyfiles = new ArrayList<File>();
                    ArrayList<File> includefiles = new ArrayList<File>();
                    ArrayList<File> linkedfiles = new ArrayList<File>();
                    for (Object file1 : files) {
                        File file = (File)file1;
                        if (!file.isFile()) continue;
                        if (dtde.getDropAction() == 0x40000000 && validDropLocation) {
                            linkedfiles.add(file);
                            continue;
                        }
                        if (FileTools.hasValidFileExtension(file) && validDropLocation) {
                            anyfiles.add(file);
                            continue;
                        }
                        if (!FileTools.hasValidIncludeFileExtension(file) || !validDropLocation) continue;
                        includefiles.add(file);
                    }
                    if (linkedfiles.size() > 0) {
                        for (File f : linkedfiles) {
                            this.editorPanes.insertString("\"" + f.toString() + "\"" + System.getProperty("line.separator"));
                        }
                    }
                    if (includefiles.size() > 0) {
                        for (File f : includefiles) {
                            insert = "";
                            if (dtde.getDropAction() == 1) {
                                insert = Tools.getByteTableFromFile(f, this.editorPanes.getActiveCompiler());
                            } else {
                                relpath = FileTools.getRelativePath(this.editorPanes.getActiveFilePath(), f);
                                if (FileTools.getFileExtension(f).equalsIgnoreCase("bin")) {
                                    switch (this.editorPanes.getActiveCompiler()) {
                                        case 1: {
                                            insert = "!bin \"" + relpath + "\"" + System.getProperty("line.separator");
                                            break;
                                        }
                                        case 0: {
                                            insert = ".import binary \"" + relpath + "\"" + System.getProperty("line.separator");
                                            break;
                                        }
                                        case 2: {
                                            insert = ".binary \"" + relpath + "\"" + System.getProperty("line.separator");
                                        }
                                    }
                                } else if (FileTools.getFileExtension(f).equalsIgnoreCase("txt")) {
                                    switch (this.editorPanes.getActiveCompiler()) {
                                        case 1: {
                                            insert = "!bin \"" + relpath + "\"" + System.getProperty("line.separator");
                                            break;
                                        }
                                        case 0: {
                                            insert = ".import text \"" + relpath + "\"" + System.getProperty("line.separator");
                                            break;
                                        }
                                        case 2: {
                                            insert = ".binary \"" + relpath + "\"" + System.getProperty("line.separator");
                                        }
                                    }
                                } else if (FileTools.getFileExtension(f).equalsIgnoreCase("c64")) {
                                    switch (this.editorPanes.getActiveCompiler()) {
                                        case 1: {
                                            insert = "!bin \"" + relpath + "\",,2" + System.getProperty("line.separator");
                                            break;
                                        }
                                        case 0: {
                                            insert = ".import c64 \"" + relpath + "\"" + System.getProperty("line.separator");
                                            break;
                                        }
                                        case 2: {
                                            insert = ".binary \"" + relpath + "\",2" + System.getProperty("line.separator");
                                        }
                                    }
                                }
                            }
                            this.editorPanes.insertString(insert);
                        }
                    }
                    if (anyfiles.size() > 0) {
                        for (File f : anyfiles) {
                            if (dtde.getDropAction() == 1) {
                                insert = "";
                                relpath = FileTools.getRelativePath(this.editorPanes.getActiveFilePath(), f);
                                switch (this.editorPanes.getActiveCompiler()) {
                                    case 1: {
                                        insert = "!src \"" + relpath + "\"" + System.getProperty("line.separator");
                                        break;
                                    }
                                    case 0: {
                                        insert = ".import source \"" + relpath + "\"" + System.getProperty("line.separator");
                                        break;
                                    }
                                    case 2: {
                                        insert = ".binclude \"" + relpath + "\"" + System.getProperty("line.separator");
                                    }
                                }
                                this.editorPanes.insertString(insert);
                                continue;
                            }
                            this.openFile(f);
                        }
                    }
                }
                dtde.getDropTargetContext().dropComplete(true);
            } else {
                ConstantsR64.r64logger.log(Level.WARNING, "DataFlavor.javaFileListFlavor is not supported, drop rejected");
                dtde.rejectDrop();
            }
        }
        catch (UnsupportedFlavorException | IOException ex) {
            ConstantsR64.r64logger.log(Level.WARNING, ex.getLocalizedMessage());
            dtde.rejectDrop();
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        Relaunch64App.getApplication().exit();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    private boolean askForSaveChanges() {
        boolean changes = false;
        int count = this.editorPanes.getCount();
        for (int i = 0; i < count; ++i) {
            if (!this.editorPanes.isModified(i)) continue;
            changes = true;
        }
        if (changes) {
            int option = JOptionPane.showConfirmDialog(this.getFrame(), this.resourceMap.getString("msgSaveChangesOnExit", new Object[0]), this.resourceMap.getString("msgSaveChangesOnExitTitle", new Object[0]), 1, -1);
            if (2 == option || -1 == option) {
                return false;
            }
            if (0 == option) {
                boolean saveok = true;
                for (int i = 0; i < count; ++i) {
                    if (!this.editorPanes.isModified(i) || this.editorPanes.saveFile()) continue;
                    saveok = false;
                }
                return saveok;
            }
        }
        return true;
    }

    public void checkForUpdates() {
        if (!this.settings.getCheckForUpdates()) {
            return;
        }
        Task cfuT = this.checkForUpdate();
        ApplicationContext appC = Application.getInstance().getContext();
        TaskMonitor tM = appC.getTaskMonitor();
        TaskService tS = appC.getTaskService();
        tS.execute(cfuT);
        tM.setForegroundTask(cfuT);
    }

    public final Task checkForUpdate() {
        return new CheckForUpdates(Application.getInstance(Relaunch64App.class));
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPaneMainEditorPane = new JScrollPane();
        this.jEditorPaneMain = new JEditorPane();
        this.jPanelFind = new JPanel();
        this.jTextFieldFind = new JTextField();
        this.jButtonFindPrev = new JButton();
        this.jButtonFindNext = new JButton();
        this.jLabel5 = new JLabel();
        this.jPanelReplace = new JPanel();
        this.jLabel4 = new JLabel();
        this.jTextFieldReplace = new JTextField();
        this.jButtonReplace = new JButton();
        this.jPanel2 = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jPanel9 = new JPanel();
        this.jComboBoxRunScripts = new JComboBox();
        this.jButtonRunScript = new JButton();
        this.jComboBoxCompilers = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jTabbedPaneLogs = new JTabbedPane();
        this.jPanel6 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaLog = new JTextArea();
        this.jPanel5 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextAreaCompilerOutput = new JTextArea();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.addTabMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.openFileMenuItem = new JMenuItem();
        this.recentDocsSubmenu = new JMenu();
        this.recent1MenuItem = new JMenuItem();
        this.recent2MenuItem = new JMenuItem();
        this.recent3MenuItem = new JMenuItem();
        this.recent4MenuItem = new JMenuItem();
        this.recent5MenuItem = new JMenuItem();
        this.recent6MenuItem = new JMenuItem();
        this.recent7MenuItem = new JMenuItem();
        this.recent8MenuItem = new JMenuItem();
        this.recent9MenuItem = new JMenuItem();
        this.recentAMenuItem = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.saveAllMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.closeFileMenuItem = new JMenuItem();
        this.closeAllMenuItem = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        JMenuItem exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.undoMenuItem = new JMenuItem();
        this.redoMenuItem = new JMenuItem();
        this.jSeparator10 = new JPopupMenu.Separator();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.selectAllMenuItem = new JMenuItem();
        this.findMenu = new JMenu();
        this.findStartMenuItem = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.findPrevMenuItem = new JMenuItem();
        this.findNextMenuItem = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.replaceMenuItem = new JMenuItem();
        this.replaceAllMenuItem = new JMenuItem();
        this.gotoMenu = new JMenu();
        this.gotoFunctionMenuItem = new JMenuItem();
        this.gotoLabelMenuItem = new JMenuItem();
        this.gotoLineMenuItem = new JMenuItem();
        this.gotoMacroMenuItem = new JMenuItem();
        this.gotoSectionMenuItem = new JMenuItem();
        this.jSeparator11 = new JPopupMenu.Separator();
        this.jumpToLabelMenuItem = new JMenuItem();
        this.jSeparator13 = new JPopupMenu.Separator();
        this.gotoNextLabel = new JMenuItem();
        this.gotoPrevLabel = new JMenuItem();
        this.jSeparator12 = new JPopupMenu.Separator();
        this.gotoNextSectionMenuItem = new JMenuItem();
        this.gotoPrevSectionMenuItem = new JMenuItem();
        this.jSeparator20 = new JPopupMenu.Separator();
        this.gotoNextErrorMenuItem = new JMenuItem();
        this.gotoPrevErrorMenuItem = new JMenuItem();
        this.sourceMenu = new JMenu();
        this.runScriptMenuItem = new JMenuItem();
        this.focusScriptMenuItem = new JMenuItem();
        this.focusSyntaxMenuItem = new JMenuItem();
        this.jSeparator17 = new JPopupMenu.Separator();
        this.commentLineMenuItem = new JMenuItem();
        this.jSeparator8 = new JPopupMenu.Separator();
        this.insertSectionMenuItem = new JMenuItem();
        this.insertSeparatorMenuItem = new JMenuItem();
        this.jSeparator14 = new JPopupMenu.Separator();
        this.insertBreakPointMenuItem = new JMenuItem();
        this.removeBreakpointMenuItem = new JMenuItem();
        this.jSeparator15 = new JPopupMenu.Separator();
        this.insertBasicStartMenuItem = new JMenuItem();
        this.insertBytesFromFileMenuItem = new JMenuItem();
        this.insertSinusMenuItem = new JMenuItem();
        this.jSeparator16 = new JPopupMenu.Separator();
        this.viewMainTabMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.viewLog1MenuItem = new JMenuItem();
        this.viewLog2MenuItem = new JMenuItem();
        this.jSeparator19 = new JPopupMenu.Separator();
        this.switchBothMenuItem = new JMenuItem();
        this.switchLogPosMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        this.settingsMenuItem = new JMenuItem();
        this.jSeparator9 = new JPopupMenu.Separator();
        this.helpMenuItem = new JMenuItem();
        this.jSeparator18 = new JPopupMenu.Separator();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.jLabel6 = new JLabel();
        this.jTextFieldConvDez = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextFieldConvHex = new JTextField();
        this.jLabel8 = new JLabel();
        this.jTextFieldConvBin = new JTextField();
        this.jLabel9 = new JLabel();
        this.jTextFieldGotoLine = new JTextField();
        this.jComboBoxGoto = new JComboBox();
        this.mainPanel.setName("mainPanel");
        this.jSplitPane1.setDividerLocation(480);
        this.jSplitPane1.setName("jSplitPane1");
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jPanel1.setName("jPanel1");
        this.jTabbedPane1.setName("jTabbedPane1");
        this.jScrollPaneMainEditorPane.setName("jScrollPaneMainEditorPane");
        this.jEditorPaneMain.setName("jEditorPaneMain");
        this.jScrollPaneMainEditorPane.setViewportView(this.jEditorPaneMain);
        ResourceMap resourceMap = Application.getInstance(Relaunch64App.class).getContext().getResourceMap(Relaunch64View.class);
        this.jTabbedPane1.addTab(resourceMap.getString("jScrollPaneMainEditorPane.TabConstraints.tabTitle", new Object[0]), this.jScrollPaneMainEditorPane);
        this.jPanelFind.setName("jPanelFind");
        this.jTextFieldFind.setToolTipText(resourceMap.getString("jTextFieldFind.toolTipText", new Object[0]));
        this.jTextFieldFind.setName("jTextFieldFind");
        ApplicationActionMap actionMap = Application.getInstance(Relaunch64App.class).getContext().getActionMap(Relaunch64View.class, this);
        this.jButtonFindPrev.setAction(actionMap.get("findPrev"));
        this.jButtonFindPrev.setIcon(resourceMap.getIcon("jButtonFindPrev.icon"));
        this.jButtonFindPrev.setText(resourceMap.getString("jButtonFindPrev.text", new Object[0]));
        this.jButtonFindPrev.setName("jButtonFindPrev");
        this.jButtonFindNext.setAction(actionMap.get("findNext"));
        this.jButtonFindNext.setIcon(resourceMap.getIcon("jButtonFindNext.icon"));
        this.jButtonFindNext.setText(resourceMap.getString("jButtonFindNext.text", new Object[0]));
        this.jButtonFindNext.setName("jButtonFindNext");
        this.jLabel5.setDisplayedMnemonic('i');
        this.jLabel5.setLabelFor(this.jTextFieldFind);
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        GroupLayout jPanelFindLayout = new GroupLayout(this.jPanelFind);
        this.jPanelFind.setLayout(jPanelFindLayout);
        jPanelFindLayout.setHorizontalGroup(jPanelFindLayout.createParallelGroup(1).add(jPanelFindLayout.createSequentialGroup().addContainerGap().add(this.jLabel5).addPreferredGap(0).add(this.jTextFieldFind).addPreferredGap(0).add(this.jButtonFindPrev).addPreferredGap(0).add(this.jButtonFindNext).addContainerGap()));
        jPanelFindLayout.setVerticalGroup(jPanelFindLayout.createParallelGroup(1).add(jPanelFindLayout.createParallelGroup(4).add(this.jLabel5).add(this.jTextFieldFind, -2, -1, -2).add(this.jButtonFindPrev).add(this.jButtonFindNext)));
        this.jPanelReplace.setName("jPanelReplace");
        this.jLabel4.setDisplayedMnemonic('R');
        this.jLabel4.setLabelFor(this.jTextFieldReplace);
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.jTextFieldReplace.setToolTipText(resourceMap.getString("jTextFieldReplace.toolTipText", new Object[0]));
        this.jTextFieldReplace.setName("jTextFieldReplace");
        this.jButtonReplace.setAction(actionMap.get("replaceTerm"));
        this.jButtonReplace.setIcon(resourceMap.getIcon("jButtonReplace.icon"));
        this.jButtonReplace.setText(resourceMap.getString("jButtonReplace.text", new Object[0]));
        this.jButtonReplace.setName("jButtonReplace");
        GroupLayout jPanelReplaceLayout = new GroupLayout(this.jPanelReplace);
        this.jPanelReplace.setLayout(jPanelReplaceLayout);
        jPanelReplaceLayout.setHorizontalGroup(jPanelReplaceLayout.createParallelGroup(1).add(jPanelReplaceLayout.createSequentialGroup().addContainerGap().add(this.jLabel4).addPreferredGap(0).add(this.jTextFieldReplace).addPreferredGap(0).add(this.jButtonReplace).addContainerGap()));
        jPanelReplaceLayout.setVerticalGroup(jPanelReplaceLayout.createParallelGroup(1).add(jPanelReplaceLayout.createParallelGroup(4).add(this.jTextFieldReplace, -2, -1, -2).add(this.jLabel4).add(this.jButtonReplace)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(this.jTabbedPane1, -1, 478, Short.MAX_VALUE).add(this.jPanelFind, -1, -1, Short.MAX_VALUE).add(this.jPanelReplace, -1, -1, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(this.jTabbedPane1, -1, 546, Short.MAX_VALUE).addPreferredGap(0).add(this.jPanelFind, -2, -1, -2).addPreferredGap(0).add(this.jPanelReplace, -2, -1, -2).addContainerGap()));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jPanel2.setName("jPanel2");
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setName("jSplitPane2");
        this.jSplitPane2.setOneTouchExpandable(true);
        this.jPanel3.setName("jPanel3");
        this.jPanel9.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel9.border.title", new Object[0])));
        this.jPanel9.setName("jPanel9");
        this.jComboBoxRunScripts.setName("jComboBoxRunScripts");
        this.jButtonRunScript.setAction(actionMap.get("runScript"));
        this.jButtonRunScript.setName("jButtonRunScript");
        this.jComboBoxCompilers.setModel(new DefaultComboBoxModel<String>(ConstantsR64.COMPILER_NAMES));
        this.jComboBoxCompilers.setName("jComboBoxCompilers");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(1).add(jPanel9Layout.createSequentialGroup().addContainerGap().add(jPanel9Layout.createParallelGroup(1).add(this.jLabel2).add(this.jLabel1)).addPreferredGap(0).add(jPanel9Layout.createParallelGroup(1).add(this.jComboBoxRunScripts, -2, -1, -2).add(this.jComboBoxCompilers, -2, -1, -2)).addPreferredGap(0, 161, Short.MAX_VALUE).add(this.jButtonRunScript).addContainerGap()));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(1).add(jPanel9Layout.createSequentialGroup().add(jPanel9Layout.createParallelGroup(3).add(this.jComboBoxRunScripts, -2, -1, -2).add(this.jButtonRunScript).add(this.jLabel2)).addPreferredGap(0, -1, Short.MAX_VALUE).add(jPanel9Layout.createParallelGroup(3).add(this.jComboBoxCompilers, -2, -1, -2).add(this.jLabel1)).addContainerGap()));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(1).add(this.jPanel9, -1, -1, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(1).add(this.jPanel9, -2, -1, -2));
        this.jSplitPane2.setTopComponent(this.jPanel3);
        this.jPanel4.setName("jPanel4");
        this.jTabbedPaneLogs.setName("jTabbedPaneLogs");
        this.jPanel6.setName("jPanel6");
        this.jScrollPane2.setName("jScrollPane2");
        this.jTextAreaLog.setEditable(false);
        this.jTextAreaLog.setWrapStyleWord(true);
        this.jTextAreaLog.setName("jTextAreaLog");
        this.jScrollPane2.setViewportView(this.jTextAreaLog);
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(1).add(0, 384, Short.MAX_VALUE).add(jPanel6Layout.createParallelGroup(1).add(this.jScrollPane2, -1, 384, Short.MAX_VALUE)));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(1).add(0, 469, Short.MAX_VALUE).add(jPanel6Layout.createParallelGroup(1).add(this.jScrollPane2, -1, 469, Short.MAX_VALUE)));
        this.jTabbedPaneLogs.addTab(resourceMap.getString("jPanel6.TabConstraints.tabTitle", new Object[0]), this.jPanel6);
        this.jPanel5.setName("jPanel5");
        this.jScrollPane3.setName("jScrollPane3");
        this.jTextAreaCompilerOutput.setEditable(false);
        this.jTextAreaCompilerOutput.setFont(resourceMap.getFont("jTextAreaCompilerOutput.font"));
        this.jTextAreaCompilerOutput.setName("jTextAreaCompilerOutput");
        this.jScrollPane3.setViewportView(this.jTextAreaCompilerOutput);
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(1).add(this.jScrollPane3, -1, 384, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(1).add(this.jScrollPane3, -1, 469, Short.MAX_VALUE));
        this.jTabbedPaneLogs.addTab(resourceMap.getString("jPanel5.TabConstraints.tabTitle", new Object[0]), this.jPanel5);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(1).add(this.jTabbedPaneLogs));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(1).add(jPanel4Layout.createSequentialGroup().add(this.jTabbedPaneLogs).add(0, 0, 0)));
        this.jSplitPane2.setRightComponent(this.jPanel4);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(2, this.jSplitPane2));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(this.jSplitPane2));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(1).add(this.jSplitPane1));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(1).add(this.jSplitPane1));
        this.menuBar.setName("menuBar");
        fileMenu.setMnemonic('F');
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        this.addTabMenuItem.setAction(actionMap.get("addNewTab"));
        this.addTabMenuItem.setName("addTabMenuItem");
        fileMenu.add(this.addTabMenuItem);
        this.jSeparator2.setName("jSeparator2");
        fileMenu.add(this.jSeparator2);
        this.openFileMenuItem.setAction(actionMap.get("openFile"));
        this.openFileMenuItem.setName("openFileMenuItem");
        fileMenu.add(this.openFileMenuItem);
        this.recentDocsSubmenu.setText(resourceMap.getString("recentDocsSubmenu.text", new Object[0]));
        this.recentDocsSubmenu.setName("recentDocsSubmenu");
        this.recent1MenuItem.setName("recent1MenuItem");
        this.recentDocsSubmenu.add(this.recent1MenuItem);
        this.recent2MenuItem.setName("recent2MenuItem");
        this.recentDocsSubmenu.add(this.recent2MenuItem);
        this.recent3MenuItem.setName("recent3MenuItem");
        this.recentDocsSubmenu.add(this.recent3MenuItem);
        this.recent4MenuItem.setName("recent4MenuItem");
        this.recentDocsSubmenu.add(this.recent4MenuItem);
        this.recent5MenuItem.setName("recent5MenuItem");
        this.recentDocsSubmenu.add(this.recent5MenuItem);
        this.recent6MenuItem.setName("recent6MenuItem");
        this.recentDocsSubmenu.add(this.recent6MenuItem);
        this.recent7MenuItem.setName("recent7MenuItem");
        this.recentDocsSubmenu.add(this.recent7MenuItem);
        this.recent8MenuItem.setName("recent8MenuItem");
        this.recentDocsSubmenu.add(this.recent8MenuItem);
        this.recent9MenuItem.setName("recent9MenuItem");
        this.recentDocsSubmenu.add(this.recent9MenuItem);
        this.recentAMenuItem.setName("recentAMenuItem");
        this.recentDocsSubmenu.add(this.recentAMenuItem);
        fileMenu.add(this.recentDocsSubmenu);
        this.jSeparator7.setName("jSeparator7");
        fileMenu.add(this.jSeparator7);
        this.saveMenuItem.setAction(actionMap.get("saveFile"));
        this.saveMenuItem.setName("saveMenuItem");
        fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setAction(actionMap.get("saveFileAs"));
        this.saveAsMenuItem.setName("saveAsMenuItem");
        fileMenu.add(this.saveAsMenuItem);
        this.saveAllMenuItem.setAction(actionMap.get("saveAllFiles"));
        this.saveAllMenuItem.setName("saveAllMenuItem");
        fileMenu.add(this.saveAllMenuItem);
        this.jSeparator1.setName("jSeparator1");
        fileMenu.add(this.jSeparator1);
        this.closeFileMenuItem.setAction(actionMap.get("closeFile"));
        this.closeFileMenuItem.setName("closeFileMenuItem");
        fileMenu.add(this.closeFileMenuItem);
        this.closeAllMenuItem.setAction(actionMap.get("closeAll"));
        this.closeAllMenuItem.setName("closeAllMenuItem");
        fileMenu.add(this.closeAllMenuItem);
        this.jSeparator6.setName("jSeparator6");
        fileMenu.add(this.jSeparator6);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        this.editMenu.setMnemonic('E');
        this.editMenu.setText(resourceMap.getString("editMenu.text", new Object[0]));
        this.editMenu.setName("editMenu");
        this.undoMenuItem.setAction(actionMap.get("undoAction"));
        this.undoMenuItem.setName("undoMenuItem");
        this.editMenu.add(this.undoMenuItem);
        this.redoMenuItem.setAction(actionMap.get("redoAction"));
        this.redoMenuItem.setName("redoMenuItem");
        this.editMenu.add(this.redoMenuItem);
        this.jSeparator10.setName("jSeparator10");
        this.editMenu.add(this.jSeparator10);
        this.cutMenuItem.setAction(actionMap.get("cut"));
        this.cutMenuItem.setName("cutMenuItem");
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setAction(actionMap.get("copy"));
        this.copyMenuItem.setName("copyMenuItem");
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setAction(actionMap.get("paste"));
        this.pasteMenuItem.setName("pasteMenuItem");
        this.editMenu.add(this.pasteMenuItem);
        this.jSeparator5.setName("jSeparator5");
        this.editMenu.add(this.jSeparator5);
        this.selectAllMenuItem.setAction(actionMap.get("selectAllText"));
        this.selectAllMenuItem.setName("selectAllMenuItem");
        this.editMenu.add(this.selectAllMenuItem);
        this.menuBar.add(this.editMenu);
        this.findMenu.setMnemonic('D');
        this.findMenu.setText(resourceMap.getString("findMenu.text", new Object[0]));
        this.findMenu.setName("findMenu");
        this.findStartMenuItem.setAction(actionMap.get("findStart"));
        this.findStartMenuItem.setName("findStartMenuItem");
        this.findMenu.add(this.findStartMenuItem);
        this.jSeparator3.setName("jSeparator3");
        this.findMenu.add(this.jSeparator3);
        this.findPrevMenuItem.setAction(actionMap.get("findPrev"));
        this.findPrevMenuItem.setName("findPrevMenuItem");
        this.findMenu.add(this.findPrevMenuItem);
        this.findNextMenuItem.setAction(actionMap.get("findNext"));
        this.findNextMenuItem.setName("findNextMenuItem");
        this.findMenu.add(this.findNextMenuItem);
        this.jSeparator4.setName("jSeparator4");
        this.findMenu.add(this.jSeparator4);
        this.replaceMenuItem.setAction(actionMap.get("replaceTerm"));
        this.replaceMenuItem.setName("replaceMenuItem");
        this.findMenu.add(this.replaceMenuItem);
        this.replaceAllMenuItem.setAction(actionMap.get("replaceAll"));
        this.replaceAllMenuItem.setName("replaceAllMenuItem");
        this.findMenu.add(this.replaceAllMenuItem);
        this.menuBar.add(this.findMenu);
        this.gotoMenu.setMnemonic('N');
        this.gotoMenu.setText(resourceMap.getString("gotoMenu.text", new Object[0]));
        this.gotoMenu.setName("gotoMenu");
        this.gotoFunctionMenuItem.setAction(actionMap.get("gotoFunction"));
        this.gotoFunctionMenuItem.setName("gotoFunctionMenuItem");
        this.gotoMenu.add(this.gotoFunctionMenuItem);
        this.gotoLabelMenuItem.setAction(actionMap.get("gotoLabel"));
        this.gotoLabelMenuItem.setName("gotoLabelMenuItem");
        this.gotoMenu.add(this.gotoLabelMenuItem);
        this.gotoLineMenuItem.setAction(actionMap.get("gotoLine"));
        this.gotoLineMenuItem.setName("gotoLineMenuItem");
        this.gotoMenu.add(this.gotoLineMenuItem);
        this.gotoMacroMenuItem.setAction(actionMap.get("gotoMacro"));
        this.gotoMacroMenuItem.setName("gotoMacroMenuItem");
        this.gotoMenu.add(this.gotoMacroMenuItem);
        this.gotoSectionMenuItem.setAction(actionMap.get("gotoSection"));
        this.gotoSectionMenuItem.setName("gotoSectionMenuItem");
        this.gotoMenu.add(this.gotoSectionMenuItem);
        this.jSeparator11.setName("jSeparator11");
        this.gotoMenu.add(this.jSeparator11);
        this.jumpToLabelMenuItem.setAction(actionMap.get("jumpToLabel"));
        this.jumpToLabelMenuItem.setName("jumpToLabelMenuItem");
        this.gotoMenu.add(this.jumpToLabelMenuItem);
        this.jSeparator13.setName("jSeparator13");
        this.gotoMenu.add(this.jSeparator13);
        this.gotoNextLabel.setAction(actionMap.get("gotoNextLabel"));
        this.gotoNextLabel.setName("gotoNextLabel");
        this.gotoMenu.add(this.gotoNextLabel);
        this.gotoPrevLabel.setAction(actionMap.get("gotoPrevLabel"));
        this.gotoPrevLabel.setName("gotoPrevLabel");
        this.gotoMenu.add(this.gotoPrevLabel);
        this.jSeparator12.setName("jSeparator12");
        this.gotoMenu.add(this.jSeparator12);
        this.gotoNextSectionMenuItem.setAction(actionMap.get("gotoNextSection"));
        this.gotoNextSectionMenuItem.setName("gotoNextSectionMenuItem");
        this.gotoMenu.add(this.gotoNextSectionMenuItem);
        this.gotoPrevSectionMenuItem.setAction(actionMap.get("gotoPrevSection"));
        this.gotoPrevSectionMenuItem.setName("gotoPrevSectionMenuItem");
        this.gotoMenu.add(this.gotoPrevSectionMenuItem);
        this.jSeparator20.setName("jSeparator20");
        this.gotoMenu.add(this.jSeparator20);
        this.gotoNextErrorMenuItem.setAction(actionMap.get("gotoNextError"));
        this.gotoNextErrorMenuItem.setName("gotoNextErrorMenuItem");
        this.gotoMenu.add(this.gotoNextErrorMenuItem);
        this.gotoPrevErrorMenuItem.setAction(actionMap.get("gotoPrevError"));
        this.gotoPrevErrorMenuItem.setName("gotoPrevErrorMenuItem");
        this.gotoMenu.add(this.gotoPrevErrorMenuItem);
        this.menuBar.add(this.gotoMenu);
        this.sourceMenu.setMnemonic('S');
        this.sourceMenu.setText(resourceMap.getString("sourceMenu.text", new Object[0]));
        this.sourceMenu.setName("sourceMenu");
        this.runScriptMenuItem.setAction(actionMap.get("runScript"));
        this.runScriptMenuItem.setText(resourceMap.getString("runScriptMenuItem.text", new Object[0]));
        this.runScriptMenuItem.setToolTipText(resourceMap.getString("runScriptMenuItem.toolTipText", new Object[0]));
        this.runScriptMenuItem.setName("runScriptMenuItem");
        this.sourceMenu.add(this.runScriptMenuItem);
        this.focusScriptMenuItem.setAction(actionMap.get("selectUserScripts"));
        this.focusScriptMenuItem.setName("focusScriptMenuItem");
        this.sourceMenu.add(this.focusScriptMenuItem);
        this.focusSyntaxMenuItem.setAction(actionMap.get("selectSyntax"));
        this.focusSyntaxMenuItem.setName("focusSyntaxMenuItem");
        this.sourceMenu.add(this.focusSyntaxMenuItem);
        this.jSeparator17.setName("jSeparator17");
        this.sourceMenu.add(this.jSeparator17);
        this.commentLineMenuItem.setAction(actionMap.get("commentLine"));
        this.commentLineMenuItem.setName("commentLineMenuItem");
        this.sourceMenu.add(this.commentLineMenuItem);
        this.jSeparator8.setName("jSeparator8");
        this.sourceMenu.add(this.jSeparator8);
        this.insertSectionMenuItem.setAction(actionMap.get("insertSection"));
        this.insertSectionMenuItem.setName("insertSectionMenuItem");
        this.sourceMenu.add(this.insertSectionMenuItem);
        this.insertSeparatorMenuItem.setAction(actionMap.get("insertSeparatorLine"));
        this.insertSeparatorMenuItem.setName("insertSeparatorMenuItem");
        this.sourceMenu.add(this.insertSeparatorMenuItem);
        this.jSeparator14.setName("jSeparator14");
        this.sourceMenu.add(this.jSeparator14);
        this.insertBreakPointMenuItem.setAction(actionMap.get("insertBreakPoint"));
        this.insertBreakPointMenuItem.setName("insertBreakPointMenuItem");
        this.sourceMenu.add(this.insertBreakPointMenuItem);
        this.removeBreakpointMenuItem.setAction(actionMap.get("removeAllBreakPoints"));
        this.removeBreakpointMenuItem.setMnemonic('R');
        this.removeBreakpointMenuItem.setName("removeBreakpointMenuItem");
        this.sourceMenu.add(this.removeBreakpointMenuItem);
        this.jSeparator15.setName("jSeparator15");
        this.sourceMenu.add(this.jSeparator15);
        this.insertBasicStartMenuItem.setAction(actionMap.get("insertBasicStart"));
        this.insertBasicStartMenuItem.setMnemonic('B');
        this.insertBasicStartMenuItem.setName("insertBasicStartMenuItem");
        this.sourceMenu.add(this.insertBasicStartMenuItem);
        this.insertBytesFromFileMenuItem.setAction(actionMap.get("insertBytesFromFile"));
        this.insertBytesFromFileMenuItem.setMnemonic('F');
        this.insertBytesFromFileMenuItem.setName("insertBytesFromFileMenuItem");
        this.sourceMenu.add(this.insertBytesFromFileMenuItem);
        this.insertSinusMenuItem.setAction(actionMap.get("insertSinusTable"));
        this.insertSinusMenuItem.setMnemonic('S');
        this.insertSinusMenuItem.setName("insertSinusMenuItem");
        this.sourceMenu.add(this.insertSinusMenuItem);
        this.jSeparator16.setName("jSeparator16");
        this.sourceMenu.add(this.jSeparator16);
        this.viewMainTabMenuItem.setAction(actionMap.get("setFocusToSource"));
        this.viewMainTabMenuItem.setName("viewMainTabMenuItem");
        this.sourceMenu.add(this.viewMainTabMenuItem);
        this.menuBar.add(this.sourceMenu);
        this.viewMenu.setMnemonic('V');
        this.viewMenu.setText(resourceMap.getString("viewMenu.text", new Object[0]));
        this.viewMenu.setName("viewMenu");
        this.viewLog1MenuItem.setAction(actionMap.get("selectLog1"));
        this.viewLog1MenuItem.setMnemonic('R');
        this.viewLog1MenuItem.setName("viewLog1MenuItem");
        this.viewMenu.add(this.viewLog1MenuItem);
        this.viewLog2MenuItem.setAction(actionMap.get("selectLog2"));
        this.viewLog2MenuItem.setMnemonic('C');
        this.viewLog2MenuItem.setName("viewLog2MenuItem");
        this.viewMenu.add(this.viewLog2MenuItem);
        this.jSeparator19.setName("jSeparator19");
        this.viewMenu.add(this.jSeparator19);
        this.switchBothMenuItem.setAction(actionMap.get("switchBothPosition"));
        this.switchBothMenuItem.setName("switchBothMenuItem");
        this.viewMenu.add(this.switchBothMenuItem);
        this.switchLogPosMenuItem.setAction(actionMap.get("switchLogPosition"));
        this.switchLogPosMenuItem.setName("switchLogPosMenuItem");
        this.viewMenu.add(this.switchLogPosMenuItem);
        this.menuBar.add(this.viewMenu);
        helpMenu.setMnemonic('O');
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        this.settingsMenuItem.setAction(actionMap.get("settingsWindow"));
        this.settingsMenuItem.setMnemonic('P');
        this.settingsMenuItem.setName("settingsMenuItem");
        helpMenu.add(this.settingsMenuItem);
        this.jSeparator9.setName("jSeparator9");
        helpMenu.add(this.jSeparator9);
        this.helpMenuItem.setAction(actionMap.get("showHelp"));
        this.helpMenuItem.setName("helpMenuItem");
        helpMenu.add(this.helpMenuItem);
        this.jSeparator18.setName("jSeparator18");
        helpMenu.add(this.jSeparator18);
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.jTextFieldConvDez.setColumns(5);
        this.jTextFieldConvDez.setName("jTextFieldConvDez");
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        this.jTextFieldConvHex.setColumns(4);
        this.jTextFieldConvHex.setName("jTextFieldConvHex");
        this.jLabel8.setText(resourceMap.getString("jLabel8.text", new Object[0]));
        this.jLabel8.setName("jLabel8");
        this.jTextFieldConvBin.setColumns(8);
        this.jTextFieldConvBin.setName("jTextFieldConvBin");
        this.jLabel9.setDisplayedMnemonic('g');
        this.jLabel9.setLabelFor(this.jTextFieldGotoLine);
        this.jLabel9.setText(resourceMap.getString("jLabel9.text", new Object[0]));
        this.jLabel9.setName("jLabel9");
        this.jTextFieldGotoLine.setColumns(5);
        this.jTextFieldGotoLine.setName("jTextFieldGotoLine");
        this.jComboBoxGoto.setName("jComboBoxGoto");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(1).add(statusPanelLayout.createSequentialGroup().add(statusPanelSeparator).add(239, 239, 239)).add(statusPanelLayout.createSequentialGroup().addContainerGap().add(this.jLabel9).addPreferredGap(0).add(this.jTextFieldGotoLine, -2, -1, -2).addPreferredGap(0).add(this.jComboBoxGoto, -2, 250, -2).add(18, 18, 18).add(this.jLabel6).addPreferredGap(0).add(this.jTextFieldConvDez, -2, -1, -2).addPreferredGap(1).add(this.jLabel7).addPreferredGap(0).add(this.jTextFieldConvHex, -2, -1, -2).addPreferredGap(1).add(this.jLabel8).addPreferredGap(0).add(this.jTextFieldConvBin, -2, -1, -2).addContainerGap(193, Short.MAX_VALUE)));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(1).add(statusPanelLayout.createSequentialGroup().add(statusPanelLayout.createParallelGroup(4).add(this.jLabel9).add(this.jTextFieldGotoLine, -2, -1, -2).add(this.jLabel6).add(this.jTextFieldConvDez, -2, -1, -2).add(this.jLabel7).add(this.jTextFieldConvHex, -2, -1, -2).add(this.jLabel8).add(this.jTextFieldConvBin, -2, -1, -2).add(this.jComboBoxGoto, -2, -1, -2)).addPreferredGap(0).add(statusPanelSeparator, -2, 0, -2)));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private class ComboBoxRenderer
    implements ListCellRenderer {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        private ComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (Relaunch64View.this.comboBoxHeadings != null & !Relaunch64View.this.comboBoxHeadings.isEmpty() && Relaunch64View.this.comboBoxHeadings.contains(index)) {
                ((Component)renderer).setFont(renderer.getFont().deriveFont(1));
                ((Component)renderer).setForeground(new Color(153, 51, 51));
            }
            return renderer;
        }
    }

    public class TextAreaHandler
    extends Handler {
        @Override
        public void publish(final LogRecord record) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StringWriter text = new StringWriter();
                    PrintWriter out = new PrintWriter(text);
                    out.println(Relaunch64View.this.jTextAreaLog.getText());
                    out.printf("[%s] %s", record.getLevel(), record.getMessage());
                    Relaunch64View.this.jTextAreaLog.setText(text.toString());
                }
            });
        }

        public JTextArea getTextArea() {
            return Relaunch64View.this.jTextAreaLog;
        }

        @Override
        public void flush() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void close() throws SecurityException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class ConfirmExit
    implements Application.ExitListener {
        private ConfirmExit() {
        }

        @Override
        public boolean canExit(EventObject e) {
            Relaunch64View.this.saveSettings();
            return Relaunch64View.this.askForSaveChanges();
        }

        @Override
        public void willExit(EventObject e) {
        }
    }
}

