/*
 * Decompiled with CFR 0.152.
 */
package de.relaunch64.popelganda;

import de.relaunch64.popelganda.Editor.ColorSchemes;
import de.relaunch64.popelganda.Editor.SyntaxScheme;
import de.relaunch64.popelganda.FontChooser;
import de.relaunch64.popelganda.Relaunch64AboutBox;
import de.relaunch64.popelganda.Relaunch64App;
import de.relaunch64.popelganda.database.CustomScripts;
import de.relaunch64.popelganda.database.Settings;
import de.relaunch64.popelganda.util.ConstantsR64;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.layout.GroupLayout;
import org.jdom2.Document;

public class SettingsDlg
extends JDialog
implements DropTargetListener {
    private final Settings settings;
    private final CustomScripts scripts;
    private Font mainfont;
    private static final String quickHelpText = "Enter command lines here or drag & drop executable files\n(first compiler, then cruncher (optional), finally emulator)\nfrom explorer window to automatically generate a script.\n\nPress help-button for more details and examples.";
    private boolean modifiedTabScript = false;
    private boolean modifiedTabFont = false;
    private boolean modifiedTabScheme = false;
    private boolean removePossible = false;
    private JButton jButtonApplyScheme;
    private JButton jButtonApplyScript;
    private JButton jButtonApplyTabAndFont;
    private JButton jButtonFont;
    private JButton jButtonNewScript;
    private JButton jButtonRemoveScript;
    private JButton jButtonScriptHelp;
    private JCheckBox jCheckBoxCheckUpdates;
    private JCheckBox jCheckBoxReopenFiles;
    private JCheckBox jCheckBoxSaveOnCompile;
    private JComboBox jComboBoxCustomScripts;
    private JComboBox jComboBoxLineNumberAlign;
    private JComboBox jComboBoxPrefComp;
    private JComboBox jComboBoxSyntaxScheme;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelFont;
    private JLabel jLabelRestart;
    private JLabel jLabelRestart2;
    private JLabel jLabelSchemePreview;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JTextArea jTextAreaUserScript;
    private JTextField jTextFieldScriptName;
    private JTextField jTextFieldTabWidth;
    private JDialog helpBox;
    private FontChooser fontDlg;

    public SettingsDlg(Frame parent, Settings s, CustomScripts scr) {
        super(parent);
        this.settings = s;
        this.scripts = scr;
        this.initComponents();
        this.mainfont = this.settings.getMainFont();
        this.jLabelFont.setText(this.mainfont.getFontName());
        this.jLabelFont.setFont(this.mainfont);
        this.jLabelRestart.setVisible(false);
        this.jLabelRestart2.setVisible(false);
        this.jComboBoxPrefComp.setSelectedIndex(this.settings.getPreferredCompiler());
        if (this.settings.getLineNumerAlignment() == 1.0f) {
            this.jComboBoxLineNumberAlign.setSelectedIndex(0);
        } else if (this.settings.getLineNumerAlignment() == 0.5f) {
            this.jComboBoxLineNumberAlign.setSelectedIndex(1);
        } else if (this.settings.getLineNumerAlignment() == 0.0f) {
            this.jComboBoxLineNumberAlign.setSelectedIndex(2);
        }
        this.jCheckBoxCheckUpdates.setSelected(this.settings.getCheckForUpdates());
        this.jCheckBoxSaveOnCompile.setSelected(this.settings.getSaveOnCompile());
        this.jCheckBoxReopenFiles.setSelected(this.settings.getReopenOnStartup());
        this.initSchemes();
        this.initScripts();
        this.initListeners();
        this.jTextFieldTabWidth.setText(String.valueOf(this.settings.getTabWidth()));
        this.setIconImage(ConstantsR64.r64icon.getImage());
        this.jButtonApplyScript.setDisplayedMnemonicIndex(0);
        this.jButtonRemoveScript.setDisplayedMnemonicIndex(0);
        this.setModifiedTabScript(false);
        this.setModifiedTabFont(false);
        this.setModifiedTabScheme(false);
    }

    private void initSchemes() {
        this.jComboBoxSyntaxScheme.removeAllItems();
        for (String sn : ColorSchemes.SCHEME_NAMES) {
            this.jComboBoxSyntaxScheme.addItem(sn);
        }
        this.jComboBoxSyntaxScheme.setMaximumRowCount(this.jComboBoxSyntaxScheme.getItemCount());
        try {
            this.jComboBoxSyntaxScheme.setSelectedIndex(this.settings.getSyntaxScheme());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.updateSchemePreview();
    }

    private void updateSchemePreview() {
        this.jLabelSchemePreview.setIcon(ConstantsR64.colorpreviews[this.jComboBoxSyntaxScheme.getSelectedIndex()]);
    }

    private void initScripts() {
        ActionListener[] al;
        for (ActionListener listener : al = this.jComboBoxCustomScripts.getActionListeners()) {
            this.jComboBoxCustomScripts.removeActionListener(listener);
        }
        this.jComboBoxCustomScripts.removeAllItems();
        Object[] scriptNames = this.scripts.getScriptNames();
        if (scriptNames != null && scriptNames.length > 0) {
            Arrays.sort(scriptNames);
            for (Object sn : scriptNames) {
                this.jComboBoxCustomScripts.addItem(sn);
            }
            this.setRemovePossible(true);
        } else {
            this.resetScriptFields();
        }
        this.jComboBoxCustomScripts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String scriptname = SettingsDlg.this.jComboBoxCustomScripts.getSelectedItem().toString();
                if (scriptname != null && !scriptname.isEmpty()) {
                    SettingsDlg.this.jTextFieldScriptName.setText(scriptname);
                    SettingsDlg.this.jTextAreaUserScript.setForeground(Color.black);
                    SettingsDlg.this.jTextAreaUserScript.setText(SettingsDlg.this.scripts.getScript(scriptname));
                    SettingsDlg.this.jButtonApplyScript.setText("Update script");
                } else {
                    SettingsDlg.this.jTextFieldScriptName.setText("");
                    SettingsDlg.this.jTextAreaUserScript.setText("");
                    SettingsDlg.this.jButtonApplyScript.setText("Add script");
                }
                SettingsDlg.this.setModifiedTabScript(false);
            }
        });
        try {
            this.jComboBoxCustomScripts.setSelectedIndex(0);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
    }

    private void initListeners() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        ActionListener cancelAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDlg.this.setVisible(false);
                SettingsDlg.this.dispose();
            }
        };
        this.getRootPane().registerKeyboardAction(cancelAction, stroke, 2);
        this.jCheckBoxCheckUpdates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDlg.this.settings.setCheckForUpdates(SettingsDlg.this.jCheckBoxCheckUpdates.isSelected());
            }
        });
        this.jCheckBoxSaveOnCompile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDlg.this.settings.setSaveOnCompile(SettingsDlg.this.jCheckBoxSaveOnCompile.isSelected());
            }
        });
        this.jCheckBoxReopenFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDlg.this.settings.setReopenOnStartup(SettingsDlg.this.jCheckBoxReopenFiles.isSelected());
            }
        });
        this.jComboBoxPrefComp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDlg.this.setModifiedTabFont(true);
            }
        });
        this.jComboBoxSyntaxScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDlg.this.setModifiedTabScheme(true);
                SettingsDlg.this.jLabelRestart2.setVisible(true);
                SettingsDlg.this.updateSchemePreview();
            }
        });
        this.jComboBoxLineNumberAlign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDlg.this.jLabelRestart.setVisible(true);
                SettingsDlg.this.setModifiedTabFont(true);
            }
        });
        this.jTextAreaUserScript.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 88 && (evt.isControlDown() || evt.isMetaDown())) {
                    SettingsDlg.this.jTextAreaUserScript.cut();
                    evt.consume();
                } else if (evt.getKeyCode() == 67 && (evt.isControlDown() || evt.isMetaDown())) {
                    SettingsDlg.this.jTextAreaUserScript.copy();
                    evt.consume();
                } else if (evt.getKeyCode() == 86 && (evt.isControlDown() || evt.isMetaDown())) {
                    SettingsDlg.this.jTextAreaUserScript.paste();
                    evt.consume();
                }
            }
        });
        this.jTextAreaUserScript.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SettingsDlg.this.switchButtonLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SettingsDlg.this.switchButtonLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SettingsDlg.this.switchButtonLabel();
            }
        });
        this.jTextFieldScriptName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SettingsDlg.this.switchButtonLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SettingsDlg.this.switchButtonLabel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SettingsDlg.this.switchButtonLabel();
            }
        });
        this.jTextFieldTabWidth.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SettingsDlg.this.setModifiedTabFont(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SettingsDlg.this.setModifiedTabFont(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SettingsDlg.this.setModifiedTabFont(true);
            }
        });
        this.jTextAreaUserScript.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                String content = SettingsDlg.this.jTextAreaUserScript.getText();
                if (content.equalsIgnoreCase(SettingsDlg.quickHelpText)) {
                    SettingsDlg.this.jTextAreaUserScript.setText("");
                    SettingsDlg.this.jTextAreaUserScript.setForeground(Color.black);
                }
            }

            @Override
            public void focusLost(FocusEvent evt) {
                String content = SettingsDlg.this.jTextAreaUserScript.getText();
                if (content.isEmpty()) {
                    SettingsDlg.this.jTextAreaUserScript.setText(SettingsDlg.quickHelpText);
                    SettingsDlg.this.jTextAreaUserScript.setForeground(Color.lightGray);
                }
            }
        });
        this.jTextAreaUserScript.setDragEnabled(true);
        DropTarget dropTarget = new DropTarget(this.jTextAreaUserScript, this);
    }

    private void switchButtonLabel() {
        String name = this.jTextFieldScriptName.getText();
        String content = this.jTextAreaUserScript.getText();
        if (name != null) {
            this.jButtonApplyScript.setText(this.scripts.findScript(name) != -1 ? "Update script" : "Add script");
        }
        this.jButtonApplyScript.setDisplayedMnemonicIndex(0);
        this.setModifiedTabScript(name != null && !name.isEmpty() && !content.isEmpty() && !content.equals(quickHelpText));
    }

    @Action
    public void showScriptHelp() {
        if (this.helpBox == null) {
            this.helpBox = new Relaunch64AboutBox(null, Application.getInstance(Relaunch64App.class).getClass().getResource("/de/relaunch64/popelganda/resources/help_userscripts.html"));
            this.helpBox.setLocationRelativeTo(this);
        }
        Relaunch64App.getApplication().show(this.helpBox);
        this.helpBox.dispose();
        this.helpBox = null;
    }

    @Action
    public void changeEditorFont() {
        if (null == this.fontDlg) {
            this.fontDlg = new FontChooser(null, this.settings.getMainFont());
            this.fontDlg.setLocationRelativeTo(null);
        }
        Relaunch64App.getApplication().show(this.fontDlg);
        Font f = this.fontDlg.getSelectedFont();
        if (f != null) {
            this.mainfont = f;
            this.jLabelFont.setFont(f);
            this.jLabelFont.setText(f.getFontName());
            this.jLabelRestart.setVisible(true);
            this.setModifiedTabFont(true);
        }
    }

    @Action(enabledProperty="modifiedTabFont")
    public void applyFontTab() {
        this.settings.setMainfont(this.mainfont);
        Document doc = SyntaxScheme.loadSyntax();
        SyntaxScheme.setFont(doc, this.mainfont.getFamily());
        SyntaxScheme.setFontSize(doc, this.mainfont.getSize());
        SyntaxScheme.changeScheme(this.jComboBoxSyntaxScheme.getSelectedIndex(), doc);
        SyntaxScheme.saveSyntax(doc);
        try {
            this.settings.setTabWidth(Integer.parseInt(this.jTextFieldTabWidth.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.settings.setPreferredCompiler(this.jComboBoxPrefComp.getSelectedIndex());
        this.settings.setSyntaxScheme(this.jComboBoxSyntaxScheme.getSelectedIndex());
        if (this.jComboBoxLineNumberAlign.getSelectedIndex() == 0) {
            this.settings.setLineNumerAlignment(1.0f);
        } else if (this.jComboBoxLineNumberAlign.getSelectedIndex() == 1) {
            this.settings.setLineNumerAlignment(0.5f);
        } else if (this.jComboBoxLineNumberAlign.getSelectedIndex() == 2) {
            this.settings.setLineNumerAlignment(0.0f);
        }
        this.setModifiedTabFont(false);
        this.jLabelRestart.setVisible(false);
    }

    @Action(enabledProperty="modifiedTabScheme")
    public void applyColorScheme() {
        Document doc = SyntaxScheme.loadSyntax();
        SyntaxScheme.changeScheme(this.jComboBoxSyntaxScheme.getSelectedIndex(), doc);
        SyntaxScheme.saveSyntax(doc);
        this.settings.setSyntaxScheme(this.jComboBoxSyntaxScheme.getSelectedIndex());
        this.setModifiedTabScheme(false);
        this.jLabelRestart2.setVisible(false);
    }

    @Action
    public void addNewScript() {
        this.resetScriptFields();
        this.jTextFieldScriptName.requestFocusInWindow();
    }

    private void resetScriptFields() {
        this.jTextFieldScriptName.setText("");
        this.jTextAreaUserScript.setText(quickHelpText);
        this.jTextAreaUserScript.setForeground(Color.lightGray);
        this.setRemovePossible(false);
    }

    @Action(enabledProperty="modifiedTabScript")
    public void applyScript() {
        String content;
        String name = this.jTextFieldScriptName.getText();
        if (this.scripts.addScript(name, content = this.jTextAreaUserScript.getText())) {
            this.initScripts();
            try {
                this.jComboBoxCustomScripts.setSelectedItem(name);
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException runtimeException) {
                // empty catch block
            }
        }
        this.setModifiedTabScript(false);
    }

    @Action(enabledProperty="removePossible")
    public void removeScript() {
        if (this.jComboBoxCustomScripts.getSelectedIndex() < 0) {
            return;
        }
        String name = this.jComboBoxCustomScripts.getSelectedItem().toString();
        if (this.scripts.removeScript(name)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SettingsDlg.this.initScripts();
                    SettingsDlg.this.setModifiedTabScript(false);
                }
            });
        }
    }

    public boolean isModifiedTabScript() {
        return this.modifiedTabScript;
    }

    public final void setModifiedTabScript(boolean b) {
        boolean old = this.isModifiedTabScript();
        this.modifiedTabScript = b;
        this.firePropertyChange("modifiedTabScript", old, this.isModifiedTabScript());
    }

    public boolean isModifiedTabFont() {
        return this.modifiedTabFont;
    }

    public final void setModifiedTabFont(boolean b) {
        boolean old = this.isModifiedTabFont();
        this.modifiedTabFont = b;
        this.firePropertyChange("modifiedTabFont", old, this.isModifiedTabFont());
    }

    public boolean isModifiedTabScheme() {
        return this.modifiedTabScheme;
    }

    public final void setModifiedTabScheme(boolean b) {
        boolean old = this.isModifiedTabScheme();
        this.modifiedTabScheme = b;
        this.firePropertyChange("modifiedTabScheme", old, this.isModifiedTabScheme());
    }

    public boolean isRemovePossible() {
        return this.removePossible;
    }

    public final void setRemovePossible(boolean b) {
        boolean old = this.isRemovePossible();
        this.removePossible = b;
        this.firePropertyChange("removePossible", old, this.isRemovePossible());
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jComboBoxCustomScripts = new JComboBox();
        this.jLabel9 = new JLabel();
        this.jTextFieldScriptName = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaUserScript = new JTextArea();
        this.jButtonApplyScript = new JButton();
        this.jButtonScriptHelp = new JButton();
        this.jButtonRemoveScript = new JButton();
        this.jButtonNewScript = new JButton();
        this.jPanel5 = new JPanel();
        this.jLabel10 = new JLabel();
        this.jLabelFont = new JLabel();
        this.jButtonFont = new JButton();
        this.jLabel11 = new JLabel();
        this.jTextFieldTabWidth = new JTextField();
        this.jComboBoxPrefComp = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jButtonApplyTabAndFont = new JButton();
        this.jLabel1 = new JLabel();
        this.jComboBoxLineNumberAlign = new JComboBox();
        this.jLabelRestart = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jComboBoxSyntaxScheme = new JComboBox();
        this.jLabelRestart2 = new JLabel();
        this.jButtonApplyScheme = new JButton();
        this.jLabelSchemePreview = new JLabel();
        this.jPanel1 = new JPanel();
        this.jCheckBoxCheckUpdates = new JCheckBox();
        this.jCheckBoxSaveOnCompile = new JCheckBox();
        this.jCheckBoxReopenFiles = new JCheckBox();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(Relaunch64App.class).getContext().getResourceMap(SettingsDlg.class);
        this.setTitle(resourceMap.getString("FormSettings.title", new Object[0]));
        this.setModal(true);
        this.setName("FormSettings");
        this.jTabbedPane1.setName("jTabbedPane1");
        this.jPanel3.setName("jPanel3");
        this.jLabel8.setDisplayedMnemonic('s');
        this.jLabel8.setLabelFor(this.jComboBoxCustomScripts);
        this.jLabel8.setText(resourceMap.getString("jLabel8.text", new Object[0]));
        this.jLabel8.setName("jLabel8");
        this.jComboBoxCustomScripts.setName("jComboBoxCustomScripts");
        this.jLabel9.setDisplayedMnemonic('m');
        this.jLabel9.setLabelFor(this.jTextFieldScriptName);
        this.jLabel9.setText(resourceMap.getString("jLabel9.text", new Object[0]));
        this.jLabel9.setName("jLabel9");
        this.jTextFieldScriptName.setColumns(20);
        this.jTextFieldScriptName.setName("jTextFieldScriptName");
        this.jScrollPane1.setName("jScrollPane1");
        this.jTextAreaUserScript.setName("jTextAreaUserScript");
        this.jScrollPane1.setViewportView(this.jTextAreaUserScript);
        ApplicationActionMap actionMap = Application.getInstance(Relaunch64App.class).getContext().getActionMap(SettingsDlg.class, this);
        this.jButtonApplyScript.setAction(actionMap.get("applyScript"));
        this.jButtonApplyScript.setName("jButtonApplyScript");
        this.jButtonScriptHelp.setAction(actionMap.get("showScriptHelp"));
        this.jButtonScriptHelp.setName("jButtonScriptHelp");
        this.jButtonRemoveScript.setAction(actionMap.get("removeScript"));
        this.jButtonRemoveScript.setName("jButtonRemoveScript");
        this.jButtonNewScript.setAction(actionMap.get("addNewScript"));
        this.jButtonNewScript.setMnemonic('n');
        this.jButtonNewScript.setName("jButtonNewScript");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().addContainerGap().add(jPanel3Layout.createParallelGroup(1).add(2, jPanel3Layout.createSequentialGroup().add(this.jButtonScriptHelp).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.jButtonRemoveScript).addPreferredGap(0).add(this.jButtonApplyScript)).add(this.jScrollPane1, -1, 525, Short.MAX_VALUE).add(jPanel3Layout.createSequentialGroup().add(jPanel3Layout.createParallelGroup(1).add(this.jLabel8).add(this.jLabel9)).addPreferredGap(0).add(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().add(this.jComboBoxCustomScripts, -2, -1, -2).addPreferredGap(0).add(this.jButtonNewScript).add(0, 0, Short.MAX_VALUE)).add(this.jTextFieldScriptName, -1, 504, Short.MAX_VALUE)))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(1).add(jPanel3Layout.createSequentialGroup().addContainerGap().add(jPanel3Layout.createParallelGroup(3).add(this.jLabel8).add(this.jComboBoxCustomScripts, -2, -1, -2).add(this.jButtonNewScript)).addPreferredGap(0).add(jPanel3Layout.createParallelGroup(3).add(this.jLabel9).add(this.jTextFieldScriptName, -2, -1, -2)).addPreferredGap(0).add(this.jScrollPane1, -1, 218, Short.MAX_VALUE).addPreferredGap(0).add(jPanel3Layout.createParallelGroup(3).add(this.jButtonApplyScript).add(this.jButtonScriptHelp).add(this.jButtonRemoveScript)).addContainerGap()));
        this.jTabbedPane1.addTab(resourceMap.getString("jPanel3.TabConstraints.tabTitle", new Object[0]), this.jPanel3);
        this.jPanel5.setName("jPanel5");
        this.jLabel10.setDisplayedMnemonic('f');
        this.jLabel10.setLabelFor(this.jButtonFont);
        this.jLabel10.setText(resourceMap.getString("jLabel10.text", new Object[0]));
        this.jLabel10.setName("jLabel10");
        this.jLabelFont.setName("jLabelFont");
        this.jButtonFont.setAction(actionMap.get("changeEditorFont"));
        this.jButtonFont.setName("jButtonFont");
        this.jLabel11.setDisplayedMnemonic('t');
        this.jLabel11.setLabelFor(this.jTextFieldTabWidth);
        this.jLabel11.setText(resourceMap.getString("jLabel11.text", new Object[0]));
        this.jLabel11.setName("jLabel11");
        this.jTextFieldTabWidth.setColumns(4);
        this.jTextFieldTabWidth.setText(resourceMap.getString("jTextFieldTabWidth.text", new Object[0]));
        this.jTextFieldTabWidth.setName("jTextFieldTabWidth");
        this.jComboBoxPrefComp.setModel(new DefaultComboBoxModel<String>(ConstantsR64.COMPILER_NAMES));
        this.jComboBoxPrefComp.setName("jComboBoxPrefComp");
        this.jLabel6.setDisplayedMnemonic('c');
        this.jLabel6.setLabelFor(this.jComboBoxPrefComp);
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.jButtonApplyTabAndFont.setAction(actionMap.get("applyFontTab"));
        this.jButtonApplyTabAndFont.setName("jButtonApplyTabAndFont");
        this.jLabel1.setDisplayedMnemonic('l');
        this.jLabel1.setLabelFor(this.jComboBoxLineNumberAlign);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jComboBoxLineNumberAlign.setModel(new DefaultComboBoxModel<String>(new String[]{"Right", "Center", "Left"}));
        this.jComboBoxLineNumberAlign.setName("jComboBoxLineNumberAlign");
        this.jLabelRestart.setForeground(resourceMap.getColor("jLabelRestart.foreground"));
        this.jLabelRestart.setText(resourceMap.getString("jLabelRestart.text", new Object[0]));
        this.jLabelRestart.setName("jLabelRestart");
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(1).add(jPanel5Layout.createSequentialGroup().addContainerGap().add(jPanel5Layout.createParallelGroup(1).add(this.jLabel6).add(this.jLabel10).add(this.jLabel11).add(this.jLabel1)).addPreferredGap(0).add(jPanel5Layout.createParallelGroup(1).add(this.jComboBoxLineNumberAlign, -2, -1, -2).add(jPanel5Layout.createSequentialGroup().add(this.jLabelFont).addPreferredGap(0).add(this.jButtonFont)).add(this.jTextFieldTabWidth, -2, -1, -2).add(this.jComboBoxPrefComp, -2, -1, -2)).addContainerGap(409, Short.MAX_VALUE)).add(2, jPanel5Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(this.jLabelRestart).add(18, 18, 18).add(this.jButtonApplyTabAndFont).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(1).add(jPanel5Layout.createSequentialGroup().addContainerGap().add(jPanel5Layout.createParallelGroup(3).add(this.jLabel10).add(this.jLabelFont).add(this.jButtonFont)).add(18, 18, 18).add(jPanel5Layout.createParallelGroup(3).add(this.jLabel11).add(this.jTextFieldTabWidth, -2, -1, -2)).add(18, 18, 18).add(jPanel5Layout.createParallelGroup(3).add(this.jLabel6).add(this.jComboBoxPrefComp, -2, -1, -2)).add(18, 18, 18).add(jPanel5Layout.createParallelGroup(3).add(this.jLabel1).add(this.jComboBoxLineNumberAlign, -2, -1, -2)).addPreferredGap(0, 142, Short.MAX_VALUE).add(jPanel5Layout.createParallelGroup(3).add(this.jButtonApplyTabAndFont).add(this.jLabelRestart)).addContainerGap()));
        this.jTabbedPane1.addTab(resourceMap.getString("jPanel5.TabConstraints.tabTitle", new Object[0]), this.jPanel5);
        this.jPanel2.setName("jPanel2");
        this.jLabel2.setDisplayedMnemonic('s');
        this.jLabel2.setLabelFor(this.jComboBoxSyntaxScheme);
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jComboBoxSyntaxScheme.setName("jComboBoxSyntaxScheme");
        this.jLabelRestart2.setForeground(resourceMap.getColor("jLabelRestart2.foreground"));
        this.jLabelRestart2.setText(resourceMap.getString("jLabelRestart2.text", new Object[0]));
        this.jLabelRestart2.setName("jLabelRestart2");
        this.jButtonApplyScheme.setAction(actionMap.get("applyColorScheme"));
        this.jButtonApplyScheme.setName("jButtonApplyScheme");
        this.jLabelSchemePreview.setName("jLabelSchemePreview");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(1).add(2, jPanel2Layout.createSequentialGroup().add(0, 294, Short.MAX_VALUE).add(this.jLabelRestart2).add(18, 18, 18).add(this.jButtonApplyScheme)).add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().add(this.jLabel2).addPreferredGap(0).add(this.jComboBoxSyntaxScheme, -2, -1, -2)).add(this.jLabelSchemePreview)).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(1).add(jPanel2Layout.createSequentialGroup().addContainerGap().add(jPanel2Layout.createParallelGroup(3).add(this.jLabel2).add(this.jComboBoxSyntaxScheme, -2, -1, -2)).addPreferredGap(0).add(this.jLabelSchemePreview).addPreferredGap(0, 253, Short.MAX_VALUE).add(jPanel2Layout.createParallelGroup(3).add(this.jButtonApplyScheme).add(this.jLabelRestart2)).addContainerGap()));
        this.jTabbedPane1.addTab(resourceMap.getString("jPanel2.TabConstraints.tabTitle", new Object[0]), this.jPanel2);
        this.jPanel1.setName("jPanel1");
        this.jCheckBoxCheckUpdates.setText(resourceMap.getString("jCheckBoxCheckUpdates.text", new Object[0]));
        this.jCheckBoxCheckUpdates.setToolTipText(resourceMap.getString("jCheckBoxCheckUpdates.toolTipText", new Object[0]));
        this.jCheckBoxCheckUpdates.setName("jCheckBoxCheckUpdates");
        this.jCheckBoxSaveOnCompile.setText(resourceMap.getString("jCheckBoxSaveOnCompile.text", new Object[0]));
        this.jCheckBoxSaveOnCompile.setToolTipText(resourceMap.getString("jCheckBoxSaveOnCompile.toolTipText", new Object[0]));
        this.jCheckBoxSaveOnCompile.setName("jCheckBoxSaveOnCompile");
        this.jCheckBoxReopenFiles.setText(resourceMap.getString("jCheckBoxReopenFiles.text", new Object[0]));
        this.jCheckBoxReopenFiles.setToolTipText(resourceMap.getString("jCheckBoxReopenFiles.toolTipText", new Object[0]));
        this.jCheckBoxReopenFiles.setName("jCheckBoxReopenFiles");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1).add(this.jCheckBoxCheckUpdates).add(this.jCheckBoxSaveOnCompile).add(this.jCheckBoxReopenFiles)).addContainerGap(417, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(this.jCheckBoxCheckUpdates).add(18, 18, 18).add(this.jCheckBoxSaveOnCompile).add(18, 18, 18).add(this.jCheckBoxReopenFiles).addContainerGap(212, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(resourceMap.getString("jPanel1.TabConstraints.tabTitle", new Object[0]), this.jPanel1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jTabbedPane1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jTabbedPane1).addContainerGap()));
        this.pack();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Transferable tr = dtde.getTransferable();
        try {
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(3);
                List files = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                if (files != null && files.size() > 0) {
                    for (Object file1 : files) {
                        String text;
                        File file = (File)file1;
                        if (!file.isFile()) continue;
                        String fp = file.getAbsolutePath();
                        if (fp.contains(" ")) {
                            fp = "\"" + fp + "\"";
                        }
                        String outputfile = (text = this.jTextAreaUserScript.getText()).contains("COMPFILE") ? "COMPFILE" : "OUTFILE";
                        String insert = "";
                        if (fp.toLowerCase().contains("acme")) {
                            insert = fp + " " + "--outfile OUTFILE --format cbm SOURCEFILE";
                        } else if (fp.toLowerCase().contains("kickass")) {
                            insert = "java -jar " + fp + " " + "SOURCEFILE";
                        } else if (fp.toLowerCase().contains("64tass")) {
                            insert = fp + " " + "-C -a -i SOURCEFILE -o OUTFILE";
                        } else if (fp.toLowerCase().contains("exomizer")) {
                            insert = fp + " " + "sfx START UNCOMPFILE -o COMPFILE";
                        } else if (fp.toLowerCase().contains("x64")) {
                            insert = fp + " " + outputfile;
                        } else if (fp.toLowerCase().contains("emu64")) {
                            insert = fp + " " + outputfile;
                        } else if (fp.toLowerCase().contains("ccs64")) {
                            insert = fp + " " + outputfile;
                        }
                        if (this.settings.isOSX() && fp.toLowerCase().contains("/Applications/") && !insert.startsWith("java")) {
                            insert = "open " + insert;
                        }
                        this.jTextAreaUserScript.setForeground(Color.black);
                        if (!text.isEmpty() && !text.equalsIgnoreCase(quickHelpText)) {
                            this.jTextAreaUserScript.append(System.getProperty("line.separator"));
                        } else {
                            this.jTextAreaUserScript.setText("");
                        }
                        this.jTextAreaUserScript.append(insert);
                    }
                }
                dtde.getDropTargetContext().dropComplete(true);
            } else {
                dtde.rejectDrop();
            }
        }
        catch (UnsupportedFlavorException | IOException ex) {
            dtde.rejectDrop();
        }
    }
}

