/*
 * Decompiled with CFR 0.152.
 */
package de.relaunch64.popelganda.util;

import de.relaunch64.popelganda.util.ConstantsR64;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileTools {
    public static File chooseFile(Frame parent, int dlgmode, int filemode, String initdir, String initfile, String title, String[] acceptedext, String desc) {
        int option;
        File curdir = null == initdir ? null : new File(initdir);
        JFileChooser fc = FileTools.createFileChooser(title, filemode, curdir, acceptedext, desc);
        int n = option = 0 == dlgmode ? fc.showOpenDialog(parent) : fc.showSaveDialog(parent);
        if (0 == option) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public static JFileChooser createFileChooser(String name, int filemode, File curdir, final String[] acceptedext, final String desc) {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(name);
        fc.setAcceptAllFileFilterUsed(false);
        fc.setCurrentDirectory(curdir);
        fc.setFileSelectionMode(filemode);
        if (null == acceptedext || acceptedext.length < 1) {
            fc.setAcceptAllFileFilterUsed(true);
        } else {
            fc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    boolean retval = false;
                    String fileext = "." + FileTools.getFileExtension(f);
                    if (acceptedext.length > 0) {
                        for (String ext : acceptedext) {
                            if (!fileext.equals(ext.toLowerCase())) continue;
                            retval = true;
                        }
                    }
                    return retval;
                }

                @Override
                public String getDescription() {
                    return desc;
                }
            });
        }
        return fc;
    }

    public static String getFileExtension(File f) {
        if (null == f) {
            return "";
        }
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(".");
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String getFilePath(File f) {
        if (f != null && f.exists()) {
            String path = f.getAbsolutePath();
            return path.substring(0, path.lastIndexOf(File.separator));
        }
        return null;
    }

    public static File setFileExtension(File f, String ext) {
        if (null == f) {
            return f;
        }
        String s = f.toString();
        int i = s.lastIndexOf(".");
        if (i > 0 && i < s.length() - 1) {
            return new File(s.substring(0, i + 1) + ext);
        }
        return f;
    }

    public static boolean hasValidFileExtension(File fp) {
        String ext = FileTools.getFileExtension(fp);
        if (null == ext || ext.isEmpty()) {
            return false;
        }
        ext = "." + ext;
        for (String extensions : ConstantsR64.FILE_EXTENSIONS) {
            if (!ext.equalsIgnoreCase(extensions)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasValidIncludeFileExtension(File fp) {
        String ext = FileTools.getFileExtension(fp);
        if (null == ext || ext.isEmpty()) {
            return false;
        }
        ext = "." + ext;
        for (String extensions : ConstantsR64.FILE_EXTENSIONS_INCLUDES) {
            if (!ext.equalsIgnoreCase(extensions)) continue;
            return true;
        }
        return false;
    }

    public static String getFileName(File f) {
        String fname;
        int extpos;
        if (f != null && (extpos = (fname = f.getName()).lastIndexOf(".")) != -1) {
            try {
                return fname.substring(0, extpos);
            }
            catch (IndexOutOfBoundsException ex) {
                return null;
            }
        }
        return null;
    }

    public static File createFilePath(String filename) {
        File sFile;
        block5: {
            if (!new File(System.getProperty("user.home") + File.separatorChar + ".Relaunch64").exists()) {
                try {
                    if (new File(System.getProperty("user.home") + File.separatorChar + ".Relaunch64").mkdirs()) {
                        sFile = new File(System.getProperty("user.home") + File.separatorChar + ".Relaunch64" + File.separatorChar + filename);
                        break block5;
                    }
                    sFile = new File(System.getProperty("user.home") + File.separatorChar + filename);
                }
                catch (SecurityException ex) {
                    sFile = null;
                }
            } else {
                sFile = new File(System.getProperty("user.home") + File.separatorChar + ".Relaunch64" + File.separatorChar + filename);
            }
        }
        return sFile;
    }

    public static String getRelativePath(File source, File dest) {
        if (null == source && null == dest) {
            return null;
        }
        if (null == source && dest != null) {
            return dest.toString();
        }
        if (null == dest && source != null) {
            return source.toString();
        }
        if (source != null && dest != null) {
            try {
                Path fp = Paths.get(source.getAbsolutePath(), new String[0]).relativize(Paths.get(dest.getAbsolutePath(), new String[0]));
                if (fp != null) {
                    return fp.toString();
                }
                return source.toString();
            }
            catch (IllegalArgumentException | SecurityException | FileSystemNotFoundException ex) {
                return source.toString();
            }
        }
        return null;
    }

    public static byte[] readBinaryFile(File sourceFile) {
        return FileTools.readBinaryFile(sourceFile, 0, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBinaryFile(File sourceFile, int startOffset, int endOffset) {
        byte[] buffer;
        if (null == sourceFile || !sourceFile.exists()) {
            return null;
        }
        FileInputStream in = null;
        byte[] retVal = null;
        try {
            int i;
            in = new FileInputStream(sourceFile);
            long fileLength = sourceFile.length();
            buffer = new byte[(int)fileLength];
            int counter = 0;
            while ((i = in.read()) != -1) {
                buffer[counter++] = (byte)i;
            }
            if (endOffset != -1 || startOffset > 0) {
                if (-1 == endOffset) {
                    endOffset = (int)fileLength;
                }
                retVal = new byte[endOffset - startOffset];
                counter = 0;
                for (i = startOffset; i < endOffset; ++i) {
                    retVal[counter++] = buffer[i];
                }
            }
        }
        catch (IOException | SecurityException ex) {
            ConstantsR64.r64logger.log(Level.SEVERE, ex.getLocalizedMessage());
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                return null;
            }
        }
        return retVal != null ? retVal : buffer;
    }
}

