/*
 * Decompiled with CFR 0.152.
 */
package de.relaunch64.popelganda.util;

import de.relaunch64.popelganda.Editor.EditorPanes;
import de.relaunch64.popelganda.Editor.SyntaxScheme;
import de.relaunch64.popelganda.util.FileTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JOptionPane;

public class Tools {
    public static boolean isDelimiter(String character, String additionalChars) {
        String delimiterList = ",;{}()[]+-/<=>&|^~*#" + additionalChars;
        return Character.isWhitespace(character.charAt(0)) || delimiterList.contains(character);
    }

    public static boolean isDelimiter(Character character, String additionalChars) {
        String delimiterList = ",;{}()[]+-/<=>&|^~*#" + additionalChars;
        return Character.isWhitespace(character.charValue()) || delimiterList.indexOf(character.charValue()) != -1;
    }

    public static String getSystemInformation() {
        StringBuilder sysinfo = new StringBuilder("");
        sysinfo.append("Relaunch64").append(" ").append("3.0.0 (Build 20140508)").append(System.getProperty("line.separator"));
        sysinfo.append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version")).append(" (").append(System.getProperty("os.arch")).append(")").append(System.getProperty("line.separator"));
        sysinfo.append("Java-Version ").append(System.getProperty("java.version")).append(" (").append(System.getProperty("java.vendor")).append(")").append(System.getProperty("line.separator"));
        sysinfo.append(System.getProperty("java.home"));
        return sysinfo.toString();
    }

    public static String getByteTableFromFile(File f, int compiler) {
        return Tools.getByteTableFromFile(f, 0, -1, compiler, 8);
    }

    public static String getByteTableFromFile(File f, int compiler, int bytesPerLine) {
        return Tools.getByteTableFromFile(f, 0, -1, compiler, bytesPerLine);
    }

    public static String getByteTableFromFile(File f, int startOffset, int endOffset, int compiler, int bytesPerLine) {
        byte[] content = FileTools.readBinaryFile(f, startOffset, endOffset);
        if (content != null && content.length > 0) {
            String byteToken;
            switch (compiler) {
                case 1: {
                    byteToken = "!byte";
                    break;
                }
                case 0: {
                    byteToken = ".byte";
                    break;
                }
                case 2: {
                    byteToken = ".byte";
                    break;
                }
                default: {
                    byteToken = ".byte";
                }
            }
            StringBuilder sb = new StringBuilder("");
            boolean startNewLine = true;
            int bpl = 0;
            for (int i = 0; i < content.length; ++i) {
                if (startNewLine) {
                    sb.append(byteToken).append(" ");
                    startNewLine = false;
                }
                sb.append("$").append(String.format("%02x", content[i]));
                if (++bpl >= bytesPerLine || i == content.length - 1) {
                    sb.append(System.getProperty("line.separator"));
                    startNewLine = true;
                    bpl = 0;
                    continue;
                }
                sb.append(", ");
            }
            return sb.toString();
        }
        return null;
    }

    public static String getAcmeToFile(String source) {
        if (source != null && source.contains("!to")) {
            int position = source.indexOf("!to");
            int fileNameStart = source.indexOf("\"", position);
            int fileNameEnd = source.indexOf("\"", fileNameStart + 1);
            try {
                return source.substring(fileNameStart + 1, fileNameEnd);
            }
            catch (IndexOutOfBoundsException ex) {
                // empty catch block
            }
        }
        return null;
    }

    public static ArrayList<Integer> getErrorLines(String log) {
        ArrayList<Integer> errorLines = new ArrayList<Integer>();
        BufferedReader br = new BufferedReader(new StringReader(log));
        LineNumberReader lineReader = new LineNumberReader(br);
        if (log != null && !log.isEmpty()) {
            try {
                String line;
                while ((line = lineReader.readLine()) != null) {
                    int err = -1;
                    if ((line.toLowerCase().contains("error") || line.toLowerCase().contains("warning")) && line.toLowerCase().contains("line")) {
                        err = Tools.getErrorLineFromLine(line, "line ");
                    } else if ((line.toLowerCase().contains("error") || line.toLowerCase().contains("warning")) && !line.toLowerCase().contains("line")) {
                        line = lineReader.readLine();
                        if (line != null) {
                            err = Tools.getErrorLineFromLine(line, "line ");
                        }
                    } else if (line.toLowerCase().contains(":") && !line.toLowerCase().contains("error") && !line.toLowerCase().contains("warning")) {
                        err = Tools.getErrorLineFromLine(line, ":");
                    }
                    if (err == -1 || errorLines.contains(err)) continue;
                    errorLines.add(err);
                }
                Collections.sort(errorLines);
            }
            catch (IOException ex) {
                // empty catch block
            }
            return errorLines;
        }
        return null;
    }

    protected static int getErrorLineFromLine(String line, String token) {
        int start;
        if (line != null && !line.isEmpty() && (start = line.toLowerCase().indexOf(token, 0)) != -1) {
            int end = start + token.length();
            try {
                while (!Tools.isDelimiter(Character.valueOf(line.charAt(end)), ":")) {
                    ++end;
                }
                return Integer.parseInt(line.substring(start + token.length(), end));
            }
            catch (IndexOutOfBoundsException | NumberFormatException ex) {
                return -1;
            }
        }
        return -1;
    }

    public static String getCruncherStart(String source, int compiler) {
        String cs = SyntaxScheme.getCommentString(compiler) + " start=";
        int position = source.toLowerCase().indexOf(cs);
        if (position != -1) {
            int eol = source.indexOf("\n", position + cs.length());
            String start = source.substring(position + cs.length(), eol);
            start = start.replace("\r", "").trim();
            return start;
        }
        return null;
    }

    public static void insertBasicStart(EditorPanes editorPanes) {
        int dezaddress = 0;
        String startaddress = JOptionPane.showInputDialog(null, (Object)"Enter start address:");
        if (startaddress != null && !startaddress.trim().isEmpty()) {
            if (!(startaddress = startaddress.trim()).startsWith("$")) {
                try {
                    dezaddress = Integer.parseInt(startaddress);
                }
                catch (NumberFormatException ex) {
                    try {
                        dezaddress = Integer.parseInt(startaddress, 16);
                    }
                    catch (NumberFormatException ex2) {}
                }
            } else {
                try {
                    dezaddress = Integer.parseInt(startaddress.substring(1), 16);
                }
                catch (NumberFormatException ex2) {
                    // empty catch block
                }
            }
        }
        if (dezaddress != 0) {
            startaddress = String.valueOf(dezaddress);
            StringBuilder output = new StringBuilder("$0c,$08,$0a,$00,$9e");
            for (int i = 0; i < startaddress.length(); ++i) {
                output.append(",$3").append(startaddress.charAt(i));
            }
            output.append(",$00,$00,$00").append(System.getProperty("line.separator"));
            switch (editorPanes.getActiveCompiler()) {
                case 1: {
                    output.insert(0, "!byte ");
                    break;
                }
                case 0: 
                case 2: {
                    output.insert(0, ".byte ");
                }
            }
            switch (editorPanes.getActiveCompiler()) {
                case 1: 
                case 2: {
                    output.insert(0, "*= $0801" + System.getProperty("line.separator"));
                    break;
                }
                case 0: {
                    output.insert(0, ".pc = $0801" + System.getProperty("line.separator"));
                }
            }
            editorPanes.insertString(output.toString());
        }
    }

    public static int countMatches(CharSequence str, char sub) {
        if (null == str || str.length() == 0) {
            return 0;
        }
        int counter = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != sub) continue;
            ++counter;
        }
        return counter;
    }
}

