/*
 * Decompiled with CFR 0.152.
 */
package de.relaunch64.popelganda.Editor;

import de.relaunch64.popelganda.util.Tools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class FunctionExtractor {
    public static ArrayList getFunctionNames(String source, int compiler) {
        return FunctionExtractor.getFunctionOrMacroNames(FunctionExtractor.getFunctionString(compiler), source, compiler);
    }

    public static LinkedHashMap getFunctions(String source, int compiler) {
        return FunctionExtractor.getFunctionsOrMacros(FunctionExtractor.getFunctionString(compiler), source, compiler);
    }

    public static String getFunctionString(int compiler) {
        switch (compiler) {
            default: 
        }
        return ".function";
    }

    public static String getFunctionOrMacroFromLine(String line, int compiler, String funmacString) {
        if (FunctionExtractor.isValidFunctionOrMacro(line = line.trim(), funmacString)) {
            String keyword;
            line = line.substring(funmacString.length()).trim();
            try {
                int i;
                for (i = 0; !Tools.isDelimiter(line.substring(i, i + 1), "") && i < line.length(); ++i) {
                }
                keyword = line.substring(0, i);
            }
            catch (IndexOutOfBoundsException ex) {
                keyword = line.substring(0, line.length());
            }
            if (keyword != null && !keyword.isEmpty() && keyword.length() > 2) {
                return keyword;
            }
        }
        return null;
    }

    public static String getFunctionFromLine(String line, int compiler) {
        return FunctionExtractor.getFunctionOrMacroFromLine(line, compiler, FunctionExtractor.getFunctionString(compiler));
    }

    public static ArrayList getFunctionOrMacroNames(String funmacString, String source, int compiler) {
        ArrayList retval = new ArrayList();
        LinkedHashMap map = FunctionExtractor.getFunctionsOrMacros(funmacString, source, compiler);
        if (map != null && !map.isEmpty()) {
            Collection c = map.values();
            Iterator i = c.iterator();
            while (i.hasNext()) {
                retval.add(i.next());
            }
            return retval;
        }
        return null;
    }

    public static LinkedHashMap getFunctionsOrMacros(String funmacString, String source, int compiler) {
        LinkedHashMap<Integer, String> functions = new LinkedHashMap<Integer, String>();
        if (compiler == 1) {
            return null;
        }
        int lineNumber = 0;
        if (source != null) {
            BufferedReader br = new BufferedReader(new StringReader(source));
            LineNumberReader lineReader = new LineNumberReader(br);
            try {
                String line;
                while ((line = lineReader.readLine()) != null) {
                    ++lineNumber;
                    String keyword = FunctionExtractor.getFunctionOrMacroFromLine(line, compiler, funmacString);
                    if (keyword == null || functions.containsValue(keyword)) continue;
                    functions.put(lineNumber, keyword);
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return functions;
    }

    public static LinkedHashMap getMacros(String source, int compiler) {
        return FunctionExtractor.getFunctionsOrMacros(FunctionExtractor.getMacroString(compiler), source, compiler);
    }

    public static String getMacroString(int compiler) {
        switch (compiler) {
            default: 
        }
        return ".macro";
    }

    public static boolean isValidFunction(String keyword, int compiler) {
        return FunctionExtractor.isValidFunctionOrMacro(keyword, FunctionExtractor.getFunctionString(compiler));
    }

    public static ArrayList getMacroNames(String source, int compiler) {
        return FunctionExtractor.getFunctionOrMacroNames(FunctionExtractor.getMacroString(compiler), source, compiler);
    }

    public static boolean isValidFunctionOrMacro(String keyword, String funmacString) {
        keyword = keyword.trim();
        return keyword.startsWith(funmacString);
    }

    public static String getMacroFromLine(String line, int compiler) {
        return FunctionExtractor.getFunctionOrMacroFromLine(line, compiler, FunctionExtractor.getMacroString(compiler));
    }

    public static boolean isValidMacro(String keyword, int compiler) {
        return FunctionExtractor.isValidFunctionOrMacro(keyword, FunctionExtractor.getMacroString(compiler));
    }
}

