/*
 * Decompiled with CFR 0.152.
 */
package de.relaunch64.popelganda.Editor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SectionExtractor {
    public static LinkedHashMap getSections(String source, String compilerComment) {
        LinkedHashMap<Integer, String> sectionValues = new LinkedHashMap<Integer, String>();
        int lineNumber = 0;
        if (source != null) {
            BufferedReader br = new BufferedReader(new StringReader(source));
            LineNumberReader lineReader = new LineNumberReader(br);
            Pattern p = Pattern.compile("@(.*?)@");
            Matcher m = p.matcher("");
            try {
                String line;
                while ((line = lineReader.readLine()) != null) {
                    ++lineNumber;
                    m.reset(line);
                    if (!(line = line.trim()).startsWith(compilerComment) || !m.find()) continue;
                    sectionValues.put(lineNumber, m.group(1));
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return sectionValues;
    }

    public static ArrayList getSectionNames(String source, String compilerComment) {
        ArrayList retval = new ArrayList();
        LinkedHashMap map = SectionExtractor.getSections(source, compilerComment);
        if (map != null && !map.isEmpty()) {
            Collection c = map.values();
            Iterator i = c.iterator();
            while (i.hasNext()) {
                retval.add(i.next());
            }
            return retval;
        }
        return null;
    }

    public static ArrayList getSectionLineNumbers(String source, String compilerComment) {
        ArrayList retval = new ArrayList();
        LinkedHashMap map = SectionExtractor.getSections(source, compilerComment);
        if (map != null && !map.isEmpty()) {
            Set ks = map.keySet();
            Iterator i = ks.iterator();
            while (i.hasNext()) {
                retval.add(i.next());
            }
            return retval;
        }
        return null;
    }
}

