/*
 * Decompiled with CFR 0.152.
 */
package de.relaunch64.popelganda.Editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.util.HashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;

public class SyntaxHighlighting
extends DefaultStyledDocument {
    private final DefaultStyledDocument doc;
    private final Element rootElement;
    private boolean multiLineComment;
    private final MutableAttributeSet normal;
    private final MutableAttributeSet comment;
    private final MutableAttributeSet quote;
    private final MutableAttributeSet hexa;
    private final MutableAttributeSet binary;
    private final MutableAttributeSet lohi;
    private final MutableAttributeSet jump;
    private final MutableAttributeSet number;
    private final MutableAttributeSet keyword;
    private final HashMap<String, MutableAttributeSet> keywords;
    private final HashMap<String, MutableAttributeSet> compilerKeywords;
    private final HashMap<String, MutableAttributeSet> illegalOpcodes;
    private int fontSize;
    private String fontName;
    private final String singleLineComment;
    private final String delimiterList;
    private final int compiler;

    public SyntaxHighlighting(HashMap<String, MutableAttributeSet> keywords, HashMap<String, MutableAttributeSet> compilerKeywords, HashMap<String, MutableAttributeSet> illegalOpcodes, String fname, int fsize, String slc, String dll, HashMap<String, MutableAttributeSet> attributes, int comp, int tabWidth) {
        this.normal = attributes.get("normal");
        this.comment = attributes.get("comment");
        this.quote = attributes.get("string");
        this.number = attributes.get("number");
        this.hexa = attributes.get("hexa");
        this.jump = attributes.get("jump");
        this.binary = attributes.get("binary");
        this.lohi = attributes.get("lohi");
        this.keyword = attributes.get("keyword");
        this.singleLineComment = slc;
        this.delimiterList = dll;
        this.fontName = fname;
        this.fontSize = fsize;
        this.compiler = comp;
        this.doc = this;
        this.rootElement = this.doc.getDefaultRootElement();
        this.putProperty("__EndOfLine__", "\n");
        this.keywords = keywords;
        this.compilerKeywords = compilerKeywords;
        this.illegalOpcodes = illegalOpcodes;
        this.setTabs(tabWidth);
        this.setFontSize(this.fontSize);
    }

    public void setAttributeFont(ATTR_TYPE attr, int style) {
        Font f = new Font(this.fontName, style, this.fontSize);
        if (attr == ATTR_TYPE.Comment) {
            SyntaxHighlighting.setAttributeFont(this.comment, f);
        } else if (attr == ATTR_TYPE.Quote) {
            SyntaxHighlighting.setAttributeFont(this.quote, f);
        } else if (attr == ATTR_TYPE.Number) {
            SyntaxHighlighting.setAttributeFont(this.number, f);
        } else if (attr == ATTR_TYPE.Hexa) {
            SyntaxHighlighting.setAttributeFont(this.hexa, f);
        } else if (attr == ATTR_TYPE.LoHi) {
            SyntaxHighlighting.setAttributeFont(this.lohi, f);
        } else if (attr == ATTR_TYPE.Binary) {
            SyntaxHighlighting.setAttributeFont(this.binary, f);
        } else if (attr == ATTR_TYPE.Jump) {
            SyntaxHighlighting.setAttributeFont(this.jump, f);
        } else {
            SyntaxHighlighting.setAttributeFont(this.normal, f);
        }
    }

    public static void setAttributeFont(MutableAttributeSet attr, Font f) {
        StyleConstants.setBold(attr, f.isBold());
        StyleConstants.setItalic(attr, f.isItalic());
        StyleConstants.setFontFamily(attr, f.getFamily());
        StyleConstants.setFontSize(attr, f.getSize());
    }

    public void setAttributeColor(ATTR_TYPE attr, Color c) {
        if (attr == ATTR_TYPE.Comment) {
            SyntaxHighlighting.setAttributeColor(this.comment, c);
        } else if (attr == ATTR_TYPE.Quote) {
            SyntaxHighlighting.setAttributeColor(this.quote, c);
        } else if (attr == ATTR_TYPE.Number) {
            SyntaxHighlighting.setAttributeColor(this.number, c);
        } else if (attr == ATTR_TYPE.Hexa) {
            SyntaxHighlighting.setAttributeColor(this.hexa, c);
        } else if (attr == ATTR_TYPE.LoHi) {
            SyntaxHighlighting.setAttributeColor(this.lohi, c);
        } else if (attr == ATTR_TYPE.Binary) {
            SyntaxHighlighting.setAttributeColor(this.binary, c);
        } else if (attr == ATTR_TYPE.Jump) {
            SyntaxHighlighting.setAttributeColor(this.jump, c);
        } else {
            SyntaxHighlighting.setAttributeColor(this.normal, c);
        }
    }

    public static void setAttributeColor(MutableAttributeSet attr, Color c) {
        StyleConstants.setForeground(attr, c);
    }

    public void addKeyword(String keyword, MutableAttributeSet attr) {
        this.keywords.put(keyword, attr);
    }

    public void addCompilerKeyword(String compilerKeyword, MutableAttributeSet attr) {
        this.compilerKeywords.put(compilerKeyword, attr);
    }

    public void addIllegalOpcode(String keyword, MutableAttributeSet attr) {
        this.illegalOpcodes.put(keyword, attr);
    }

    public MutableAttributeSet getKeywordFormatting(String keyword) {
        return this.keywords.get(keyword);
    }

    public MutableAttributeSet getCompilerKeywordFormatting(String compilerKeyword) {
        return this.compilerKeywords.get(compilerKeyword);
    }

    public MutableAttributeSet getIllegalOpcodeFormatting(String keyword) {
        return this.illegalOpcodes.get(keyword);
    }

    public void removeKeyword(String keyword) {
        this.keywords.remove(keyword);
    }

    public void removeCompilerKeyword(String compilerKeyword) {
        this.compilerKeywords.remove(compilerKeyword);
    }

    public void removeIllegalOpcode(String keyword) {
        this.illegalOpcodes.remove(keyword);
    }

    private void setTabs(int charactersPerTab) {
        Font f = new Font(this.fontName, 0, this.fontSize);
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(f);
        int charWidth = fm.charWidth('w');
        int tabWidth = charWidth * charactersPerTab;
        TabStop[] tabs = new TabStop[35];
        for (int j = 0; j < tabs.length; ++j) {
            int tab = j + 1;
            tabs[j] = new TabStop(tab * tabWidth);
        }
        TabSet tabSet = new TabSet(tabs);
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setTabSet(attributes, tabSet);
        int length = this.getLength();
        this.setParagraphAttributes(0, length, attributes, false);
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        if (str.equals("{")) {
            str = this.addMatchingBrace(offset);
        }
        super.insertString(offset, str, a);
        this.processChangedLines(offset, str.length());
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        this.processChangedLines(offset, 0);
    }

    public void processChangedLines(int offset, int length) throws BadLocationException {
        String content = this.doc.getText(0, this.doc.getLength());
        int startLine = this.rootElement.getElementIndex(offset);
        int endLine = this.rootElement.getElementIndex(offset + length);
        this.setMultiLineComment(this.commentLinesBefore(content, startLine));
        for (int i = startLine; i <= endLine; ++i) {
            this.applyHighlighting(content, i);
        }
        if (this.isMultiLineComment()) {
            this.commentLinesAfter(content, endLine);
        } else {
            this.highlightLinesAfter(content, endLine);
        }
    }

    private boolean commentLinesBefore(String content, int line) {
        int offset = this.rootElement.getElement(line).getStartOffset();
        int startDelimiter = this.lastIndexOf(content, this.getStartDelimiter(), offset - 2);
        if (startDelimiter < 0) {
            return false;
        }
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), startDelimiter);
        if (endDelimiter < offset & endDelimiter != -1) {
            return false;
        }
        this.doc.setCharacterAttributes(startDelimiter, offset - startDelimiter + 1, this.comment, false);
        return true;
    }

    private void commentLinesAfter(String content, int line) {
        int offset = this.rootElement.getElement(line).getEndOffset();
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), offset);
        if (endDelimiter < 0) {
            return;
        }
        int startDelimiter = this.lastIndexOf(content, this.getStartDelimiter(), endDelimiter);
        if (startDelimiter < 0 || startDelimiter <= offset) {
            this.doc.setCharacterAttributes(offset, endDelimiter - offset + 1, this.comment, false);
        }
    }

    private void highlightLinesAfter(String content, int line) throws BadLocationException {
        int delimiter;
        int offset = this.rootElement.getElement(line).getEndOffset();
        int startDelimiter = this.indexOf(content, this.getStartDelimiter(), offset);
        int endDelimiter = this.indexOf(content, this.getEndDelimiter(), offset);
        if (startDelimiter < 0) {
            startDelimiter = content.length();
        }
        if (endDelimiter < 0) {
            endDelimiter = content.length();
        }
        if ((delimiter = Math.min(startDelimiter, endDelimiter)) < offset) {
            return;
        }
        int endLine = this.rootElement.getElementIndex(delimiter);
        for (int i = line + 1; i < endLine; ++i) {
            Element branch = this.rootElement.getElement(i);
            Element leaf = this.doc.getCharacterElement(branch.getStartOffset());
            AttributeSet as = leaf.getAttributes();
            if (!as.isEqual(this.comment)) continue;
            this.applyHighlighting(content, i);
        }
    }

    private void applyHighlighting(String content, int line) throws BadLocationException {
        int startOffset = this.rootElement.getElement(line).getStartOffset();
        int endOffset = this.rootElement.getElement(line).getEndOffset() - 1;
        int lineLength = endOffset - startOffset;
        int contentLength = content.length();
        if (endOffset >= contentLength) {
            endOffset = contentLength - 1;
        }
        if (this.endingMultiLineComment(content, startOffset, endOffset) || this.isMultiLineComment() || this.startingMultiLineComment(content, startOffset, endOffset)) {
            this.doc.setCharacterAttributes(startOffset, endOffset - startOffset + 1, this.comment, false);
            return;
        }
        this.doc.setCharacterAttributes(startOffset, lineLength, this.normal, true);
        int index = content.indexOf(this.getSingleLineDelimiter(), startOffset);
        if (index > -1 && index < endOffset) {
            this.doc.setCharacterAttributes(index, endOffset - index + 1, this.comment, false);
            endOffset = index - 1;
        }
        this.checkForTokens(content, startOffset, endOffset);
    }

    private boolean startingMultiLineComment(String content, int startOffset, int endOffset) throws BadLocationException {
        int index = this.indexOf(content, this.getStartDelimiter(), startOffset);
        if (index < 0 || index > endOffset) {
            return false;
        }
        this.setMultiLineComment(true);
        return true;
    }

    private boolean endingMultiLineComment(String content, int startOffset, int endOffset) throws BadLocationException {
        int index = this.indexOf(content, this.getEndDelimiter(), startOffset);
        if (index < 0 || index > endOffset) {
            return false;
        }
        this.setMultiLineComment(false);
        return true;
    }

    private boolean isMultiLineComment() {
        return this.multiLineComment;
    }

    private void setMultiLineComment(boolean value) {
        this.multiLineComment = value;
    }

    private void checkForTokens(String content, int startOffset, int endOffset) {
        if (content.length() < 2) {
            return;
        }
        while (startOffset <= endOffset) {
            try {
                while (this.isDelimiter(content.substring(startOffset, startOffset + 1), "")) {
                    if (startOffset < endOffset) {
                        ++startOffset;
                        continue;
                    }
                    return;
                }
                if (this.isQuoteDelimiter(content.substring(startOffset, startOffset + 1))) {
                    startOffset = this.getQuoteToken(content, startOffset, endOffset);
                    continue;
                }
                if (this.isBinCharDelimiter(content.substring(startOffset, startOffset + 2))) {
                    startOffset = this.getBinCharToken(content, startOffset, endOffset, 2);
                    continue;
                }
                if (this.isLoHiByteDelimiter(content.substring(startOffset, startOffset + 2))) {
                    startOffset = this.getLoHiByteToken(content, startOffset, endOffset);
                    continue;
                }
                if (this.isJumpDelimiter(content.substring(startOffset, startOffset + 1))) {
                    startOffset = this.getJumpToken(content, startOffset, endOffset);
                    continue;
                }
                if (this.isHexCharDelimiter(content.substring(startOffset, startOffset + 1))) {
                    startOffset = this.getHexCharToken(content, startOffset, endOffset);
                    continue;
                }
                if (this.isHexAddressDelimiter(content.substring(startOffset, startOffset + 1))) {
                    startOffset = this.getHexAddressToken(content, startOffset, endOffset);
                    continue;
                }
                if (this.isBinCharDelimiter(content.substring(startOffset, startOffset + 1))) {
                    startOffset = this.getBinCharToken(content, startOffset, endOffset, 1);
                    continue;
                }
                startOffset = this.getOtherToken(content, startOffset, endOffset);
            }
            catch (IndexOutOfBoundsException ex) {
                if (startOffset < endOffset) {
                    ++startOffset;
                    continue;
                }
                return;
            }
        }
    }

    private int getQuoteToken(String content, int startOffset, int endOffset) {
        String quoteDelimiter = content.substring(startOffset, startOffset + 1);
        String escapeString = this.getEscapeString(quoteDelimiter);
        int endOfQuote = startOffset;
        int index = content.indexOf(escapeString, endOfQuote + 1);
        while (index > -1 && index < endOffset) {
            endOfQuote = index + 1;
            index = content.indexOf(escapeString, endOfQuote);
        }
        index = content.indexOf(quoteDelimiter, endOfQuote + 1);
        endOfQuote = index < 0 || index > endOffset ? endOffset : index;
        this.doc.setCharacterAttributes(startOffset, endOfQuote - startOffset + 1, this.quote, false);
        return endOfQuote + 1;
    }

    private int getBinCharToken(String content, int startOffset, int endOffset, int addValue) {
        int endOfToken;
        for (endOfToken = startOffset + addValue; endOfToken <= endOffset && !this.isDelimiter(content.substring(endOfToken, endOfToken + 1), ""); ++endOfToken) {
        }
        this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.binary, false);
        return endOfToken + 1;
    }

    private int getLoHiByteToken(String content, int startOffset, int endOffset) {
        int endOfToken;
        for (endOfToken = startOffset + 2; endOfToken <= endOffset && !this.isDelimiter(content.substring(endOfToken, endOfToken + 1), "."); ++endOfToken) {
        }
        this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.lohi, false);
        return endOfToken + 1;
    }

    private int getHexCharToken(String content, int startOffset, int endOffset) {
        int endOfToken;
        for (endOfToken = startOffset + 1; endOfToken <= endOffset && !this.isDelimiter(content.substring(endOfToken, endOfToken + 1), ""); ++endOfToken) {
        }
        this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.number, false);
        return endOfToken + 1;
    }

    private int getJumpToken(String content, int startOffset, int endOffset) {
        int endOfToken;
        for (endOfToken = startOffset + 1; endOfToken <= endOffset && !this.isDelimiter(content.substring(endOfToken, endOfToken + 1), ""); ++endOfToken) {
        }
        this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.jump, false);
        return endOfToken + 1;
    }

    private int getHexAddressToken(String content, int startOffset, int endOffset) {
        int endOfToken;
        for (endOfToken = startOffset + 1; endOfToken <= endOffset && !this.isDelimiter(content.substring(endOfToken, endOfToken + 1), ""); ++endOfToken) {
        }
        this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, this.hexa, false);
        return endOfToken + 1;
    }

    private int getOtherToken(String content, int startOffset, int endOffset) {
        int endOfToken;
        for (endOfToken = startOffset + 1; endOfToken <= endOffset && !this.isDelimiter(content.substring(endOfToken, endOfToken + 1), ""); ++endOfToken) {
        }
        String token = content.substring(startOffset, endOfToken);
        MutableAttributeSet attr = this.keywords.get(token.toUpperCase());
        if (attr != null) {
            this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, attr, false);
        } else {
            attr = this.illegalOpcodes.get(token.toUpperCase());
            if (attr != null) {
                this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, attr, false);
            } else {
                attr = this.compilerKeywords.get(token.toUpperCase());
                if (attr != null) {
                    this.doc.setCharacterAttributes(startOffset, endOfToken - startOffset, attr, false);
                }
            }
        }
        return endOfToken + 1;
    }

    private int indexOf(String content, String needle, int offset) {
        String text;
        int index;
        while ((index = content.indexOf(needle, offset)) != -1 && !(text = this.getLine(content, index).trim()).startsWith(needle) && !text.endsWith(needle)) {
            offset = index + 1;
        }
        return index;
    }

    private int lastIndexOf(String content, String needle, int offset) {
        String text;
        int index;
        while ((index = content.lastIndexOf(needle, offset)) != -1 && !(text = this.getLine(content, index).trim()).startsWith(needle) && !text.endsWith(needle)) {
            offset = index - 1;
        }
        return index;
    }

    private String getLine(String content, int offset) {
        int line = this.rootElement.getElementIndex(offset);
        Element lineElement = this.rootElement.getElement(line);
        int start = lineElement.getStartOffset();
        int end = lineElement.getEndOffset();
        return content.substring(start, end - 1);
    }

    protected boolean isDelimiter(String character, String additional_operands) {
        String operands = this.delimiterList + additional_operands;
        return Character.isWhitespace(character.charAt(0)) || operands.contains(character);
    }

    protected boolean isQuoteDelimiter(String character) {
        String quoteDelimiters = "\"'";
        return quoteDelimiters.contains(character);
    }

    protected boolean isHexCharDelimiter(String character) {
        String quoteDelimiters = "#";
        return quoteDelimiters.contains(character);
    }

    protected boolean isJumpDelimiter(String character) {
        String quoteDelimiters = ".";
        switch (this.compiler) {
            case 1: {
                quoteDelimiters = ".";
                break;
            }
            case 0: {
                quoteDelimiters = "!";
                break;
            }
            case 2: {
                return false;
            }
        }
        return quoteDelimiters.contains(character);
    }

    protected boolean isBinCharDelimiter(String character) {
        String quoteDelimiters1 = "#%";
        String quoteDelimiters2 = "%";
        return quoteDelimiters1.contains(character) || quoteDelimiters2.contains(character);
    }

    protected boolean isLoHiByteDelimiter(String character) {
        String quoteDelimiters = "#<";
        if (!quoteDelimiters.contains(character)) {
            quoteDelimiters = "#>";
            return quoteDelimiters.contains(character);
        }
        return true;
    }

    protected boolean isHexAddressDelimiter(String character) {
        String quoteDelimiters = "$";
        return quoteDelimiters.contains(character);
    }

    protected String getStartDelimiter() {
        return "/*";
    }

    protected String getEndDelimiter() {
        return "*/";
    }

    protected String getSingleLineDelimiter() {
        return this.singleLineComment;
    }

    protected String getEscapeString(String quoteDelimiter) {
        return "\\" + quoteDelimiter;
    }

    protected String addMatchingBrace(int offset) throws BadLocationException {
        String temp;
        StringBuilder whiteSpace = new StringBuilder(16);
        int line = this.rootElement.getElementIndex(offset);
        int i = this.rootElement.getElement(line).getStartOffset();
        while ((temp = this.doc.getText(i, 1)).equals(" ") || temp.equals("\t")) {
            whiteSpace.append(temp);
            ++i;
        }
        return "{\n" + whiteSpace.toString() + "\t\n" + whiteSpace.toString() + "}";
    }

    public int getFontSize() {
        return this.fontSize;
    }

    private void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        StyleConstants.setFontSize(this.normal, fontSize);
        StyleConstants.setFontSize(this.quote, fontSize);
        StyleConstants.setFontSize(this.number, fontSize);
        StyleConstants.setFontSize(this.hexa, fontSize);
        StyleConstants.setFontSize(this.lohi, fontSize);
        StyleConstants.setFontSize(this.binary, fontSize);
        StyleConstants.setFontSize(this.jump, fontSize);
        StyleConstants.setFontSize(this.comment, fontSize);
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
        StyleConstants.setFontFamily(this.normal, fontName);
        StyleConstants.setFontFamily(this.quote, fontName);
        StyleConstants.setFontFamily(this.number, fontName);
        StyleConstants.setFontFamily(this.hexa, fontName);
        StyleConstants.setFontFamily(this.lohi, fontName);
        StyleConstants.setFontFamily(this.binary, fontName);
        StyleConstants.setFontFamily(this.jump, fontName);
        StyleConstants.setFontFamily(this.comment, fontName);
    }

    public static enum ATTR_TYPE {
        Normal,
        Comment,
        Quote,
        Number,
        Hexa,
        LoHi,
        Binary,
        Jump;

    }
}

