/*
 * Decompiled with CFR 0.152.
 */
package de.relaunch64.popelganda;

import de.relaunch64.popelganda.Relaunch64App;
import de.relaunch64.popelganda.util.ConstantsR64;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;

public class FontChooser
extends JDialog {
    private Font selectedFont;
    private DefaultListModel listmodelFont = new DefaultListModel();
    private final DefaultListModel listmodelSize = new DefaultListModel();
    private JButton jButtonApply;
    private JButton jButtonCancel;
    private JEditorPane jEditorPanePreview;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JList jListFont;
    private JList jListSize;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JTextField jTextFieldFilter;

    public FontChooser(Frame parent, Font f) {
        super(parent);
        String[] fonts;
        this.initComponents();
        this.setIconImage(ConstantsR64.r64icon.getImage());
        this.selectedFont = f;
        for (String fts : fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            this.listmodelFont.addElement(fts);
        }
        for (int i = 8; i <= 72; ++i) {
            this.listmodelSize.addElement(i);
        }
        int index = this.listmodelFont.indexOf(this.selectedFont.getFamily());
        if (index != -1) {
            this.jListFont.setSelectedIndex(index);
        } else {
            this.jListFont.setSelectedIndex(0);
        }
        this.jListFont.ensureIndexIsVisible(index);
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        ActionListener cancelAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontChooser.this.cancelFont();
            }
        };
        this.getRootPane().registerKeyboardAction(cancelAction, stroke, 2);
        int size = this.selectedFont.getSize();
        index = this.listmodelSize.indexOf(size);
        if (index != -1) {
            this.jListSize.setSelectedIndex(index);
        } else {
            this.jListSize.setSelectedIndex(3);
        }
        this.jListSize.ensureIndexIsVisible(index);
        this.jListFont.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FontChooser.this.fontChanged();
            }
        });
        this.jListSize.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FontChooser.this.fontChanged();
            }
        });
        this.jTextFieldFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FontChooser.this.gotoFont();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FontChooser.this.gotoFont();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FontChooser.this.gotoFont();
            }
        });
        this.updatePreview(this.selectedFont);
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListFont = new JList();
        this.jTextFieldFilter = new JTextField();
        this.jPanel4 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jListSize = new JList();
        this.jPanel5 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.jEditorPanePreview = new JEditorPane();
        this.jButtonApply = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(Relaunch64App.class).getContext().getResourceMap(FontChooser.class);
        this.setTitle(resourceMap.getString("FormFontChooser.title", new Object[0]));
        this.setModal(true);
        this.setName("FormFontChooser");
        this.jPanel1.setName("jPanel1");
        this.jPanel2.setName("jPanel2");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jScrollPane1.setName("jScrollPane1");
        this.jListFont.setModel(this.listmodelFont);
        this.jListFont.setSelectionMode(0);
        this.jListFont.setName("jListFont");
        this.jScrollPane1.setViewportView(this.jListFont);
        this.jTextFieldFilter.setText(resourceMap.getString("jTextFieldFilter.text", new Object[0]));
        this.jTextFieldFilter.setName("jTextFieldFilter");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 311, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.jTextFieldFilter))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFilter, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 215, Short.MAX_VALUE).addContainerGap()));
        this.jPanel4.setName("jPanel4");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jScrollPane3.setName("jScrollPane3");
        this.jListSize.setModel(this.listmodelSize);
        this.jListSize.setSelectionMode(0);
        this.jListSize.setName("jListSize");
        this.jScrollPane3.setViewportView(this.jListSize);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 123, Short.MAX_VALUE).addComponent(this.jLabel3)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3).addContainerGap()));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel5.border.title", new Object[0])));
        this.jPanel5.setName("jPanel5");
        this.jScrollPane4.setBorder(null);
        this.jScrollPane4.setName("jScrollPane4");
        this.jEditorPanePreview.setEditable(false);
        this.jEditorPanePreview.setBorder(null);
        this.jEditorPanePreview.setContentType(resourceMap.getString("jEditorPanePreview.contentType", new Object[0]));
        this.jEditorPanePreview.setName("jEditorPanePreview");
        this.jScrollPane4.setViewportView(this.jEditorPanePreview);
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane4).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jScrollPane4, -1, 135, Short.MAX_VALUE).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addContainerGap()));
        ApplicationActionMap actionMap = Application.getInstance(Relaunch64App.class).getContext().getActionMap(FontChooser.class, this);
        this.jButtonApply.setAction(actionMap.get("applyFont"));
        this.jButtonApply.setName("jButtonApply");
        this.jButtonCancel.setAction(actionMap.get("cancelFont"));
        this.jButtonCancel.setName("jButtonCancel");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonApply))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonApply).addComponent(this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    @Action
    public void cancelFont() {
        this.selectedFont = null;
        this.dispose();
        this.setVisible(false);
    }

    @Action
    public void applyFont() {
        this.dispose();
        this.setVisible(false);
    }

    private void gotoFont() {
        String f = this.jTextFieldFilter.getText().toLowerCase();
        this.listmodelFont = (DefaultListModel)this.jListFont.getModel();
        for (int cnt = 0; cnt < this.listmodelFont.getSize(); ++cnt) {
            String font = this.listmodelFont.get(cnt).toString().toLowerCase();
            if (!font.startsWith(f)) continue;
            this.jListFont.setSelectedIndex(cnt);
            this.jListFont.ensureIndexIsVisible(cnt);
            return;
        }
    }

    private void fontChanged() {
        int size = this.jListSize.getSelectedIndex() + 8;
        String name = this.jListFont.getSelectedValue().toString();
        this.selectedFont = new Font(name, 0, size);
        this.updatePreview(this.selectedFont);
    }

    private void updatePreview(Font f) {
        StringBuilder css = new StringBuilder("");
        String style = "normal";
        String weight = "normal";
        if (0 == f.getStyle()) {
            style = "normal";
            weight = "normal";
        } else if (1 == f.getStyle()) {
            style = "normal";
            weight = "bold";
        } else if (2 == f.getStyle()) {
            style = "italic";
            weight = "normal";
        } else if (3 == f.getStyle()) {
            style = "italic";
            weight = "bold";
        }
        css.append("<html>\n<head>\n<style>\nbody{font-family:");
        css.append(f.getFamily());
        css.append(";font-size:");
        css.append(String.valueOf(f.getSize()));
        css.append("pt;color:#000000");
        css.append(";font-style:");
        css.append(style);
        css.append(";font-weight:");
        css.append(weight);
        css.append(";}\n</style>\n</head>\n<body>\n");
        css.append("<p>abcdef ABCDEG<br>1234567890<br><br>LDA #$01<br>STA $D020<br><br>.text \"hello world...\"<br><br>Relaunch64 - Preview!</p></body>\n</html>");
        this.jEditorPanePreview.setText(css.toString());
    }
}

