/*
 * Decompiled with CFR 0.152.
 */
package de.relaunch64.popelganda;

import de.relaunch64.popelganda.Relaunch64App;
import de.relaunch64.popelganda.database.Settings;
import de.relaunch64.popelganda.util.ConstantsR64;
import de.relaunch64.popelganda.util.FileTools;
import de.relaunch64.popelganda.util.Tools;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;

public class InsertByteFromFileDlg
extends JDialog {
    private File fileToOpen = null;
    private String bytetable = null;
    private final int compiler;
    private final Settings settings;
    private JButton jButtonApply;
    private JButton jButtonBrowse;
    private JButton jButtonCancel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField jTextFieldBytesPerLine;
    private JTextField jTextFieldEndOffset;
    private JTextField jTextFieldFile;
    private JTextField jTextFieldStartOffset;

    public InsertByteFromFileDlg(Frame parent, Settings s, int c) {
        super(parent);
        this.settings = s;
        this.compiler = c;
        this.bytetable = null;
        this.fileToOpen = null;
        this.initComponents();
        this.setIconImage(ConstantsR64.r64icon.getImage());
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        ActionListener cancelAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InsertByteFromFileDlg.this.cancel();
            }
        };
        this.getRootPane().registerKeyboardAction(cancelAction, stroke, 2);
    }

    @Action
    public void browseFile() {
        this.fileToOpen = FileTools.chooseFile(null, 0, 0, this.settings.getLastUsedPath().getAbsolutePath(), "", "Open binary File", null, "All files");
        this.jTextFieldFile.setText(this.fileToOpen != null && this.fileToOpen.exists() ? this.fileToOpen.toString() : "");
    }

    @Action
    public void apply() {
        try {
            int start = Integer.parseInt(this.jTextFieldStartOffset.getText());
            int end = Integer.parseInt(this.jTextFieldEndOffset.getText());
            int bpl = Integer.parseInt(this.jTextFieldBytesPerLine.getText());
            if (start >= 0 && (start < end || -1 == end) && bpl > 0) {
                if (this.fileToOpen != null && this.fileToOpen.exists()) {
                    this.bytetable = Tools.getByteTableFromFile(this.fileToOpen, start, end, this.compiler, bpl);
                    this.settings.setLastUsedPath(this.fileToOpen);
                    this.setVisible(false);
                    this.dispose();
                } else {
                    JOptionPane.showMessageDialog(null, "File not found or no valid file name specified!");
                    this.jTextFieldFile.setText("");
                }
            } else {
                JOptionPane.showMessageDialog(null, "Invalid values for offsets or bytes per line!");
            }
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(null, "Invalid values for offsets or bytes per line!");
        }
    }

    @Action
    public void cancel() {
        this.bytetable = null;
        this.setVisible(false);
        this.dispose();
    }

    public String getByteTable() {
        return this.bytetable;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldFile = new JTextField();
        this.jButtonBrowse = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextFieldStartOffset = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldEndOffset = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldBytesPerLine = new JTextField();
        this.jButtonApply = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(Relaunch64App.class).getContext().getResourceMap(InsertByteFromFileDlg.class);
        this.setTitle(resourceMap.getString("InsertBytesFromFileDlg.title", new Object[0]));
        this.setModal(true);
        this.setName("InsertBytesFromFileDlg");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jTextFieldFile.setName("jTextFieldFile");
        ApplicationActionMap actionMap = Application.getInstance(Relaunch64App.class).getContext().getActionMap(InsertByteFromFileDlg.class, this);
        this.jButtonBrowse.setAction(actionMap.get("browseFile"));
        this.jButtonBrowse.setName("jButtonBrowse");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jTextFieldStartOffset.setColumns(8);
        this.jTextFieldStartOffset.setText(resourceMap.getString("jTextFieldStartOffset.text", new Object[0]));
        this.jTextFieldStartOffset.setToolTipText(resourceMap.getString("jTextFieldStartOffset.toolTipText", new Object[0]));
        this.jTextFieldStartOffset.setName("jTextFieldStartOffset");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jTextFieldEndOffset.setColumns(8);
        this.jTextFieldEndOffset.setText(resourceMap.getString("jTextFieldEndOffset.text", new Object[0]));
        this.jTextFieldEndOffset.setToolTipText(resourceMap.getString("jTextFieldEndOffset.toolTipText", new Object[0]));
        this.jTextFieldEndOffset.setName("jTextFieldEndOffset");
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.jTextFieldBytesPerLine.setColumns(8);
        this.jTextFieldBytesPerLine.setText(resourceMap.getString("jTextFieldBytesPerLine.text", new Object[0]));
        this.jTextFieldBytesPerLine.setName("jTextFieldBytesPerLine");
        this.jButtonApply.setAction(actionMap.get("apply"));
        this.jButtonApply.setName("jButtonApply");
        this.jButtonCancel.setAction(actionMap.get("cancel"));
        this.jButtonCancel.setName("jButtonCancel");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldBytesPerLine, -2, -1, -2).addComponent(this.jTextFieldEndOffset, -2, -1, -2).addComponent(this.jTextFieldStartOffset, -2, -1, -2).addComponent(this.jTextFieldFile, -1, 231, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonBrowse)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonApply))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldFile, -2, -1, -2).addComponent(this.jButtonBrowse)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldStartOffset, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldEndOffset, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldBytesPerLine, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonApply).addComponent(this.jButtonCancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }
}

