/*
 * Decompiled with CFR 0.152.
 */
package de.relaunch64.popelganda;

import de.relaunch64.popelganda.Relaunch64App;
import de.relaunch64.popelganda.util.ConstantsR64;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;

public class InsertSinusTableDlg
extends JDialog {
    private String bytetable = null;
    private final int compiler;
    private JButton jButtonApply;
    private JButton jButtonCancel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JTextField jTextFieldBytesPerLine;
    private JTextField jTextFieldCount;
    private JTextField jTextFieldCurves;
    private JTextField jTextFieldMax;
    private JTextField jTextFieldMin;

    public InsertSinusTableDlg(Frame parent, int c) {
        super(parent);
        this.compiler = c;
        this.bytetable = null;
        this.initComponents();
        this.setIconImage(ConstantsR64.r64icon.getImage());
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        ActionListener cancelAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InsertSinusTableDlg.this.cancel();
            }
        };
        this.getRootPane().registerKeyboardAction(cancelAction, stroke, 2);
    }

    @Action
    public void apply() {
        try {
            String byteToken;
            int min = Integer.parseInt(this.jTextFieldMin.getText());
            int max = Integer.parseInt(this.jTextFieldMax.getText());
            int count = Integer.parseInt(this.jTextFieldCount.getText());
            int bpl = Integer.parseInt(this.jTextFieldBytesPerLine.getText());
            int anzahlKurven = Integer.parseInt(this.jTextFieldCurves.getText());
            int phase = (max + 1 - min) / 2;
            double step = (double)anzahlKurven * 2.0 * Math.PI;
            int dummy = (int)((step /= (double)count) * 10000.0) + 1;
            step = (double)dummy / 10000.0;
            switch (this.compiler) {
                case 1: {
                    byteToken = "!byte";
                    break;
                }
                case 0: 
                case 2: {
                    byteToken = ".byte";
                    break;
                }
                default: {
                    byteToken = ".byte";
                }
            }
            StringBuilder sb = new StringBuilder("");
            boolean startNewLine = true;
            int bytesPerLine = 0;
            if (min >= 0 && min < max && bpl > 0 && count > 0 && anzahlKurven > 0) {
                while (anzahlKurven > 0) {
                    int value;
                    double i;
                    for (i = -1.5707963267948966; i < 1.5707963267948966; i += step) {
                        if (startNewLine) {
                            sb.append(byteToken).append(" ");
                            startNewLine = false;
                        }
                        if ((value = (int)(Math.sin(i) * (double)phase + (double)(phase + min))) > max) {
                            value = max;
                        }
                        if (value < min) {
                            value = min;
                        }
                        sb.append("$").append(String.format("%02x", value));
                        if (++bytesPerLine >= bpl) {
                            sb.append(System.getProperty("line.separator"));
                            startNewLine = true;
                            bytesPerLine = 0;
                            continue;
                        }
                        sb.append(", ");
                    }
                    for (i = 1.5707963267948966; i > -1.5707963267948966; i -= step) {
                        if (startNewLine) {
                            sb.append(byteToken).append(" ");
                            startNewLine = false;
                        }
                        if ((value = (int)(Math.sin(i) * (double)phase + (double)(phase + min))) > max) {
                            value = max;
                        }
                        if (value < min) {
                            value = min;
                        }
                        sb.append("$").append(String.format("%02x", value));
                        if (++bytesPerLine >= bpl || i <= -1.5707963267948966) {
                            sb.append(System.getProperty("line.separator"));
                            startNewLine = true;
                            bytesPerLine = 0;
                            continue;
                        }
                        sb.append(", ");
                    }
                    --anzahlKurven;
                }
                this.bytetable = sb.toString();
                this.setVisible(false);
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(null, "Invalid values or wrong range specified!");
            }
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(null, "Invalid values!");
        }
    }

    @Action
    public void cancel() {
        this.bytetable = null;
        this.setVisible(false);
        this.dispose();
    }

    public String getByteTable() {
        return this.bytetable;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldMin = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldMax = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldCount = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldBytesPerLine = new JTextField();
        this.jButtonApply = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel5 = new JLabel();
        this.jTextFieldCurves = new JTextField();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(Relaunch64App.class).getContext().getResourceMap(InsertSinusTableDlg.class);
        this.setTitle(resourceMap.getString("InsertSinusTableDlg.title", new Object[0]));
        this.setModal(true);
        this.setName("InsertSinusTableDlg");
        this.jLabel1.setDisplayedMnemonic('i');
        this.jLabel1.setLabelFor(this.jTextFieldMin);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jTextFieldMin.setColumns(8);
        this.jTextFieldMin.setText(resourceMap.getString("jTextFieldMin.text", new Object[0]));
        this.jTextFieldMin.setName("jTextFieldMin");
        this.jLabel2.setDisplayedMnemonic('x');
        this.jLabel2.setLabelFor(this.jTextFieldMax);
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jTextFieldMax.setColumns(8);
        this.jTextFieldMax.setText(resourceMap.getString("jTextFieldMax.text", new Object[0]));
        this.jTextFieldMax.setName("jTextFieldMax");
        this.jLabel3.setDisplayedMnemonic('v');
        this.jLabel3.setLabelFor(this.jTextFieldCount);
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jTextFieldCount.setColumns(8);
        this.jTextFieldCount.setText(resourceMap.getString("jTextFieldCount.text", new Object[0]));
        this.jTextFieldCount.setName("jTextFieldCount");
        this.jLabel4.setDisplayedMnemonic('l');
        this.jLabel4.setLabelFor(this.jTextFieldBytesPerLine);
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.jTextFieldBytesPerLine.setColumns(8);
        this.jTextFieldBytesPerLine.setText(resourceMap.getString("jTextFieldBytesPerLine.text", new Object[0]));
        this.jTextFieldBytesPerLine.setName("jTextFieldBytesPerLine");
        ApplicationActionMap actionMap = Application.getInstance(Relaunch64App.class).getContext().getActionMap(InsertSinusTableDlg.class, this);
        this.jButtonApply.setAction(actionMap.get("apply"));
        this.jButtonApply.setMnemonic('A');
        this.jButtonApply.setName("jButtonApply");
        this.jButtonCancel.setAction(actionMap.get("cancel"));
        this.jButtonCancel.setName("jButtonCancel");
        this.jLabel5.setDisplayedMnemonic('c');
        this.jLabel5.setLabelFor(this.jTextFieldCurves);
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.jTextFieldCurves.setColumns(8);
        this.jTextFieldCurves.setText(resourceMap.getString("jTextFieldCurves.text", new Object[0]));
        this.jTextFieldCurves.setName("jTextFieldCurves");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldBytesPerLine, -2, -1, -2).addComponent(this.jTextFieldCount, -2, -1, -2).addComponent(this.jTextFieldMax, -2, -1, -2).addComponent(this.jTextFieldMin, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonApply).addGap(10, 10, 10)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldCurves, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldMin, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldMax, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldCount, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextFieldCurves, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldBytesPerLine, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonApply).addComponent(this.jButtonCancel)).addContainerGap()));
        this.pack();
    }
}

