/*
 * Decompiled with CFR 0.152.
 */
package de.relaunch64.popelganda.database;

import de.relaunch64.popelganda.util.ConstantsR64;
import de.relaunch64.popelganda.util.FileTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.IllegalAddException;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class CustomScripts {
    private Document scriptFile = new Document(new Element("CustomScripts"));
    private final File filepath = FileTools.createFilePath("relaunch64-scripts.xml");
    private static final String ELEMENT_SCRIPT = "Script";
    private static final String ATTR_NAME = "script_name";
    private static final String ROOT_NAME = "CustomScripts";

    public void loadScripts() {
        if (this.filepath != null && this.filepath.exists()) {
            try {
                SAXBuilder builder = new SAXBuilder();
                this.scriptFile = builder.build(this.filepath);
            }
            catch (IOException | JDOMException ex) {
                ConstantsR64.r64logger.log(Level.WARNING, ex.getLocalizedMessage());
            }
        }
    }

    public void saveScripts() {
        if (this.filepath != null) {
            OutputStream dest = null;
            try {
                XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
                dest = new FileOutputStream(this.filepath);
                out.output(this.scriptFile, dest);
            }
            catch (IOException ex) {
                ConstantsR64.r64logger.log(Level.WARNING, ex.getLocalizedMessage());
            }
            finally {
                if (dest != null) {
                    try {
                        dest.close();
                    }
                    catch (IOException ex) {
                        ConstantsR64.r64logger.log(Level.WARNING, ex.getLocalizedMessage());
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addScript(String name, String content) {
        if (null == name || name.isEmpty() || null == content || content.isEmpty()) {
            return false;
        }
        int pos = this.findScript(name);
        if (pos != -1) {
            Element el = this.retrieveElement(pos);
            if (el == null) return false;
            el.setText(content);
            return true;
        } else {
            Element el = new Element(ELEMENT_SCRIPT);
            el.setAttribute(ATTR_NAME, name);
            el.setText(content);
            this.scriptFile.getRootElement().addContent(el);
        }
        return true;
    }

    public String getScript(String name) {
        Element el;
        int pos = this.findScript(name);
        if (pos != -1 && (el = this.retrieveElement(pos)) != null) {
            return el.getText();
        }
        return null;
    }

    public String getScriptName(int pos) {
        Element el = this.retrieveElement(pos);
        if (el != null) {
            return el.getAttributeValue(ATTR_NAME);
        }
        return null;
    }

    public String[] getScriptNames() {
        ArrayList<String> snames = new ArrayList<String>();
        for (int i = 0; i < this.getCount(); ++i) {
            String sn = this.getScriptName(i);
            if (sn == null || sn.isEmpty() || snames.contains(sn)) continue;
            snames.add(sn);
        }
        if (snames.isEmpty()) {
            return null;
        }
        return snames.toArray(new String[snames.size()]);
    }

    private Element retrieveElement(int pos) {
        if (pos < 0) {
            return null;
        }
        try {
            List<Element> elementList = this.scriptFile.getRootElement().getChildren();
            try {
                return elementList.get(pos);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public int findScript(String name) {
        if (null == name || name.trim().isEmpty()) {
            return -1;
        }
        name = name.trim();
        try {
            List<Element> scriptList = this.scriptFile.getRootElement().getChildren();
            Iterator<Element> iterator = scriptList.iterator();
            int cnt = 0;
            while (iterator.hasNext()) {
                Element script = iterator.next();
                if (name.equalsIgnoreCase(script.getAttributeValue(ATTR_NAME))) {
                    return cnt;
                }
                ++cnt;
            }
            return -1;
        }
        catch (IllegalStateException e) {
            return -1;
        }
    }

    public int getCount() {
        return this.scriptFile.getRootElement().getContentSize();
    }

    public boolean removeScript(String name) {
        int index = this.findScript(name);
        return this.removeScript(index);
    }

    public boolean removeScript(int index) {
        List<Element> children = this.scriptFile.getRootElement().getChildren();
        try {
            Element el = children.remove(index);
            if (el != null) {
                this.scriptFile = new Document(new Element(ROOT_NAME));
                for (Element e : children) {
                    this.addScript(e.getAttributeValue(ATTR_NAME), e.getText());
                }
                return true;
            }
        }
        catch (IndexOutOfBoundsException | UnsupportedOperationException | IllegalAddException ex) {
            return false;
        }
        return false;
    }
}

