/*
 * Decompiled with CFR 0.152.
 */
package de.relaunch64.popelganda.database;

import de.relaunch64.popelganda.Editor.EditorPanes;
import de.relaunch64.popelganda.util.ConstantsR64;
import de.relaunch64.popelganda.util.FileTools;
import java.awt.Font;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class Settings {
    private static final int recentDocCount = 10;
    private static final String SETTING_RECENT_DOC = "recentDoc";
    private static final String SETTING_LAST_USED_PATH = "lastusedpath";
    private static final String SETTING_PREF_COMP = "preferredCompiler";
    private static final String SETTING_SYNTAX_SCHEME = "syntaxscheme";
    private static final String SETTING_LAST_SCRIPT = "lastUserScript";
    private static final String REC_DOC_COMPILER = "compiler";
    private static final String REC_DOC_SCRIPT = "script";
    private static final String SETTING_MAINFONT = "editorfont";
    private static final String SETTING_CHECKUPDATES = "checkupdates";
    private static final String SETTING_SAVEONCOMPILE = "saveoncompile";
    private static final String SETTING_LOGSPLITLAYOUT = "logsplitlayout";
    private static final String SETTING_BOTHLOGRUNSPLITLAYOUT = "bothlogrubsplitlayout";
    private static final String SETTING_TABWIDTH = "tabwidth";
    private static final String SETTING_LINE_NUMBER_ALIGNMENT = "linenumberalignment";
    private static final String SETTING_REOPEN_FILES_ON_STARTUP = "rofstartup";
    private static final String SETTING_REOPEN_FILES = "reopenfiles";
    private static final String SETTING_REOPEN_FILES_CHILD = "rof";
    private static final String ATTR_COMPILER = "compiler";
    private static final String ATTR_SCRIPT = "script";
    private final File filepath;
    private final boolean IS_WINDOWS;
    private final boolean IS_WINDOWS7;
    private final boolean IS_WINDOWS8;
    private final boolean IS_OSX;
    private final boolean IS_LINUX;
    public static final int FONTNAME = 1;
    public static final int FONTSIZE = 2;
    public static final int SPLITPANE_LOG = 1;
    public static final int SPLITPANE_RUN = 2;
    public static final int SPLITPANE_BOTHLOGRUN = 3;
    private Document settingsFile = new Document(new Element("settings"));

    public boolean isWindows() {
        return this.IS_WINDOWS;
    }

    public boolean isWindows7() {
        return this.IS_WINDOWS7;
    }

    public boolean isWindows8() {
        return this.IS_WINDOWS8;
    }

    public boolean isOSX() {
        return this.IS_OSX;
    }

    public boolean isLinux() {
        return this.IS_LINUX;
    }

    public Settings() {
        this.IS_WINDOWS = System.getProperty("os.name").toLowerCase().startsWith("windows");
        this.IS_OSX = System.getProperty("os.name").toLowerCase().startsWith("mac os");
        this.IS_LINUX = System.getProperty("os.name").toLowerCase().contains("linux");
        this.IS_WINDOWS7 = System.getProperty("os.name").toLowerCase().startsWith("windows 7");
        this.IS_WINDOWS8 = System.getProperty("os.name").toLowerCase().startsWith("windows 8");
        this.filepath = FileTools.createFilePath("relaunch64-settings.xml");
        this.fillElements();
    }

    public void loadSettings() {
        if (this.filepath != null && this.filepath.exists()) {
            try {
                SAXBuilder builder = new SAXBuilder();
                this.settingsFile = builder.build(this.filepath);
            }
            catch (IOException | JDOMException ex) {
                ConstantsR64.r64logger.log(Level.WARNING, ex.getLocalizedMessage());
            }
        }
        this.fillElements();
    }

    public void saveSettings() {
        if (this.filepath != null) {
            OutputStream dest = null;
            try {
                XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
                dest = new FileOutputStream(this.filepath);
                out.output(this.settingsFile, dest);
            }
            catch (IOException ex) {
                ConstantsR64.r64logger.log(Level.WARNING, ex.getLocalizedMessage());
            }
            finally {
                if (dest != null) {
                    try {
                        dest.close();
                    }
                    catch (IOException ex) {
                        ConstantsR64.r64logger.log(Level.WARNING, ex.getLocalizedMessage());
                    }
                }
            }
        }
    }

    private void fillElements() {
        String font = "Helvetica";
        if (this.isWindows()) {
            font = "Arial";
            if (this.isWindows7() || this.isWindows8()) {
                font = "Calibri";
            }
        } else if (this.isLinux()) {
            font = "Nimbus Sans L Regular";
        }
        for (int cnt = 0; cnt < 10; ++cnt) {
            String fi = SETTING_RECENT_DOC + String.valueOf(cnt + 1);
            if (null != this.settingsFile.getRootElement().getChild(fi)) continue;
            Element el = new Element(fi);
            el.setText("");
            this.settingsFile.getRootElement().addContent(el);
        }
        if (null == this.settingsFile.getRootElement().getChild(SETTING_REOPEN_FILES)) {
            Element el = new Element(SETTING_REOPEN_FILES);
            this.settingsFile.getRootElement().addContent(el);
        }
        if (null == this.settingsFile.getRootElement().getChild(SETTING_MAINFONT)) {
            Element el = new Element(SETTING_MAINFONT);
            this.settingsFile.getRootElement().addContent(el);
            el.setText(font);
            el.setAttribute("size", "11");
        }
        if (null == this.settingsFile.getRootElement().getChild(SETTING_LAST_USED_PATH)) {
            Element el = new Element(SETTING_LAST_USED_PATH);
            el.setText("");
            this.settingsFile.getRootElement().addContent(el);
        }
        if (null == this.settingsFile.getRootElement().getChild(SETTING_CHECKUPDATES)) {
            Element el = new Element(SETTING_CHECKUPDATES);
            el.setText("1");
            this.settingsFile.getRootElement().addContent(el);
        }
        if (null == this.settingsFile.getRootElement().getChild(SETTING_REOPEN_FILES_ON_STARTUP)) {
            Element el = new Element(SETTING_REOPEN_FILES_ON_STARTUP);
            el.setText("1");
            this.settingsFile.getRootElement().addContent(el);
        }
        if (null == this.settingsFile.getRootElement().getChild(SETTING_SAVEONCOMPILE)) {
            Element el = new Element(SETTING_SAVEONCOMPILE);
            el.setText("1");
            this.settingsFile.getRootElement().addContent(el);
        }
        if (null == this.settingsFile.getRootElement().getChild(SETTING_PREF_COMP)) {
            Element el = new Element(SETTING_PREF_COMP);
            el.setText(String.valueOf(0));
            this.settingsFile.getRootElement().addContent(el);
        }
        if (null == this.settingsFile.getRootElement().getChild(SETTING_SYNTAX_SCHEME)) {
            Element el = new Element(SETTING_SYNTAX_SCHEME);
            el.setText(String.valueOf(0));
            this.settingsFile.getRootElement().addContent(el);
        }
        if (null == this.settingsFile.getRootElement().getChild(SETTING_LAST_SCRIPT)) {
            Element el = new Element(SETTING_LAST_SCRIPT);
            el.setText("0");
            this.settingsFile.getRootElement().addContent(el);
        }
        if (null == this.settingsFile.getRootElement().getChild(SETTING_LOGSPLITLAYOUT)) {
            Element el = new Element(SETTING_LOGSPLITLAYOUT);
            el.setText(String.valueOf(1));
            this.settingsFile.getRootElement().addContent(el);
        }
        if (null == this.settingsFile.getRootElement().getChild(SETTING_BOTHLOGRUNSPLITLAYOUT)) {
            Element el = new Element(SETTING_BOTHLOGRUNSPLITLAYOUT);
            el.setText(String.valueOf(0));
            this.settingsFile.getRootElement().addContent(el);
        }
        if (null == this.settingsFile.getRootElement().getChild(SETTING_TABWIDTH)) {
            Element el = new Element(SETTING_TABWIDTH);
            el.setText("4");
            this.settingsFile.getRootElement().addContent(el);
        }
        if (null == this.settingsFile.getRootElement().getChild(SETTING_LINE_NUMBER_ALIGNMENT)) {
            Element el = new Element(SETTING_LINE_NUMBER_ALIGNMENT);
            el.setText(String.valueOf(1.0f));
            this.settingsFile.getRootElement().addContent(el);
        }
    }

    public File getRecentDoc(int nr) {
        String retval;
        if (nr < 0) {
            return null;
        }
        Element el = this.settingsFile.getRootElement().getChild(SETTING_RECENT_DOC + String.valueOf(nr));
        if (el != null && !(retval = el.getText()).isEmpty()) {
            return new File(retval);
        }
        return null;
    }

    public int findRecentDoc(File f) {
        if (null == f) {
            return -1;
        }
        for (int i = 0; i < 10; ++i) {
            File rf = this.getRecentDoc(i);
            if (rf == null || !f.equals(rf)) continue;
            return i;
        }
        return -1;
    }

    public int getRecentDocCompiler(int nr) {
        Attribute comp;
        if (nr < 0) {
            return 0;
        }
        Element el = this.settingsFile.getRootElement().getChild(SETTING_RECENT_DOC + String.valueOf(nr));
        if (el != null && (comp = el.getAttribute("compiler")) != null) {
            try {
                return Integer.parseInt(comp.getValue());
            }
            catch (NumberFormatException ex) {
                return 0;
            }
        }
        return 0;
    }

    public int getRecentDocScript(int nr) {
        Attribute comp;
        if (nr < 0) {
            return 0;
        }
        Element el = this.settingsFile.getRootElement().getChild(SETTING_RECENT_DOC + String.valueOf(nr));
        if (el != null && (comp = el.getAttribute("script")) != null) {
            try {
                return Integer.parseInt(comp.getValue());
            }
            catch (NumberFormatException ex) {
                return 0;
            }
        }
        return 0;
    }

    public int findRecentDoc(String doc) {
        if (null == doc || doc.isEmpty()) {
            return -1;
        }
        for (int cnt = 1; cnt <= 10; ++cnt) {
            if (!this.getRecentDoc(cnt).getPath().equals(doc)) continue;
            return cnt;
        }
        return -1;
    }

    private String getRecentDocAsString(int nr) {
        File rd = this.getRecentDoc(nr);
        if (rd != null) {
            return rd.toString();
        }
        return null;
    }

    public void addToRecentDocs(String fp, int compiler, int userScript) {
        int cnt;
        if (null == fp || fp.isEmpty()) {
            return;
        }
        File dummy = new File(fp);
        if (!dummy.exists()) {
            return;
        }
        LinkedList<String> recdocs = new LinkedList<String>();
        LinkedList<Integer> reccomps = new LinkedList<Integer>();
        LinkedList<Integer> recscripts = new LinkedList<Integer>();
        recdocs.add(fp);
        reccomps.add(compiler);
        recscripts.add(userScript);
        for (cnt = 1; cnt <= 10; ++cnt) {
            String recentDoc = this.getRecentDocAsString(cnt);
            int comp = this.getRecentDocCompiler(cnt);
            int script = this.getRecentDocScript(cnt);
            if (recentDoc == null || recentDoc.isEmpty() || !(dummy = new File(recentDoc)).exists() || recdocs.contains(recentDoc)) continue;
            reccomps.add(comp);
            recscripts.add(script);
            recdocs.add(recentDoc);
        }
        for (cnt = 1; cnt <= 10; ++cnt) {
            if (recdocs.size() >= cnt) {
                this.setRecentDoc(cnt, (String)recdocs.get(cnt - 1), (Integer)reccomps.get(cnt - 1), (Integer)recscripts.get(cnt - 1));
                continue;
            }
            this.setRecentDoc(cnt, "", -1, -1);
        }
    }

    public void setRecentDoc(int nr, String fp, int compiler, int userScript) {
        if (null == fp || -1 == nr) {
            return;
        }
        Element el = this.settingsFile.getRootElement().getChild(SETTING_RECENT_DOC + String.valueOf(nr));
        if (null == el) {
            el = new Element(SETTING_RECENT_DOC + String.valueOf(nr));
            this.settingsFile.getRootElement().addContent(el);
        }
        el.setText(fp);
        el.setAttribute("compiler", String.valueOf(compiler));
        el.setAttribute("script", String.valueOf(userScript));
    }

    public File getLastUsedPath() {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_LAST_USED_PATH);
        File value = null;
        if (el != null) {
            value = new File(el.getText());
        }
        return value;
    }

    public void setLastUsedPath(File f) {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_LAST_USED_PATH);
        if (null == el) {
            el = new Element(SETTING_LAST_USED_PATH);
            this.settingsFile.getRootElement().addContent(el);
        }
        el.setText(f.getAbsolutePath());
    }

    public int getPreferredCompiler() {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_PREF_COMP);
        try {
            if (el != null) {
                return Integer.parseInt(el.getText());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    public void setPreferredCompiler(int compiler) {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_PREF_COMP);
        if (null == el) {
            el = new Element(SETTING_PREF_COMP);
            this.settingsFile.getRootElement().addContent(el);
        }
        el.setText(String.valueOf(compiler));
    }

    public int getSyntaxScheme() {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_SYNTAX_SCHEME);
        try {
            if (el != null) {
                return Integer.parseInt(el.getText());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    public void setSyntaxScheme(int scheme) {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_SYNTAX_SCHEME);
        if (null == el) {
            el = new Element(SETTING_SYNTAX_SCHEME);
            this.settingsFile.getRootElement().addContent(el);
        }
        el.setText(String.valueOf(scheme));
    }

    public boolean getCheckForUpdates() {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_CHECKUPDATES);
        if (el != null) {
            return el.getText().equals("1");
        }
        return true;
    }

    public void setCheckForUpdates(boolean val) {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_CHECKUPDATES);
        if (null == el) {
            el = new Element(SETTING_CHECKUPDATES);
            this.settingsFile.getRootElement().addContent(el);
        }
        el.setText(val == Boolean.TRUE ? "1" : "0");
    }

    public boolean getSaveOnCompile() {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_SAVEONCOMPILE);
        if (el != null) {
            return el.getText().equals("1");
        }
        return true;
    }

    public void setSaveOnCompile(boolean val) {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_SAVEONCOMPILE);
        if (null == el) {
            el = new Element(SETTING_SAVEONCOMPILE);
            this.settingsFile.getRootElement().addContent(el);
        }
        el.setText(val == Boolean.TRUE ? "1" : "0");
    }

    public boolean getReopenOnStartup() {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_REOPEN_FILES_ON_STARTUP);
        if (el != null) {
            return el.getText().equals("1");
        }
        return true;
    }

    public void setReopenOnStartup(boolean val) {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_REOPEN_FILES_ON_STARTUP);
        if (null == el) {
            el = new Element(SETTING_REOPEN_FILES_ON_STARTUP);
            this.settingsFile.getRootElement().addContent(el);
        }
        el.setText(val == Boolean.TRUE ? "1" : "0");
    }

    public int getTabWidth() {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_TABWIDTH);
        if (el != null) {
            try {
                return Integer.parseInt(el.getText());
            }
            catch (NumberFormatException ex) {
                return 4;
            }
        }
        return 4;
    }

    public void setTabWidth(int tabwidth) {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_TABWIDTH);
        if (null == el) {
            el = new Element(SETTING_TABWIDTH);
            this.settingsFile.getRootElement().addContent(el);
        }
        el.setText(String.valueOf(tabwidth));
    }

    public int getLastUserScript() {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_LAST_SCRIPT);
        try {
            if (el != null) {
                return Integer.parseInt(el.getText());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    public void setLastUserScript(int index) {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_LAST_SCRIPT);
        if (null == el) {
            el = new Element(SETTING_LAST_SCRIPT);
            this.settingsFile.getRootElement().addContent(el);
        }
        el.setText(String.valueOf(index));
    }

    public String getMainfont(int what) {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_MAINFONT);
        String retval = "";
        if (el != null) {
            switch (what) {
                case 1: {
                    retval = el.getText();
                    break;
                }
                case 2: {
                    retval = el.getAttributeValue("size");
                }
            }
        }
        return retval;
    }

    public Font getMainFont() {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_MAINFONT);
        int fsize = Integer.parseInt(el.getAttributeValue("size"));
        return new Font(el.getText(), 0, fsize);
    }

    public void setMainfont(Font f) {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_MAINFONT);
        if (null == el) {
            el = new Element(SETTING_MAINFONT);
            this.settingsFile.getRootElement().addContent(el);
        }
        el.setText(f.getName());
        el.setAttribute("size", String.valueOf(f.getSize()));
    }

    public int getSearchFrameSplitLayout(int splitpane) {
        String splitname = SETTING_LOGSPLITLAYOUT;
        switch (splitpane) {
            case 1: {
                splitname = SETTING_LOGSPLITLAYOUT;
                break;
            }
            case 3: {
                splitname = SETTING_BOTHLOGRUNSPLITLAYOUT;
            }
        }
        Element el = this.settingsFile.getRootElement().getChild(splitname);
        if (el != null) {
            try {
                return Integer.parseInt(el.getText());
            }
            catch (NumberFormatException e) {
                return 1;
            }
        }
        return 1;
    }

    public void setSearchFrameSplitLayout(int val, int splitpane) {
        String splitname = SETTING_LOGSPLITLAYOUT;
        switch (splitpane) {
            case 1: {
                splitname = SETTING_LOGSPLITLAYOUT;
                break;
            }
            case 3: {
                splitname = SETTING_BOTHLOGRUNSPLITLAYOUT;
            }
        }
        Element el = this.settingsFile.getRootElement().getChild(splitname);
        if (null == el) {
            el = new Element(splitname);
            this.settingsFile.getRootElement().addContent(el);
        }
        el.setText(String.valueOf(val));
    }

    public float getLineNumerAlignment() {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_LINE_NUMBER_ALIGNMENT);
        if (el != null) {
            try {
                return Float.parseFloat(el.getText());
            }
            catch (NumberFormatException ex) {
                return 1.0f;
            }
        }
        return 1.0f;
    }

    public void setLineNumerAlignment(float align) {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_LINE_NUMBER_ALIGNMENT);
        if (null == el) {
            el = new Element(SETTING_LINE_NUMBER_ALIGNMENT);
            this.settingsFile.getRootElement().addContent(el);
        }
        el.setText(String.valueOf(align));
    }

    public ArrayList<Object[]> getReopenFiles() {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_REOPEN_FILES);
        if (null == el) {
            return null;
        }
        ArrayList<Object[]> rofiles = new ArrayList<Object[]>();
        List<Element> children = el.getChildren();
        for (Element e : children) {
            File f = new File(e.getText());
            if (!f.exists()) continue;
            String attr_c = e.getAttributeValue("compiler");
            String attr_s = e.getAttributeValue("script");
            int compiler = 0;
            int script = -1;
            try {
                if (attr_c != null) {
                    compiler = Integer.parseInt(attr_c);
                }
                if (attr_s != null) {
                    script = Integer.parseInt(attr_s);
                }
            }
            catch (NumberFormatException ex) {
                compiler = 0;
                script = -1;
            }
            rofiles.add(new Object[]{f, compiler, script});
        }
        return rofiles;
    }

    public void setReopenFiles(EditorPanes ep) {
        Element el = this.settingsFile.getRootElement().getChild(SETTING_REOPEN_FILES);
        if (null == el) {
            el = new Element(SETTING_REOPEN_FILES);
            this.settingsFile.getRootElement().addContent(el);
        }
        el.removeContent();
        for (int i = 0; i < ep.getCount(); ++i) {
            File fp = ep.getFilePath(i);
            int c = ep.getCompiler(i);
            int s = ep.getScript(i);
            if (fp == null || !fp.exists()) continue;
            Element child = new Element(SETTING_REOPEN_FILES_CHILD);
            child.setText(fp.getAbsolutePath());
            child.setAttribute("compiler", String.valueOf(c));
            child.setAttribute("script", String.valueOf(s));
            el.addContent(child);
        }
    }
}

