!to "tf64-docs.prg",cbm
!cpu 6510

!src "../static.asm"
; ______________________________________________ DEFINES
; ____________ STATIC NUMBERS
line0                 = $f9
line1                 = $3d

zp1                   = $05
zp2                   = zp1+2

enable                = $ea
disable               = $60
; ____________ RAM ADRESSES
vidmem0               = $0400
charset               = $2800

music_init            = $1000
music_play            = $1003

freqtbl               = music_init+($079a-$7e)
; ______________________________________________ INCLUDES
*= music_init
  !bin "rinderschokolade.sid",,$7e

  !fi $100-(<*), 0          ; page align with zero-fill
ntsc_freqtbl:
  !bin "rinderntsc.sid",$bb,$079a
ntsc_freqtbl_end:

*= charset-$100
framecounter:
  !byte $00

joystick:
  !byte $00

joystick_prev:
  !byte $00

shift:
  !byte $00

pagenum:
  !byte $00

pagenum_dec:
  !byte $00

pagemax:
  !byte $08

pagemax_dec:
  !byte $08

pages_lo:
  !byte <page00, <page01, <page02, <page03
  !byte <page04, <page05, <page06, <page07
  !byte <page08

pages_hi:
  !byte >page00, >page01, >page02, >page03
  !byte >page04, >page05, >page06, >page07
  !byte >page08

*= charset
  !bin "nintendo-font.chr"
docstext:
  !src "docstext.asm"
; ______________________________________________ CODE START
*= $0810
start:
  cld
  sei
  lda #$7f
  sta $dc0d
  sta $dd0d

  lda $dc0d
  lda $dd0d

  lda #$0b
  sta $d011

  lda #$35
  sta $01

  lda #<fake_nmi
  sta $fffa
  lda #>fake_nmi
  sta $fffb

  jsr ntsc_check

  jsr vic_init

  lda #$00
  jsr music_init

  lda #$01
  sta $d01a

  lda #<irq0
  sta $fffe
  lda #>irq0
  sta $ffff

  lda #line0
  sta $d012

  lda #$1b
  sta $d011

  asl $d019
  cli
; ______________________________________________ MAINLOOP
mainloop:
  jsr next_page
  jsr prev_page
  jsr print_page
  jmp mainloop
; ______________________________________________ IRQs
; ____________ IRQ0
irq0:
  sta savea
  stx savex
  sty savey

  ldx #$08
-
  dex
  bne -

  lda #light_grey
  sta $d020
  sta $d021

ntsc_mplay =*+1
  jsr music_play

  inc framecounter

  lda #<irq1
  sta $fffe
  lda #>irq1
  sta $ffff

  lda #line1
  sta $d012

endirq:
  asl $d019
  lda savea
  ldx savex
  ldy savey
fake_nmi:
  rti
; ____________ IRQ1
irq1:
  sta savea
  stx savex
  sty savey

  ldx #$08
-
  dex
  bne -

  lda #black
  sta $d020
  sta $d021

  jsr display_pagenum
  jsr joy_get
  jsr key_get
  jsr joy_input

  lda #<irq0
  sta $fffe
  lda #>irq0
  sta $ffff

  lda #line0
  sta $d012

  jmp endirq
; ______________________________________________ VIC INIT
vic_init:
  lda #$1a
  sta $d018

  lda #light_grey
  ldx #0
-
  sta $d800+$000,x
  sta $d800+$100,x
  sta $d800+$200,x
  sta $d800+$2e8,x
  inx
  bne -

  lda #$20
-
  sta vidmem0+$000,x
  sta vidmem0+$100,x
  sta vidmem0+$200,x
  sta vidmem0+$2e8,x
  inx
  bne -

  ldx #$27
-
  lda docstext,x
  sta vidmem0,x
  lda #black
  sta $d800,x
  dex
  bpl -
  rts
; ______________________________________________ PRINT LINE
print_line:
  ldy #$27
-
  lda (zp1),y
  sta (zp2),y
  dey
  bpl -
  rts
; ______________________________________________ PRINT PAGE
print_page:
  nop

  ldx pagenum
  lda pages_lo,x
  sta zp1
  lda pages_hi,x
  sta zp1+1

  lda #<(vidmem0+80)
  sta zp2
  lda #>(vidmem0+80)
  sta zp2+1

  ldx #$00
-
  jsr print_line

  clc
  lda zp1
  adc #40
  sta zp1
  lda zp1+1
  adc #0
  sta zp1+1

  clc
  lda zp2
  adc #40
  sta zp2
  lda zp2+1
  adc #0
  sta zp2+1

  inx
  cpx #22
  bne -

  lda #disable
  sta print_page
  rts
; ______________________________________________ DISPLAY PAGENUM
display_pagenum:
  lda pagenum_dec
  and #$0f
  ora #$30
  sta vidmem0+35

  lda pagenum_dec
  and #$f0
  lsr
  lsr
  lsr
  lsr
  ora #$30
  sta vidmem0+34

  lda pagemax_dec
  and #$0f
  ora #$30
  sta vidmem0+38

  lda pagemax_dec
  and #$f0
  lsr
  lsr
  lsr
  lsr
  ora #$30
  sta vidmem0+37
  rts
; ______________________________________________ JOY GET
joy_get:

  lda #$00                  ; set data direction for joystick
  sta $dc03                 ; PORT B : INPUT

  lda #$00                  ; set data direction for joystick
  sta $dc02                 ; PORT A : INPUT

  lda #$1f
  sta $dc00

  lda $dc00
  and #$1f
  eor #$1f
  sta joystick

  rts
; ______________________________________________ KEY GET
key_get:
  lda #$00                  ; set data direction for keyboard
  sta $dc03                 ; PORT B : INPUT

  lda #$ff                  ; set data direction for keyboard
  sta $dc02                 ; PORT A : OUTPUT

  lda #$00
  sta shift

  lda #%10111111
  sta $dc00

  lda $dc01
  and #%00010000
  bne +
  lda #$0f
  sta shift
+

  lda #%11111101
  sta $dc00

  lda $dc01
  and #%10000000
  bne +
  lda #$0f
  sta shift
+
  lda #%11111110
  sta $dc00

  lda $dc01
  and #%00000100
  beq .crsr_l_r

  lda #%11111110
  sta $dc00

  lda $dc01
  and #%10000000
  beq .crsr_u_d

  lda #%01111111
  sta $dc00

  lda $dc01
  and #%00010000
  bne +
  lda #$10
  sta joystick
+
  rts

.crsr_l_r
.crsr_u_d
  lda #%00001010
  eor shift
  sta joystick
  rts

; ______________________________________________ JOY INPUT
joy_input:
.debounce =*+1
  lda #0
  beq +
  dec .debounce
  rts
+
  lda joystick
  and #%00001010
  beq +
  lda #enable
  sta next_page
  jmp ++
+
  lda joystick
  and #%00000101
  beq +
  lda #enable
  sta prev_page
  jmp ++
+
  lda joystick
  and #$10
  beq +
  sei
  lda #$37
  sta $01
  lda #0                    ; if AR/RR present
  sta $de00                 ; reset will lead to menu
  jmp $fce2
+
  rts
++
  lda #$1f
  sta .debounce
  rts
; ______________________________________________ NEXT PAGE
next_page:
  rts

  lda pagenum
  cmp pagemax
  beq +

  inc pagenum
  sed
  clc
  lda pagenum_dec
  adc #$01
  sta pagenum_dec
  cld

  lda #enable
  sta print_page
+
  lda #disable
  sta next_page
  rts
; ______________________________________________ PREV. PAGE
prev_page:
  rts

  lda pagenum
  beq +

  dec pagenum
  sed
  sec
  lda pagenum_dec
  sbc #$01
  sta pagenum_dec
  cld

  lda #enable
  sta print_page
+
  lda #disable
  sta prev_page
  rts
; ______________________________________________________________________
!zone NTSC_PAL
; ______________________________________________ NTSC/PAL CHECK
ntsc_check:
--
  lda $d012                 ; simple pal/ntsc check
-
  cmp $d012
  beq -
  bmi --
  cmp #$37                  ; leaves $37 in a if on pal
  bne +
  rts
+
  lda #<ntsc_music          ; if on NTSC:
  sta ntsc_mplay
  lda #>ntsc_music
  sta ntsc_mplay+1          ; change music play routine

  ldx #0
-
  lda ntsc_freqtbl,x        ; copy note frequency table
  sta freqtbl,x
  inx
  cpx # <(ntsc_freqtbl_end-ntsc_freqtbl)
  bne -

  rts
; ______________________________________________ NTSC MUSIC CALL
ntsc_music:
  lda #$05
  beq +
  jsr music_play
  dec ntsc_music+1
  rts
+
  lda #$05
  sta ntsc_music+1
  rts
