!to "intro.prg",cbm
!cpu 6510

!src "../static.asm"
; ______________________________________________ DEFINES
DEBUG                 = 0
; ____________ STATIC NUMBERS
line0                 = $b9
line1                 = $3a

enable                = $20
disable               = $2c

scrollspeed           = $02
; ____________ RAM ADRESSES
vidmem0               = $2800
vidmem1               = $2c00
charset               = $2000

music_data            = $3000
; ______________________________________________ INCLUDES
; ____________ GFX DATA
*= charset
  !bin "chars.raw"
tiles:
  !bin "tiles.raw"
attribs:
  !bin "attribs.raw"
map:
  !bin "map.raw"

  !fi $100-(<*), 0          ; page align with zero-fill
sprites:
  !bin "../tuttisprites.bin",$80,(4*$40)
; ____________ MUSIC DATA
*= music_data
  !bin "tf64-kaputt.mus",,2

  !fi $100-(<*), 0          ; page align with zero-fill
music_driver:
  !src "../nt2play.asm"

  !fi $100-(<*), 0          ; page align with zero-fill
; ____________ SCROLLTEXT
scrolltext:
; !scr "          1         2         3
; !scr "0123456789012345678901234567890123456789"
  !scr "          For 30 long years ...         "
  !scr "            C16/Plus4 users             "
  !scr "       are still hearing this tune      "
  !scr "         in their nightmares ...        "
  !scr "         Now he's coming to C64:        "
  !scr "         The King of the Orchard        "
  !scr "            SUPER STRAWBERRY!      ",$a0,"    "
  !scr "            Brought to you by:          "
  !scr "       Spider Jerusalem for MAYDAY!     "
  !scr "         Hit 'FIRE' to start game.      "
  !byte $00
; ______________________________________________ BASIC START
!macro basic_line .n {
  !ifdef .n {
  !if .n < 10000 { !byte $0c
  } else { !byte $0d }
  !byte $08, $00, $00, $9e, $20
  !if .n > 9999 { !byte $30+.n/10000 }
  !byte $30+.n/1000%10, $30+.n/100%10, $30+.n/10%10, $30+.n%10
  !byte $00, $00, $00 }
  }
!ifndef RELEASE {
*= $0801
  +basic_line start
  }
; ______________________________________________ CODE START
*= $0810
start:
  cld
  sei
  lda #$7f
  sta $dc0d
  sta $dd0d

  lda $dc0d
  lda $dd0d

  lda #$35
  sta $01

  lda #$0b
  sta $d011

  lda #<fake_nmi
  sta $fffa
  lda #>fake_nmi
  sta $fffb

  jsr ntsc_check

  jsr init_music
  jsr init_vic

  lda #$01
  sta $d01a

  lda #<irq0
  sta $fffe
  lda #>irq0
  sta $ffff

  lda #line0
  sta $d012

  asl $d019
  cli
; ______________________________________________ MAINLOOP
mainloop:

enable_mainloop =*+1
  lda #0
  beq mainloop

  lda #0
  sta enable_mainloop

  !if DEBUG = 1 { inc $d020 }

enable_hardscroll_a:
  bit hardscroll_a

enable_hardscroll_b:
  bit hardscroll_b

enable_hardscroll:
  bit hardscroll_newdata

  !if DEBUG = 1 { dec $d020 }

  jmp mainloop
; ______________________________________________ IRQs
; ____________ IRQ0
irq0:
  sta savea
  stx savex
  sty savey

  lda #$08
  sta $d016

  ldx #$06
-
  dex
  bne -

  lda #$a6
  sta $d018

  lda #pink
  sta $d020
  sta $d021

  !if DEBUG = 1 { dec $d020 }
enable_music:
ntsc_mplay =*+1
  bit nt_music
  jsr scroller
  !if DEBUG = 1 { inc $d020 }

  lda #$1b
  sta $d011

  lda #line1
  sta $d012

  lda #<irq1
  sta $fffe
  lda #>irq1
  sta $ffff

endirq:
  asl $d019
  lda savea
  ldx savex
  ldy savey
fake_nmi:
  rti
; ____________ IRQ1
irq1:
  sta savea
  stx savex
  sty savey

  lda #$10
  ora scrollbyte
  sta $d016

  lda d018_val
  sta $d018

  ldx #$05
-
  dex
  bne -
colchange =*+1
  lda #pink
  sta $d020
  sta $d021

  inc framecounter

  jsr sprite_anim
  jsr moving_text

  jsr check_partstart

  jsr joy_check

  lda #line0
  sta $d012

  lda #<irq0
  sta $fffe
  lda #>irq0
  sta $ffff

  jmp endirq
; ______________________________________________ INIT MUSIC
init_music:
  lda #<music_data
  ldx #>music_data
  jsr nt_newmusic
  lda #0
  jsr nt_playsong
  rts
; ______________________________________________ INIT VIC
init_vic:
  lda #$a8
  sta d018_val
  sta $d018

  lda #$18
  sta $d016

  lda #pink
  sta $d020
  sta $d021

  lda #red
  sta $d022

  lda #pink
  sta $d023

  lda #$00
  tax
-
  sta $d800+$000,x
  sta $d800+$100,x
  sta $d800+$200,x
  sta $d800+$2e8,x
  inx
  bne -

  lda #pink
  sta $d800+(19*40)+35

  lda #$20
-
  sta vidmem0+$2a8,x
  sta vidmem0+$2e8,x
  inx
  bne -
-
  sta vidmem0,x
  inx
  cpx #$28
  bne -

  lda #$98
  sta vidmem0+$3f8

  lda #$d8
  sta $d001
  lda #$98
  sta $d000

  lda #green
  sta $d027

  lda #red
  sta $d025

  lda #white
  sta $d026

  lda #$01
  sta $d01c
  sta $d017
  sta $d01d

  lda #$00
  sta $d015
  rts
; ______________________________________________ HARDSCROLL NEWDATA
hardscroll_newdata:

  lda #disable
  sta enable_hardscroll

start_scroll:
  rts

  !for j, 0, 38 {
  !for i, 0, 16 {
  lda $d800+(i*40)+1+j
  sta $d800+(i*40)+j
  }
  }

  lda d018_val
  eor #$10
  sta d018_val

  inc halfcounter

  lda halfcounter
  and #$01
  beq ++
  jsr second_half
  inc mapindex
  lda mapindex
  cmp #128
  bne +
  lda #0
  sta mapindex
+
  rts
++
  jsr first_half
  rts
first_half:
  ldx mapindex
  lda map+(0*128),x
  tax
  tay
  lda attribs,x
  sta $d800+(((0*2)+1)*40)+39
  tya
  asl
  asl
  tax
  lda tiles+3,x
  sta vidmem1+(((0*2)+1)*40)+39
  !for i, 1, 7 {
  ldx mapindex
  lda map+(i*128),x
  tax
  tay
  lda attribs,x
  sta $d800+((i*2)*40)+39
  sta $d800+(((i*2)+1)*40)+39
  tya
  asl
  asl
  tax
  lda tiles,x
  sta vidmem1+((i*2)*40)+39
  lda tiles+2,x
  sta vidmem1+(((i*2)+1)*40)+39
  }
  ldx mapindex
  lda map+(8*128),x
  tax
  tay
  lda attribs,x
  sta $d800+((8*2)*40)+39
  tya
  asl
  asl
  tax
  lda tiles,x
  sta vidmem1+((8*2)*40)+39
  rts
second_half:
  ldx mapindex
  lda map+(0*128),x
  tax
  tay
  lda attribs,x
  sta $d800+(((0*2)+1)*40)+39
  tya
  asl
  asl
  tax
  lda tiles+3,x
  sta vidmem0+(((0*2)+1)*40)+39
  !for i, 1, 7 {
  ldx mapindex
  lda map+(i*128),x
  tax
  tay
  lda attribs,x
  sta $d800+((i*2)*40)+39
  sta $d800+(((i*2)+1)*40)+39
  tya
  asl
  asl
  tax
  lda tiles+1,x
  sta vidmem0+((i*2)*40)+39
  lda tiles+3,x
  sta vidmem0+(((i*2)+1)*40)+39
  }
  ldx mapindex
  lda map+(8*128),x
  tax
  tay
  lda attribs,x
  sta $d800+((8*2)*40)+39
  tya
  asl
  asl
  tax
  lda tiles,x
  sta vidmem0+((8*2)*40)+39
  rts
mapindex:
  !byte $00
halfcounter:
  !byte $ff
d018_val:
  !byte $00
; ______________________________________________ HARDSCROLL A
hardscroll_a:
  lda #disable
  sta enable_hardscroll_a

  ldx #0
-
  !for i, 1, 16 {
  lda vidmem0+(i*40)+1,x
  sta vidmem1+(i*40),x
  }
  inx
  cpx #39
  bne -
  rts
; ______________________________________________ HARDSCROLL B
hardscroll_b:
  lda #disable
  sta enable_hardscroll_b

  ldx #0
-
  !for i, 1, 16 {
  lda vidmem1+(i*40)+1,x
  sta vidmem0+(i*40),x
  }
  inx
  cpx #39
  bne -
  rts
; ______________________________________________ SCROLLER
scroller:
  sec
  lda scrollbyte
  sbc #scrollspeed
  sta scrollbyte
  bcs +
  lda #$07
  sta scrollbyte
  lda #enable
  sta enable_hardscroll
  lda #1
  sta enable_mainloop
  rts
+
  lda scrollbyte
  cmp #($07-scrollspeed)
  beq +
  rts
+
  lda #1
  sta enable_mainloop
  lda halfcounter
  and #$01
  beq +
  lda #enable
  sta enable_hardscroll_a
  rts
+
  lda #enable
  sta enable_hardscroll_b
  rts

scrollbyte:
  !byte $07
; ______________________________________________ SPRITE ANIM
sprite_anim:
  lda framecounter
  and #$0f
  cmp #$08
  bne +
  lda vidmem0+$3f8
  eor #$01
  sta vidmem0+$3f8
+
  rts
framecounter:
  !byte $00
; ______________________________________________ MOVING TEXT
moving_text:

enable_clean_line:
  bit clean_line

  lda framecounter
  and #$03
  cmp #$03
  beq +
  rts
+
  ldx text_x
text_pt =*+1
  lda scrolltext,x
  bne +
  lda #<scrolltext
  sta text_pt
  lda #>scrolltext
  sta text_pt+1
  rts
+
  sta vidmem0+(19*40),x
  inx
  stx text_x

  lda text_x
  cmp #40
  bne +

  lda #enable
  sta enable_clean_line

  lda #0
  sta text_x
  clc
  lda text_pt
  adc #40
  sta text_pt
  lda text_pt+1
  adc #0
  sta text_pt+1
+
  rts
text_x:
  !byte $00
; ______________________________________________ CLEAN LINE
clean_line:
  lda #disable
  sta enable_clean_line

  lda #$20
  ldx #$27
-
  sta vidmem0+(19*40),x
  dex
  bpl -
  rts
; ______________________________________________ CHECK PART START
check_partstart:
  nop
  lda vidmem0+(19*40)+31
  cmp #'.'
  bne +
  lda #enable
  sta enable_music
+
  lda vidmem0+(19*40)+35
  cmp #$a0
  bne +
  lda #$01
  sta $d015

  lda #purple
  sta colchange

  lda #$ea
  sta start_scroll
  lda #$60
  sta check_partstart
+
  rts
; ______________________________________________ JOY CHECK
joy_check:
  lda $dc00
  and #$10
  beq exit
  lda $dc01
  and #$10
  beq exit
  rts
exit:
  sei
  asl $d019
  lda #$00
  sta $d01a

  lda #$0b
  sta $d011

  lda #$00
  sta $d015
  sta $d418

  lda #$81
  sta $dc0d

  lda $dc0d

  lda #$37
  sta $01
  cli
!ifndef RELEASE {
  jmp $fce2
  } else {
  jmp $3a00 }
; ______________________________________________________________________
!zone NTSC_PAL
; ______________________________________________ NTSC/PAL CHECK
ntsc_check:
--
  lda $d012                 ; simple pal/ntsc check
-
  cmp $d012
  beq -
  bmi --
  cmp #$37                  ; leaves $37 in a if on pal
  bne +
  rts
+
  lda #<ntsc_music          ; if on NTSC:
  sta ntsc_mplay
  lda #>ntsc_music
  sta ntsc_mplay+1          ; change music play routine

  ldx #0
-
  lda nt_ntsc_freqtbl,x     ; copy note frequency table
  sta nt_freqtbl,x
  inx
  cpx # <(nt_ntsc_freqtbl_end-nt_ntsc_freqtbl)
  bne -

  rts
; ______________________________________________ NTSC MUSIC CALL
ntsc_music:
  lda #$05
  beq +
  jsr nt_music
  dec ntsc_music+1
  rts
+
  lda #$05
  sta ntsc_music+1
  rts
