; used ACME, release 0.95.4 ("Fenchurch"), 26 Nov 2014
!to "tuttifrutti64.prg",cbm
!cpu 6510

!src "static.asm"           ; C64 color table and static ZP adresses
                            ; to save/restore A,X & Y in IRQ
; ______________________________________________ DEFINES
; if DEBUG is 1 a few $d020 changes + ZP registers
; will be displayed on screen
; $d020 green : IRQ, $d020 yellow : mainloop
DEBUG                 = 0
; ____________ STATIC NUMBERS
line0                 = $f0
line1                 = $32
line2                 = $62
line3                 = $92
line4                 = $c2

enable                = $20 ; OPCODE 'JSR'
disable               = $2c ; OPCODE 'BIT'

color_digits          = green
color_letters         = yellow
color_bg              = black
color_msg             = cyan
color_title           = yellow
color_panelborder     = red
color_1strow          = blue

enemy_base_x          = $80
enemy_base_y          = $91

player_panel_x        = $20
player_panel_y        = $79

shot_base_char        = $2c

eorvalue              = >(vidmem0 XOR $d800)

load_adress           = scoreboard
file_start            = scoreboard
file_end              = scoreboard_end
; ____________ ZEROPAGE ADRESSES
zp_start              = $05

joystick              = zp_start              ; temp joy register
screen_pt             = joystick+1
global_ct_lo          = screen_pt+2
global_ct_hi          = global_ct_lo+1
zp_temp_01            = global_ct_hi+1
zp_temp_02            = zp_temp_01+2
zp_temp_03            = zp_temp_02+2
temp_x                = zp_temp_03+2
temp_y                = temp_x+1
slshowindex           = temp_y+1

; unlike the original code which calculated the progressive
; player positions multiple times when needed those are only
; calculated once when player is aligned and permanently stored
; into ZP registers player_x0 and player_y0
player_x              = slshowindex+1         ; continous player X pos.
player_y              = player_x+1            ; continous player Y pos.
player_x0             = player_y+1            ; progressive player X pos.
player_y0             = player_x0+1           ; progressive player Y pos.
player_dir            = player_y0+1           ; player direction
player_shoot_dir      = player_dir+1          ; same as player_dir but
                                              ; without a possible 'no dir'
                                              ; ($ff) value

enemy_x               = player_shoot_dir+1    ; continous enemy X pos.
enemy_y               = enemy_x+5             ; continous enemy Y pos.
enemy_dir             = enemy_y+5             ; enemy direction
enemy_queue           = enemy_dir+5           ; enemy queue
                                              ; for enemies not on screen

apple_delaytab        = enemy_queue+5
apple_x               = apple_delaytab+8
apple_y               = apple_x+8
apple_dir             = apple_y+8
apple_addval_x        = apple_dir+8
apple_addval_y        = apple_addval_x+8

apple_temptabx        = apple_addval_y+8
apple_temptaby        = apple_temptabx+8
apple_replot_tab      = apple_temptaby+8
apple_flag            = apple_replot_tab+8
apple_flag_save       = apple_flag+1
char_add              = apple_flag_save+1
apple_ground_flag     = char_add+1

current_map           = apple_ground_flag+1
maptype               = current_map+1
gametype              = maptype+1

rnd_ct                = gametype+1

gamespeed             = rnd_ct+3
gamespeed_add         = gamespeed+1

frame_counter         = gamespeed_add+1

cherrycounter         = frame_counter+1
level_done            = cherrycounter+1

sfx_num               = level_done+1
nt_zpbase             = sfx_num+1

deathflag             = nt_zpbase+2

bonus_skip            = deathflag+1
seconds               = bonus_skip+1

shot_state            = seconds+1
shot_x                = shot_state+1
shot_y                = shot_x+1
shot_addval_x         = shot_y+1
shot_addval_y         = shot_addval_x+1
shot_back             = shot_addval_y+1

topscore_pos          = shot_back+1
topscore_temp         = topscore_pos+1

way_free_sav01        = topscore_temp+1
way_free_sav02        = way_free_sav01+1
kill_tilex            = way_free_sav02+2
kill_tiley            = kill_tilex+1
kill_tile_flag        = kill_tiley+1
difficulty            = kill_tile_flag+1
queue_flag            = difficulty+1
bg_col                = queue_flag+1

record_ct1            = bg_col+1
record_ct2            = record_ct1+1
record_ct3            = record_ct2+1
rec_pt_lo             = record_ct3+1
rec_pt_hi             = rec_pt_lo+1

spriteset_flag        = rec_pt_hi+1
autoplay_flag         = spriteset_flag+1

zp_last               = autoplay_flag+1
; ____________ RAM ADRESSES
music_data            = $0900
music_init            = nt_newmusic
music_play            = nt_music
music_sfx             = nt_playsfx

vicbank               = $4000
charset               = vicbank+$0000
vidmem0               = vicbank+$0800
sprite_data           = vicbank+$0c00
sprite_base           = <((sprite_data-vicbank)/$40)

autoplay_data         = $5540

vidmem_save           = $0400
colram_save           = vidmem_save+(3*8)
map_layout            = colram_save+(3*8)
map_layout_y00        = map_layout+(0*16)
map_layout_y01        = map_layout+(1*16)
map_layout_y02        = map_layout+(2*16)
map_layout_y03        = map_layout+(3*16)
map_layout_y04        = map_layout+(4*16)
map_layout_y05        = map_layout+(5*16)
map_layout_y06        = map_layout+(6*16)
map_layout_y07        = map_layout+(7*16)
map_layout_y08        = map_layout+(8*16)
map_layout_y09        = map_layout+(9*16)
map_layout_y10        = map_layout+(10*16)
map_layout_y11        = map_layout+(11*16)

temp_screenpos_lo     = map_layout+(12*16)
temp_screenpos_hi     = temp_screenpos_lo+$30
charbuffer            = temp_screenpos_hi+$30
temp_colram           = charbuffer+$30
save_screenpos_lo     = temp_colram+$30
save_screenpos_hi     = save_screenpos_lo+$30
; ______________________________________________ INCLUDES
; ____________ GFX DATA
*= charset
  !bin "tuttichar_neu.chr"

*= sprite_data+$300
  !bin "tuttisprites.bin",,$300
sprites_original:
  !bin "tuttisprites.bin",$300
sprites_alternative:
  !bin "tuttisprites_alt.bin",$300

*= autoplay_data
  !src "autoplaydata.asm"

; ____________ MUSIC & SFX DATA
*= music_data
  !bin "tf64.mus",,2

  !fi $100-(<*), 0          ; page align with zero-fill
music_driver:
  !src "nt2play.asm"

  !fi $100-(<*), 0          ; page align with zero-fill
sound_effects:
  !src "sfx.asm"

; ____________ GAMEDATA TABLES
  !fi $100-(<*), 0          ; page align with zero-fill
  !src "tables.asm"

  !fi $100-(<*), 0          ; page align with zero-fill
code_start:
; ______________________________________________ BASIC START
!macro basic_line .n {
  !ifdef .n {
  !if .n < 10000 { !byte $0c
  } else { !byte $0d }
  !byte $08, $00, $00, $9e, $20
  !if .n > 9999 { !byte $30+.n/10000 }
  !byte $30+.n/1000%10, $30+.n/100%10, $30+.n/10%10, $30+.n%10
  !byte $00, $00, $00 }
  }
!ifndef RELEASE {
*= $0801
  +basic_line code_start
  }
; ______________________________________________ INIT
*= code_start
init:
  cld                       ; YES!!! :-)
  jsr highscore_load        ; load highscore file if available

  sei
begin:
  lda #$7f
  sta $dc0d                 ; disable CIA IRQs
  sta $dd0d

  lda $dc0d                 ; ack CIA IRQs
  lda $dd0d

  lda #$35                  ; memcfg
  sta $01                   ; RAM - RAM - I/O - RAM

  lda #$0b
  sta $d011                 ; blank screen for no flick0rz on init

  lda #<fake_nmi            ; disable RESTORE key
  sta $fffa
  lda #>fake_nmi
  sta $fffb

  jsr ntsc_check            ; run NTSC/PAL check

  jsr init_vic

  lda #$00                  ; init ZP
  ldx #zp_last
-
  sta $00,x
  dex
  cpx #$01
  bne -

  lda #color_bg
  sta bg_col

  lda #$ea                  ; enable topscore save if it was disabled
  sta topscore_save         ; by using trainer
  sta player_life_dec       ; deactivate trainer
  sta bonus_counter
  sta joy_playback          ; re-enable joy playback for demomode

  lda #$40                  ; setup pointer for the demomode data
  sta rec_pt_lo
  lda #$55
  sta rec_pt_hi

  lda #<music_data          ; setup music
  ldx #>music_data
  jsr nt_newmusic

  lda #0
  jsr nt_playsong

  jsr setup_screen          ; setup the screen

  lda #$01
  sta $d01a                 ; set RASTER as IRQ source

  lda #<irq0
  ldx #>irq0                ; irq lo/hi byte in A/X
  ldy #line0                ; irq rasterline in Y
  jsr init_irq              ; subroutine init IRQ

  lda #$1b
  sta $d011                 ; enable screen display

  asl $d019                 ; ack VIC IRQ
  cli
  !if DEBUG=1 { inc $d020 }
; ______________________________________________________________________
!zone MAINLOOPs
; ______________________________________________ MAINLOOP INTRO
mainloop_intro:
  jsr slide_show            ; slide show of title screen / level maps

  !if DEBUG=1 { dec $d020 }

  jsr wait                  ; wait for IRQ

  !if DEBUG=1 { inc $d020 }

  lda #disable              ; disable panel display
  sta enable_panel          ; has to run only once in intro part

enable_spritechange:
  jsr spritedata_change
enable_topscore_reset:
  bit topscore_reset

  lda global_ct_hi
.andval =*+1
  and #$04                  ; check global counter hi
  beq ++                    ; if andval not reached -> skip
  lda #$00                  ; else:
  sta global_ct_hi          ; reset global counter hi

  clc
  lda slshowindex
  adc #$08                  ; increase slideshow index
  sta slshowindex
  cmp #(8*8)                ; last 'picture'?
  bne +                     ; no -> skip
  lda #0                    ; else: reset slideshow index
  sta slshowindex
  lda #$04                  ; .andval = #$04
  sta .andval
+
  cmp #(2*8)
  bne +
  lda #$02                  ; .andval = #$02 if not last picure
  sta .andval               ; (title is shown longer than maps)
+
  ldx slshowindex           ; X = slide show index
  lda #$20                  ; load opcode JSR
  sta slide_show,x          ; store in the slide_show routine
++
  bit joystick
  bmi +                     ; joy fire not pressed -> loop
                            ; else:
  lda #$04                  ; .andval = #$04
  sta .andval
  lda global_ct_lo          ; init the rnd counters according to
  sta rnd_ct                ; when the player did hit the fire
  adc #$02                  ; button
  sta rnd_ct+1              ; don't know if this makes any sense
  adc #$02
  sta rnd_ct+2
  jmp prep_mainloop_ready   ; prepare the ready loop

+
  jmp mainloop_intro
; ______________________________________________ PREPARE READY LOOP
prep_mainloop_ready:
  !if DEBUG=1 { dec $d020 }

  sei
  lda #$00
  sta $d418                 ; turn down volume
  sta global_ct_hi          ; reset global counter
  sta global_ct_lo
  lda #$01
  sta $d015

  lda #2                    ; subtune 2 (READY jingle)
  jsr nt_playsong           ; init music

  ldx current_map
  lda #enable
  sta map_show,x
  !if DEBUG=1 { stx vidmem0+$3e5 }
  jsr map_show              ; show the map

  jsr ready_message         ; show the READY message

  jsr copy_maplayout        ; copy the map layout to temp table

  jsr game_display_disable

  lda #enable
  sta enable_panel

enable_init_game:
  jsr init_game
  lda #disable
  sta *-5

  asl $d019
  cli
; ______________________________________________ MAINLOOP READY
mainloop_ready:
  jsr wait

  !if DEBUG=1 { inc $d020 }

  lda global_ct_hi          ; check global counter for
  cmp #$01                  ; READY-jingle to be finished
  bne +
  lda global_ct_lo
  cmp #$fc
  bcc +
  jmp prep_mainloop_ingame  ; if jingle finished -> prepare ingame loop
+
  !if DEBUG=1 { dec $d020 }

  jmp mainloop_ready
; ______________________________________________ PREPARE INGAME LOOP
prep_mainloop_ingame:
  !if DEBUG=1 { dec $d020 }

  sei
  lda #$00
  sta $d418                 ; turn down volume
  sta global_ct_hi          ; reset global counter
  sta global_ct_lo

  lda #1                    ; subtune 1 (ingame music)
  jsr nt_playsong           ; init music
  lda #$08
  sta sfx_num

  jsr restore_screen        ; restore colram/vidmem below ready msg.

  jsr game_display_enable
  jsr gametype_check

enable_init_level:
  bit init_level_start
  lda #enable
  sta *-5

  asl $d019
  cli
; ______________________________________________ MAINLOOP INGAME
mainloop_ingame:
  jsr wait                  ; wait for IRQ to be finished

  !if DEBUG=1 { inc $d020 }
; ____________ EXECUTED EVERY FRAME
enable_death:
  bit prepare_mainloop_death
                            ; jump to death mainloop if player dies

; ____________ EXECUTED EVERY 2nd FRAME
  lda frame_counter
  and #$01
  bne +
  jsr player_move           ; move player
  jsr update_maplayout      ; update maplayout
+
; ____________ EXECUTED EVERY FRAME
enable_chest_check:
  bit chest_move_manager
; ____________ EXECUTED CONTROLLED BY GAMESPEED
  lda gamespeed
  clc
  adc gamespeed_add
  sta gamespeed
  bcc +
  jsr enemy_manager         ; call enemy manager
  jsr bonus_counter         ; call bonus counter routine
+
; ____________ EXECUTED EVERY FRAME
  jsr timer

enable_cherrywatch:
  bit cherrywatch           ; call cherry watch routine

  jsr apple_savetab

enable_applewatch:
  jsr applewatch            ; check if tile below apple is erased

enable_apple_move:
  jsr apple_move            ; apple fall routines
  jsr anim_apples_cherries  ; precalculate char animations

enable_apple_y_check:
  bit apple_y_check         ; check for apples on ground level exit
                            ; on gametype 1

enable_secret_exit:
  bit chest_secret_exit     ; check for 'secret' exit in gametype 2

  jsr start_sfx_plaback     ; start sfx playback

  jsr enemy_hit             ; enemy hit detection
  jsr player_hit            ; player hit detection
  jsr player_death          ; check if player should die

  lda level_done            ; check if level is done
  beq +                     ; no -> skip
-
  jsr next_level
  jmp prep_mainloop_next_level
                            ; prepare the next level loop
+
  !if DEBUG=1 { dec $d020 }
  jmp mainloop_ingame
; ______________________________________________ PREP MAINLOOP DEATH
prepare_mainloop_death:
  !if DEBUG=1 { dec $d020 }

  sei
  lda #$00
  sta $d418
  sta global_ct_hi          ; reset global counter
  sta global_ct_lo

  lda #4                    ; subtune 4 (DEATH jingle)
  jsr nt_playsong           ; init music

  jsr game_display_disable

  jsr player_life_dec

  lda shot_state
  beq +
  jsr shot_erase
+
  asl $d019
  cli
; ______________________________________________ MAINLOOP DEATH
; plays player death jingle
; jumps to gameover when all lives are gone
; jumps to ingame again when lives are left
mainloop_death:
  jsr wait
  !if DEBUG=1 { inc $d020 }

  lda global_ct_hi          ; check global counter for
  cmp #$01                  ; DEATH-jingle to be finished
  bne ++
  lda global_ct_lo
  cmp #$fc
  bcc ++
  lda lives
  cmp #$1c
  bne +
  jmp game_over
+
  jmp prep_mainloop_ingame0 ; if jingle finished -> prepare ingame loop
++
  !if DEBUG=1 { dec $d020 }
  jmp mainloop_death
; ______________________________________________ PREP. MAINLOOP NEXT L.
; setups all needed values for next level mainloop
prep_mainloop_next_level:
  !if DEBUG=1 { dec $d020 }

  sei
  lda #$00
  sta $d418                 ; turn down volume
  sta global_ct_hi          ; reset global counter
  sta global_ct_lo

  lda #3                    ; subtune 3 (LEVEL DONE jingle)
  jsr nt_playsong           ; init music

  lda #disable
  sta enable_sprites
  sta enable_chars
  sta enable_shot

  asl $d019
  cli
; ______________________________________________ MAINLOOP NEXT LEVEL
; waits for 'level done' jingle to be finished
mainloop_next_level:
  jsr wait
  !if DEBUG=1 { inc $d020 }
  lda global_ct_hi          ; check global counter for
  cmp #$01                  ; NEXTLEVEL-jingle to be finished
  bne +
  lda global_ct_lo
  cmp #$fc
  bcc +
  jmp prep_mainloop_ready
+
  !if DEBUG=1 { dec $d020 }
  jmp mainloop_next_level
; ______________________________________________ PREPARE INGAME LOOP
; setups all needed values for ingame mainloop after player death
prep_mainloop_ingame0:
  !if DEBUG=1 { dec $d020 }

  sei
  lda #$00
  sta $d418                 ; turn down volume
  sta global_ct_hi          ; reset global counter
  sta global_ct_lo

  lda #1                    ; subtune 1 (ingame music)
  jsr nt_playsong           ; init music
  lda #$08
  sta sfx_num

  jsr update_screen_death

  jsr game_display_enable
  jsr gametype_check
  jsr init_level_death

  asl $d019
  cli
  jmp mainloop_ingame
; ______________________________________________ GAME OVER
game_over:
  !if DEBUG=1 { dec $d020 }
  sei
  lda #$00
  sta $d418
  sta global_ct_hi          ; reset global counter
  sta global_ct_lo

  lda #5                    ; subtune 5 (GAMEOVER jingle)
  jsr nt_playsong           ; init music

  lda #enable
  sta enable_init_game
  lda #disable
  sta enable_init_level

  asl $d019
  cli
; _______________ GAME OVER MESSAGE
gameover_msg:
  ldx #$0f
-
  lda gameover_text,x
  sta vidmem0+$148,x
  lda #$00
  sta vidmem0+$120,x
  sta vidmem0+$170,x
  lda #color_msg
  sta $d948,x
  sta $d920,x
  sta $d970,x
  dex
  bpl -

  lda #$01
  sta $d015

  lda lives
  sta vidmem0+(10*40)+38

-
  lda global_ct_hi          ; check global counter for
  cmp #$02                  ; GAMEOVER-jingle to be finished
  bne -
  lda global_ct_lo
  cmp #$fc
  bcc -

  sei
  lda #$00
  sta $d418                 ; mute sound
  lda #$20
  sta slide_show            ; reset slideshow

  jsr topscore_save
  jmp begin
; ______________________________________________ NEXT LEVEL
next_level:
  jsr score_bonus_add
  jsr score_level_points

  clc
  lda current_map
  adc #$08
  cmp #(6*8)
  bne +
  lda #0
+
  sta current_map

  inc difficulty            ; inc difficulty
  lda difficulty
  cmp #$10                  ; difficulty < #$10
  bcc +                     ; if yes -> skip
  lda #$0f                  ; else: highest difficulty
+
  tax
  lda queue_difficulty,x    ; load from queue difficulty table
  sta queue_flag            ; store in queue_flag
  lda game_speed_tab,x      ; load from game speed table
  sta gamespeed_add         ; store in game speed add value

  inc gametype
  lda gametype
  cmp #$03
  bne +
  lda #$00
  sta gametype
+

  inc maptype
  lda maptype
  cmp #$06
  bne +
  lda #$00
  sta maptype
+
  lda level+1
  cmp #$1c+9
  beq +
  inc level+1
  rts
+
  lda #$1c+0
  sta level+1
  inc level

  lda level
  cmp #$1c+10
  bne +
  lda #$1c+0
  sta level
+
  rts
; ______________________________________________ WAIT FOR IRQ
; if irq is ready it sets wait_irq = 1
wait:
wait_irq =*+1
-
  lda #0
  beq -                     ; wait for irq to set wait_irq = 1

  lda #0
  sta wait_irq              ; reset wait_irq to 0
  rts
; ______________________________________________ EN-/DISABLE GAME DISPLAY
; enables and disables routines in the mainloop & irq
; that are needed in all gametypes
game_display_enable:
  lda #enable
  !byte $2c
game_display_disable:
  lda #disable
  sta enable_sprites        ; en-/disable sprites
  sta enable_chars          ; en-/disable chars
  sta enable_apple_write    ; en-/disable apple routines
  sta enable_apple_erase
  sta enable_apple_replot
  sta enable_topscore       ; en-/disable topscore sort routine

  sta enable_shot           ; shot is a special case, as it runs in the
                            ; irq only. gametype check will disable it
                            ; again on gametype 2
  rts
; ______________________________________________ GAMETYPE CHECK
; enables and disables routines in the mainloop & irq
; that are needed / not needed for the current gametype
gametype_check:
  lda gametype
  cmp #$02
  bne +
  lda #disable              ; disable shot, and falling apple routines
  sta enable_shot           ; in gametype 2
  sta enable_applewatch
  sta enable_apple_move
  lda #enable               ; enable chest moving, tile fade and
  sta enable_chest_check    ; special level exit (apple tile in each
  sta enable_kill_tile      ; playfield corner)
  sta enable_secret_exit
  rts
+
  cmp #$01
  bne +
  lda #enable               ; enable special level exit for gametype 1
  sta enable_apple_y_check  ; (all apples on ground + all cherries)
  jmp ++
+
  lda #disable
  sta enable_apple_y_check
++
  lda #disable
  sta enable_chest_check    ; disable chest moving, tile fade and special
  sta enable_kill_tile      ; level exit for gametypes 0+1
  sta enable_secret_exit
  lda #enable
  sta enable_applewatch     ; enable falling apples and shot for
  sta enable_apple_move     ; gametypes 0+1

; sta enable_shot           ; shot is a special case, as it runs in the
                            ; irq only. it is en-/disabled by the
                            ; general routines above
  lda #$13
  sta replotval
  rts
; ______________________________________________________________________
!zone INIT_ROUTINES
; ______________________________________________ INIT IRQ
; parameters: |
; ------------+------------------------
;        A    | IRQ lowbyte
; ------------+------------------------
;        X    | IRQ highbyte
; ------------+------------------------
;        Y    | rasterline
init_irq:
  sta $fffe
  stx $ffff
  sty $d012
  rts
; ______________________________________________ INIT VIC
init_vic:
  lda #color_bg             ; set screen colors
  sta $d020
  lda #black
  sta $d021

  lda $dd00                 ; set vicbank
  and #$fc
  ora #<!(vicbank/$4000) & 3
  sta $dd00

  lda # <(((vidmem0-vicbank)/$400) << 4)+ <(((charset-vicbank)/$800) << 1)
  sta $d018                 ; and screen/charset in $d018

  lda #$18
  sta $d016                 ; multicolor mode

sprites_init:
  ldx #$07
-
  lda #green                ; all sprites get color green
  sta $d027,x
  lda #$00                  ; all x/y coords = #$00
  sta $d000,x
  sta $d008,x
  dex
  bpl -

  lda #enemy_base_x         ; position of the enemy base
  sta $d000+2
  lda #enemy_base_y
  sta $d001+2

  lda #player_panel_x
  sta $d000
  lda #player_panel_y
  sta $d001

  lda #red                  ; sprite multicolor colors
  sta $d025
  lda #white
  sta $d026

  lda #$00
  sta $d017                 ; no y expansion
  sta $d01d                 ; no x expansion

  lda #$01
  sta $d015                 ; don't show sprites yet
  sta $d010                 ; reset x pos. msb

  lda #$ff
  sta $d01c                 ; all sprites multicolor
  lda #$80
  sta $d01b


  lda #sprite_base+4
  sta vidmem0+$3f8
  rts
; ______________________________________________ PLAY SFX
; parameters: |
; ------------+------------------------
;        A    | -
; ------------+------------------------
;        X    | -
; ------------+------------------------
;        Y    | sound number
play_sfx:
  lda sfx_table_hi,y
  tax
  lda sfx_table_lo,y
  ldy #14                   ; SID voice 3 (see nt2play.asm)
  jsr music_sfx
  rts
; ______________________________________________ START SFX PLAYBACK
; parameters: |
; ------------+------------------------
;        A    | -
; ------------+------------------------
;        X    | -
; ------------+------------------------
;        Y    | sound number
start_sfx_plaback:
  ldy sfx_num               ; load sfx_num in Y
  beq +                     ; #$00 means: no sfx to be played -> RETURN
  jsr play_sfx              ; else: subroutine play_sfx
  lda #$00
  sta sfx_num               ; reset sfx_num
+
  rts
; ______________________________________________________________________
!zone IRQs
; ______________________________________________ IRQ0
irq0:
  sta savea
  stx savex
  sty savey
  !if DEBUG=1 { dec $d020 }

  jsr joy_get               ; joystick input routine

  jsr joy_playback

enable_panel:
  jsr panel_display         ; panel display (score, bonus, lives...)

enable_chars:
  bit chars_display         ; display chars / update screen

enable_sprites:
  bit sprite_display        ; display sprites

enable_shot:
  bit shot_manager          ; call shot manager

enable_apple_erase:
  bit apple_erase           ; softsprite erase routine

enable_apple_write:
  bit apple_write           ; softsprite write routine

enable_apple_replot:
  bit apple_replot          ; replot an item from map in screen

enable_topscore:
  bit topscore              ; topscore sorter routine

enable_kill_tile:
  bit kill_tile             ; this is for tile fade in gametype 2

enable_sprites_intro:
  bit sprites_intro         ; this is for the sprites in the title screen

  lda bg_col
  sta $d020

  !if DEBUG=1 {
  ldx #$0f+8
-
  lda apple_delaytab,x
  sta vidmem0+(24*40),x
  dex
  bpl -
  }

enable_music:
ntsc_mplay =*+1
  jsr music_play            ; play music

  jsr keyboard              ; check keyboard
; ____________ GLOBAL COUNTERs
  clc
  lda global_ct_lo
  adc #$06
  sta global_ct_lo
  bne +
  inc global_ct_hi
+
  inc frame_counter

  lda #line1
  sta $d012

  lda #<d023_irq            ; setup the $d023 change IRQ
  sta $fffe
  lda #>d023_irq
  sta $ffff

  lda #$01
  sta wait_irq
endirq:
  ;!if DEBUG=1 { inc $d020 }
  asl $d019

  lda savea
  ldx savex
  ldy savey

  rti
; ______________________________________________ d023 IRQ
; this IRQ changes the $d023 multicolor
d023_irq:
  sta savea
  stx savex
  sty savey

  ldx #$03                  ; delay
-
  dex
  bne -

  nop
  bit $ea

.irqnum =*+1
  ldx #0

  lda d023_tab,x            ; load value from $d023 table
  sta $d023                 ; write to $d023

  lda d012_tab,x            ; load next IRQ rasterline from $d012 table
  sta $d012

  inx
  cpx #$04                  ; this IRQ runs 4 times per frame
  bne +

  lda #<irq0                ; then the main IRQ is set up again
  sta $fffe
  lda #>irq0
  sta $ffff

  ldx #$00
+
  stx .irqnum

  jmp endirq
; ______________________________________________ FAKE NMI
; restarts the programm if RESTORE key pressed
fake_nmi:
  sei
  lda #$00
  sta $d418                 ; mute sound
  lda #$20
  sta slide_show            ; reset slideshow

  jsr game_display_disable

  lda #enable
  sta enable_init_game
  lda #disable
  sta enable_init_level

  ldx #0
  txs                       ; reset stack pointer
  jmp begin
; ______________________________________________________________________
!zone INPUT
; ______________________________________________ JOYSTICK
joy_get:
  lda autoplay_flag
  beq ++
  lda $dc00                 ; if autoplay is running
  and #$10                  ; fire button will
  bne +
  jmp fake_nmi              ; reset the program
+
  rts
++
  nop
  lda $dc00                 ; mimics the original joystick routine
  and #$10
  bne +
  lda #$00
  !byte $2c
+
  lda #$80                  ; sets bit 7 in 'joystick' if button pressed
  sta .or_value

  lda $dc00
  and #$0f
.or_value =*+1
  ora #0
  eor #$0f                  ; eor the low nibble to get
                            ; direction ~ bit set
  sta joystick

  !if DEBUG=1 { sta vidmem0+$3e7 }

  rts
; ______________________________________________ KEYBOARD
keyboard:
.debounce =*+1
  lda #0
  beq +
  dec .debounce
  rts
+
  lda #$00                  ; set data direction for keyboard
  sta $dc03                 ; PORT B : INPUT
  lda #$ff
  sta $dc02                 ; PORT A : OUTPUT

  lda #%01110111            ; check keyboard for
  sta $dc00                 ; C= + B

  lda $dc01
  and #%00110000
  sta $dc01
  bne +

  lda bonus_counter         ; enable bonus counter cheat
  eor #$8a
  sta bonus_counter

  lda #$60                  ; disable topscores
  sta topscore_save

  lda vidmem0+(24*40)+36    ; show 'B' on screen for bonus cheat
  eor #(166 XOR 194)
  sta vidmem0+(24*40)+36

  lda #$10
  sta .debounce

+
  lda #%01111011            ; check keyboard for
  sta $dc00                 ; C= + C

  lda $dc01
  and #%00110000
  sta $dc01
  bne +

  lda #enable
  sta enable_spritechange

  lda #$10
  sta .debounce

+
  lda #%01011111            ; check keyboard for
  sta $dc00                 ; C= + L

  lda $dc01
  and #%00100100
  sta $dc01
  bne +

  lda player_life_dec       ; enable life-cheat
  eor #$8a
  sta player_life_dec

  lda #$60                  ; disable topscores
  sta topscore_save

  lda vidmem0+(24*40)+34    ; show 'L' on screen for life cheat
  eor #(166 XOR 195)
  sta vidmem0+(24*40)+34

  lda #$10
  sta .debounce

+
  lda #%01111011            ; check keyboard for
  sta $dc00                 ; C= + R

  lda $dc01
  and #%00100010
  sta $dc01
  bne +

  lda #enable
  sta enable_topscore_reset

  lda #$10
  sta .debounce

+
  lda #%01111011            ; check keyboard for
  sta $dc00                 ; C= + X

  lda $dc01
  and #%10100000
  sta $dc01
  bne +
                            ; if key combination is pressed:
  sei                       ; reset C64
  lda #$37
  sta $01
  lda #0                    ; if AR/RR present
  sta $de00                 ; reset will lead to menu
  jmp $fce2
+
  lda #$00                  ; set data direction for joystick
  sta $dc02                 ; PORT A : INPUT
  lda #$1f                  ; set bits 0-5 in $dc00
  sta $dc00                 ; to get correct values for joystick
  rts
; ______________________________________________________________________
!zone SCREEN_KRAM
; ______________________________________________ SETUP SCREEN
; initial screen setup
setup_screen:
  ldx #$00
  lda #$00
-
  sta $d800,x
  sta $d900,x
  sta $da00,x
  sta $dae8,x
  inx
  bne -

  ldx #$05
-
  lda text_panel+(00*6),x
  sta vidmem0+$22,x
  lda text_panel+(01*6),x
  sta vidmem0+$9a,x
  lda text_panel+(02*6),x
  sta vidmem0+$112,x
  lda text_panel+(03*6),x
  sta vidmem0+$202,x
  lda text_panel+(04*6),x
  sta vidmem0+$27a,x
  lda text_panel+(05*6),x
  sta vidmem0+$2a2,x
  lda text_panel+(06*6),x
  sta vidmem0+$2ca,x
  lda text_panel+(07*6),x
  sta vidmem0+$2f2,x
  lda text_panel+(08*6),x
  sta vidmem0+$31a,x
  lda text_panel+(09*6),x
  sta vidmem0+$342,x
  lda text_panel+(10*6),x
  sta vidmem0+$36a,x
  lda text_panel+(11*6),x
  sta vidmem0+$392,x
  lda text_panel+(12*6),x
  sta vidmem0+$3ba,x
  lda #color_letters
  sta $d822,x
  sta $d89a,x
  sta $d912,x
  sta $da02,x
  sta $da7a,x
  lda #color_digits
  sta $d822+40,x
  sta $d89a+40,x
  sta $d912+40,x
  sta $da02+40,x
  sta $da7a+40,x
  sta $da7a+(2*40),x
  sta $da7a+(3*40),x
  sta $da7a+(4*40),x
  sta $da7a+(5*40),x
  sta $da7a+(6*40),x
  sta $da7a+(7*40),x
  sta $da7a+(8*40),x
  dex
  bmi +
  jmp -
+
  sta $d800+(10*40)+38
  ldx #$27
-
  lda #166
  sta vidmem0+$3c0,x
  lda #color_panelborder
  sta $dbc0,x
  dex
  bpl -

  ldx #$17
-
  lda screentab_lo,x
  sta screen_pt
  lda screentab_hi,x
  sta screen_pt+1
  ldy #$20
  lda #162
  sta (screen_pt),y
  iny
  lda #163
  sta (screen_pt),y
  lda screen_pt+1
  eor #eorvalue
  sta screen_pt+1
  ldy #$20
  lda #color_panelborder
  sta (screen_pt),y
  iny
  sta (screen_pt),y
  dex
  bne -

  sta $d800+(0*40)+$20
  sta $d800+(0*40)+$21

  ldx #160
  stx vidmem0+(0*40)+$20
  inx
  stx vidmem0+(0*40)+$21

  ldx #164
  stx vidmem0+(24*40)+$20
  inx
  stx vidmem0+(24*40)+$21

  ldx #167
  stx vidmem0+(24*40)+0
  inx
  stx vidmem0+(24*40)+39

  lda #white
  sta $d800+(10*40)+36
  rts
; ______________________________________________ PANEL DISPLAY
panel_display:
  ldx #$05
-
  lda score,x
  sta vidmem0+(1*40)+34,x
  lda time,x
  sta vidmem0+(4*40)+34,x
  dex
  bpl -

  ldx #$02
-
  lda bonus,x
  sta vidmem0+(7*40)+34,x
  dex
  bpl -

  lda lives
  sta vidmem0+(10*40)+38

  lda level
  sta vidmem0+(13*40)+34
  lda level+1
  sta vidmem0+(13*40)+35

  lda gametype
  cmp #$02                  ; check if gametype is 2
  beq +                     ; yes -> skip
  lda shot_state            ; else: load shot state
  bne +                     ; shot not available -> skip
  lda #shot_base_char+2     ; load shot char
  !byte $2c
+
  lda #$00                  ; or empty char
  sta vidmem0+(10*40)+36    ; display next to player in panel
  rts
; ______________________________________________ TITLE SCREEN
title_screen:
  lda #<gfx_title_fruit     ; load lo/hi of title screen fruit border
  sta zp_temp_01            ; store in pointer
  lda #>gfx_title_fruit
  sta zp_temp_01+1

  lda #red
  sta $d022
  lda #pink
  sta d023_tab
  sta d023_tab+1
  sta d023_tab+2
  sta d023_tab+3

  lda #green+8              ; multicolor green
  ldx #0
  jsr print_map             ; display as if it were a map

; from here almost the same as in the original code
; really don't care if it could be optimized
  ldx #$17
-
  lda text_title1,x
  sta vidmem0+$7c,x
  lda text_title1+(1*24),x
  sta vidmem0+$324,x
  lda text_title1+(2*24),x
  sta vidmem0+$cc,x
  lda text_title1+(3*24),x
  sta vidmem0+$20c,x
  lda text_title1+(4*24),x
  sta vidmem0+$2d4,x
  lda #color_title
  sta $d87c,x
  sta $db24,x
  sta $d8cc,x
  sta $da0c,x
  sta $dad4,x
  dex
  bpl -

  lda #enable
  sta enable_sprites_intro

  ldx #$0f
-
  lda text_title2+(0*16),x
  sta vidmem0+$144,x
  lda text_title2+(1*16),x
  sta vidmem0+$198,x
  lda text_title2+(2*16),x
  sta vidmem0+$1c0,x

  lda #color_title
  sta $d944,x
  sta $d998,x
  sta $d9c0,x
  lda #white+8
  sta $da60,x
  sta $da88,x
  dex
  bpl -
  lda #white+8
  sta $d998
  sta $d999
  sta $d9c0
  sta $d9c1
  rts
; ______________________________________________ CREDIT SCREEN
credit_screen:
  lda #disable
  sta enable_sprites_intro

  lda #$01
  sta $d015

  ldx #$17
-
  lda text_credits+(0*17),x
  sta vidmem0+(3*40)+4,x

  lda text_credits+(1*17)+1,x
  sta vidmem0+(5*40)+4,x

  lda text_credits+(2*$17),x
  sta vidmem0+(6*40)+4,x

  lda text_credits+(3*$17)+1,x
  sta vidmem0+(8*40)+4,x

  lda text_credits+(4*$18),x
  sta vidmem0+(9*40)+4,x

  lda text_credits+(6*$18),x
  sta vidmem0+(10*40)+4,x

  lda text_credits+(7*$18),x
  sta vidmem0+(11*40)+4,x

  lda text_credits+(8*$18),x
  sta vidmem0+(12*40)+4,x

  lda text_credits+(9*$18),x
  sta vidmem0+(13*40)+4,x

  lda text_credits+(10*$18),x
  sta vidmem0+(16*40)+4,x

  lda text_credits+(11*$18),x
  sta vidmem0+(17*40)+4,x

  lda text_credits+(12*$18),x
  sta vidmem0+(18*40)+4,x

  lda text_credits+(13*$18),x
  sta vidmem0+(19*40)+4,x

  lda text_credits+(14*$18),x
  sta vidmem0+(20*40)+4,x

  lda text_credits+(15*$18),x
  sta vidmem0+(15*40)+4,x

  lda #color_digits
  sta $d800+(6*40)+4,x
  sta $d800+(9*40)+4,x

  sta $d800+(11*40)+4,x
  sta $d800+(12*40)+4,x
  sta $d800+(13*40)+4,x

  lda #color_title
  sta $d800+(8*40)+4,x
  sta $d800+(10*40)+4,x

  lda #red
  sta $d800+(15*40)+4,x
  sta $d800+(16*40)+4,x
  sta $d800+(17*40)+4,x
  sta $d800+(18*40)+4,x
  sta $d800+(19*40)+4,x
  sta $d800+(20*40)+4,x

  dex
  bmi +
  jmp -
+

  rts
; ______________________________________________ SHOW MAP 01
show_map_01:
  lda #disable
  sta enable_sprites_intro

  lda #$01
  sta $d015

  lda #<map_01
  sta zp_temp_01
  lda #>map_01
  sta zp_temp_01+1

  lda #red
  sta $d022

  lda #light_green
  sta d023_tab

  lda #yellow
  sta d023_tab+1

  lda #orange
  sta d023_tab+2

  lda #brown
  sta d023_tab+3

  lda #green+8
  ldx #0
  jsr print_map
  rts
; ______________________________________________ SHOW MAP 02
show_map_02:
  lda #<map_02
  sta zp_temp_01
  lda #>map_02
  sta zp_temp_01+1

  lda #red
  sta $d022

  lda #light_grey
  sta d023_tab

  lda #grey
  sta d023_tab+1

  lda #light_blue
  sta d023_tab+2

  lda #purple
  sta d023_tab+3

  lda #green+8
  ldx #1
  jsr print_map

  rts
; ______________________________________________ SHOW MAP 03
show_map_03:
  lda #<map_03
  sta zp_temp_01
  lda #>map_03
  sta zp_temp_01+1

  lda #red
  sta $d022
  lda #pink
  sta d023_tab
  sta d023_tab+1
  sta d023_tab+2
  sta d023_tab+3

  lda #green+8
  ldx #0
  jsr print_map
  rts
; ______________________________________________ SHOW MAP 04
show_map_04:
  lda #<map_04
  sta zp_temp_01
  lda #>map_04
  sta zp_temp_01+1

  lda #red
  sta $d022

  lda #light_green
  sta d023_tab

  lda #yellow
  sta d023_tab+1

  lda #orange
  sta d023_tab+2

  lda #brown
  sta d023_tab+3

  lda #green+8
  ldx #0
  jsr print_map
  rts
; ______________________________________________ SHOW MAP 05
show_map_05:
  lda #<map_05
  sta zp_temp_01
  lda #>map_05
  sta zp_temp_01+1

  lda #red
  sta $d022

  lda #light_grey
  sta d023_tab

  lda #grey
  sta d023_tab+1

  lda #light_blue
  sta d023_tab+2

  lda #purple
  sta d023_tab+3

  lda #green+8
  ldx #1
  jsr print_map

  rts
; ______________________________________________ SHOW MAP 06
show_map_06:
  lda #<map_06
  sta zp_temp_01
  lda #>map_06
  sta zp_temp_01+1

  lda #red
  sta $d022
  lda #pink
  sta d023_tab
  sta d023_tab+1
  sta d023_tab+2
  sta d023_tab+3

  lda #green+8
  ldx #0
  jsr print_map
  rts
; ______________________________________________ PRINT MAP
; parameters: |
; ------------+------------------------
;        A    | map color
; ------------+------------------------
;        X    | map type 0 or 1 (for filled first line)
; ------------+------------------------
;        Y    |
print_map:
  sta .mapcolor
  stx .maptype

  lda screentab_lo          ; load from screen table
  sta screen_pt             ; store to pointer
  lda screentab_hi
  sta screen_pt+1

  ldx #11                   ; number of lines in X
--
  stx .savex                ; save X for next loop
  ldy #0                    ; column in Y
-
  lda (zp_temp_01),y        ; load tile number in A
.mapcolor =*+1
  ldx #0                    ; load map color in X
  sty .savey                ; save Y for next loop
  jsr print_tile            ; print a tile (destroys X/Y registers)

  clc
  lda screen_pt
  adc #$02                  ; add 2 to screen pointer (2x2 tiles)
  sta screen_pt
  bcc +
  inc screen_pt+1
+
.savey =*+1
  ldy #0
  iny
  cpy #16                   ; last column reached?
  bne -                     ; no -> small loop

  clc
  lda zp_temp_01            ; set map pointer to next line
  adc #16
  sta zp_temp_01
  bcc +
  inc zp_temp_01+1
  clc
+
  lda screen_pt             ; set screen pointer to next line (2x2 tiles)
  adc #48
  sta screen_pt
  bcc +
  inc screen_pt+1
+
.savex =*+1
  ldx #0
  dex
  bpl --                    ; last line reached? no -> big loop

.maptype =*+1
  lda #0                    ; load maptype
  bne +                     ; if 1 -> skip
  rts                       ; if 0 -> RETURN
+
  ldx #31
  lda #color_1strow+8       ; color first two screen lines
-                           ; for maps 02 and 05
  sta $d800,x
  sta $d828,x
  dex
  bpl -
  rts
; ______________________________________________ PRINT TILE
; print_tile
;             prints a 2x2 tile on the screen
;                       AB
;                       CD
;             tile number should be in a
;             tile color  should be in x
;             (screenpos) should be set correctly
print_tile:
  stx .tilecolor
                            ; calculate offset from tile definition
  asl                       ; a * 2
  asl                       ; a * 2
                            ; -----
                            ; a * 4
  tax

  ldy #$00

  lda tiles,x
  sta (screen_pt),y         ; print char A
  iny
  lda tiles+1,x
  sta (screen_pt),y         ; print char B

  ldy #$28

  lda tiles+2,x
  sta (screen_pt),y         ; print char C
  iny
  lda tiles+3,x
  sta (screen_pt),y         ; print char D

nocolor:
  nop                       ; will be RTS if colram update not needed

  lda screen_pt+1
  eor #eorvalue
  sta screen_pt+1

.tilecolor =*+1
  lda #$00
  ldy #$00
  sta (screen_pt),y
  iny
  sta (screen_pt),y
  ldy #$28
  sta (screen_pt),y
  iny
  sta (screen_pt),y

  lda screen_pt+1
  eor #eorvalue
  sta screen_pt+1
  rts
; ______________________________________________ SLIDE/MAP SHOW
slide_show:
  jsr title_screen
  lda #disable
  sta *-5
  bit credit_screen
  lda #disable
  sta *-5
map_show:
  bit show_map_01
  lda #disable
  sta *-5
  bit show_map_02
  lda #disable
  sta *-5
  bit show_map_03
  lda #disable
  sta *-5
  bit show_map_04
  lda #disable
  sta *-5
  bit show_map_05
  lda #disable
  sta *-5
  bit show_map_06
  lda #disable
  sta *-5
  rts
; ______________________________________________ READY MESSAGE
; saves the screen and colram data and displays READY message
ready_message:
  ldx #$07
-
  lda vidmem0+$124,x
  sta vidmem_save+(0*8),x
  lda vidmem0+$14c,x
  sta vidmem_save+(1*8),x
  lda vidmem0+$174,x
  sta vidmem_save+(2*8),x
  lda $d924,x
  sta colram_save+(0*8),x
  lda $d94c,x
  sta colram_save+(1*8),x
  lda $d974,x
  sta colram_save+(2*8),x
  lda #color_msg
  sta $d924,x
  sta $d94c,x
  sta $d974,x
  lda #$00
  sta vidmem0+$124,x
  sta vidmem0+$174,x
  lda ready_text,x
  sta vidmem0+$14c,x
  dex
  bpl -
  rts
; ______________________________________________ RESTORE SCREEN
; restores the screen and colram data after a READY message
restore_screen:
  ldx #$07
-
  lda vidmem_save+(0*8),x
  sta vidmem0+$124,x
  lda vidmem_save+(1*8),x
  sta vidmem0+$14c,x
  lda vidmem_save+(2*8),x
  sta vidmem0+$174,x
  lda colram_save+(0*8),x
  sta $d924,x
  lda colram_save+(1*8),x
  sta $d94c,x
  lda colram_save+(2*8),x
  sta $d974,x
  dex
  bpl -
  rts
; ______________________________________________ CHARS DISPLAY
chars_display:
  jsr erase_chars_below_player
  rts
; ______________________________________________ ERASE CHARS BELOW PLAYER
; checks for direction and then erases the chars below
; it uses the continous player X/Y positions to erase the chars
; already when the player approaches the progressive X/Y pos.
; this kind of 'simulates' the softsprite logic of the original
erase_chars_below_player:
  lda player_dir
  cmp #$ff
  bne +
  rts
+
  cmp #$03
  bne +
  jmp .erase_below
+
  cmp #$02
  bne +
  jmp .erase_above
+
  cmp #$01
  bne +
  jmp .erase_right
+
; ____________ IF PLAYER MOVES LEFT
.erase_left
  lda player_y
  lsr
  lsr
  lsr
  tay
  lda screen_erasetab_lo,y
  sta zp_temp_01
  lda screen_erasetab_hi,y
  sta zp_temp_01+1

  lda player_x
  lsr
  lsr
  tay
  lda #$00
  sta (zp_temp_01),y
  tya
  clc
  adc #$28
  tay
  lda #$00
  sta (zp_temp_01),y
  rts
; ____________ IF PLAYER MOVES RIGHT
.erase_right
  lda player_y
  lsr
  lsr
  lsr
  tay
  lda screen_erasetab_lo,y
  sta zp_temp_01
  lda screen_erasetab_hi,y
  sta zp_temp_01+1

  lda player_x
  lsr
  lsr
  tay
  iny
  iny
  lda #$00
  sta (zp_temp_01),y
  tya
  clc
  adc #$28
  tay
  lda #$00
  sta (zp_temp_01),y
  rts
; ____________ IF PLAYER MOVES DOWN
.erase_below
  lda player_y
  lsr
  lsr
  tay
  iny
  iny
  lda screentab_lo,y
  sta zp_temp_01
  lda screentab_hi,y
  sta zp_temp_01+1

  lda player_x
  lsr
  lsr
  tay
  lda #$00
  sta (zp_temp_01),y
  iny
  sta (zp_temp_01),y
  rts
; ____________ IF PLAYER MOVES UP
.erase_above
  lda player_y
  lsr
  lsr
  tay
  dey
  bpl +
  ldy #0
  sty .addval               ; workaround for lowest Y position
+
  lda screentab_lo,y
  sta zp_temp_01
  lda screentab_hi,y
  sta zp_temp_01+1

  lda player_x
  lsr
  lsr
  tay
  tya
  clc
.addval =*+1
  adc #$28
  tay
  lda #$00
  sta (zp_temp_01),y
  iny
  sta (zp_temp_01),y

  lda #$28
  sta .addval
  rts
; ______________________________________________________________________
!zone NTSC_PAL
; ______________________________________________ NTSC/PAL CHECK
ntsc_check:
--
  lda $d012                 ; simple pal/ntsc check
-
  cmp $d012
  beq -
  bmi --
  cmp #$37                  ; leaves $37 in a if on pal
  bne +
  rts
+
  lda #<ntsc_music          ; if on NTSC:
  sta ntsc_mplay
  lda #>ntsc_music
  sta ntsc_mplay+1          ; change music play routine

  ldx #0
-
  lda nt_ntsc_freqtbl,x     ; copy note frequency table
  sta nt_freqtbl,x
  inx
  cpx # <(nt_ntsc_freqtbl_end-nt_ntsc_freqtbl)
  bne -

  rts
; ______________________________________________ NTSC MUSIC CALL
ntsc_music:
  lda #$05
  beq +
  jsr music_play
  dec ntsc_music+1
  rts
+
  lda #$05
  sta ntsc_music+1
  rts
; ______________________________________________________________________
!zone SPRITES
; ______________________________________________ SPRITE DISPLAY
.xadd = $10
.yadd = $31
sprite_display:
; ____________ EXECUTED EVERY 4th FRAME
  lda frame_counter
  and #%00000011
  bne +
  jsr animate_sprites       ; animate sprites
+
; ____________ SPRITE POSTITIONS
  sec
  ror $d010
  clc
  ror $d010

  lda enemy_x+4
  asl
  clc
  adc #.xadd
  sta $d000+4
  ror $d010
  lda enemy_y+4
  asl
  clc
  adc #.yadd
  sta $d001+4

  lda enemy_x+3
  asl
  clc
  adc #.xadd
  sta $d000+6
  ror $d010
  lda enemy_y+3
  asl
  clc
  adc #.yadd
  sta $d001+6

  lda enemy_x+2
  asl
  clc
  adc #.xadd
  sta $d000+8
  ror $d010
  lda enemy_y+2
  asl
  clc
  adc #.yadd
  sta $d001+8

  lda enemy_x+1
  asl
  clc
  adc #.xadd
  sta $d000+10
  ror $d010
  lda enemy_y+1
  asl
  clc
  adc #.yadd
  sta $d001+10

  lda enemy_x+0
  asl
  clc
  adc #.xadd
  sta $d000+12
  ror $d010
  lda enemy_y+0
  asl
  clc
  adc #.yadd
  sta $d001+12

  lda player_x
  asl
  clc
  adc #.xadd
  sta $d000+14
  ror $d010
  lda player_y
  asl
  clc
  adc #.yadd
  sta $d001+14
; ____________ STORE POINTER
  lda #sprite_base+12
  sta vidmem0+$3f9

  lda actpointer+5
  sta vidmem0+$3fa

  lda actpointer+4
  sta vidmem0+$3fb

  lda actpointer+3
  sta vidmem0+$3fc

  lda actpointer+2
  sta vidmem0+$3fd

  lda actpointer+1
  sta vidmem0+$3fe

  lda actpointer
  sta vidmem0+$3ff

  inc $d028                 ; blink enemy base
; ____________ SHOW SPRITES
  sec
  ror $d015
  sec
  ror $d015
  ldx #$04
-
  lda enemy_dir,x
  and #$80
  eor #$80
  asl
  ror $d015
  dex
  bpl -
  sec
  ror $d015
  rts
; ______________________________________________ ANIMATE SPRITES
animate_sprites:
  inc pointerswitch
  jsr animate_player
  jsr animate_enemies
  rts
; ______________________________________________ ANIMATE PLAYER
animate_player:
  lda player_dir            ; load player direction
                            ; is the player moving?
  bpl +                     ; yes -> skip
  rts                       ; no -> RETURN
+
  asl                       ; player direction * 2
  sta zp_temp_01            ; store in temp register

  lda pointerswitch
  and #$01                  ; load bit 0 of pointerswitch
  clc
  adc zp_temp_01            ; add player_dir*2
  tax
  lda pointertable,x        ; load from pointertable
  sta actpointer            ; store in the actual pointer for this frame
  rts
; ______________________________________________ ANIMATE ENEMIES
animate_enemies:
  ldx #$04                  ; same as above for all enemies
-
  lda enemy_dir,x
  cmp #$ff
  beq +

  asl
  sta zp_temp_01

  lda pointerswitch
  and #$01
  clc
  adc zp_temp_01
  tay
  lda pointertable+8,y
  sta actpointer+1,x
+
  dex
  bpl -
  rts
; ______________________________________________ SPRITES INTRO
; sprite positions etc. for the title screen
sprites_intro:
  lda #sprite_base+4
  sta vidmem0+$3ff

  lda #sprite_base+4+6
  sta vidmem0+$3fa
  sta vidmem0+$3fb
  sta vidmem0+$3fc
  sta vidmem0+$3fd
  sta vidmem0+$3fe

  lda #$40+.xadd
  sta $d00e
  sta $d00c

  lda #$50+.yadd
  sta $d00f

  lda #$78+.yadd
  sta $d00d
  sta $d00d-(1*2)
  sta $d00d-(2*2)
  sta $d00d-(3*2)
  sta $d00d-(4*2)

  lda #$40+.xadd+(1*24)
  sta $d00c-(1*2)
  lda #$40+.xadd+(2*24)
  sta $d00c-(2*2)
  lda #$40+.xadd+(3*24)
  sta $d00c-(3*2)
  lda #$40+.xadd+(4*24)
  sta $d00c-(4*2)

  lda #$01
  sta $d010

  lda #$fd
  sta $d015

  rts
; ______________________________________________ CHANGE SPRITEDATA
; copies original or alternative spriteset to the sprite data memory
spritedata_change:
  lda #disable
  sta enable_spritechange

  lda spriteset_flag
  and #$01
  bne .altsprites
.orgsprites
  ldx #$00
-
  lda sprites_original+$000,x
  sta sprite_data+$000,x
  lda sprites_original+$100,x
  sta sprite_data+$100,x
  lda sprites_original+$200,x
  sta sprite_data+$200,x
  dex
  bne -

  inc spriteset_flag
  rts
.altsprites
  ldx #$00
-
  lda sprites_alternative+$000,x
  sta sprite_data+$000,x
  lda sprites_alternative+$100,x
  sta sprite_data+$100,x
  lda sprites_alternative+$200,x
  sta sprite_data+$200,x
  dex
  bne -

  inc spriteset_flag
  rts
; ______________________________________________________________________
!zone GAME_INIT
; ______________________________________________ GAME INIT
; init entry point if a whole new game is started
init_game:
; ____________ RESET SCORE
  ldx #$04
  lda #$1c
-
  sta score,x
  dex
  bpl -

  lda #$08
  sta topscore_pos
; ____________ RESET GAME SPEED
  lda #$00
  sta gamespeed
  lda #$78
  sta gamespeed_add

  lda #$00
  sta difficulty
; ____________ RESET LIVES
  lda autoplay_flag
  beq +
  lda #$1c+1                ; just one life on autoplay
  sta lives
  jmp ++
+
  lda #$60                  ; deactivate joy playback if no autoplay
  sta joy_playback
  lda #$1c+5                ; and five lives
  sta lives
++
; ____________ SET LEVEL NUMBER
  lda #$1c
  sta level
  lda #$1c+1
  sta level+1
; ____________ RESET TIME
  lda #$1c
  sta time
  sta time+1
  sta time+3
  sta time+4
; ______________________________________________ INIT LEVEL START
; init entry point if a new level is started
init_level_start:
; ____________
  ldx maptype
  lda cherryquantity,x
  sta cherrycounter
; ____________
  lda #$00
  sta level_done
; ____________ INIT APPLE X/Y POSITIONS
  ldx maptype
  lda applexpt_lo,x
  sta zp_temp_01
  lda applexpt_hi,x
  sta zp_temp_01+1

  lda appleypt_lo,x
  sta zp_temp_02
  lda appleypt_hi,x
  sta zp_temp_02+1

  ldy #$07
-
  lda (zp_temp_01),y
  sta apple_x,y
  lda (zp_temp_02),y
  sta apple_y,y
  dey
  bpl -
; ____________ INIT APPLE ADDTABLES & DELAYTAB
  ldx #$07
-
  lda #$00
  sta apple_addval_x,x
  sta apple_addval_y,x
  sta apple_replot_tab,x
  lda #$ff
  sta apple_delaytab,x
  dex
  bpl -
; ______________________________________________ INIT LEVEL DEATH
; init entry point if player died
init_level_death:
; ____________ RESET DEATHFLAG
  lda #$00
  sta deathflag
  lda #disable
  sta enable_death
; ____________ RESET BONUS
  ldx gametype
  lda bonus_first_digit,x
  sta bonus
  lda #$1c+9
  sta bonus+1
  sta bonus+2
; ____________ INIT ENEMY TABLES
  ldx #$04
-
  lda #$ff
  sta enemy_x,x
  sta enemy_y,x
  sta enemy_dir,x
  dex
  bpl -

  ldx #$04
-
  lda queue_data,x
  sta enemy_queue,x
  dex
  bpl -
; ____________ INIT APPLE TABLES
  ldx #$07
  lda #$ff
-
  sta apple_dir,x
  dex
  bpl -
  sta apple_flag
  sta apple_flag_save
; ____________ INIT PLAYER
  lda #sprite_base+4
  sta actpointer

  lda #$38
  sta player_x

  lda #$08
  sta player_y

  lda #$07
  sta player_x0

  lda #$01
  sta player_y0

  lda #$ff
  sta player_dir
; ____________ RESET SHOT
  lda #$00
  sta shot_x
  sta shot_y
  sta shot_addval_x
  sta shot_addval_y
  sta shot_state
  rts
; ______________________________________________ COPY MAPLAYOUT
; copy the current map data into a temporary table
copy_maplayout:
  ldx maptype
  lda mlayouttbl_lo,x
  sta zp_temp_01
  lda mlayouttbl_hi,x
  sta zp_temp_01+1

  ldy #$00
-
  lda (zp_temp_01),y
  sta map_layout,y
  iny
  cpy #$c0
  bne -
  rts
; ______________________________________________________________________
!zone ENEMIES
; ______________________________________________ ENEMY MANAGER
; almost completely the same as in the original code
enemy_manager:
; ____________ SPAWN NEW ENEMIES
  ldx #$04
-
  lda enemy_queue,x         ; check if there are enemies in the queue
  cmp #$ff
  beq ++                    ; if no -> next X

  cmp #$00
  bne +

  lda #$38                  ; else: new enemy to start point
  sta enemy_x,x
  lda #$30
  sta enemy_y,x

  lda #$01                  ; load 'right' into
  sta enemy_dir,x           ; directions table

+ dec enemy_queue,x         ; decrease queue
++
  dex
  bpl -
; ____________ MOVE ENEMIES
  ldx #$04                  ; load enemy index in X register
-
  ldy enemy_dir,x           ; load enemy direction
  cpy #$ff
  beq +                     ; enemy not moving -> next X

  lda enemy_x,x             ; load enemy X positiopn
  clc
  adc xmovtab,y             ; add xmovtab ( $ff $01 $00 $00 )
  sta enemy_x,x             ; store enemy X position

  lda enemy_y,x             ; load enemy Y position
  clc
  adc ymovtab,y             ; add ymovtab ( $00 $00 $ff $01 )
  sta enemy_y,x             ; store enemy Y position

  lda enemy_y,x             ; align the movement
  ora enemy_x,x
  and #$07
  bne +                     ; as long as not aligned -> skip
  jsr enemy_calc_mov        ; else: calc next move
+
  dex
  bpl -

  rts
; ______________________________________________ ENEMY CALC MOV
enemy_calc_mov:
  ldy enemy_x,x             ; load from enemy pos X table
  lda coord_to_map_x,y      ; (/8)
  sta temp_x                ; store to temp X

  ldy enemy_y,x             ; load from enemy pos Y table
  lda coord_to_map_y,y      ; (/8)
  sta temp_y                ; store to temp Y

  txa
  pha                       ; save X on stack

  lda #$00
  sta zp_temp_01            ; clear zp_temp_01

  ldx temp_x                ; saved X value in X
  ldy temp_y                ; saved Y value in Y
  inx                       ; increase X
  cpx #$10                  ; if #$10  (highest X pos on playfield = $0f)
  beq +                     ; -> skip

  jsr check_way_free        ; else: check if way is free
  cmp #$01
  bcs +                     ; no? -> skip

  lda zp_temp_01            ; else:
  ora #$08                  ; set bit 3 in zp_temp_01
  sta zp_temp_01

+
  ldx temp_x                ; saved X value in X
  ldy temp_y                ; saved Y value in Y
  dex                       ; decrease X
  cpx #$ff                  ; if #$ff (lowest X pos on playfield = $00)
  beq +                     ; -> skip

  jsr check_way_free        ; else: check if way is free
  cmp #$01
  bcs +                     ; no? -> skip

  lda zp_temp_01            ; else:
  ora #$04                  ; set bit 2 in zp_temp_01
  sta zp_temp_01

+
  ldx temp_x                ; saved X value in X
  ldy temp_y                ; saved Y value in Y
  iny                       ; increase Y
  cpy #$0c                  ; if #$0c (highest Y pos on playfield = $0b)
  beq +                     ; -> skip

  jsr check_way_free        ; else: check if way is free
  cmp #$01
  bcs +                     ; no? -> skip

  lda zp_temp_01            ; else:
  ora #$02                  ; set bit 1 in zp_temp_01
  sta zp_temp_01

+
  ldx temp_x                ; saved X value in X
  ldy temp_y                ; saved Y value in Y
  dey                       ; decrease Y
  cpy #$ff                  ; if #$ff (lowest Y pos on playfield = $00)
  beq +                     ; -> skip

  jsr check_way_free        ; else: check if way is free
  cmp #$01
  bcs +                     ; no? -> skip

  lda zp_temp_01            ; else:
  ora #$01                  ; set bit 0 in zp_temp_01
  sta zp_temp_01
+
  pla
  tax                       ; restore X reg

  lda enemy_dir,x           ; load from direction table
  eor #$01                  ; eor with #$01
                            ; 00 -> 01
                            ; 01 -> 00
                            ; 02 -> 03
                            ; 03 -> 02
  tay                       ; result in Y
  lda joy_tab,y             ; load from joy table (04 08 01 02)
  eor #$0f                  ; eor #$0f
                            ; 04 -> 0b
                            ; 08 -> 07
                            ; 01 -> 0e
                            ; 02 -> 0d
  and zp_temp_01            ; mask only the bits set in zp_temp_01
  bne +                     ; result not #$00 -> skip

  lda enemy_dir,x           ; else: load from table again
  eor #$01                  ; eor with #$01 (see above)
  sta enemy_dir,x           ; and write back to table
  rts
+
  sta zp_temp_01            ; store in zp_temp_01
-
  jsr randomize             ; subroutine randomize
  and #$03                  ; produce a 'random' direction
  tay
  lda joy_tab,y             ; check if direction is possible
  and zp_temp_01
  beq -                     ; if no -> try again
  tay
  lda dir_tab,y             ; else: load from directions table
  sta enemy_dir,x           ; store in enemy direction
  rts
; ______________________________________________ ENEMY HIT
enemy_hit:
  lda shot_state            ; load shot_state
  cmp #$c0                  ; is it #$c0
  bne .skiploop1            ; then skip loop1
  ldx #$04                  ; else: X = #$04 (enemy index)
.loop1
  lda enemy_dir,x           ; load from enemy directions table
  cmp #$ff                  ; if #$ff skip this X
  beq .skip1
  lda enemy_x,x             ; else: load from X pos table
  sec
  sbc shot_x                ; subtract with value from shot_x
  bpl +                     ; result 'positive' -> skip next instruction
  eor #$ff                  ; else: make result 'positive'
+
  cmp #$06                  ; result >= #$06 ?
  bcs .skip1                ; yes -> skip this X
  lda enemy_y,x             ; else: load from Y pos table
  sec
  sbc shot_y                ; subtract with value from shot_y
  bpl +                     ; result 'positive' -> skip next instruction
  eor #$ff                  ; else: make result 'positive'
+
  cmp #$06                  ; result >= #$06 ?
  bcs .skip1                ; yes -> skip this X
  lda #$ff                  ; else: load #$ff
  sta enemy_dir,x           ; store in table enemy dir
  jsr score_100_points      ; add 100 points to score
  lda gametype
  cmp #$02
  beq +
  jsr score_150_points
+
  jsr shot_erase            ; erase shot

  lda #5
  sta sfx_num               ; SFX enemy death

  lda #$40                  ; set to lda #$00 for shoot cheat
  sta shot_state            ; store in shot_state

  lda #$00
  sta global_ct_hi          ; reset global counter
  sta global_ct_lo          ; (for shoot reloading wait time)
.skip1
  dex                       ;
  bpl .loop1                ; .loop1
.skiploop1

; _________________ enemy hit by an apple ?!?
  ldy #$07                  ; Y = #$07
.loop2
  lda apple_dir,y           ; load from table apple_dir
  cmp #$ff
  beq .skip2                ; is it #$ff -> next Y

  ldx #$04                  ; X = #$05
.inner1
  lda enemy_dir,x           ; load from table enemy_dir
  cmp #$ff
  beq .skip3                ; is it #$ff -> next X
  lda enemy_x,x             ; else: load from X pos table
  sec
  sbc apple_x,y             ; subtract with value from apple X pos table
  bpl +                     ; result 'positive' -> skip next instr.
  eor #$ff                  ; else: make result 'positive'
+
  cmp #$06                  ; is it >= #$06 ?
  bcs .skip3                ; yes -> skip this X
  lda enemy_y,x             ; else: load from Y pos table
  sec
  sbc apple_y,y             ; subtract with value from apple Y pos table
  bpl +                     ; result 'positive' -> skip next instr.
  eor #$ff                  ; else: make result 'positive'
+
  cmp #$06                  ; is it >= #$06 ?
  bcs .skip3                ; yes -> skip this X
  lda #$ff                  ; else:
  sta enemy_dir,x           ; store #$ff to enemy_dir table
  jsr score_100_points      ; add 100 points to score
  lda #5
  sta sfx_num               ; SFX enemy death

.skip3
  dex
  bpl .inner1               ; loop for all enemies

.skip2
  dey                       ; decrease Y
  bpl .loop2                ; loop from 07 - 00 (apple table)

enemy_dead:
  lda queue_flag            ; load queue_flag
  beq ++                    ; if #$00 -> RETURN
  ldx #$04                  ; else: X = #$05 (enemy index)
-
  lda enemy_dir,x           ; load from table $0370
  cmp #$ff
  bne +                     ; is it #$ff -> next X
  lda enemy_queue,x         ; load from table $04f0
  cmp #$ff
  bne +                     ; is it #$ff -> next X
  dec queue_flag            ; else: decrease queue_flag
  lda queue_flag
  bpl .flag_okay
  lda #0
  sta queue_flag
.flag_okay
  lda #$30
  sta enemy_y,x             ; enemy Y pos table = #$30
  lda #$38
  sta enemy_x,x             ; enemy X pos table = #$38
  jsr randomize             ; subroutine randomize (returns value of $8b in A)
  and #$3f                  ; mask bits 0-5
  ora #$40                  ; set bit 6
  sta enemy_queue,x         ; write to table $04f0
+
  dex
  bpl -                     ; X from 05 - 01 (enemy index)
  rts
++
  ldx #$04
-
  lda enemy_queue,x
  cmp #$ff
  bne +
  lda enemy_dir,x
  cmp #$ff
  bne +
  dex
  bpl -
  lda #$01
  sta level_done
+
  rts
; ______________________________________________ CHECK WAY FREE
; parameters: |
; ------------+------------------------
;        A    | -
; ------------+------------------------
;        X    | X pos of player/enemy
; ------------+------------------------
;        Y    | Y pos of player/enemy
-
  lda #$0f
  rts
check_way_free_shot:
  cpy #$0c
  bcs -
  cpx #$10
  bcs -
check_way_free:
  lda map_layout_y_tab_lo,y
  sta zp_temp_02            ; setup ZP pointer
  lda map_layout_y_tab_hi,y
  sta zp_temp_02+1

  txa
  tay
  lda (zp_temp_02),y        ; return the map entry from the direction
                            ; where player/enemy or shoot is heading in A

  rts
; ______________________________________________ RANDOMIZE
; this is also in the original code
; but the ZP adresses in the original aren't initialized
randomize:
  lda rnd_ct
  clc
  adc #$79
  sta rnd_ct
  lda rnd_ct+1
  adc #$35
  sta rnd_ct+1
  lda rnd_ct+2
  adc #$b1
  sta rnd_ct+2
  rts
; ______________________________________________________________________
!zone PLAYER
; ______________________________________________ PLAYER CALC MOV
; almost completely the same as in the original code
player_calc_move:
  ldx player_x              ; load continous X pos of player
  lda coord_to_map_x,x      ; (/8)
  sta player_x0             ; store progressive X pos of player

  ldx player_y              ; load continous Y pos of player
  lda coord_to_map_y,x      ; (/8)
  sta player_y0             ; store progressive Y pos of player


  lda #$00
  sta zp_temp_01            ; clear zp_temp_01

  ldx player_x0             ; saved X value in X
  ldy player_y0             ; saved Y value in Y
  inx                       ; increase X
  cpx #$10                  ; if #$10  (highest X pos on playfield = $0f)
  beq +                     ; -> skip

  jsr check_way_free        ; else: check if way is free
  cmp #$03
  bcs +                     ; no? -> skip

  lda zp_temp_01            ; else:
  ora #$08                  ; set bit 3 in zp_temp_01
  sta zp_temp_01

+
  ldx player_x0             ; saved X value in X
  ldy player_y0             ; saved Y value in Y
  dex                       ; decrease X
  cpx #$ff                  ; if #$ff (lowest X pos on playfield = $00)
  beq +                     ; -> skip

  jsr check_way_free        ; else: check if way is free
  cmp #$03
  bcs +                     ; no? -> skip

  lda zp_temp_01            ; else:
  ora #$04                  ; set bit 2 in zp_temp_01
  sta zp_temp_01

+
  ldx player_x0             ; saved X value in X
  ldy player_y0             ; saved Y value in Y
  iny                       ; increase Y
  cpy #$0c                  ; if #$0c (highest Y pos on playfield = $0b)
  beq +                     ; -> skip

  jsr check_way_free        ; else: check if way is free
  cmp #$03
  bcs +                     ; no? -> skip

  lda zp_temp_01            ; else:
  ora #$02                  ; set bit 1 in zp_temp_01
  sta zp_temp_01

+
  ldx player_x0             ; saved X value in X
  ldy player_y0             ; saved Y value in Y
  dey                       ; decrease Y
  cpy #$ff                  ; if #$ff (lowest Y pos on playfield = $00)
  beq +                     ; -> skip

  jsr check_way_free        ; else: check if way is free
  cmp #$03
  bcs +                     ; no? -> skip

  lda zp_temp_01            ; else:
  ora #$01                  ; set bit 0 in zp_temp_01
  sta zp_temp_01
+
  lda joystick              ; load joystick
  and #$0f                  ; mask low nibble (directions)
  sta zp_temp_01+1          ; store into zp temp reg

  lda zp_temp_01            ; load possible directions
  and zp_temp_01+1          ; and-compare with joy directions
  beq ++                    ; no match -> skip

  tax
  lda dir_tab,x             ; get correct index with help of dir table
  sta player_dir
  rts                       ; RETURN
++
  lda player_dir
  ora #$80
  sta player_dir            ; write to player direction
  rts
; ______________________________________________ MOVE PLAYER
; almost completely the same as in the original code
player_move:
  ldx player_dir            ; load player direction
  bmi +                     ; player not moving -> skip

  lda player_x              ; load player X pos.
  clc
  adc xmovtab,x             ; add xmovtab ( $ff $01 $00 $00 )
  sta player_x              ; store in player X pos.

  lda player_y              ; load player Y pos.
  clc
  adc ymovtab,x             ; add ymovtab ( $00 $00 $ff $01 )
  sta player_y              ; store in player Y pos.
+
  lda player_y              ; align the movement
  ora player_x
  and #$07
  bne +                     ; as long as not aligned -> skip
  jsr player_calc_move      ; else: calc next move
+
  rts
; ______________________________________________ PLAYER HIT
player_hit:
                            ; check if player was hit by an apple
  ldx #$05                  ; X = #$05 (sprite index)
-
  lda apple_dir,x           ; load from table apple_dir
  cmp #$ff
  beq ++                    ; if #$ff -> next X
  lda apple_x,x             ; load from apple X pos table
  sec
  sbc player_x              ; subtract player X pos
  bpl +                     ; result 'positive' -> skip next instr.
  eor #$ff                  ; else: make result 'positive'
+
  cmp #$05                  ; result >= #$04 ?
  bcs ++                    ; yes -> next X
  lda apple_y,x             ; else: load from apple Y pos table
  sec
  sbc player_y              ; subtract player Y pos
  bpl +                     ; result 'positive' -> skip next instr.
  eor #$ff                  ; else: make result 'positive'
+
  cmp #$07                  ; result >= #$04 ?
  bcs ++                    ; yes -> next X
  lda #$01
  sta deathflag
  rts                       ; RETURN
++
  dex                       ; decrease X
  bpl -                     ; repeat for falling apples

                            ; check if player was hit by an enemy
  ldx #$04                  ; .
-
  lda enemy_dir,x           ; .
  cmp #$ff                  ; .
  beq ++                    ; same as above only with
  lda enemy_x,x             ; enemy tables
  sec                       ; .
  sbc player_x              ; .
  bpl +                     ; .
  eor #$ff
+
  cmp #$04
  bcs ++
  lda enemy_y,x
  sec
  sbc player_y
  bpl +
  eor #$ff
+
  cmp #$04
  bcs ++
  lda #$01
  sta deathflag
++
  dex
  bpl -
  rts
; ______________________________________________ PLAYER DEATH
player_death:
  nop                       ; write $60 (RTS) here for INVINCIBLE cheat
  lda deathflag
  bne +
  rts
+
  lda #$4c                  ; load opcode JMP
  sta enable_death          ; write to enable death mainloop
  rts

player_life_dec:
  nop                       ; write $60 (RTS) here for LIFE cheat
  dec lives
  rts
; ______________________________________________________________________
!zone SHOOT
; ______________________________________________ SHOT MANAGER
shot_manager:
  lda shot_state
  bne +
  jsr shoot_start
  rts
+
  cmp #$41
  bcc shoot_wait

  jsr shoot_execute

  lda frame_counter
  and #$10
  bne +
  lda #$02
  sta sfx_num
+
  rts
; ______________________________________________ SHOOT WAIT
; waits till shoot is 'reloaded' after hitting an enemy
shoot_wait:
  lda global_ct_hi
  and #$01
  beq +
  lsr shot_state
  lda shot_state            ; shoot completely reloaded
  bne +                     ; no -> skip
  lda #3                    ; else:
  sta sfx_num               ; play shoot ready sfx
+
  rts
; ______________________________________________ SHOT ERASE
shot_erase:
  lda shot_y                ; load shot_y
  lsr                       ; /2
  lsr                       ; /2 (/4)
  tay                       ; result -> Y
  lda screentab_lo,y        ; load value from table $1850 (screen lo)
  sta zp_temp_01            ; store in zp_temp_01
  lda screentab_hi,y        ; load value from table $1868 (screen hi)
  sta zp_temp_01+1          ; store in $d9

  lda shot_x                ; load shot_x
  lsr
  lsr                       ; (/4)
  tay                       ; result -> Y
  lda #$00                  ; load #$00
  sta (zp_temp_01),y        ; store to screen
  rts
; ______________________________________________ SHOOT START
shoot_start:
  bit joystick              ; check bit7 of joystick register
  bmi +                     ; not set -> RETURN

  lda player_dir            ; load from shoot dir
  and #$03                  ; get bits 0+1
  tax                       ; result in X
  lda shot_tab1,x           ; load from table shot_tab1
  sta shot_addval_x         ; store in shot_addval_x
  lda shot_tab2,x           ; load from table shot_tab2
  sta shot_addval_y         ; store in shot_addval_y

  lda #$c0
  sta shot_state            ; shot state = #$c0
  lda player_x0             ; load player X pos.
  asl
  asl
  asl
  and #$f8                  ; get bits 3-7
  ora #$04                  ; set bit 2
  sta shot_x                ; store in shot_x
  lda player_y0             ; load player Y pos.
  asl
  asl
  asl
  and #$f8                  ; get bits 3-7
  sta shot_y                ; store in shot_y

  lda #$00
  sta shot_back
+
  rts
; ______________________________________________ SHOOT EXECUTE
; based on the original routine
shoot_execute:
  lda shot_y                ; load shot_y (shoot Y pos.)
  lsr
  lsr
  tay
  lda screentab_lo,y        ; setup screen pointer
  sta zp_temp_01
  lda screentab_hi,y
  sta zp_temp_01+1
  lda shot_x                ; load shot_x (shoot X pos.)
  lsr
  lsr
  tay
  lda #$00
  sta (zp_temp_01),y        ; write to screen

  lda shot_x
  clc
  adc shot_addval_x
  lsr
  lsr
  lsr
  tax
  lda shot_y
  lsr
  lsr
  lsr
  tay
  jsr check_way_free_shot
  beq +
  lda #$00
  sec
  sbc shot_addval_x
  sta shot_addval_x

+
  lda shot_y
  clc
  adc shot_addval_y
  lsr
  lsr
  lsr
  tay
  lda shot_x
  lsr
  lsr
  lsr
  tax
  jsr check_way_free_shot
  beq +
  lda #$00
  sec
  sbc shot_addval_y
  sta shot_addval_y

+
  lda shot_y
  clc
  adc shot_addval_y
  lsr
  lsr
  lsr
  tay
  lda shot_x
  clc
  adc shot_addval_x
  lsr
  lsr
  lsr
  tax
  jsr check_way_free_shot
  beq +
  lda #$00
  sec
  sbc shot_addval_y
  sta shot_addval_y
  lda #$00
  sec
  sbc shot_addval_x
  sta shot_addval_x

+
  lda shot_x
  clc
  adc shot_addval_x
  sta shot_x
  lda shot_y
  clc
  adc shot_addval_y
  sta shot_y
  lda shot_y
  lsr
  lsr
  tax
  lda screentab_lo,x
  sta zp_temp_01
  lda screentab_hi,x
  sta zp_temp_01+1
  lda shot_x
  lsr
  lsr
  tay
  lda shot_x
  and #$02
  lsr
  sta zp_temp_02
  lda shot_y
  and #$02
  ora zp_temp_02
  ora #shot_base_char
  sta (zp_temp_01),y

  lda zp_temp_01+1
  eor #eorvalue
  sta zp_temp_01+1
  lda #white
  sta (zp_temp_01),y
  lda shot_x
  eor player_x
  and #$f8
  bne ++
  lda shot_y
  eor player_y
  and #$f8
  bne ++
  lda shot_back
  beq +
  lda #$00
  sta (zp_temp_01),y
  lda zp_temp_01+1
  eor #eorvalue
  sta zp_temp_01+1
  lda #$00
  sta (zp_temp_01),y
  sta shot_state
+
  rts
++
  lda #$01
  sta shot_back
  rts
; ______________________________________________________________________
!zone APPLES_n_CHERRIES
; ______________________________________________ ANIM APPLES&CHERRIES
; based on the original routine
anim_apples_cherries:
  lda apple_flag
  sta apple_flag_save
  lda #$00
  sta apple_flag
  ldx #$07
--
  lda apple_dir,x
  cmp #$ff
  beq +++
  cmp #$02
  bcc +
  lda apple_y,x
  and #$03
  bpl ++
+
  lda apple_x,x
  and #$03
++
  pha
  lda apple_y,x
  lsr
  lsr
  tay
  lda screentab_lo,y
  sta zp_temp_01
  lda screentab_hi,y
  sta zp_temp_01+1
  lda apple_x,x
  lsr
  lsr
  clc
  adc zp_temp_01
  sta zp_temp_01
  lda zp_temp_01+1
  adc #$00
  sta zp_temp_01+1
  lda apple_dir,x
  and #$02
  asl
  sta zp_temp_02
  pla
  ora zp_temp_02
  tay
  stx zp_temp_02
  lda charcopytab2,y
  sta zp_temp_03
  lda charcopytab1,y
  sta zp_temp_03+1

  ldy apple_flag
  ldx zp_temp_03+1
-
  jsr .fetchchar
  sta charbuffer,y
  lda screenpos_addtable,x
  clc
  adc zp_temp_01
  sta temp_screenpos_lo,y
  lda zp_temp_01+1
  adc #$00
  sta temp_screenpos_hi,y
  jsr .setcolram
  inx
  iny
  cpx zp_temp_03
  bne -
  sty apple_flag
  ldx zp_temp_02
+++
  dex
  bmi +
  jmp --
+
  dec apple_flag
  rts
.fetchchar
  lda tiles_uneven,x
  pha
  lda zp_temp_02
  cmp #$07
  bne +
  pla
  clc
  adc char_add
  rts
+
  lda gametype
  cmp #$02
  beq +
  pla
  clc
  adc #$50
  rts
+
  pla
  rts

.setcolram
  lda #green+8
  sta temp_colram,y
  rts
; ______________________________________________ APPLE ERASE
; based on the original routine
; but uses a saved screen positions table
; to erase the data from the frame before
; in the original all code was executed in V-BLANK area
; which is not possible on C64 (less CPU time)
apple_erase:
  ldx apple_flag_save       ; load apple flag
  cpx #$ff
  beq +
-
  lda save_screenpos_lo,x   ; load from temporary screenlo/hi tables
  sta zp_temp_01            ; store to pointers
  lda save_screenpos_hi,x
  sta zp_temp_01+1

  ldy #$00
  lda #$00                  ; #$00 (empty char)
  sta (zp_temp_01),y        ; write to screen
  dex
  bpl -
+
  lda #$ff
  sta apple_flag_save
  rts
; ______________________________________________ SAVE TEMP SCREEN TABLE
; see above
apple_savetab:
  !if DEBUG = 1 { inc $d020 }
  ldx #$0f
-
  lda temp_screenpos_lo,x
  sta save_screenpos_lo,x
  lda temp_screenpos_lo+$10,x
  sta save_screenpos_lo+$10,x
  lda temp_screenpos_lo+$20,x
  sta save_screenpos_lo+$20,x
  lda temp_screenpos_hi,x
  sta save_screenpos_hi,x
  lda temp_screenpos_hi+$10,x
  sta save_screenpos_hi+$10,x
  lda temp_screenpos_hi+$20,x
  sta save_screenpos_hi+$20,x
  dex
  bpl -

  !if DEBUG = 1 { dec $d020 }
  rts
; ______________________________________________ APPLE WRITE
; based on the original routine
apple_write:
  ldx apple_flag            ; load apple flag
  cpx #$ff                  ; if #$ff
  beq ++                    ; -> skip
-
  lda temp_screenpos_lo,x   ; load from temporary screen tables
  sta zp_temp_01            ; store into pointer
  lda temp_screenpos_hi,x
  sta zp_temp_01+1

  ldy #$00
  lda charbuffer,x          ; load from temp chardata table

  beq +
  sta (zp_temp_01),y        ; store in screenram

  lda zp_temp_01+1          ; load zp temp +1
  eor #eorvalue             ; eor for colram hibyte
  sta zp_temp_01+1          ; store in zp temp +1

  lda temp_colram,x         ; load from temp colortable
  sta (zp_temp_01),y        ; store in colorram
+
  dex
  bpl -
++
  rts
; ______________________________________________ APPLE REPLOT
; re-plots apples
apple_replot:
  !if DEBUG = 1 { dec $d020 }
  ldx #$07
-
  lda apple_replot_tab,x
  beq +

  lda apple_y,x
  lsr
  lsr
  lsr
  tay
  lda screen_erasetab_lo,y
  sta screen_pt
  lda screen_erasetab_hi,y
  sta screen_pt+1

  lda apple_x,x
  lsr
  lsr
  clc
  adc screen_pt
  sta screen_pt
  lda screen_pt+1
  adc #0
  sta screen_pt+1

  lda #$60
  sta nocolor

  stx .savex
replotval =*+1
  lda #$13
  jsr print_tile

  lda #$ea
  sta nocolor

.savex =*+1
  ldx #0
  lda #$00
  sta apple_replot_tab,x
+
  dex
  bpl -
  !if DEBUG = 1 { inc $d020 }
  rts
; ______________________________________________ APPLE MOVE
; based on the original routine
apple_move:
  ldx #$05                  ; X = #$05
-
  lda apple_dir,x           ; load apple direction
  cmp #$ff                  ; is it #$ff?
  beq +                     ; yes -> skip this X value
  lda apple_x,x             ; else load X-Coords of APPLES
  clc
  adc apple_addval_x,x      ; add value
  sta apple_x,x
  lda apple_y,x             ; load Y-Coords of APPLES
  clc
  adc apple_addval_y,x      ; add value
  sta apple_y,x

  lda apple_y,x             ; align the movement
  ora apple_x,x
  and #$07
  bne +
  jsr check_way_free_apple
+
  dex
  bpl -
  rts
; ______________________________________________ CHECK WAY FREE APPLE
; unlike the original a special routine for falling
; apples is used
check_way_free_apple:
  lda apple_y,x
  lsr
  lsr
  lsr
  tay
  lda map_layout_y_tab_lo,y
  sta zp_temp_01
  lda map_layout_y_tab_hi,y
  sta zp_temp_01+1

  lda apple_x,x
  lsr
  lsr
  lsr
  clc
  adc #16
  tay
  lda (zp_temp_01),y
  beq +
  lda #$ff
  sta apple_delaytab,x
  sta apple_dir,x
  tya
  sec
  sbc #16
  tay
  lda #$03
  sta (zp_temp_01),y
  lda #$01
  sta apple_replot_tab,x

  lda #8
  sta sfx_num
+
  rts

; ______________________________________________ APPLE WATCH
; checks if apples should start to fall
applewatch:
  ldx #$05
-
  lda apple_delaytab,x
  cmp #$ff
  bne ++
  lda apple_y,x
  cmp #$58
  bcs +
  lsr
  lsr
  lsr
  sta apple_temptaby,x
  tay
  lda map_layout_y_tab_lo,y
  sta zp_temp_01
  lda map_layout_y_tab_hi,y
  sta zp_temp_01+1

  lda apple_x,x
  lsr
  lsr
  lsr
  sta apple_temptabx,x
  clc
  adc #16
  tay
  lda (zp_temp_01),y
  bne +
  lda #$1e
  !byte $2c
+
  lda #$ff
  sta apple_delaytab,x
++
  dex
  bpl -

  ldx #$05
--
  lda apple_delaytab,x
  cmp #$ff
  beq +
  cmp #$00
  beq ++
  dec apple_delaytab,x
+
-
  dex
  bpl --
  rts
++
  lda #$03
  sta apple_dir,x
  tay
  lda ymovtab,y
  sta apple_addval_y,x
  lda #$ff
  sta apple_delaytab,x
  ldy apple_temptaby,x
  lda map_layout_y_tab_lo,y
  sta zp_temp_01
  lda map_layout_y_tab_hi,y
  sta zp_temp_01+1
  ldy apple_temptabx,x
  lda #$00
  sta (zp_temp_01),y
  lda #6
  sta sfx_num
  jmp -
; ______________________________________________ APPLE Y CHECK
; checks for 'all apples on ground + all cherries collected'
; on gametype 1
apple_y_check:
  ldx #$05
-
  lda apple_y,x
  cmp #$58
  bne +
  inc apple_ground_flag
+
  dex
  bpl -

  lda apple_ground_flag
  cmp #$06
  bne +
  lda cherrycounter
  cmp #$01
  bne +
  lda #$01
  sta level_done
+
  lda #$00
  sta apple_ground_flag
  rts
; ______________________________________________ CHEST MOVE MANAGER
chest_move_manager:
  jsr chest_check_move_start
  jsr chest_move
  jsr chest_move_end
  rts
; ______________________________________________ CHEST 'SECRET' EXIT
; exits gametype 2 with apple tiles in each playfield corner
chest_secret_exit:
  lda map_layout_y00
  cmp #$05
  bne +
  lda map_layout_y00+15
  cmp #$05
  bne +
  lda map_layout_y11
  cmp #$05
  bne +
  lda map_layout_y11+15
  cmp #$05
  bne +
  lda #$01
  sta level_done
+
  rts
; ______________________________________________ CHEST CHECK MOVE START
-
  rts
chest_check_move_start:
  lda kill_tile_flag        ; is there still a tile to be erased?
  bne -                     ; yes -> skip
  lda apple_dir+7
  cmp #$ff
  bne -

  ldx player_x              ; store player x pos /8 in temp x
  lda coord_to_map_x,x
  sta temp_x

  ldy player_y              ; store player y pos /8 in temp y
  lda coord_to_map_y,y
  sta temp_y

  lda player_x
  ora player_y
  and #$07                  ; player aligned?
  bne +                     ; no -> RETURN

  lda joystick
  and #$80                  ; fire pressed?
  bne +                     ; no -> RETURN

  lda joystick
  and #$0f
  beq +
  sta zp_temp_01

  ldx zp_temp_01
  lda dir_tab,x
  sta zp_temp_01+1

  lda zp_temp_01+1          ; load player direction
  and #$03
  tax
  lda xmovtab,x             ; get X offset from xmovtab
  clc
  adc temp_x
  sta temp_x                ; store to temp x

  lda ymovtab,x             ; get Y offset from ymovtab
  clc
  adc temp_y
  sta temp_y                ; store to temp y

  ldx temp_x
  ldy temp_y
  jsr check_way_free_shot
  cmp #$03
  bcc +
  sta way_free_sav01
  lda zp_temp_01+1
  and #$03
  tax
  lda xmovtab,x
  clc
  adc temp_x
  sta zp_temp_03
  lda ymovtab,x
  clc
  adc temp_y
  sta zp_temp_03+1
  ldx zp_temp_03
  ldy zp_temp_03+1
  jsr check_way_free_shot
  sta way_free_sav02
  clc
  bcc ++
+
  rts

++
  lda way_free_sav01
  cmp #$04
  bne +
  lda way_free_sav02
  cmp #$00
  bne +
  lda #$28
  sta char_add
-
  lda temp_x
  asl
  asl
  asl
  sta apple_x+7
  lda temp_y
  asl
  asl
  asl
  sta apple_y+7
  lda zp_temp_01+1
  and #$03
  tax
  lda xmovtab,x
  sta apple_addval_x+7
  lda ymovtab,x
  sta apple_addval_y+7
  txa
  sta apple_dir+7
  lda apple_x+7
  lsr
  lsr
  lsr
  tax
  lda apple_y+7
  lsr
  lsr
  lsr
  tay
  lda #$00
  jsr update_maplayout_apples
  rts
+
                            ; destroy tile
  lda way_free_sav01
  cmp #$05
  bne +
  lda way_free_sav02
  cmp #$00
  bne +
  lda #$00
  sta char_add
  beq -
+
  lda way_free_sav01
  cmp #$04
  bne +
  lda temp_x
  sta kill_tilex
  lda temp_y
  sta kill_tiley
  lda #$05
  sta kill_tile_flag
  lda #$ff
  sta apple_dir+7
  sta apple_x+7
  sta apple_y+7

  lda #0
  sta global_ct_lo
  sta global_ct_hi
+
  rts
; ______________________________________________ KILL TILE
; erases a tile with fadeaway-animation in gametype 2
; and adds 25 points to score afterwards
kill_tile:
  lda kill_tile_flag
  beq +

  lda global_ct_lo
  cmp #$20
  bcc +

  lda #0
  sta global_ct_lo

  ldy kill_tiley

  lda screen_erasetab_lo,y
  sta screen_pt
  lda screen_erasetab_hi,y
  sta screen_pt+1

  lda kill_tilex
  asl
  clc
  adc screen_pt
  sta screen_pt

  lda screen_pt+1
  adc #0
  sta screen_pt+1

  lda #$60
  sta nocolor

.fadetile =*+1
  lda #$07
  jsr print_tile

  lda #$ea
  sta nocolor

  inc .fadetile
  dec kill_tile_flag

  lda kill_tile_flag
  bne +

  jsr score_25_points

  ldy kill_tiley
  lda map_layout_y_tab_lo,y
  sta zp_temp_01
  lda map_layout_y_tab_hi,y
  sta zp_temp_01+1

  lda kill_tilex
  tay
  lda #$00
  sta (zp_temp_01),y

  lda #$07
  sta .fadetile
  rts
+
  rts
; ______________________________________________ CHEST MOVE
chest_move:
  lda apple_dir+7           ; load apple direction
  cmp #$ff                  ; is it #$ff?
  beq +                     ; yes -> skip this X value
  lda apple_x+7             ; else load X-Coords of APPLES
  clc
  adc apple_addval_x+7      ; add value
  sta apple_x+7
  lda apple_y+7             ; load Y-Coords of APPLES
  clc
  adc apple_addval_y+7      ; add value
  sta apple_y+7
+
  rts
; ______________________________________________ CHEST MOVE END
chest_move_end:
  lda apple_x+7             ; load last entry of apple X pos
  ora apple_y+7             ; or with last entry of apple Y pos
  and #$07                  ; check for bits 0-2
  bne ++                    ; if zero -> RETURN
  lda apple_dir+7           ; load last entry of apple direction
  cmp #$ff
  beq ++                    ; if #$ff -> RETURN
  lda apple_x+7             ; else: load last entry of apple X pos
  lsr
  lsr
  lsr                       ; (/8)
  sta temp_x                ; store in temp_x (temp X pos)
  clc
  adc apple_addval_x+7      ; add with last value of add-table
  sta zp_temp_03            ; store result in zp temp
  lda apple_y+7             ; load last entry of apple Y pos
  lsr
  lsr
  lsr                       ; (/8)
  sta temp_y                ; store in temp_y (temp Y pos)
  clc
  adc apple_addval_y+7      ; add with another add-table value
  sta zp_temp_03+1          ; store in zp temp +1

  ldx zp_temp_03            ; zp temp -> X
  ldy zp_temp_03+1          ; tp temp + 1 -> Y
  jsr check_way_free_shot   ;
  sta zp_temp_01            ;
  beq ++                    ; if zero -> RETURN
  lda #$ff                  ; load #$ff
  sta apple_dir+7           ; store in last entry of apple dir
  lda #$00                  ; load #$00
  sta apple_addval_x+7      ; store in last value of add-table
  sta apple_addval_y+7      ; store in another add-table value

  ldx temp_x                ; temp_x -> X
  ldy temp_y                ; temp_y -> Y
  lda char_add              ; load char add value
  bne +                     ; not zero -> skip
  lda #$05                  ; else: load #$05 (solid apple)
  !byte $2c
+
  lda #$04                  ; load #$04 (solid cherry)
  sta replotval             ; store in replot value
  jsr update_maplayout_apples
                            ; update the map layout
  lda #$01
  sta apple_replot_tab+7    ; enable replot
  lda #$07
  sta sfx_num               ; play sfx chest hits another chest
++
  rts

; ______________________________________________________________________
!zone GAME_LOGIC
; ______________________________________________ UPDATE MAY LAYOUT
; updates the 'virtual' map layout according to player movement
update_maplayout:
  ldy player_y0             ; load player Y pos.
  lda map_layout_y_tab_lo,y ; get Y pos. line from map layout y pos table
  sta zp_temp_01            ; store in zp pointer
  lda map_layout_y_tab_hi,y
  sta zp_temp_01+1

  ldy player_x0             ; load player X pos.
  lda (zp_temp_01),y        ; load field below player
  cmp #$02                  ; is it a cherry?
  bne +                     ; no -> skip
  lda #enable               ; else: enable cherrywatch routine
  sta enable_cherrywatch    ; to decrease cherries/add score/play sfx
+
  cmp #$01                  ; is it muddy ground
  bne +                     ; no -> skip
  lda #4                    ; else: play 'dig sound'
  sta sfx_num
+
  lda #$00
  sta (zp_temp_01),y        ; erase field below player
  rts
; ______________________________________________
update_screen_death:
  ldx player_dir
-
  lda player_x              ; load player X pos.
  clc
  adc xmovtab,x             ; add xmovtab ( $ff $01 $00 $00 )
  sta player_x              ; store in player X pos.

  lda player_y              ; load player Y pos.
  clc
  adc ymovtab,x             ; add ymovtab ( $00 $00 $ff $01 )
  sta player_y              ; store in player Y pos.

  lda player_y              ; align the movement
  ora player_x
  and #$07
  bne -

  lda player_y
  lsr
  lsr
  lsr
  tay
  lda map_layout_y_tab_lo,y ; get Y pos. line from map layout y pos table
  sta zp_temp_01            ; store in zp pointer
  lda map_layout_y_tab_hi,y
  sta zp_temp_01+1
  lda screen_erasetab_lo,y
  sta screen_pt
  lda screen_erasetab_hi,y
  sta screen_pt+1

  lda player_x
  lsr
  lsr
  clc
  adc screen_pt
  sta screen_pt

  lda screen_pt+1
  adc #0
  sta screen_pt+1

  lda #$ea
  sta nocolor

  lda player_x
  lsr
  lsr
  lsr
  tay
  lda (zp_temp_01),y

  ldx #green+8
  jsr print_tile
  rts
; ______________________________________________
update_maplayout_apples:
  sta .tilenum
  lda map_layout_y_tab_lo,y ; get Y pos. line from map layout y pos table
  sta zp_temp_01            ; store in zp pointer
  lda map_layout_y_tab_hi,y
  sta zp_temp_01+1

  txa
  tay
.tilenum =*+1
  lda #$00
  sta (zp_temp_01),y        ; store tilenum in mapdata field
  rts
; ______________________________________________ CHERRY WATCH
cherrywatch:
  dec cherrycounter         ; decrease cherrycounter
  lda cherrycounter
  cmp #$ff                  ; all cherries collected ?
  bne +                     ; no -> skip
  lda #$01                  ; else:
  sta level_done            ; set level done switch
+
  jsr score_25_points       ; score 25 points
  lda #disable              ; disable this routine
  sta enable_cherrywatch    ; for next frame
  lda #$01
  sta sfx_num               ; enable sfx playback
  rts

; ______________________________________________ ADD STH. TO SCORE
; parameters: |
; ------------+------------------------
;        A    | value to add ( $01-$09 )
; ------------+------------------------
;        X    | digit position
;             | $04 ~ 1
;             | $03 ~ 10
;             | $02 ~ 100
;             | $01 ~ 1000
;             | $00 ~ 10000
score_add:
-
  clc
  adc score,x               ; add value in A to score
  sta score,x               ; and store there
  cmp #$26
  bcc +                     ; no carry -> RETURN
  sec                       ; else:
  sbc #$0a                  ; subtract '10'
  sta score,x               ; from this digit
  lda #$01                  ; and add one
  dex                       ; to next digit
  bpl -
+
  rts
; ______________________________________________ add 25 points to score
score_25_points:
  ldx #$03
  lda #$02
  jsr score_add
  ldx #$04
  lda #$05
  jsr score_add
  rts
; ______________________________________________ add 100 points to score
score_100_points:
  ldx #$02
  lda #$01
  jsr score_add
  rts
; ______________________________________________ add 150 points to score
score_150_points:
  ldx #$02
  lda #$01
  jsr score_add
  ldx #$03
  lda #$05
  jsr score_add
  rts
; ______________________________________________ add points to score (levelend)
score_level_points:
  lda gametype
  clc
  adc #$01
  ldx #$01
  jsr score_add
  rts
; ______________________________________________ add bonus to score
score_bonus_add:
  ldx #$04                  ; load x with #$04
  lda bonus+2               ; load bonus last digit
  sec
  sbc #$1c                  ; subtract #$1c (value of digit stays in A)
  jsr score_add             ; subroutine score_add (add sth. to SCORE)
  ldx #$03
  lda bonus+1               ; bonus middle digit
  sec
  sbc #$1c
  jsr score_add             ; add to score
  ldx #$02
  lda bonus+0               ; bonus first digit
  sec
  sbc #$1c
  jsr score_add             ; add to score
  rts
; ______________________________________________ BONUS COUNTER
bonus_counter:
  nop                       ; write $60 (RTS) here for BONUS CT cheat
  inc bonus_skip            ; increase bonus_skip
  lda bonus_skip
  and #$01                  ; check for bit 0
  sta bonus_skip            ; write back to bonus_skip
  bne .skip                 ; if 1 -> skip
  ldx #$02                  ; else load x = $02
-
  dec bonus,x               ; decrease bonus,x
  lda bonus,x               ; load bonus,x
  cmp #$1b                  ; is it #$1b? (one below 0 char)
  bne +                     ; no -> end loop
  lda #$25                  ; else load #$25 (char for no. 9)
  sta bonus,x               ; store to bonus,x
  dex                       ; decrease x
  bpl -                     ; while x >= 0 -> loop
+
  lda bonus
  ora bonus+1
  ora bonus+2
  cmp #$1c                  ; check if counter is zero
  beq +                     ; yes -> go on
  rts                       ; no -> RETURN

+
                            ; display 0 in last digit on screen
  sta vidmem0+(7*40)+34+2   ; because panel update isn't run when death
                            ; occurs
  lda #$01
  sta deathflag             ; set deathflag
.skip
  rts
; ______________________________________________ TIMER
timer:
  inc seconds               ; increase seconds
  lda seconds               ; load
  cmp #$3c                  ; and compare #$3c
  bne +                     ; no -> RETURN
  lda #$00                  ; else: set seconds = #$00
  sta seconds
  inc time+4                ; increase time + 4
  lda time+4                ; load time + 4
  cmp #$26                  ; is it #$26 (explanation mark 1 char above 9)
  bne +                     ; no -> RETURN
  lda #$1c                  ; else load #$1c (char 0)
  sta time+4                ; to time + 4
  inc time+3                ; and increase time + 3
  lda time+3                ; load
  cmp #$22                  ; is it #$22 (6)
  bne +                     ; no -> RETURN
  lda #$1c                  ; else: load #$1c (char 0)
  sta time+3                ; to time + 3
  inc time+1                ; ...
  lda time+1                ; .
  cmp #$26                  ; and so on ...
  bne +                     ; .
  lda #$1c                  ; .
  sta time+1
  inc time+0
  lda time+0
  cmp #$22
  bne +
  lda #$1c
  sta time+0
+
  rts
; ______________________________________________ TOPSCORE ROUTINE
topscore:
  lda autoplay_flag
  beq +
  rts
+
  lda topscore_pos          ; load topscore_pos
  sta topscore_temp         ; save in topscore_temp
---
  lda topscore_pos          ; load topscore_pos
  beq .skiptopscore         ; it is #$00 ? -> skip
  clc                       ; else:
  adc #$0f                  ; add #$0f
  tax                       ; and put result in X
  lda screentab_lo,x        ; load from screentab and store
  sta zp_temp_01            ; in the pointers
  lda screentab_hi,x        ; .
  sta zp_temp_01+1          ; .

  ldy #$22                  ; Y = #$22
-
  lda vidmem0+$28,y         ; load current score digit
  cmp (zp_temp_01),y        ; compare with top score digit
  bcc .skiptopscore         ; current score < top score -> skip
  bne +                     ; not equal -> b2122
  iny                       ; if equal: increase Y
  cpy #$27                  ; all digits checked?
  bne -                     ; no -> loop
  beq .skiptopscore         ; beq instead of jmp to save bytes?
+
  dec topscore_pos          ; decrease topscore_pos
  lda topscore_pos
  cmp #$07                  ; is it #$07
  beq topscore              ; yes -> loop


--
  lda topscore_temp         ; else: load topscore_temp
  clc
  adc #$10                  ; add #$10
  tax                       ; put in X
  lda screentab_lo,x        ; load from screentab
  sta zp_temp_01            ; write to pointer
  lda screentab_hi,x
  sta zp_temp_01+1
  lda screentab_lo-1,x      ; load from screentab-1
  sta zp_temp_02            ; store in pointer $da/$db
  lda screentab_hi-1,x
  sta zp_temp_02+1
  ldy #$22
-
  lda (zp_temp_02),y        ; copy digits
  sta (zp_temp_01),y        ; one line up
  iny
  cpy #$27
  bne -
  dec topscore_temp         ; decrease topscore_temp
  lda topscore_temp
  cmp topscore_pos          ; compare with topscore_pos
  bne --                    ; not equal -> loop
  clc                       ; else clear carry
  bcc ---                   ; bcc instead of jump?
.skiptopscore
  lda topscore_pos          ; is topscore_pos = #$08 ?
  cmp #$08
  bne +                     ; no -> next loop
  rts                       ; else: RETURN

+
  ldx #$10
--
  lda screentab_lo,x
  sta zp_temp_01
  lda screentab_hi,x
  eor #eorvalue             ; .
  sta zp_temp_01+1          ; .
  ldy #$22                  ; .
  lda #color_digits         ; color score list
-
  sta (zp_temp_01),y        ; .
  iny                       ; .
  cpy #$27                  ; .
  bne -
  inx
  cpx #$18
  bne --

  lda topscore_pos          ; load topscore_pos
  clc
  adc #$10                  ; add #$10
  tax                       ; result in X
  lda screentab_lo,x        ; write from screentab to pointer
  sta zp_temp_01
  lda screentab_hi,x
  sta zp_temp_01+1
  ldy #$22
-
  lda vidmem0+$28,y         ; load current score
  sta (zp_temp_01),y        ; write to top list
  iny
  cpy #$27
  bne -
  lda topscore_pos
  ora #$10
  tax
  lda screentab_lo,x
  sta zp_temp_01
  lda screentab_hi,x
  eor #eorvalue
  sta zp_temp_01+1
  ldy #$22
                            ; mark score in toplist
  lda #white
-
  sta (zp_temp_01),y
  iny
  cpy #$27
  bne -
  rts
; ______________________________________________ SAVE TOPSCORES
topscore_save:
  nop

  lda autoplay_flag
  beq +
  rts
+
  ldx #$05
-
  lda vidmem0+$2a2+(0*40),x
  sta scoreboard+(0*6),x
  lda vidmem0+$2a2+(1*40),x
  sta scoreboard+(1*6),x
  lda vidmem0+$2a2+(2*40),x
  sta scoreboard+(2*6),x
  lda vidmem0+$2a2+(3*40),x
  sta scoreboard+(3*6),x
  lda vidmem0+$2a2+(4*40),x
  sta scoreboard+(4*6),x
  lda vidmem0+$2a2+(5*40),x
  sta scoreboard+(5*6),x
  lda vidmem0+$2a2+(6*40),x
  sta scoreboard+(6*6),x
  lda vidmem0+$2a2+(7*40),x
  sta scoreboard+(7*6),x
  dex
  bpl -

  lda topscore_pos
  cmp #$08
  beq +

  jsr highscore_save        ; save scores to disk
+
  rts
; ______________________________________________ RESET TOPSCORES
topscore_reset:
  ldx #$05
-
  lda scoreboard_reset+(0*6),x
  sta scoreboard+(0*6),x
  sta vidmem0+$2a2+(0*40),x
  lda scoreboard_reset+(1*6),x
  sta scoreboard+(1*6),x
  sta vidmem0+$2a2+(1*40),x
  lda scoreboard_reset+(2*6),x
  sta scoreboard+(2*6),x
  sta vidmem0+$2a2+(2*40),x
  lda scoreboard_reset+(3*6),x
  sta scoreboard+(3*6),x
  sta vidmem0+$2a2+(3*40),x
  lda scoreboard_reset+(4*6),x
  sta scoreboard+(4*6),x
  sta vidmem0+$2a2+(4*40),x
  lda scoreboard_reset+(5*6),x
  sta scoreboard+(5*6),x
  sta vidmem0+$2a2+(5*40),x
  lda scoreboard_reset+(6*6),x
  sta scoreboard+(6*6),x
  sta vidmem0+$2a2+(6*40),x
  lda scoreboard_reset+(7*6),x
  sta scoreboard+(7*6),x
  sta vidmem0+$2a2+(7*40),x
  dex
  bpl -

  lda #disable
  sta enable_topscore_reset
  rts
; ______________________________________________________________________
!zone DISK_OPERATIONS
; ______________________________________________ HS LOAD
highscore_load:
  lda #filename_end-filename
  ldx #<filename
  ldy #>filename
  jsr $ffbd
  lda #$01
  ldx $ba
  bne +
  ldx #$08
+
  ldy #$00
  jsr $ffba

  ldx #<load_adress
  ldy #>load_adress
  lda #$00
  jsr $ffd5
                            ; no error handling
                            ; just don't care =)
  rts
; ______________________________________________ HS SAVE
highscore_save:

  lda #$0b
  sta $d011

  lda #$00
  sta $d01a
  lda #$7f
  sta $dc0d

  lda #$37
  sta $01

  jsr $ffe7

  lda #filename_end-scratchname
                            ; length filename
  ldx #<scratchname         ; low-byte filename
  ldy #>scratchname         ; high-byte filename
  jsr $ffbd                 ; kernal SETNAM (filename)

  lda #$01                  ; file no. = 1
  ldx $ba
  bne +
  ldx #$08
+
  ldy #$0f                  ; sec. address = 15
  jsr $ffba                 ; kernal SETFLS / parameter for OPEN

  jsr $ffc0                 ; kernal OPEN
  lda #$01                  ; file no. = 1
  jsr $ffc3                 ; kernal CLOSE

  lda #filename_end-filename
  ldx #<filename
  ldy #>filename
  jsr $ffbd
  lda #$00
  ldx $ba
  bne +
  ldx #$08
+
  ldy #$00
  jsr $ffba

  lda #<file_start
  sta $c1
  lda #>file_start
  sta $c2

  ldx #<file_end
  ldy #>file_end
  lda #$c1
  jsr $ffd8

  lda #$35
  sta $01

  lda #$1b
  sta $d011

  lda #$01
  sta $d01a

  rts
; ______________________________________________________________________
!zone AUTOPLAY
; ______________________________________________ JOY PLAYBACK
; feeds the joystick register with data from a table for demomode
joy_playback:
  nop
  lda autoplay_flag
  beq +
  lda #$80
  sta joystick
+
  clc
  lda record_ct1
  adc #$01
  sta record_ct1
  bcc +

  lda record_ct2
  adc #$00
  sta record_ct2
+

  ldy #0
  lda (rec_pt_lo),y
  cmp record_ct1
  bne ++

  iny
  lda (rec_pt_lo),y
  cmp record_ct2
  bne ++

  iny
  lda (rec_pt_lo),y
  sta joystick

  lda #$01
  sta autoplay_flag

  clc
  lda rec_pt_lo
  adc #$03
  sta rec_pt_lo
  bcc +
  inc rec_pt_hi
+
  lda rec_pt_hi
  cmp #$80
  bne ++
  lda #$60
  sta joy_playback

++
  rts
